/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MultiLineRenderSupport;
import org.xml.sax.Attributes;

public class Note
implements GenomeItem,
Cloneable {
    private String id_;
    private String name_;
    private String text_;
    private boolean interactive_;
    private String lineBreakDef_;

    public Note(Note other) {
        this.id_ = other.id_;
        this.name_ = other.name_;
        this.text_ = other.text_;
        this.interactive_ = other.interactive_;
        this.lineBreakDef_ = other.lineBreakDef_;
    }

    public Note(Note other, String newID) {
        this.id_ = newID;
        this.name_ = other.name_;
        this.text_ = other.text_;
        this.interactive_ = other.interactive_;
        this.lineBreakDef_ = other.lineBreakDef_;
    }

    public Note(String id, String name, String breakDef, boolean interactive) {
        this.id_ = id.trim();
        this.name_ = MultiLineRenderSupport.applyLineBreaks(name, breakDef);
        this.text_ = "";
        this.interactive_ = interactive;
        this.lineBreakDef_ = breakDef;
    }

    public Note(String id, String name, boolean interactive) {
        this.id_ = id.trim();
        this.name_ = name;
        this.text_ = "";
        this.interactive_ = interactive;
        this.lineBreakDef_ = MultiLineRenderSupport.genBreaks(name);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getID() {
        return this.id_;
    }

    public void setName(String name) {
        this.name_ = name;
        this.lineBreakDef_ = MultiLineRenderSupport.genBreaks(name);
    }

    public String getName() {
        return this.name_;
    }

    public void setText(String text) {
        this.text_ = text;
    }

    public boolean isInteractive() {
        return this.interactive_;
    }

    public void setInteractive(boolean interactive) {
        this.interactive_ = interactive;
    }

    public void appendToNote(String newText) {
        this.text_ = this.text_ == null ? newText : this.text_.concat(newText);
        this.text_ = CharacterEntityMapper.unmapEntities(this.text_, false);
    }

    public String getText() {
        return this.text_;
    }

    public String getTextWithBreaksReplaced() {
        return MultiLineRenderSupport.breaksToWhitespace(this.text_);
    }

    public String toString() {
        return "Note: id = " + this.id_ + "name = " + this.name_ + " text = " + this.text_;
    }

    public void writeXML(PrintWriter out, Indenter ind, boolean forDynamic) {
        ind.indent();
        String key = Note.mapKeywords(forDynamic);
        out.print("<");
        out.print(key);
        out.print(" id=\"");
        out.print(this.id_);
        if (this.name_ != null) {
            String oneLineName = MultiLineRenderSupport.stripBreaks(this.name_);
            out.print("\" name=\"");
            out.print(CharacterEntityMapper.mapEntities(oneLineName, false));
        }
        if (this.lineBreakDef_ != null) {
            out.print("\" breakDef=\"");
            out.print(this.lineBreakDef_);
        }
        out.print("\" interactive=\"");
        out.print(this.interactive_);
        if (this.text_ != null && !this.text_.trim().equals("")) {
            out.print("\" >");
            out.print(CharacterEntityMapper.mapEntities(this.text_, false));
            out.print("</");
            out.print(key);
            out.println(">");
        } else {
            out.println("\"/>");
        }
    }

    public static String mapKeywords(boolean forDynamic) {
        return forDynamic ? "dpNote" : "note";
    }

    public static Set keywordsOfInterest(boolean forDynamic) {
        HashSet<String> retval = new HashSet<String>();
        retval.add(Note.mapKeywords(forDynamic));
        return retval;
    }

    public static Note buildFromXML(String elemName, Attributes attrs) throws IOException {
        String id = null;
        String name = null;
        String breakDef = null;
        String interactiveStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("breakDef")) {
                    breakDef = val;
                    continue;
                }
                if (!key.equals("interactive")) continue;
                interactiveStr = val;
            }
        }
        if (id == null) {
            throw new IOException();
        }
        boolean interactive = interactiveStr != null ? Boolean.valueOf(interactiveStr) : true;
        return new Note(id, name, breakDef, interactive);
    }

    private Note() {
    }
}

