/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.DBGene;
import org.systemsbiology.biotapestry.genome.DBInternalLogic;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;

public class SbmlSupport {
    public void writeSBML(StringBuffer buf, Indenter ind, Genome genome) {
        ind.indent();
        buf.append("<model ");
        buf.append("name=\"");
        String modelName = genome.getName().replaceAll(" ", "_");
        buf.append(CharacterEntityMapper.mapEntities(modelName, false));
        buf.append("\" >\n");
        ind.up().indent();
        buf.append("<listOfUnitDefinitions>\n");
        ind.up().indent();
        buf.append("<unitDefinition name=\"volume\">\n");
        ind.up().indent();
        buf.append("<listOfUnits>\n");
        ind.up().indent();
        buf.append("<unit kind=\"dimensionless\"/>\n");
        ind.down().indent();
        buf.append("</listOfUnits>\n");
        ind.down().indent();
        buf.append("</unitDefinition>\n");
        ind.indent();
        buf.append("<unitDefinition name=\"substance\">\n");
        ind.up().indent();
        buf.append("<listOfUnits>\n");
        ind.up().indent();
        buf.append("<unit kind=\"item\"/>\n");
        ind.down().indent();
        buf.append("</listOfUnits>\n");
        ind.down().indent();
        buf.append("</unitDefinition>\n");
        ind.down().indent();
        buf.append("</listOfUnitDefinitions>\n");
        ind.indent();
        buf.append("<listOfCompartments>\n");
        ind.up().indent();
        buf.append("<compartment name=\"A\" />\n");
        ind.down().indent();
        buf.append("</listOfCompartments>\n");
        HashMap tracker = new HashMap();
        HashMap uniqueNames = new HashMap();
        this.writeSpecies(buf, ind, "A", genome, tracker, uniqueNames);
        StringBuffer localBuf = new StringBuffer();
        HashSet set = new HashSet();
        Indenter bufIndent = new Indenter(localBuf, ind.getIndent());
        bufIndent.setCurrLevel(ind.getCurrLevel());
        this.writeRules(localBuf, bufIndent, "A", set, genome, tracker, uniqueNames);
        ind.setCurrLevel(bufIndent.getCurrLevel());
        Set missedParams = this.writeParameters(buf, ind, "A", set, genome);
        buf.append(localBuf);
        this.writeReactions(buf, ind, "A", genome, tracker, uniqueNames);
        ind.down().indent();
        buf.append("</model>\n");
    }

    public Set requiredGeneParameters(Gene gene, Genome genome) {
        HashMap tracker = new HashMap();
        HashMap uniqueNames = new HashMap();
        StringBuffer buf = new StringBuffer();
        String geneID = gene.getID();
        HashSet<String> retval = new HashSet<String>();
        retval.add("initVal");
        this.buildParam("DN", geneID, buf, retval, false);
        this.buildParam("IM", geneID, buf, retval, false);
        this.buildParam("KD", geneID, buf, retval, false);
        TreeSet<String> inputs = new TreeSet<String>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getTarget().equals(geneID)) continue;
            inputs.add(lnk.getSource());
        }
        int n = inputs.size();
        if (n == 0) {
            return retval;
        }
        for (int m = 1; m <= n; ++m) {
            this.buildParam("DN", geneID, buf, retval, false);
            long termCount = this.binomialCoefficient(n, m);
            int j = 0;
            while ((long)j < termCount) {
                SortedSet subset = this.nChooseM(inputs, m, j);
                if (subset.size() > 1) {
                    this.buildCoop("KQ", subset, geneID, buf, retval, false);
                }
                Iterator sit = subset.iterator();
                while (sit.hasNext()) {
                    String input = (String)sit.next();
                    this.buildParamTimesSpecie("KR", geneID, genome.getNode(input), "DONT_CARE", buf, retval, tracker, uniqueNames, false);
                }
                ++j;
            }
        }
        return retval;
    }

    public Set requiredNonGeneParameters(Node node, Genome genome) {
        StringBuffer buf = new StringBuffer();
        String nodeID = node.getID();
        HashSet<String> retval = new HashSet<String>();
        retval.add("initVal");
        if (0 == this.countLinksTerminatingOnNode(node, genome)) {
            this.buildParam("KD", nodeID, buf, retval, false);
        } else {
            this.buildParam("Kmult", nodeID, buf, retval, false);
        }
        return retval;
    }

    public static String extractNodeIdFromParam(String param) {
        return param.substring(param.lastIndexOf(95) + 1);
    }

    public static String extractBaseIdFromParam(String param) {
        int index = param.lastIndexOf(95);
        return param.substring(0, index == -1 ? param.length() : index);
    }

    public static String extractRootIdFromParam(String param) {
        int index = param.indexOf(95);
        return param.substring(0, index == -1 ? param.length() : index);
    }

    private void writeSpecies(StringBuffer buf, Indenter ind, String cmpt, Genome genome, HashMap tracker, HashMap uniqueNames) {
        String initVal;
        ind.indent();
        buf.append("<listOfSpecies>\n");
        ind.up();
        HashMap<String, String> sMap = new HashMap<String, String>();
        HashMap<String, String> initVals = new HashMap<String, String>();
        StringBuffer localBuf = new StringBuffer();
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            String nid = node.getID();
            DBInternalLogic dbil = ((DBNode)node).getInternalLogic();
            if (dbil != null && (initVal = dbil.getSimulationParam("initVal", node.getNodeType())) != null) {
                initVals.put(nid, initVal);
            }
            sMap.put(nid, this.buildSpecie(node, cmpt, localBuf, tracker, uniqueNames, false));
        }
        Iterator git = genome.getGeneIterator();
        while (git.hasNext()) {
            String initVal2;
            Gene gene = (Gene)git.next();
            String gid = gene.getID();
            DBInternalLogic dbil = ((DBGene)gene).getInternalLogic();
            if (dbil != null && (initVal2 = dbil.getSimulationParam("initVal", gene.getNodeType())) != null) {
                initVals.put(gid, initVal2);
            }
            sMap.put(gid, this.buildSpecie(gene, cmpt, localBuf, tracker, uniqueNames, false));
        }
        Iterator smit = sMap.keySet().iterator();
        while (smit.hasNext()) {
            String sid = (String)smit.next();
            initVal = (String)initVals.get(sid);
            ind.indent();
            buf.append("<species name=\"");
            buf.append(sMap.get(sid));
            buf.append("\" compartment=\"");
            buf.append(cmpt);
            Node node = genome.getNode(sid);
            if (node.getNodeType() == 4 || 0 == this.countLinksTerminatingOnNode(node, genome)) {
                if (initVal != null) {
                    buf.append("\" initialAmount=\"");
                    buf.append(initVal);
                } else {
                    buf.append("\" initialAmount=\"0");
                }
                buf.append("\" boundaryCondition=\"false\" />\n");
                continue;
            }
            buf.append("\" boundaryCondition=\"true\" />\n");
        }
        ind.down().indent();
        buf.append("</listOfSpecies>\n");
    }

    private int countLinksTerminatingOnNode(Node node, Genome genome) {
        int linkCount = 0;
        Iterator linkIt = genome.getLinkageIterator();
        String nodeID = node.getID();
        while (linkIt.hasNext()) {
            Linkage linkage = (Linkage)linkIt.next();
            String linkTargetID = linkage.getTarget();
            if (!linkTargetID.equals(nodeID)) continue;
            ++linkCount;
        }
        return linkCount;
    }

    private Set writeParameters(StringBuffer buf, Indenter ind, String cmpt, HashSet dict, Genome genome) {
        ind.indent();
        buf.append("<listOfParameters>\n");
        TreeSet<String> retval = new TreeSet<String>();
        ind.up();
        Iterator dit = dict.iterator();
        while (dit.hasNext()) {
            String param = (String)dit.next();
            String nodeID = SbmlSupport.extractNodeIdFromParam(param);
            String paramPrefix = SbmlSupport.extractBaseIdFromParam(param);
            DBNode dbn = (DBNode)genome.getNode(nodeID);
            DBInternalLogic dbil = dbn.getInternalLogic();
            if (dbil != null) {
                String val = dbil.getSimulationParam(paramPrefix, dbn.getNodeType());
                if (val != null) {
                    ind.indent();
                    buf.append("<parameter name=\"");
                    buf.append(param);
                    buf.append("\" value=\"");
                    buf.append(val);
                    buf.append("\" />\n");
                    continue;
                }
                retval.add(param);
                continue;
            }
            retval.add(param);
        }
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            String nid = node.getID();
            if (0 != this.countLinksTerminatingOnNode(node, genome)) continue;
            ind.indent();
            buf.append("<parameter name=\"");
            this.buildParam("DEGRF", nid, cmpt, buf, null, true);
            buf.append("\" />\n");
        }
        Iterator git = genome.getGeneIterator();
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            String gid = gene.getID();
            if (this.geneHasInputs(gid, genome)) {
                ind.indent();
                buf.append("<parameter name=\"");
                this.buildParam("Y", gid, cmpt, buf, null, true);
                buf.append("\" />\n");
                ind.indent();
                buf.append("<parameter name=\"");
                this.buildParam("CRMAS", gid, cmpt, buf, null, true);
                buf.append("\" />\n");
                ind.indent();
                buf.append("<parameter name=\"");
                this.buildParam("TRNLR", gid, cmpt, buf, null, true);
                buf.append("\" />\n");
            }
            ind.indent();
            buf.append("<parameter name=\"");
            this.buildParam("DEGRF", gid, cmpt, buf, null, true);
            buf.append("\" />\n");
        }
        ind.down().indent();
        buf.append("</listOfParameters>\n");
        return retval;
    }

    private boolean geneHasInputs(String geneID, Genome genome) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getTarget().equals(geneID)) continue;
            return true;
        }
        return false;
    }

    private void writeRules(StringBuffer buf, Indenter ind, String cmpt, HashSet dict, Genome genome, HashMap tracker, HashMap uniqueNames) {
        ind.indent();
        buf.append("<listOfRules>\n");
        ind.up();
        Iterator git = genome.getGeneIterator();
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            TreeSet<String> inputs = new TreeSet<String>();
            HashMap<String, Boolean> signs = new HashMap<String, Boolean>();
            String geneID = gene.getID();
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage lnk = (Linkage)lit.next();
                if (!lnk.getTarget().equals(geneID)) continue;
                String src = lnk.getSource();
                inputs.add(lnk.getSource());
                signs.put(src, lnk.getSign() == -1);
            }
            if (!inputs.isEmpty()) {
                ind.indent();
                buf.append("<parameterRule name=\"");
                this.buildParam("Y", geneID, cmpt, buf, null, true);
                buf.append("\" formula=\"");
                DBInternalLogic dbil = ((DBGene)gene).getInternalLogic();
                if (dbil == null) {
                    throw new IllegalArgumentException();
                }
                this.writeFormula(dbil.getFunctionType(), geneID, inputs, signs, cmpt, buf, dict, tracker, uniqueNames, genome, true);
                buf.append("\" />\n");
                ind.indent();
                buf.append("<parameterRule name=\"");
                this.buildParam("CRMAS", geneID, cmpt, buf, null, true);
                buf.append("\"");
                buf.append(" formula=\"");
                this.buildParam("Y", geneID, cmpt, buf, null, true);
                buf.append(" * ");
                this.buildParam("IM", geneID, buf, dict, true);
                buf.append("\" />\n");
                ind.indent();
                buf.append("<parameterRule name=\"");
                this.buildParam("TRNLR", geneID, cmpt, buf, null, true);
                buf.append("\"");
                buf.append(" formula=\"");
                this.buildParam("CRMAS", geneID, cmpt, buf, null, true);
                buf.append(" * 2.0\" />\n");
            }
            ind.indent();
            buf.append("<parameterRule name=\"");
            this.buildParam("DEGRF", geneID, cmpt, buf, null, true);
            buf.append("\"");
            buf.append(" formula=\"");
            this.buildParam("KD", geneID, buf, dict, true);
            buf.append(" * ");
            this.buildSpecie(gene, cmpt, buf, tracker, uniqueNames, true);
            buf.append("\" />\n");
        }
        HashMap<String, Integer> nodeInputs = new HashMap<String, Integer>();
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            String nodeID = node.getID();
            if (this.countLinksTerminatingOnNode(node, genome) == 0) {
                ind.indent();
                buf.append("<parameterRule name=\"");
                this.buildParam("DEGRF", nodeID, cmpt, buf, null, true);
                buf.append("\"");
                buf.append(" formula=\"");
                this.buildParam("KD", nodeID, buf, dict, true);
                buf.append(" * ");
                this.buildSpecie(node, cmpt, buf, tracker, uniqueNames, true);
                buf.append("\" />\n");
                continue;
            }
            DBInternalLogic internalLogic = ((DBNode)node).getInternalLogic();
            int functionType = internalLogic.getFunctionType();
            Iterator lit = genome.getLinkageIterator();
            nodeInputs.clear();
            while (lit.hasNext()) {
                int linkSign;
                Linkage lnk = (Linkage)lit.next();
                if (!lnk.getTarget().equals(nodeID) || (linkSign = lnk.getSign()) == 0) continue;
                nodeInputs.put(lnk.getSource(), new Integer(linkSign));
            }
            if (nodeInputs.size() == 0) {
                throw new IllegalStateException("aggregating node with no inputs");
            }
            ind.indent();
            buf.append("<speciesConcentrationRule species=\"");
            this.buildSpecie(node, cmpt, buf, tracker, uniqueNames, true);
            buf.append("\" formula=\"");
            String operand = null;
            switch (functionType) {
                case 0: {
                    operand = new String("*");
                    break;
                }
                case 1: {
                    operand = new String("+");
                    break;
                }
                case 2: {
                    throw new IllegalStateException("illegal state; encountered a aggregating node with an XOR function type");
                }
                default: {
                    throw new IllegalStateException("illegal state; encountered a aggregating node with an unknown function type");
                }
            }
            StringBuffer formBuf = new StringBuffer();
            this.buildParam("Kmult", nodeID, formBuf, dict, true);
            formBuf.append(" * (");
            Set keySet = nodeInputs.keySet();
            LinkedList keyList = new LinkedList(keySet);
            Collections.sort(keyList);
            Iterator inputIter = keyList.iterator();
            boolean firstInput = true;
            while (inputIter.hasNext()) {
                String inputName = (String)inputIter.next();
                Integer inputTypeObj = (Integer)nodeInputs.get(inputName);
                int inputType = inputTypeObj;
                Node inputNode = genome.getNode(inputName);
                String inputSpeciesName = this.buildSpecie(inputNode, cmpt, new StringBuffer(), tracker, uniqueNames, false);
                if (!firstInput) {
                    formBuf.append(operand);
                } else {
                    firstInput = false;
                }
                switch (inputType) {
                    case 1: {
                        formBuf.append(" " + inputSpeciesName + " ");
                        break;
                    }
                    case -1: {
                        formBuf.append(" 1/(1 + ");
                        formBuf.append(inputSpeciesName);
                        formBuf.append(") ");
                        break;
                    }
                    case 0: {
                        throw new IllegalStateException("cannot generate SBML for a diagram with a linkage with a state of \"NONE\"");
                    }
                }
            }
            formBuf.append(")");
            buf.append(formBuf.toString() + "\" />\n");
        }
        ind.down().indent();
        buf.append("</listOfRules>\n");
    }

    private void writeReactions(StringBuffer buf, Indenter ind, String cmpt, Genome genome, HashMap tracker, HashMap uniqueNames) {
        ind.indent();
        buf.append("<listOfReactions>\n");
        ind.up();
        Iterator git = genome.getGeneIterator();
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            String geneID = gene.getID();
            if (!this.geneHasInputs(geneID, genome)) continue;
            ind.indent();
            buf.append("<reaction name=\"");
            this.buildParam("REAC", geneID, cmpt, buf, null, true);
            buf.append("\" reversible=\"false\">\n");
            ind.up();
            ind.indent();
            buf.append("<listOfProducts>\n");
            ind.up().indent();
            buf.append("<speciesReference species=\"");
            this.buildSpecie(gene, cmpt, buf, tracker, uniqueNames, true);
            buf.append("\"/>\n");
            ind.down().indent();
            buf.append("</listOfProducts>\n");
            ind.indent();
            buf.append("<kineticLaw formula=\"");
            this.buildParam("TRNLR", geneID, cmpt, buf, null, true);
            buf.append("\" />\n");
            ind.down().indent();
            buf.append("</reaction>\n");
        }
        HashSet<String> ids = new HashSet<String>();
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            int nodeType = node.getNodeType();
            if (this.countLinksTerminatingOnNode(node, genome) != 0) continue;
            ids.add(node.getID());
        }
        git = genome.getGeneIterator();
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            ids.add(gene.getID());
        }
        Iterator idit = ids.iterator();
        while (idit.hasNext()) {
            String id = (String)idit.next();
            Node node = genome.getNode(id);
            int nodeType = node.getNodeType();
            ind.indent();
            buf.append("<reaction name=\"");
            this.buildParam("DEGR", id, cmpt, buf, null, true);
            buf.append("\" reversible=\"false\">\n");
            ind.up().indent();
            buf.append("<listOfReactants>\n");
            ind.up().indent();
            buf.append("<speciesReference species=\"");
            this.buildSpecie(genome.getNode(id), cmpt, buf, tracker, uniqueNames, true);
            buf.append("\"/>\n");
            ind.down().indent();
            buf.append("</listOfReactants>\n");
            ind.indent();
            buf.append("<kineticLaw formula=\"");
            this.buildParam("DEGRF", id, cmpt, buf, null, true);
            buf.append("\" />\n");
            ind.down().indent();
            buf.append("</reaction>\n");
        }
        ind.down().indent();
        buf.append("</listOfReactions>\n");
    }

    private String writeFormula(int logicFunction, String out, SortedSet inputs, HashMap signs, String cmpt, StringBuffer buf, HashSet dict, HashMap tracker, HashMap uniqueNames, Genome genome, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        int size = inputs.size();
        buf.append("(");
        for (int m = 1; m <= size; ++m) {
            this.buildTermsOfSize(logicFunction, inputs, signs, out, m, cmpt, buf, dict, tracker, uniqueNames, genome, true);
            if (m >= size) continue;
            buf.append(" + ");
        }
        buf.append(") / (");
        this.buildDenominator(logicFunction, inputs, out, cmpt, buf, dict, tracker, uniqueNames, genome, true);
        buf.append(")");
        return append ? null : buf.toString();
    }

    private String buildDenominator(int logicFunction, SortedSet inputs, String out, String cmpt, StringBuffer buf, HashSet dict, HashMap tracker, HashMap uniqueNames, Genome genome, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        int n = inputs.size();
        buf.append("(");
        this.buildParam("DN", out, buf, dict, true);
        if (n > 1) {
            buf.append("^");
            buf.append(n);
            buf.append(".0");
        }
        buf.append(")");
        buf.append(" + (");
        if (n > 1) {
            buf.append("(");
            this.buildParam("DN", out, buf, dict, true);
            if (n > 2) {
                buf.append("^");
                buf.append(Integer.toString(n - 1));
                buf.append(".0");
            }
            buf.append(")*");
        }
        buf.append("(");
        Iterator iit = inputs.iterator();
        while (iit.hasNext()) {
            String input = (String)iit.next();
            this.buildSpecie(genome.getNode(input), cmpt, buf, tracker, uniqueNames, true);
            if (!iit.hasNext()) continue;
            buf.append("+");
        }
        buf.append("))");
        buf.append(" + ");
        for (int m = 1; m <= n; ++m) {
            this.buildTermsOfSize(logicFunction, inputs, null, out, m, cmpt, buf, dict, tracker, uniqueNames, genome, true);
            if (m >= n) continue;
            buf.append(" + ");
        }
        return append ? null : buf.toString();
    }

    private String buildTermsOfSize(int logicFunction, SortedSet inputs, HashMap signs, String out, int m, String cmpt, StringBuffer buf, HashSet dict, HashMap tracker, HashMap uniqueNames, Genome genome, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        int n = inputs.size();
        buf.append("(");
        int exp = n - m;
        if (exp > 0) {
            buf.append("(");
            this.buildParam("DN", out, buf, dict, true);
            if (exp > 1) {
                buf.append("^");
                buf.append(exp);
                buf.append(".0");
            }
            buf.append(")*(");
        }
        long termCount = this.binomialCoefficient(n, m);
        int j = 0;
        while ((long)j < termCount) {
            SortedSet subset = this.nChooseM(inputs, m, j);
            boolean useTerm = this.getTruthValue(subset, inputs, logicFunction, signs);
            if (useTerm) {
                if (subset.size() > 1) {
                    this.buildCoop("KQ", subset, out, buf, dict, true);
                    buf.append("*(");
                }
                Iterator sit = subset.iterator();
                while (sit.hasNext()) {
                    String input = (String)sit.next();
                    this.buildParamTimesSpecie("KR", out, genome.getNode(input), cmpt, buf, dict, tracker, uniqueNames, true);
                    if (sit.hasNext()) {
                        buf.append("*");
                        continue;
                    }
                    if (subset.size() <= 1) continue;
                    buf.append(")");
                }
            } else {
                buf.append("0");
            }
            if ((long)j < termCount - 1L) {
                buf.append("+");
            }
            ++j;
        }
        if (exp > 0) {
            buf.append(")");
        }
        buf.append(")");
        return append ? null : buf.toString();
    }

    private SortedSet nChooseM(SortedSet s, int m, int which) {
        int size = s.size();
        if (which < 0 || (long)which >= this.binomialCoefficient(size, m)) {
            System.err.println("Bad which: " + which + " size: " + size + " bc: " + this.binomialCoefficient(size, m));
            throw new IllegalArgumentException();
        }
        int count = -1;
        int selection = -1;
        while (count != which) {
            if (!this.nBitsOn(++selection, m)) continue;
            ++count;
        }
        return this.generateSubset(s, selection);
    }

    private long binomialCoefficient(int n, int m) {
        if (m > n) {
            throw new IllegalArgumentException();
        }
        long num = 1L;
        for (int i = n; i > m; --i) {
            num *= (long)i;
        }
        long denom = 1L;
        for (int i = n - m; i > 1; --i) {
            denom *= (long)i;
        }
        return num / denom;
    }

    private boolean nBitsOn(int num, int bitcount) {
        int count = 0;
        for (int shifted = num; shifted != 0; shifted >>>= 1) {
            if ((shifted & 1) != 1) continue;
            ++count;
        }
        return count == bitcount;
    }

    private SortedSet generateSubset(SortedSet set, int which) {
        TreeSet retval = new TreeSet();
        Iterator sit = set.iterator();
        int slotnum = 0;
        while (sit.hasNext()) {
            Object obj = sit.next();
            if ((which >>> slotnum++ & 1) != 1) continue;
            retval.add(obj);
        }
        return retval;
    }

    private boolean getTruthValue(Set inputSubset, Set allInputs, int logicFunction, Map inputSigns) {
        if (inputSigns == null) {
            return true;
        }
        ArrayList<Boolean> converted = new ArrayList<Boolean>();
        Iterator aiit = allInputs.iterator();
        while (aiit.hasNext()) {
            String input = (String)aiit.next();
            boolean convVal = inputSubset.contains(input);
            Boolean sign = (Boolean)inputSigns.get(input);
            if (sign.booleanValue()) {
                convVal = !convVal;
            }
            converted.add(convVal);
        }
        boolean retval = false;
        int sum = 0;
        Iterator cit = converted.iterator();
        boolean firstPass = true;
        while (cit.hasNext()) {
            boolean input = (Boolean)cit.next();
            switch (logicFunction) {
                case 0: {
                    if (firstPass) {
                        retval = true;
                    }
                    if (input) break;
                    return false;
                }
                case 1: {
                    if (firstPass) {
                        retval = false;
                    }
                    if (!input) break;
                    return true;
                }
                case 2: {
                    retval = (sum += input ? 1 : 0) == 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            firstPass = false;
        }
        return retval;
    }

    private String buildParamTimesSpecie(String prefix, String out, Node node, String cmpt, StringBuffer buf, HashSet dict, HashMap tracker, HashMap uniqueNames, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        buf.append("(");
        this.buildParam(prefix, node.getID(), out, buf, dict, true);
        buf.append("*");
        this.buildSpecie(node, cmpt, buf, tracker, uniqueNames, true);
        buf.append(")");
        return append ? null : buf.toString();
    }

    private String buildSpecie(Node node, String cmpt, StringBuffer buf, HashMap tracker, HashMap uniqueNames, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        buf.append("bt");
        buf.append(this.buildUniqueDisplayName(node, tracker, uniqueNames));
        buf.append('_');
        buf.append(cmpt);
        return append ? null : buf.toString();
    }

    private String buildCoop(String prefix, SortedSet inputs, String output, StringBuffer buf, HashSet dict, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        int startPos = buf.length();
        buf.append(prefix);
        buf.append('_');
        Iterator iit = inputs.iterator();
        while (iit.hasNext()) {
            String input = (String)iit.next();
            buf.append(input);
            buf.append('_');
        }
        buf.append(output);
        if (dict != null) {
            dict.add(buf.substring(startPos));
        }
        return append ? null : buf.toString();
    }

    private String buildParam(String prefix, String input, String output, StringBuffer buf, HashSet dict, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        int startPos = buf.length();
        buf.append(prefix);
        buf.append('_');
        buf.append(input);
        buf.append('_');
        buf.append(output);
        if (dict != null) {
            dict.add(buf.substring(startPos));
        }
        return append ? null : buf.toString();
    }

    private String buildParam(String prefix, String output, StringBuffer buf, HashSet dict, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        int startPos = buf.length();
        buf.append(prefix);
        buf.append('_');
        buf.append(output);
        if (dict != null) {
            dict.add(buf.substring(startPos));
        }
        return append ? null : buf.toString();
    }

    private String buildUniqueDisplayName(Node node, HashMap tracker, HashMap uniqueNames) {
        UniqueTracker trackEntry;
        String retval = (String)uniqueNames.get(node.getID());
        if (retval != null) {
            return retval;
        }
        String name = node.getName();
        if (name.trim().equals("")) {
            name = "unnamed";
        }
        if ((trackEntry = (UniqueTracker)tracker.get(name)) == null) {
            trackEntry = new UniqueTracker(name);
            tracker.put(name, trackEntry);
        }
        if (trackEntry.count == 0) {
            trackEntry.count = 1;
            retval = name;
        } else {
            retval = name + "_" + trackEntry.count++;
        }
        uniqueNames.put(node.getID(), retval);
        return retval;
    }

    class UniqueTracker {
        String display;
        int count;

        UniqueTracker(String display) {
            this.display = display;
            this.count = 0;
        }
    }
}

