/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMembership;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.util.DataUtil;

public class SifSupport {
    private DBGenome genome_;
    private GenomeInstance gi_;

    public SifSupport(DBGenome genome) {
        this.genome_ = genome;
    }

    public SifSupport(GenomeInstance gi) {
        this.gi_ = gi;
    }

    public void writeSIF(PrintWriter out) {
        Cloneable useGenome = this.genome_ == null ? this.gi_ : this.genome_;
        HashSet<String> seen = new HashSet<String>();
        HashMap outputs = new HashMap();
        Iterator links = useGenome.getLinkageIterator();
        while (links.hasNext()) {
            Linkage lnk = (Linkage)links.next();
            String src = lnk.getSource();
            String trg = lnk.getTarget();
            int sign = lnk.getSign();
            seen.add(src);
            seen.add(trg);
            this.writeSIFLink(out, src, trg, sign, outputs, (Genome)((Object)useGenome));
        }
        Iterator genes = useGenome.getGeneIterator();
        while (genes.hasNext()) {
            Gene g = (Gene)genes.next();
            if (seen.contains(g.getID())) continue;
            out.println(this.sifNodeName(g, outputs, (Genome)((Object)useGenome)));
        }
        Iterator nodes = useGenome.getNodeIterator();
        while (nodes.hasNext()) {
            Node n = (Node)nodes.next();
            String id = n.getID();
            if (seen.contains(id)) continue;
            out.println(this.sifNodeName(n, outputs, (Genome)((Object)useGenome)));
        }
    }

    private void writeSIFLink(PrintWriter out, String src, String trg, int sign, Map outputs, Genome useGenome) {
        String srcName = this.sifNodeName(useGenome.getNode(src), outputs, useGenome);
        String trgName = this.sifNodeName(useGenome.getNode(trg), outputs, useGenome);
        out.print(srcName);
        for (int i = srcName.length(); i < 16; ++i) {
            out.print(" ");
        }
        out.print("\t");
        String edge = null;
        if (sign == 1) {
            edge = "PROMOTES";
        } else if (sign == -1) {
            edge = "REPRESSES";
        } else if (sign == 0) {
            edge = "REGULATES";
        }
        out.print(edge);
        for (int i = edge.length(); i < 20; ++i) {
            out.print(" ");
        }
        out.print("\t");
        out.println(trgName);
    }

    private String sifNodeName(Node node, Map outputs, Genome useGenome) {
        String activeSuffix;
        String groupPrefix = useGenome == this.gi_ ? this.sifRegionPrefix((NodeInstance)node, this.gi_) : "";
        String string = activeSuffix = useGenome == this.gi_ ? this.sifActivitySuffix((NodeInstance)node, this.gi_) : "";
        if (node.getNodeType() == 4) {
            String retval = this.padForUnique(node, groupPrefix + node.getName() + activeSuffix, outputs);
            outputs.put(node.getID(), retval);
            return retval;
        }
        String name = node.getName();
        String prefix = name == null || name.trim().equals("") ? "(" + DBNode.mapToTag(node.getNodeType()) + ")" : name;
        String retval = this.padForUnique(node, groupPrefix + prefix + "." + node.getID() + activeSuffix, outputs);
        outputs.put(node.getID(), retval);
        return retval;
    }

    private String sifRegionPrefix(NodeInstance node, GenomeInstance gi) {
        GroupMembership memb = gi.getNodeGroupMembership(node);
        if (memb.mainGroups.size() == 0) {
            return "[--no region--" + node.getID() + "]:";
        }
        if (memb.mainGroups.size() != 1) {
            throw new IllegalStateException();
        }
        String parent = (String)memb.mainGroups.iterator().next();
        Group parentGroup = gi.getGroup(parent);
        String activeSub = parentGroup.getActiveSubset();
        if (activeSub != null) {
            if (memb.subGroups.size() == 0) {
                return "[--no region--" + node.getID() + "]:";
            }
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            Iterator sit = memb.subGroups.iterator();
            while (sit.hasNext()) {
                String subID = (String)sit.next();
                Group subGroup = gi.getGroup(subID);
                buf.append(subGroup.getInheritedDisplayName(gi));
                if (!sit.hasNext()) continue;
                buf.append(":");
            }
            buf.append("]:");
            return buf.toString();
        }
        return "[" + parentGroup.getInheritedDisplayName(gi) + "]:";
    }

    private String sifActivitySuffix(NodeInstance node, GenomeInstance gi) {
        int activity = node.getActivity();
        if (activity == 0) {
            return "";
        }
        String activTag = NodeInstance.mapActivityTypes(activity);
        return "{" + activTag + "}";
    }

    private String padForUnique(Node node, String name, Map outputs) {
        String retval = (String)outputs.get(node.getID());
        if (retval == null) {
            retval = name;
            while (DataUtil.containsKey(outputs.values(), retval)) {
                retval = "_" + retval;
            }
        }
        return retval;
    }
}

