/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.util.List;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorkerClient;
import org.systemsbiology.biotapestry.util.MultiUrlRetrievalWorker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UrlRetrievalWorkerClient;

public abstract class URLDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        return this.isUrlListPerInstance(genomeID, itemID);
    }

    public boolean haveCallbackWorker() {
        return true;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String itemID) {
        List urls = this.getUrlListFromArgs(genomeID, itemID);
        return new URLDisplayWorker(urls);
    }

    public String getDataAsHTML(String genomeID, String itemID) {
        List urls = this.getUrlListFromArgs(genomeID, itemID);
        if (urls.isEmpty()) {
            return " ";
        }
        return ResourceManager.getManager().getString("dataWindow.waitingForResponse");
    }

    protected abstract List getUrlListFromArgs(String var1, String var2);

    protected abstract boolean isUrlListPerInstance(String var1, String var2);

    public static class URLDisplayWorker
    implements PluginCallbackWorker,
    UrlRetrievalWorkerClient {
        private MultiUrlRetrievalWorker murw_;
        private PluginCallbackWorkerClient myClient_;
        private String myID_;

        public URLDisplayWorker(List urls) {
            this.murw_ = new MultiUrlRetrievalWorker(urls, this);
        }

        public void run() {
            this.murw_.run();
        }

        public void setIDAndClient(String idKey, PluginCallbackWorkerClient client) {
            this.myID_ = idKey;
            this.myClient_ = client;
        }

        public void retrievedResult(String theUrl, String result) {
            this.myClient_.retrievedResult(this.myID_, result);
        }
    }
}

