/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.TopOfTheHeap;
import org.systemsbiology.biotapestry.genome.URLDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.InternalLinkDataDisplayPlugIn;

public class URLLinkDisplayPlugIn
extends URLDisplayPlugIn
implements InternalLinkDataDisplayPlugIn {
    protected boolean isUrlListPerInstance(String genomeID, String itemId) {
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        Genome genome = tooth.getGenome();
        boolean haveInstance = tooth.isInstance();
        if (!haveInstance) {
            return false;
        }
        Linkage link = genome.getLinkage(itemId);
        return link.getURLCount() != 0;
    }

    protected List getUrlListFromArgs(String genomeID, String linkID) {
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        Genome genome = tooth.getGenome();
        boolean haveInstance = tooth.isInstance();
        Database db = Database.getDB();
        ArrayList<String> retval = new ArrayList<String>();
        Linkage link = genome.getLinkage(linkID);
        if (link.getURLCount() == 0 && haveInstance) {
            Genome useGenome = db.getGenome();
            String useID = GenomeItemInstance.getBaseID(linkID);
            link = useGenome.getLinkage(useID);
        }
        Iterator uit = link.getURLs();
        while (uit.hasNext()) {
            String urlString = (String)uit.next();
            retval.add(urlString);
        }
        return retval;
    }
}

