/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.TopOfTheHeap;
import org.systemsbiology.biotapestry.genome.URLDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.InternalNodeDataDisplayPlugIn;

public class URLNodeDisplayPlugIn
extends URLDisplayPlugIn
implements InternalNodeDataDisplayPlugIn {
    protected boolean isUrlListPerInstance(String genomeID, String itemId) {
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        Genome genome = tooth.getGenome();
        boolean haveInstance = tooth.isInstance();
        if (!haveInstance) {
            return false;
        }
        Node node = genome.getNode(itemId);
        return node.getURLCount() != 0;
    }

    protected List getUrlListFromArgs(String genomeID, String geneId) {
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        Genome genome = tooth.getGenome();
        boolean haveInstance = tooth.isInstance();
        Database db = Database.getDB();
        Node node = genome.getNode(geneId);
        if (node.getURLCount() == 0 && haveInstance) {
            Genome useGenome = db.getGenome();
            String useID = GenomeItemInstance.getBaseID(geneId);
            node = useGenome.getNode(useID);
        }
        ArrayList<String> retval = new ArrayList<String>();
        Iterator uit = node.getURLs();
        while (uit.hasNext()) {
            String urlString = (String)uit.next();
            retval.add(urlString);
        }
        return retval;
    }
}

