/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.embedded.ExternalInventoryItem;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.event.GeneralChangeListener;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeListener;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.TopOfTheHeap;
import org.systemsbiology.biotapestry.nav.DataPopupStringBuilder;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.dialogs.LinkUsageDisplayFrame;
import org.systemsbiology.biotapestry.ui.dialogs.NodeUsageDisplayFrame;

public class DataPopupManager
implements GeneralChangeListener,
ModelChangeListener {
    private static DataPopupManager singleton_;
    private HashMap popups_ = new HashMap();
    private HashMap linkPopups_ = new HashMap();
    private HashMap nodeSelections_ = new HashMap();
    private HashMap linkSelections_ = new HashMap();
    private boolean clearing_ = false;

    public void generalChangeOccurred(GeneralChangeEvent gcev) {
        this.fullRefresh();
    }

    public void modelHasChanged(ModelChangeEvent event, int remaining) {
        this.modelHasChanged(event);
    }

    public void modelHasChanged(ModelChangeEvent mcev) {
        int change = mcev.getChangeType();
        if (change == 1) {
            this.fullRefresh();
        } else if (change == 2) {
            if (mcev.getGenomeKey().equals(Database.getDB().getGenome().getID())) {
                this.fullClear();
            } else {
                this.fullRefresh();
            }
        } else if (change == 3) {
            this.fullRefresh();
        } else if (change == 4) {
            this.fullRefresh();
        }
    }

    public void popupData(String genomeID, String nodeID) {
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        genomeID = tooth.getID();
        boolean isInstance = tooth.isInstance();
        ExternalInventoryItem.BuilderArgs ba = new ExternalInventoryItem.BuilderArgs(genomeID, nodeID, false);
        boolean needPerInstance = DataPopupStringBuilder.needPerInstanceForNode(ba);
        FrameKey fkey = new FrameKey(genomeID, nodeID, needPerInstance, isInstance);
        ba = new ExternalInventoryItem.BuilderArgs(fkey.genomeID, fkey.itemID, false);
        FrameInfo existing = (FrameInfo)this.popups_.get(fkey);
        if (existing != null) {
            existing.frame.setExtendedState(0);
            existing.frame.toFront();
        } else {
            JEditorPane pane = new JEditorPane("text/html", "");
            DataPopupStringBuilder builder = new DataPopupStringBuilder(pane, ba);
            builder.prepare();
            Genome keyGenome = Database.getDB().getGenome(fkey.genomeID);
            Node node = keyGenome.getNode(fkey.itemID);
            String title = node.getDisplayString(keyGenome, false);
            JFrame frame = this.createDataWindow(fkey, title, pane, true);
            this.popups_.put(fkey, new FrameInfo(fkey.genomeID, fkey.itemID, title, pane, frame, null, builder));
            frame.setVisible(true);
            builder.kickOff();
        }
    }

    public void popupLinkData(String genomeID, String linkID) {
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        genomeID = tooth.getID();
        boolean isInstance = tooth.isInstance();
        ExternalInventoryItem.BuilderArgs ba = new ExternalInventoryItem.BuilderArgs(genomeID, linkID, true);
        boolean needPerInstance = DataPopupStringBuilder.needPerInstanceForLink(ba);
        FrameKey fkey = new FrameKey(genomeID, linkID, needPerInstance, isInstance);
        ba = new ExternalInventoryItem.BuilderArgs(fkey.genomeID, fkey.itemID, true);
        FrameInfo existing = (FrameInfo)this.linkPopups_.get(fkey);
        if (existing != null) {
            existing.frame.setExtendedState(0);
            existing.frame.toFront();
        } else {
            JEditorPane pane = new JEditorPane("text/html", "");
            DataPopupStringBuilder builder = new DataPopupStringBuilder(pane, ba);
            builder.prepare();
            Genome keyGenome = Database.getDB().getGenome(fkey.genomeID);
            Linkage link = keyGenome.getLinkage(fkey.itemID);
            String title = link.getDisplayString(keyGenome, false);
            JFrame frame = this.createDataWindow(fkey, title, pane, false);
            this.linkPopups_.put(fkey, new FrameInfo(fkey.genomeID, fkey.itemID, title, pane, frame, null, builder));
            frame.setVisible(true);
            builder.kickOff();
        }
    }

    public void displayNodeUsages(JFrame parent, String nodeID, GenomePresentation pre) {
        String baseID = GenomeItemInstance.getBaseID(nodeID);
        FrameInfo existing = (FrameInfo)this.nodeSelections_.get(baseID);
        if (existing != null) {
            existing.frame.setExtendedState(0);
            existing.frame.toFront();
        } else {
            NodeUsageDisplayFrame nudd = new NodeUsageDisplayFrame(parent, baseID, pre);
            this.nodeSelections_.put(baseID, new FrameInfo(null, baseID, null, null, nudd, null, null));
            nudd.setVisible(true);
        }
    }

    public void displayLinkUsages(JFrame parent, Set linkUsage, GenomePresentation pre) {
        Database db = Database.getDB();
        Genome genome = db.getGenome();
        HashSet<String> baseLinks = new HashSet<String>();
        String baseSrcID = null;
        Iterator lit = linkUsage.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            String baseLinkID = GenomeItemInstance.getBaseID(linkID);
            if (baseSrcID == null) {
                Linkage baseLink = genome.getLinkage(baseLinkID);
                baseSrcID = baseLink.getSource();
            }
            baseLinks.add(baseLinkID);
        }
        FrameInfo existing = (FrameInfo)this.linkSelections_.get(baseSrcID);
        if (existing != null) {
            if (!((Object)existing.linkIDs).equals(baseLinks)) {
                ((LinkUsageDisplayFrame)existing.frame).updateLinkSet(baseLinks);
            }
            existing.frame.setExtendedState(0);
            existing.frame.toFront();
        } else {
            LinkUsageDisplayFrame ludd = new LinkUsageDisplayFrame(parent, baseLinks, pre, baseSrcID);
            this.linkSelections_.put(baseSrcID, new FrameInfo(null, baseSrcID, null, null, ludd, baseLinks, null));
            ludd.setVisible(true);
        }
    }

    public void dropSelectionWindow(String geneID) {
        if (this.clearing_) {
            return;
        }
        FrameInfo existing = (FrameInfo)this.nodeSelections_.get(geneID);
        if (existing != null) {
            this.nodeSelections_.remove(geneID);
            existing.frame.dispose();
        }
    }

    public void dropLinkSelectionWindow(String srcID) {
        if (this.clearing_) {
            return;
        }
        FrameInfo existing = (FrameInfo)this.linkSelections_.get(srcID);
        if (existing != null) {
            this.linkSelections_.remove(srcID);
            existing.frame.dispose();
        }
    }

    public void dropDataWindow(FrameKey fiKey) {
        if (this.clearing_) {
            return;
        }
        FrameInfo existing = (FrameInfo)this.popups_.get(fiKey);
        if (existing != null) {
            this.popups_.remove(fiKey);
            existing.builder.discardBuilder();
            existing.frame.dispose();
        }
    }

    public void dropLinkDataWindow(FrameKey fiKey) {
        if (this.clearing_) {
            return;
        }
        FrameInfo existing = (FrameInfo)this.linkPopups_.get(fiKey);
        if (existing != null) {
            this.linkPopups_.remove(fiKey);
            existing.builder.discardBuilder();
            existing.frame.dispose();
        }
    }

    public static synchronized DataPopupManager getPopupMgr() {
        if (singleton_ == null) {
            singleton_ = new DataPopupManager();
        }
        return singleton_;
    }

    private DataPopupManager() {
        EventManager em = EventManager.getManager();
        em.addModelChangeListener(this);
        em.addGeneralChangeListener(this);
    }

    private JFrame createDataWindow(FrameKey key, String title, JEditorPane pane, boolean forNode) {
        pane.setEditable(false);
        if (DisplayOptionsManager.getMgr().isForBigScreen()) {
            HTMLDocument doc = (HTMLDocument)pane.getDocument();
            StyleSheet styles = doc.getStyleSheet();
            String rule1 = "h1 {font-size: 60pt;}";
            styles.addRule(rule1);
        }
        JFrame frame = new JFrame(title == null || title.trim().equals("") ? "\" \"" : title);
        URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/BioTapFab16White.gif");
        frame.setIconImage(new ImageIcon(ugif).getImage());
        final JEditorPane fpane = pane;
        pane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent ev) {
                try {
                    if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        fpane.setPage(ev.getURL());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        final FrameKey closeID = key;
        if (forNode) {
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    DataPopupManager.this.dropDataWindow(closeID);
                }
            });
        } else {
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    DataPopupManager.this.dropLinkDataWindow(closeID);
                }
            });
        }
        frame.setSize(1024, 768);
        JPanel cp = (JPanel)frame.getContentPane();
        cp.add(new JScrollPane(pane));
        pane.setCaretPosition(0);
        return frame;
    }

    private void fullRefresh() {
        FrameInfo info;
        Node node;
        Database db = Database.getDB();
        Iterator<Object> fit = new HashSet(this.popups_.keySet()).iterator();
        while (fit.hasNext()) {
            FrameKey fiID = (FrameKey)fit.next();
            FrameInfo info2 = (FrameInfo)this.popups_.get(fiID);
            Genome nodeGenome = db.getGenome(info2.genomeKey);
            node = nodeGenome.getNode(info2.itemID);
            if (node != null) {
                boolean isInstance;
                ExternalInventoryItem.BuilderArgs ba = new ExternalInventoryItem.BuilderArgs(info2.genomeKey, info2.itemID, false);
                boolean needPerInstance = DataPopupStringBuilder.needPerInstanceForNode(ba);
                boolean bl = isInstance = !GenomeItemInstance.isBaseID(info2.itemID);
                if (needPerInstance != isInstance) {
                    this.dropDataWindow(fiID);
                    continue;
                }
                info2.winTitle = node.getDisplayString(nodeGenome, false);
                this.fullRefreshCore(info2, false);
                continue;
            }
            this.dropDataWindow(fiID);
        }
        Iterator flit = new HashSet(this.linkPopups_.keySet()).iterator();
        while (flit.hasNext()) {
            FrameKey fiID = (FrameKey)flit.next();
            info = (FrameInfo)this.linkPopups_.get(fiID);
            Genome linkGenome = db.getGenome(info.genomeKey);
            Linkage link = linkGenome.getLinkage(info.itemID);
            if (link != null) {
                boolean isInstance;
                ExternalInventoryItem.BuilderArgs ba = new ExternalInventoryItem.BuilderArgs(info.genomeKey, info.itemID, true);
                boolean needPerInstance = DataPopupStringBuilder.needPerInstanceForLink(ba);
                boolean bl = isInstance = !GenomeItemInstance.isBaseID(info.itemID);
                if (needPerInstance != isInstance) {
                    this.dropLinkDataWindow(fiID);
                    continue;
                }
                info.winTitle = link.getDisplayString(linkGenome, false);
                this.fullRefreshCore(info, true);
                continue;
            }
            this.dropLinkDataWindow(fiID);
        }
        Genome genome = db.getGenome();
        fit = new HashSet(this.nodeSelections_.values()).iterator();
        while (fit.hasNext()) {
            info = (FrameInfo)fit.next();
            node = genome.getNode(info.itemID);
            if (node != null) {
                ((NodeUsageDisplayFrame)info.frame).refreshList();
                continue;
            }
            this.dropSelectionWindow(info.itemID);
        }
        fit = new HashSet(this.linkSelections_.values()).iterator();
        while (fit.hasNext()) {
            info = (FrameInfo)fit.next();
            node = genome.getNode(info.itemID);
            if (node == null) {
                this.dropLinkSelectionWindow(info.itemID);
                continue;
            }
            HashSet<String> baseLinks = new HashSet<String>();
            Iterator lit = info.linkIDs.iterator();
            while (lit.hasNext()) {
                String linkID = (String)lit.next();
                String baseLinkID = GenomeItemInstance.getBaseID(linkID);
                Linkage baseLink = genome.getLinkage(baseLinkID);
                if (baseLink == null || !baseLink.getSource().equals(info.itemID)) continue;
                baseLinks.add(baseLinkID);
            }
            if (baseLinks.size() == 0) {
                this.dropLinkSelectionWindow(info.itemID);
                continue;
            }
            if (!baseLinks.equals(info.linkIDs)) {
                ((LinkUsageDisplayFrame)info.frame).updateLinkSet(baseLinks);
                info.linkIDs = baseLinks;
                continue;
            }
            ((LinkUsageDisplayFrame)info.frame).refreshList();
        }
    }

    private void fullRefreshCore(FrameInfo info, boolean forLink) {
        info.builder.discardBuilder();
        info.frame.setTitle(info.winTitle);
        ExternalInventoryItem.BuilderArgs ba = new ExternalInventoryItem.BuilderArgs(info.genomeKey, info.itemID, forLink);
        info.builder = new DataPopupStringBuilder(info.pane, ba);
        info.builder.prepare();
        info.builder.kickOff();
    }

    private void fullClear() {
        FrameInfo info;
        this.clearing_ = true;
        Iterator fit = this.popups_.values().iterator();
        while (fit.hasNext()) {
            FrameInfo info2 = (FrameInfo)fit.next();
            info2.builder.discardBuilder();
            info2.frame.dispose();
        }
        this.popups_.clear();
        Iterator flit = this.linkPopups_.values().iterator();
        while (flit.hasNext()) {
            info = (FrameInfo)flit.next();
            info.builder.discardBuilder();
            info.frame.dispose();
        }
        this.linkPopups_.clear();
        fit = this.nodeSelections_.values().iterator();
        while (fit.hasNext()) {
            info = (FrameInfo)fit.next();
            info.frame.dispose();
        }
        this.nodeSelections_.clear();
        fit = this.linkSelections_.values().iterator();
        while (fit.hasNext()) {
            info = (FrameInfo)fit.next();
            info.frame.dispose();
        }
        this.linkSelections_.clear();
        this.clearing_ = false;
    }

    public static class FrameKey {
        String genomeID;
        String itemID;

        FrameKey(String genomeID, String itemID, boolean needPerInstance, boolean isInstance) {
            if (needPerInstance) {
                this.genomeID = genomeID;
                this.itemID = itemID;
            } else if (isInstance) {
                this.genomeID = Database.getDB().getGenome().getID();
                this.itemID = GenomeItemInstance.getBaseID(itemID);
            } else {
                this.genomeID = genomeID;
                this.itemID = itemID;
            }
        }

        public int hashCode() {
            return this.genomeID.hashCode() + this.itemID.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof FrameKey)) {
                return false;
            }
            FrameKey otherFK = (FrameKey)other;
            return this.genomeID.equals(otherFK.genomeID) && this.itemID.equals(otherFK.itemID);
        }

        public String toString() {
            return "FrameKey genomeID: " + this.genomeID + " itemID: " + this.itemID;
        }
    }

    private static class FrameInfo {
        String genomeKey;
        String itemID;
        String winTitle;
        JEditorPane pane;
        JFrame frame;
        Set linkIDs;
        DataPopupStringBuilder builder;

        FrameInfo(String genomeKey, String itemID, String winTitle, JEditorPane pane, JFrame frame, Set linkIDs, DataPopupStringBuilder builder) {
            this.genomeKey = genomeKey;
            this.itemID = itemID;
            this.winTitle = winTitle;
            this.pane = pane;
            this.frame = frame;
            this.linkIDs = linkIDs;
            this.builder = builder;
        }
    }
}

