/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.embedded.ExternalInventoryItem;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.plugin.DataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.ExternalDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.ExternalLinkDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.ExternalNodeDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.InternalDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.InternalLinkDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.InternalNodeDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PlugInManager;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorkerClient;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class DataPopupStringBuilder
implements PluginCallbackWorkerClient {
    private JEditorPane pane_;
    private ExternalInventoryItem.BuilderArgs args_;
    private ArrayList drawBlocks_;
    private ArrayList threadList_;
    private String desc_;
    private boolean bigScreen_;
    private boolean discarded_;

    public DataPopupStringBuilder(JEditorPane pane, ExternalInventoryItem.BuilderArgs args) {
        this.pane_ = pane;
        this.args_ = args;
        this.drawBlocks_ = new ArrayList();
        this.threadList_ = new ArrayList();
        this.bigScreen_ = DisplayOptionsManager.getMgr().isForBigScreen();
        this.discarded_ = false;
    }

    public void discardBuilder() {
        this.discarded_ = true;
        this.pane_ = null;
    }

    public void retrievedResult(String idKey, String result) {
        final String fid = idKey;
        final String fresult = result;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DataPopupStringBuilder.this.processResult(fid, fresult);
            }
        });
    }

    public void prepare() {
        Genome genome = Database.getDB().getGenome(this.args_.genomeKey);
        if (this.args_.isALink) {
            Linkage link = genome.getLinkage(this.args_.itemID);
            String title = link.getDisplayString(genome, false);
            String useName = title == null || title.trim().equals("") ? "\" \"" : title;
            String format = ResourceManager.getManager().getString("dataWindow.dataForLinkFormat");
            this.desc_ = MessageFormat.format(format, useName);
            this.prepareBlocksAndThreadsForLink();
        } else {
            Node node = genome.getNode(this.args_.itemID);
            String title = node.getDisplayString(genome, false);
            String useName = title == null || title.trim().equals("") ? "\" \"" : title;
            String format = ResourceManager.getManager().getString("dataWindow.dataForNodeFormat");
            this.desc_ = MessageFormat.format(format, useName);
            this.prepareBlocksAndThreads();
        }
        String contents = this.buildString();
        this.pane_.setText(contents);
        this.pane_.setCaretPosition(0);
        this.pane_.invalidate();
        this.pane_.validate();
    }

    public void kickOff() {
        int numBlocks = this.threadList_.size();
        for (int i = 0; i < numBlocks; ++i) {
            Thread nextThread = (Thread)this.threadList_.get(i);
            nextThread.run();
        }
        this.threadList_.clear();
    }

    private void processResult(String idKey, String result) {
        int index;
        if (this.discarded_) {
            return;
        }
        try {
            index = Integer.parseInt(idKey);
        }
        catch (NumberFormatException nfex) {
            throw new IllegalStateException();
        }
        this.drawBlocks_.set(index, result);
        String contents = this.buildString();
        this.pane_.setText(contents);
        this.pane_.setCaretPosition(0);
        this.pane_.invalidate();
        this.pane_.validate();
    }

    private String buildString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("  <body>");
        buf.append("<p></p>");
        buf.append("<center><h1>");
        buf.append(this.desc_);
        buf.append("</h1></center>\n");
        buf.append("<p></p><hr width=\"50%\" align=\"center\">");
        int numBlocks = this.drawBlocks_.size();
        for (int i = 0; i < numBlocks; ++i) {
            String toDraw = ((String)this.drawBlocks_.get(i)).trim();
            buf.append(toDraw);
            if (toDraw.length() <= 0 || i >= numBlocks - 1) continue;
            buf.append("<p></p><hr width=\"50%\" align=\"center\">");
        }
        buf.append("<p></p><p></p>");
        buf.append("  </body>");
        buf.append("</html>");
        return buf.toString();
    }

    private void prepareBlocksAndThreadsForLink() {
        ExternalInventoryItem.ArgsForExternalLink afel = null;
        int count = 0;
        PlugInManager pim = PlugInManager.getMgr();
        Iterator ddit = pim.getLinkDataDisplayPlugIns();
        while (ddit.hasNext()) {
            Thread pcwThread;
            PluginCallbackWorker pcw;
            DataDisplayPlugIn ddpi = (DataDisplayPlugIn)ddit.next();
            if (ddpi.isInternal()) {
                InternalLinkDataDisplayPlugIn ilddpi = (InternalLinkDataDisplayPlugIn)ddpi;
                this.drawBlocks_.add(ilddpi.getDataAsHTML(this.args_.genomeKey, this.args_.itemID));
                if (ilddpi.haveCallbackWorker()) {
                    pcw = ilddpi.getCallbackWorker(this.args_.genomeKey, this.args_.itemID);
                    pcw.setIDAndClient(Integer.toString(count), this);
                    pcwThread = new Thread(pcw);
                    this.threadList_.add(pcwThread);
                }
            } else {
                if (afel == null) {
                    afel = new ExternalInventoryItem.ArgsForExternalLink(this.args_);
                }
                ExternalLinkDataDisplayPlugIn elddpi = (ExternalLinkDataDisplayPlugIn)ddpi;
                this.drawBlocks_.add(elddpi.getDataAsHTML(afel.modelNameChain, afel.srcNodeName, afel.srcRegionName, afel.trgNodeName, afel.trgRegionName));
                if (elddpi.haveCallbackWorker()) {
                    pcw = elddpi.getCallbackWorker(afel.modelNameChain, afel.srcNodeName, afel.srcRegionName, afel.trgNodeName, afel.trgRegionName);
                    pcw.setIDAndClient(Integer.toString(count), this);
                    pcwThread = new Thread(pcw);
                    this.threadList_.add(pcwThread);
                }
            }
            ++count;
        }
    }

    private void prepareBlocksAndThreads() {
        ExternalInventoryItem.ArgsForExternalNode afen = null;
        int count = 0;
        PlugInManager pim = PlugInManager.getMgr();
        Iterator ddit = pim.getDataDisplayPlugIns();
        while (ddit.hasNext()) {
            Thread pcwThread;
            PluginCallbackWorker pcw;
            DataDisplayPlugIn ddpi = (DataDisplayPlugIn)ddit.next();
            if (ddpi.isInternal()) {
                if (ddpi instanceof InternalDataDisplayPlugIn) {
                    if (afen == null) {
                        afen = new ExternalInventoryItem.ArgsForExternalNode(this.args_);
                    }
                    this.drawBlocks_.add(((InternalDataDisplayPlugIn)ddpi).getDataAsHTML(this.args_.itemID, afen.nodeName, this.bigScreen_));
                } else {
                    InternalNodeDataDisplayPlugIn inddpi = (InternalNodeDataDisplayPlugIn)ddpi;
                    this.drawBlocks_.add(inddpi.getDataAsHTML(this.args_.genomeKey, this.args_.itemID));
                    if (inddpi.haveCallbackWorker()) {
                        pcw = inddpi.getCallbackWorker(this.args_.genomeKey, this.args_.itemID);
                        pcw.setIDAndClient(Integer.toString(count), this);
                        pcwThread = new Thread(pcw);
                        this.threadList_.add(pcwThread);
                    }
                }
            } else {
                if (afen == null) {
                    afen = new ExternalInventoryItem.ArgsForExternalNode(this.args_);
                }
                if (ddpi instanceof ExternalDataDisplayPlugIn) {
                    this.drawBlocks_.add(((ExternalDataDisplayPlugIn)ddpi).getDataAsHTML(afen.nodeName));
                } else {
                    ExternalNodeDataDisplayPlugIn enddpi = (ExternalNodeDataDisplayPlugIn)ddpi;
                    this.drawBlocks_.add(enddpi.getDataAsHTML(afen.modelNameChain, afen.nodeDisplay, afen.regionName));
                    if (enddpi.haveCallbackWorker()) {
                        pcw = enddpi.getCallbackWorker(afen.modelNameChain, afen.nodeDisplay, afen.regionName);
                        pcw.setIDAndClient(Integer.toString(count), this);
                        pcwThread = new Thread(pcw);
                        this.threadList_.add(pcwThread);
                    }
                }
            }
            ++count;
        }
    }

    public static boolean needPerInstance(ExternalInventoryItem.BuilderArgs args) {
        if (args.isALink) {
            return DataPopupStringBuilder.needPerInstanceForLink(args);
        }
        return DataPopupStringBuilder.needPerInstanceForNode(args);
    }

    public static boolean needPerInstanceForLink(ExternalInventoryItem.BuilderArgs args) {
        ExternalInventoryItem.ArgsForExternalLink afel = null;
        PlugInManager pim = PlugInManager.getMgr();
        Iterator ddit = pim.getLinkDataDisplayPlugIns();
        while (ddit.hasNext()) {
            ExternalLinkDataDisplayPlugIn elddpi;
            DataDisplayPlugIn ddpi = (DataDisplayPlugIn)ddit.next();
            if (ddpi.isInternal()) {
                InternalLinkDataDisplayPlugIn ilddpi = (InternalLinkDataDisplayPlugIn)ddpi;
                if (!ilddpi.requiresPerInstanceDisplay(args.genomeKey, args.itemID)) continue;
                return true;
            }
            if (afel == null) {
                afel = new ExternalInventoryItem.ArgsForExternalLink(args);
            }
            if (!(elddpi = (ExternalLinkDataDisplayPlugIn)ddpi).requiresPerInstanceDisplay(afel.modelNameChain, afel.srcNodeName, afel.srcRegionName, afel.trgNodeName, afel.trgRegionName)) continue;
            return true;
        }
        return false;
    }

    public static boolean needPerInstanceForNode(ExternalInventoryItem.BuilderArgs args) {
        ExternalInventoryItem.ArgsForExternalNode afen = null;
        PlugInManager pim = PlugInManager.getMgr();
        Iterator ddit = pim.getDataDisplayPlugIns();
        while (ddit.hasNext()) {
            ExternalNodeDataDisplayPlugIn enddpi;
            DataDisplayPlugIn ddpi = (DataDisplayPlugIn)ddit.next();
            if (ddpi.isInternal()) {
                InternalNodeDataDisplayPlugIn inddpi;
                if (ddpi instanceof InternalDataDisplayPlugIn || !(inddpi = (InternalNodeDataDisplayPlugIn)ddpi).requiresPerInstanceDisplay(args.genomeKey, args.itemID)) continue;
                return true;
            }
            if (ddpi instanceof ExternalDataDisplayPlugIn) continue;
            if (afen == null) {
                afen = new ExternalInventoryItem.ArgsForExternalNode(args);
            }
            if (!(enddpi = (ExternalNodeDataDisplayPlugIn)ddpi).requiresPerInstanceDisplay(afen.modelNameChain, afen.nodeDisplay, afen.regionName)) continue;
            return true;
        }
        return false;
    }
}

