/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.GroupSettingChangeCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.nav.GroupSettingChange;
import org.systemsbiology.biotapestry.nav.GroupSettings;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class GroupSettingManager {
    private static GroupSettingManager singleton_;
    private HashMap settings_ = new HashMap();

    public void drop() {
        this.settings_.clear();
    }

    public GroupSettingChange setGroupVisibility(String genomeName, String groupName, int setting) {
        GroupSettings gs;
        GroupSettingChange retval = new GroupSettingChange();
        retval.genomeKey = genomeName;
        retval.groupKey = groupName;
        retval.oldSetting = gs = (GroupSettings)this.settings_.get(genomeName);
        if (gs == null) {
            retval.oldSetting = null;
            gs = new GroupSettings();
            this.settings_.put(genomeName, gs);
        } else {
            retval.oldSetting = new GroupSettings(gs);
        }
        gs.setVisibility(groupName, setting);
        retval.newSetting = new GroupSettings(gs);
        return retval;
    }

    public void setGroupVisibilities(GenomeInstance gi, int setting) {
        String giName = gi.getID();
        GroupSettings gs = (GroupSettings)this.settings_.get(giName);
        if (gs == null) {
            gs = new GroupSettings();
            this.settings_.put(giName, gs);
        }
        HashSet<String> groupNames = new HashSet<String>();
        Iterator grit = gi.getGroupIterator();
        while (grit.hasNext()) {
            Group group = (Group)grit.next();
            String groupID = group.getID();
            groupNames.add(groupID);
        }
        gs.setVisibility(groupNames, setting);
    }

    public GroupSettingChange dropGroupVisibilities(String giName) {
        GroupSettingChange retval = new GroupSettingChange();
        retval.genomeKey = giName;
        retval.oldSetting = (GroupSettings)this.settings_.remove(giName);
        return retval.oldSetting != null ? retval : null;
    }

    public GroupSettingChange dropGroupVisibility(String giName, String groupName) {
        GroupSettingChange retval = new GroupSettingChange();
        retval.genomeKey = giName;
        GroupSettings gs = (GroupSettings)this.settings_.get(giName);
        if (gs == null) {
            return null;
        }
        retval.oldSetting = new GroupSettings(gs);
        gs.dropVisibility(groupName);
        retval.newSetting = new GroupSettings(gs);
        return retval;
    }

    public int getGroupVisibility(String viewName, String groupName) {
        GroupSettings gs = (GroupSettings)this.settings_.get(viewName);
        if (gs == null) {
            Database db = Database.getDB();
            Genome genome = db.getGenome(viewName);
            this.setGroupVisibilities((GenomeInstance)genome, 4);
            gs = (GroupSettings)this.settings_.get(viewName);
        }
        return gs.getVisibility(groupName);
    }

    public GroupSettings getGroupVisibilities(String viewName) {
        GroupSettings retval = (GroupSettings)this.settings_.get(viewName);
        if (retval == null) {
            Database db = Database.getDB();
            Genome genome = db.getGenome(viewName);
            this.setGroupVisibilities((GenomeInstance)genome, 4);
            retval = (GroupSettings)this.settings_.get(viewName);
        }
        return retval;
    }

    public void changeUndo(GroupSettingChange undo) {
        if (undo.oldSetting == null) {
            this.settings_.remove(undo.genomeKey);
        } else {
            this.settings_.put(undo.genomeKey, undo.oldSetting);
        }
    }

    public void changeRedo(GroupSettingChange undo) {
        this.settings_.put(undo.genomeKey, undo.newSetting);
    }

    public void dumpGroupVisibilities(PrintStream out) {
        Iterator kit = this.settings_.keySet().iterator();
        while (kit.hasNext()) {
            String giid = (String)kit.next();
            out.print(giid);
            out.println(":");
            GroupSettings gs = (GroupSettings)this.settings_.get(giid);
            gs.dumpVisibilities(out);
        }
    }

    public boolean dropOrphanedVisibilities(String genomeID, Set liveGroups, UndoSupport support) {
        boolean retval = false;
        if (liveGroups.isEmpty()) {
            GroupSettingChange gsc = this.dropGroupVisibilities(genomeID);
            if (gsc != null) {
                GroupSettingChangeCmd gscc = new GroupSettingChangeCmd(gsc);
                support.addEdit(gscc);
                retval = true;
            }
            return retval;
        }
        GroupSettings gs = (GroupSettings)this.settings_.get(genomeID);
        if (gs == null) {
            return false;
        }
        Iterator kit = gs.getKeyIterator();
        HashSet<String> deadGuys = new HashSet<String>();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            if (liveGroups.contains(key)) continue;
            deadGuys.add(key);
        }
        if (deadGuys.isEmpty()) {
            return false;
        }
        GroupSettingChange gsc = new GroupSettingChange();
        gsc.genomeKey = genomeID;
        gsc.oldSetting = new GroupSettings(gs);
        Iterator dgit = deadGuys.iterator();
        while (dgit.hasNext()) {
            String key = (String)dgit.next();
            gs.dropVisibility(key);
        }
        gsc.newSetting = new GroupSettings(gs);
        GroupSettingChangeCmd gscc = new GroupSettingChangeCmd(gsc);
        support.addEdit(gscc);
        return true;
    }

    public boolean dropOrphanedVisibilitiesForProxy(String proxyID, Set liveGroups, UndoSupport support) {
        HashSet<String> deadGuys = new HashSet<String>();
        Iterator kit = this.settings_.keySet().iterator();
        while (kit.hasNext()) {
            String proxID;
            String key = (String)kit.next();
            if (!DynamicInstanceProxy.isDynamicInstance(key) || !proxyID.equals(proxID = DynamicInstanceProxy.extractProxyID(key))) continue;
            deadGuys.add(key);
        }
        if (deadGuys.isEmpty()) {
            return false;
        }
        boolean retval = false;
        Iterator dgit = deadGuys.iterator();
        while (dgit.hasNext()) {
            String key = (String)dgit.next();
            boolean didIt = this.dropOrphanedVisibilities(key, liveGroups, support);
            retval |= didIt;
        }
        return retval;
    }

    public static synchronized GroupSettingManager getGroupMgr() {
        if (singleton_ == null) {
            singleton_ = new GroupSettingManager();
        }
        return singleton_;
    }

    private GroupSettingManager() {
    }
}

