/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.nav.ImageManager;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.xml.sax.Attributes;

public class ImageFactory
implements ParserClient {
    private static final int NONE_ = 0;
    private static final int IMAGE_ = 1;
    private String currImage_;
    private int charTarget_;
    private Set imageKeys_ = ImageManager.keywordsOfInterest();
    private String imageKey_ = ImageManager.getImageKeyword();
    private HashSet allKeys_ = new HashSet();

    public ImageFactory() {
        this.allKeys_.addAll(this.imageKeys_);
    }

    public void setContainer(Object container) {
    }

    public boolean finishElement(String elemName) {
        this.charTarget_ = 0;
        if (this.currImage_ != null) {
            ImageManager.getMgr().finishImageDefinition(this.currImage_);
            this.currImage_ = null;
        }
        return this.allKeys_.contains(elemName);
    }

    public void processCharacters(char[] chars, int start, int length) {
        switch (this.charTarget_) {
            case 0: {
                break;
            }
            case 1: {
                ImageManager.getMgr().appendToImageDefinition(this.currImage_, chars, start, length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public Set keywordsOfInterest() {
        return this.allKeys_;
    }

    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (this.imageKeys_.contains(elemName)) {
            return null;
        }
        if (this.imageKey_.equals(elemName)) {
            this.currImage_ = ImageManager.installFromXML(elemName, attrs);
            this.charTarget_ = 1;
        }
        return null;
    }
}

