/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.util.Base64Util;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class ImageManager {
    public static final int WARN_DIM_X = 200;
    public static final int WARN_DIM_Y = 200;
    private static ImageManager singleton_;
    private HashMap stringCache_ = new HashMap();
    private HashMap imageCache_ = new HashMap();
    private HashMap typeDictionary_ = new HashMap();
    private HashMap imgCounts_ = new HashMap();
    private UniqueLabeller labels_ = new UniqueLabeller();
    private StringBuffer buildBuf_;
    private String bufKey_;

    public void dropAllImages() {
        this.stringCache_.clear();
        this.imageCache_.clear();
        this.typeDictionary_.clear();
        this.imgCounts_.clear();
        this.labels_ = new UniqueLabeller();
    }

    public BufferedImage getImage(String key) {
        if (key == null) {
            return null;
        }
        BufferedImage bi = (BufferedImage)this.imageCache_.get(key);
        if (bi == null) {
            String imgString = (String)this.stringCache_.get(key);
            String type = (String)this.typeDictionary_.get(key);
            try {
                bi = this.readImageFromString(imgString, type);
                this.imageCache_.put(key, bi);
            }
            catch (IOException ioex) {
                throw new IllegalStateException();
            }
        }
        return bi;
    }

    public boolean hasAnImage() {
        Iterator icit = this.imgCounts_.values().iterator();
        while (icit.hasNext()) {
            Integer count = (Integer)icit.next();
            if (count <= 0) continue;
            return true;
        }
        return false;
    }

    public ImageChange registerImageUsage(String key) {
        Integer currCount = (Integer)this.imgCounts_.get(key);
        ImageChange retval = new ImageChange();
        retval.countOnlyKey = key;
        retval.oldCount = currCount;
        retval.newCount = retval.oldCount + 1;
        this.imgCounts_.put(key, new Integer(retval.newCount));
        return retval;
    }

    public ImageChange dropImageUsage(String key) {
        Integer currCount = (Integer)this.imgCounts_.get(key);
        ImageChange retval = new ImageChange();
        if (currCount == 1) {
            retval.oldImage = (String)this.stringCache_.get(key);
            retval.oldType = (String)this.typeDictionary_.get(key);
            retval.oldCount = 1;
            retval.oldKey = key;
            this.stringCache_.remove(key);
            this.imageCache_.remove(key);
            this.typeDictionary_.remove(key);
            this.imgCounts_.remove(key);
            this.labels_.removeLabel(key);
        } else {
            retval.oldCount = currCount;
            retval.newCount = retval.oldCount - 1;
            retval.countOnlyKey = key;
            this.imgCounts_.put(key, new Integer(retval.newCount));
        }
        return retval;
    }

    public TypedImage loadImageFromFileStart(File loadFile) throws IOException {
        TypedImage timg = this.readImageFromFile(loadFile);
        return timg;
    }

    public NewImageInfo loadImageFromFileFinish(TypedImage timg) throws IOException {
        String imgString = this.writeImageToString(timg);
        NewImageInfo retval = new NewImageInfo();
        Iterator skit = this.stringCache_.keySet().iterator();
        while (skit.hasNext()) {
            String key = (String)skit.next();
            String cacheString = (String)this.stringCache_.get(key);
            if (!cacheString.equals(imgString)) continue;
            retval.key = key;
            retval.change = null;
            return retval;
        }
        String imgKey = this.labels_.getNextLabel();
        this.imageCache_.put(imgKey, timg.img);
        this.stringCache_.put(imgKey, imgString);
        this.typeDictionary_.put(imgKey, timg.type);
        this.imgCounts_.put(imgKey, new Integer(0));
        retval.key = imgKey;
        retval.change = new ImageChange();
        retval.change.newImage = imgString;
        retval.change.newKey = imgKey;
        retval.change.newType = timg.type;
        retval.change.newCount = 0;
        return retval;
    }

    public void appendToImageDefinition(String key, char[] chars, int start, int length) {
        if (this.buildBuf_ == null) {
            this.buildBuf_ = new StringBuffer();
        }
        if (this.bufKey_ == null || !this.bufKey_.equals(key)) {
            throw new IllegalStateException();
        }
        this.buildBuf_.append(chars, start, length);
    }

    public void finishImageDefinition(String key) {
        if (this.bufKey_ == null || !this.bufKey_.equals(key)) {
            throw new IllegalStateException();
        }
        this.bufKey_ = null;
        if (this.buildBuf_ == null) {
            return;
        }
        int bufLen = this.buildBuf_.length();
        int index = bufLen - 1;
        while (Character.isWhitespace(this.buildBuf_.charAt(index))) {
            this.buildBuf_.setLength(index--);
        }
        index = 0;
        while (Character.isWhitespace(this.buildBuf_.charAt(index))) {
            this.buildBuf_.deleteCharAt(index++);
        }
        this.stringCache_.put(key, this.buildBuf_.toString());
        if (this.buildBuf_ != null) {
            this.buildBuf_.setLength(0);
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<images>");
        ind.up();
        TreeSet keys = new TreeSet(this.stringCache_.keySet());
        Iterator skit = keys.iterator();
        while (skit.hasNext()) {
            String key = (String)skit.next();
            String imgString = (String)this.stringCache_.get(key);
            String imgType = (String)this.typeDictionary_.get(key);
            Integer imgCount = (Integer)this.imgCounts_.get(key);
            ind.indent();
            out.print("<image ");
            out.print("key=\"");
            out.print(key);
            out.print("\" refCount=\"");
            out.print(imgCount);
            out.print("\" encoding=\"");
            out.print(imgType);
            out.println("\" >");
            out.println(imgString);
            ind.indent();
            out.println("</image>");
        }
        ind.down().indent();
        out.println("</images>");
    }

    public void changeUndo(ImageChange undo) {
        if (undo.newKey != null) {
            this.stringCache_.remove(undo.newKey);
            this.imageCache_.remove(undo.newKey);
            this.typeDictionary_.remove(undo.newKey);
            this.imgCounts_.remove(undo.newKey);
            this.labels_.removeLabel(undo.newKey);
        } else if (undo.oldKey != null) {
            this.labels_.addExistingLabel(undo.oldKey);
            this.stringCache_.put(undo.oldKey, undo.oldImage);
            this.typeDictionary_.put(undo.oldKey, undo.oldType);
            this.imgCounts_.put(undo.oldKey, new Integer(undo.oldCount));
        } else {
            this.imgCounts_.put(undo.countOnlyKey, new Integer(undo.oldCount));
        }
    }

    public void changeRedo(ImageChange redo) {
        if (redo.newKey != null) {
            this.labels_.addExistingLabel(redo.newKey);
            this.stringCache_.put(redo.newKey, redo.newImage);
            this.typeDictionary_.put(redo.newKey, redo.newType);
            this.imgCounts_.put(redo.newKey, new Integer(redo.newCount));
        } else if (redo.oldKey != null) {
            this.stringCache_.remove(redo.oldKey);
            this.imageCache_.remove(redo.oldKey);
            this.typeDictionary_.remove(redo.oldKey);
            this.imgCounts_.remove(redo.oldKey);
            this.labels_.removeLabel(redo.oldKey);
        } else {
            this.imgCounts_.put(redo.countOnlyKey, new Integer(redo.newCount));
        }
    }

    public List getSupportedFileSuffixes() {
        String[] names = ImageIO.getReaderFormatNames();
        List<String> nameList = Arrays.asList(names);
        ArrayList<String> retval = new ArrayList<String>();
        if (nameList.contains("tif")) {
            retval.add("tif");
            retval.add("tiff");
        }
        if (nameList.contains("png")) {
            retval.add("png");
        }
        if (nameList.contains("jpg")) {
            retval.add("jpg");
            retval.add("jpeg");
        }
        if (nameList.contains("gif")) {
            retval.add("gif");
        }
        return retval;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("images");
        return retval;
    }

    public static String getImageKeyword() {
        return "image";
    }

    public static synchronized ImageManager getMgr() {
        if (singleton_ == null) {
            singleton_ = new ImageManager();
        }
        return singleton_;
    }

    public static String installFromXML(String elemName, Attributes attrs) throws IOException {
        int count;
        String imgKey = null;
        String encodingStr = null;
        String countStr = null;
        if (attrs != null) {
            count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("key")) {
                    imgKey = val;
                    continue;
                }
                if (key.equals("encoding")) {
                    encodingStr = val;
                    continue;
                }
                if (!key.equals("refCount")) continue;
                countStr = val;
            }
        }
        if (encodingStr == null || imgKey == null || countStr == null) {
            throw new IOException();
        }
        count = 0;
        try {
            count = Integer.parseInt(countStr);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
        ImageManager mgr = ImageManager.getMgr();
        mgr.stringCache_.put(imgKey, "");
        mgr.typeDictionary_.put(imgKey, encodingStr);
        mgr.imgCounts_.put(imgKey, new Integer(count));
        mgr.labels_.addExistingLabel(imgKey);
        mgr.bufKey_ = imgKey;
        return imgKey;
    }

    public static void main(String[] argv) {
    }

    private ImageManager() {
    }

    private String writeImageToString(TypedImage timg) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(timg.type);
        if (!writers.hasNext()) {
            throw new IOException();
        }
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
        writer.setOutput(ios);
        IIOImage img = new IIOImage(timg.img, null, null);
        writer.write(img);
        ios.close();
        writer.dispose();
        String retval = new Base64Util().encode(baos.toByteArray());
        return retval;
    }

    private TypedImage readImageFromFile(File readFile) throws IOException {
        FileInputStream fis = new FileInputStream(readFile);
        ImageInputStream iis = ImageIO.createImageInputStream(fis);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        if (!readers.hasNext()) {
            throw new IOException();
        }
        TypedImage retval = new TypedImage();
        ImageReader reader = readers.next();
        retval.type = reader.getFormatName();
        retval.type = retval.type.equalsIgnoreCase("jpg") || retval.type.equalsIgnoreCase("jpeg") ? "jpg" : "png";
        retval.img = ImageIO.read(iis);
        return retval;
    }

    private BufferedImage readImageFromString(String imgString, String type) throws IOException {
        byte[] bytes = new Base64Util().decode(imgString);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(type);
        if (!readers.hasNext()) {
            throw new IOException();
        }
        ImageReader reader = readers.next();
        ImageInputStream iis = ImageIO.createImageInputStream(bais);
        reader.setInput(iis);
        BufferedImage retval = reader.read(0);
        iis.close();
        reader.dispose();
        return retval;
    }

    public static class TypedImage {
        BufferedImage img;
        String type;

        public int getHeight() {
            return this.img == null ? 0 : this.img.getHeight();
        }

        public int getWidth() {
            return this.img == null ? 0 : this.img.getWidth();
        }
    }

    public static class NewImageInfo {
        public String key;
        public ImageChange change;
    }
}

