/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.nav.NavTreeChange;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class NavTree
extends DefaultTreeModel {
    public static final int NO_FLAG = 0;
    public static final int SKIP_EVENT = 1;
    public static final int SKIP_FINISH = 2;
    private HashMap parentMap_;
    private boolean doingUndo_;
    private int skipFlag_;

    public NavTree() {
        super(new DefaultMutableTreeNode());
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        NavNodeContents contents = new NavNodeContents("", null, null);
        dmtnRoot.setUserObject(contents);
        this.parentMap_ = new HashMap();
        this.doingUndo_ = false;
        this.skipFlag_ = 0;
    }

    public void clearOut() {
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        dmtnRoot.removeAllChildren();
        this.parentMap_ = new HashMap();
        this.nodeStructureChanged(dmtnRoot);
    }

    public void setSkipFlag(int flag) {
        this.skipFlag_ = flag;
    }

    public int getSkipFlag() {
        return this.skipFlag_;
    }

    public void changeUndo(NavTreeChange undo) {
        if (undo.oldMap != null) {
            this.doingUndo_ = true;
            this.setRoot(undo.oldRoot);
            this.parentMap_ = undo.oldMap;
            this.nodeStructureChanged((TreeNode)this.getRoot());
            this.doingUndo_ = false;
        } else {
            this.undoContentChange(undo);
        }
    }

    public void changeRedo(NavTreeChange undo) {
        if (undo.newMap != null) {
            this.doingUndo_ = true;
            this.setRoot(undo.newRoot);
            this.parentMap_ = undo.newMap;
            this.nodeStructureChanged((TreeNode)this.getRoot());
            this.doingUndo_ = false;
        } else {
            this.redoContentChange(undo);
        }
    }

    public boolean amDoingUndo() {
        return this.doingUndo_;
    }

    public NavTreeChange addNode(String name, String parentID, String id) {
        int index;
        if (name == null) {
            index = 0;
        } else if (parentID == null) {
            DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)dmtnRoot.getFirstChild();
            index = parentNode.getChildCount();
        } else {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.parentMap_.get(parentID);
            index = parentNode.getChildCount();
        }
        return this.addNodeAtIndex(name, parentID, id, index);
    }

    public NavTreeChange addNodeAtIndex(String name, String parentID, String id, int index) {
        NavTreeChange retval = new NavTreeChange();
        retval.oldRoot = this.deepCopyRoot();
        retval.oldMap = this.makeParentMap(retval.oldRoot);
        if (name == null) {
            ResourceManager rMan = ResourceManager.getManager();
            DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
            String fullGenLabel = rMan.getString("tree.FullGenome");
            NavNodeContents contents = new NavNodeContents(fullGenLabel, id, null);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(contents);
            this.insertNodeInto(newNode, dmtnRoot, index);
        } else if (parentID == null) {
            NavNodeContents contents = new NavNodeContents(name, id, null);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(contents);
            DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)dmtnRoot.getFirstChild();
            this.insertNodeInto(newNode, parentNode, index);
            this.parentMap_.put(id, newNode);
        } else {
            NavNodeContents contents = new NavNodeContents(name, id, null);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(contents);
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.parentMap_.get(parentID);
            this.insertNodeInto(newNode, parentNode, index);
            this.parentMap_.put(id, newNode);
        }
        retval.newRoot = this.deepCopyRoot();
        retval.newMap = this.makeParentMap(retval.newRoot);
        this.nodeStructureChanged(this.root);
        return retval;
    }

    public NavTreeChange addProxyNode(String name, String parentID, String proxyID) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.parentMap_.get(parentID);
        int index = parentNode.getChildCount();
        return this.addProxyNodeAtIndex(name, parentID, proxyID, index);
    }

    public NavTreeChange addProxyNodeAtIndex(String name, String parentID, String proxyID, int index) {
        NavTreeChange retval = new NavTreeChange();
        retval.oldRoot = this.deepCopyRoot();
        retval.oldMap = this.makeParentMap(retval.oldRoot);
        NavNodeContents contents = new NavNodeContents(name, null, proxyID);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(contents);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.parentMap_.get(parentID);
        this.insertNodeInto(newNode, parentNode, index);
        retval.newRoot = this.deepCopyRoot();
        retval.newMap = this.makeParentMap(retval.newRoot);
        this.nodeStructureChanged(this.root);
        return retval;
    }

    public boolean canShiftNode(DefaultMutableTreeNode movingNode, boolean doLower) {
        int numKids;
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)movingNode.getParent();
        int oldIndex = this.getIndexOfChild(parentNode, movingNode);
        int newIndex = oldIndex + (doLower ? 1 : -1);
        return newIndex < (numKids = this.getChildCount(parentNode)) && newIndex >= 0;
    }

    public NavTreeChange shiftNode(DefaultMutableTreeNode movingNode, boolean doLower) {
        int numKids;
        NavTreeChange retval = new NavTreeChange();
        retval.oldRoot = this.deepCopyRoot();
        retval.oldMap = this.makeParentMap(retval.oldRoot);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)movingNode.getParent();
        int oldIndex = this.getIndexOfChild(parentNode, movingNode);
        int newIndex = oldIndex + (doLower ? 1 : -1);
        if (newIndex >= (numKids = this.getChildCount(parentNode)) || newIndex < 0) {
            return null;
        }
        this.removeNodeFromParent(movingNode);
        this.insertNodeInto(movingNode, parentNode, newIndex);
        retval.newRoot = this.deepCopyRoot();
        retval.newMap = this.makeParentMap(retval.newRoot);
        this.nodeStructureChanged(this.root);
        return retval;
    }

    public int getNewSiblingIndex(TreeNode checkNode) {
        TreeNode parentNode = checkNode.getParent();
        return this.getIndexOfChild(parentNode, checkNode) + 1;
    }

    public NavTreeChange changeToProxy(DefaultMutableTreeNode node, String proxyID) {
        NavTreeChange retval = new NavTreeChange();
        retval.oldContents = (NavNodeContents)node.getUserObject();
        retval.newContents = new NavNodeContents(retval.oldContents.name, null, proxyID);
        node.setUserObject(new NavNodeContents(retval.oldContents.name, null, proxyID));
        return retval;
    }

    public NavTreeChange changeFromProxy(DefaultMutableTreeNode node, String id) {
        NavTreeChange retval = new NavTreeChange();
        retval.oldContents = (NavNodeContents)node.getUserObject();
        retval.newContents = new NavNodeContents(retval.oldContents.name, id, null);
        node.setUserObject(new NavNodeContents(retval.oldContents.name, id, null));
        return retval;
    }

    public NavTreeChange deleteNode(DefaultMutableTreeNode nodeToGo, Set deadIDs) {
        NavTreeChange retval = new NavTreeChange();
        retval.oldRoot = this.deepCopyRoot();
        retval.oldMap = this.makeParentMap(retval.oldRoot);
        this.removeNodeFromParent(nodeToGo);
        Iterator diit = deadIDs.iterator();
        while (diit.hasNext()) {
            String did = (String)diit.next();
            this.parentMap_.remove(did);
        }
        retval.newRoot = this.deepCopyRoot();
        retval.newMap = this.makeParentMap(retval.newRoot);
        return retval;
    }

    public NavTreeChange deleteNodeChildren(DefaultMutableTreeNode parentOfNodesToGo, Set deadIDs) {
        NavTreeChange retval = new NavTreeChange();
        retval.oldRoot = this.deepCopyRoot();
        retval.oldMap = this.makeParentMap(retval.oldRoot);
        ArrayList<DefaultMutableTreeNode> kids = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> cen = parentOfNodesToGo.children();
        while (cen.hasMoreElements()) {
            DefaultMutableTreeNode kid = (DefaultMutableTreeNode)cen.nextElement();
            kids.add(kid);
        }
        Iterator kit = kids.iterator();
        while (kit.hasNext()) {
            DefaultMutableTreeNode kid = (DefaultMutableTreeNode)kit.next();
            this.removeNodeFromParent(kid);
        }
        Iterator diit = deadIDs.iterator();
        while (diit.hasNext()) {
            String did = (String)diit.next();
            this.parentMap_.remove(did);
        }
        retval.newRoot = this.deepCopyRoot();
        retval.newMap = this.makeParentMap(retval.newRoot);
        return retval;
    }

    public NavTreeChange deleteNode(String nodeID, Set deadIDs) {
        NavTreeChange retval = new NavTreeChange();
        retval.oldRoot = this.deepCopyRoot();
        retval.oldMap = this.makeParentMap(retval.oldRoot);
        DefaultMutableTreeNode nodeToGo = (DefaultMutableTreeNode)this.parentMap_.get(nodeID);
        this.removeNodeFromParent(nodeToGo);
        Iterator diit = deadIDs.iterator();
        while (diit.hasNext()) {
            String did = (String)diit.next();
            this.parentMap_.remove(did);
        }
        retval.newRoot = this.deepCopyRoot();
        retval.newMap = this.makeParentMap(retval.newRoot);
        return retval;
    }

    public void nodeNameRefresh(String id) {
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> e = dmtnRoot.preorderEnumeration();
        while (e.hasMoreElements()) {
            String name;
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            NavNodeContents contents = (NavNodeContents)next.getUserObject();
            if (contents != null && contents.id != null && contents.id.equals(id)) {
                String name2;
                contents.name = name2 = Database.getDB().getGenome(id).getName();
                break;
            }
            if (contents == null || contents.proxyID == null || !contents.proxyID.equals(id)) continue;
            contents.name = name = Database.getDB().getDynamicProxy(id).getName();
            break;
        }
    }

    public String getGenomeID(TreePath tp) {
        if (tp == null) {
            return null;
        }
        Object[] path = tp.getPath();
        DefaultMutableTreeNode last = (DefaultMutableTreeNode)path[path.length - 1];
        NavNodeContents contents = (NavNodeContents)last.getUserObject();
        return contents == null ? null : contents.id;
    }

    public String getDynamicProxyID(TreePath tp) {
        if (tp == null) {
            return null;
        }
        Object[] path = tp.getPath();
        DefaultMutableTreeNode last = (DefaultMutableTreeNode)path[path.length - 1];
        NavNodeContents contents = (NavNodeContents)last.getUserObject();
        return contents == null ? null : contents.proxyID;
    }

    public String getGenomeID(TreeNode node) {
        if (node == null) {
            return null;
        }
        DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)node;
        NavNodeContents contents = (NavNodeContents)dmtNode.getUserObject();
        return contents == null ? null : contents.id;
    }

    public String getDynamicProxyID(TreeNode node) {
        if (node == null) {
            return null;
        }
        DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)node;
        NavNodeContents contents = (NavNodeContents)dmtNode.getUserObject();
        return contents == null ? null : contents.proxyID;
    }

    public TreePath getVfgSelection() {
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        if (dmtnRoot.getChildCount() == 0) {
            return null;
        }
        DefaultMutableTreeNode full = (DefaultMutableTreeNode)dmtnRoot.getFirstChild();
        return new TreePath(full.getPath());
    }

    public TreePath getDefaultSelection() {
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        if (dmtnRoot.getChildCount() == 0) {
            return null;
        }
        DefaultMutableTreeNode full = (DefaultMutableTreeNode)dmtnRoot.getFirstChild();
        if (full.getChildCount() == 0) {
            return new TreePath(full.getPath());
        }
        DefaultMutableTreeNode vfg = (DefaultMutableTreeNode)full.getLastChild();
        if (full == null) {
            return null;
        }
        return new TreePath(vfg.getPath());
    }

    public TreePath getStartupSelection(String modelKey) {
        if (modelKey == null) {
            return this.getDefaultSelection();
        }
        Database db = Database.getDB();
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> e = dmtnRoot.preorderEnumeration();
        while (e.hasMoreElements()) {
            String dipID;
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            String genomeID = this.getGenomeID(next);
            if (genomeID != null && modelKey.equals(genomeID)) {
                return new TreePath(next.getPath());
            }
            if (genomeID != null || (dipID = this.getDynamicProxyID(next)) == null) continue;
            DynamicInstanceProxy dip = db.getDynamicProxy(dipID);
            Iterator pkit = dip.getProxiedKeys().iterator();
            while (pkit.hasNext()) {
                String diKey = (String)pkit.next();
                if (!modelKey.equals(diKey)) continue;
                return new TreePath(next.getPath());
            }
        }
        return this.getDefaultSelection();
    }

    public List getPreorderListing(boolean skipFull) {
        int doSkip;
        ArrayList<String> retval = new ArrayList<String>();
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> e = dmtnRoot.preorderEnumeration();
        int n = doSkip = skipFull ? 2 : 1;
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            NavNodeContents contents = (NavNodeContents)next.getUserObject();
            if (doSkip == 0) {
                if (contents.id == null) continue;
                retval.add(contents.id);
                continue;
            }
            --doSkip;
        }
        return retval;
    }

    public List getFullTreePreorderListing() {
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        return this.getPreorderListing((DefaultMutableTreeNode)dmtnRoot.getFirstChild());
    }

    public List getPreorderListing(TreeNode topNode) {
        ArrayList<String> retval = new ArrayList<String>();
        DefaultMutableTreeNode topMutNode = (DefaultMutableTreeNode)topNode;
        Database db = Database.getDB();
        Enumeration<TreeNode> e = topMutNode.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            NavNodeContents contents = (NavNodeContents)next.getUserObject();
            if (contents.id != null) {
                retval.add(contents.id);
                continue;
            }
            if (contents.proxyID == null) continue;
            DynamicInstanceProxy dip = db.getDynamicProxy(contents.proxyID);
            String giKey = dip.getFirstProxiedKey();
            retval.add(giKey);
        }
        return retval;
    }

    public List getProxyPreorderListing() {
        ArrayList<String> retval = new ArrayList<String>();
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> e = dmtnRoot.preorderEnumeration();
        int doSkip = 2;
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            NavNodeContents contents = (NavNodeContents)next.getUserObject();
            if (doSkip == 0) {
                if (contents.proxyID == null) continue;
                retval.add(contents.proxyID);
                continue;
            }
            --doSkip;
        }
        return retval;
    }

    public List getAllPathsToNonLeaves() {
        ArrayList<TreePath> retval = new ArrayList<TreePath>();
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> e = dmtnRoot.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            if (next.getChildCount() == 0) continue;
            TreePath path = new TreePath(next.getPath());
            retval.add(path);
        }
        return retval;
    }

    public List mapAllPaths(List paths, NavTreeChange change, boolean useOld) {
        ArrayList<TreePath> retval = new ArrayList<TreePath>();
        DefaultMutableTreeNode useRoot = useOld ? change.oldRoot : change.newRoot;
        Iterator pit = paths.iterator();
        while (pit.hasNext()) {
            TreePath tp = (TreePath)pit.next();
            retval.add(this.mapPath(tp, useRoot));
        }
        return retval;
    }

    public TreePath mapAPath(TreePath path, NavTreeChange change, boolean useOld) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode useRoot = useOld ? change.oldRoot : change.newRoot;
        return this.mapPath(path, useRoot);
    }

    public boolean isPathPresent(TreePath path) {
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        ArrayList<Object> pathTail = new ArrayList<Object>(Arrays.asList(path.getPath()));
        pathTail.remove(0);
        return this.isPathPresentGuts(pathTail, dmtnRoot);
    }

    public TreePath mapPath(TreePath oldPath, DefaultMutableTreeNode dmtnRoot) {
        ArrayList<DefaultMutableTreeNode> newNodes = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<Object> oldTail = new ArrayList<Object>(Arrays.asList(oldPath.getPath()));
        oldTail.remove(0);
        newNodes.add(dmtnRoot);
        this.mapPathGuts(oldTail, dmtnRoot, newNodes);
        return new TreePath(newNodes.toArray());
    }

    private HashMap makeParentMap(DefaultMutableTreeNode dmtnRoot) {
        HashMap retval = new HashMap();
        if (dmtnRoot.getChildCount() > 0) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)dmtnRoot.getFirstChild();
            this.makeParentMapGuts(parentNode, retval, true);
        }
        return retval;
    }

    private void makeParentMapGuts(DefaultMutableTreeNode node, HashMap map, boolean isTop) {
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            this.makeParentMapGuts(child, map, false);
        }
        if (!isTop) {
            NavNodeContents nc = new NavNodeContents((NavNodeContents)node.getUserObject());
            if (nc.id != null) {
                map.put(nc.id, node);
            }
        }
    }

    private DefaultMutableTreeNode deepCopyRoot() {
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        return this.deepCopyGuts(dmtnRoot);
    }

    private DefaultMutableTreeNode deepCopyGuts(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode retval = new DefaultMutableTreeNode();
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode childCopy = this.deepCopyGuts(child);
            retval.add(childCopy);
        }
        NavNodeContents nc = new NavNodeContents((NavNodeContents)node.getUserObject());
        retval.setUserObject(nc);
        return retval;
    }

    private void mapPathGuts(ArrayList oldTail, DefaultMutableTreeNode node, ArrayList newHead) {
        if (oldTail.size() == 0) {
            return;
        }
        DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)oldTail.get(0);
        NavNodeContents oldContents = (NavNodeContents)oldNode.getUserObject();
        int count = node.getChildCount();
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            NavNodeContents childContents = (NavNodeContents)child.getUserObject();
            if (!childContents.equals(oldContents)) continue;
            oldTail.remove(0);
            newHead.add(child);
            this.mapPathGuts(oldTail, child, newHead);
            return;
        }
        System.err.println("No match with " + oldContents);
        throw new IllegalArgumentException();
    }

    private boolean isPathPresentGuts(ArrayList pathTail, DefaultMutableTreeNode node) {
        int count = node.getChildCount();
        int ptSize = pathTail.size();
        if (count == 0) {
            return ptSize == 0;
        }
        if (ptSize == 0) {
            return true;
        }
        DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)pathTail.get(0);
        NavNodeContents oldContents = (NavNodeContents)oldNode.getUserObject();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            NavNodeContents childContents = (NavNodeContents)child.getUserObject();
            if (!childContents.equals(oldContents)) continue;
            pathTail.remove(0);
            return this.isPathPresentGuts(pathTail, child);
        }
        return false;
    }

    public void undoContentChange(NavTreeChange undo) {
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> e = dmtnRoot.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            NavNodeContents contents = (NavNodeContents)next.getUserObject();
            if (contents == null || !undo.newContents.equals(contents)) continue;
            next.setUserObject(undo.oldContents);
            return;
        }
        throw new IllegalStateException();
    }

    public void redoContentChange(NavTreeChange redo) {
        DefaultMutableTreeNode dmtnRoot = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> e = dmtnRoot.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            NavNodeContents contents = (NavNodeContents)next.getUserObject();
            if (contents == null || !redo.oldContents.equals(contents)) continue;
            next.setUserObject(redo.newContents);
            return;
        }
        throw new IllegalStateException();
    }

    public class NavNodeContents {
        String name;
        String id;
        String proxyID;

        public NavNodeContents(String name, String id, String proxyID) {
            this.name = name;
            this.id = id;
            this.proxyID = proxyID;
        }

        public NavNodeContents(NavNodeContents other) {
            this.name = other.name;
            this.id = other.id;
            this.proxyID = other.proxyID;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof NavNodeContents)) {
                return false;
            }
            NavNodeContents otherNNC = (NavNodeContents)other;
            if (this.name == null ? otherNNC.name != null : !this.name.equals(otherNNC.name)) {
                return false;
            }
            if (this.id == null ? otherNNC.id != null : !this.id.equals(otherNNC.id)) {
                return false;
            }
            return !(this.proxyID == null ? otherNNC.proxyID != null : !this.proxyID.equals(otherNNC.proxyID));
        }
    }
}

