/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.ui.GenomePresentation;

public class SelectionNavController {
    private CommonView suw_;

    public SelectionNavController(CommonView suw) {
        this.suw_ = suw;
    }

    public void displayModelAndShow(StartupView suv, Set nodes, List linkIntersections, GenomePresentation pre) {
        this.selectTreePath(suv);
        this.installSelections(suv.getModel(), nodes, linkIntersections, pre);
        this.suw_.getSUPanel().repaint();
    }

    private void selectTreePath(StartupView suv) {
        Database db = Database.getDB();
        NavTree navTree = db.getNavTree();
        JTree jtree = this.suw_.getTree();
        suv.installInTree(this.suw_, false, navTree, jtree);
    }

    private void installSelections(String modelKey, Set found, List linkIntersections, GenomePresentation pre) {
        String layoutID = new LayoutManager().getLayout(modelKey);
        pre.selectNodesAndLinks(found, modelKey, layoutID, linkIntersections, true);
    }
}

