/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.nav.UserTreePathStop;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class UserTreePath
implements Cloneable {
    private String id_;
    private String name_;
    private ArrayList stops_;

    public UserTreePath(UserTreePath other) {
        this.id_ = other.id_;
        this.name_ = other.name_;
        this.stops_ = new ArrayList();
        int size = other.stops_.size();
        for (int i = 0; i < size; ++i) {
            UserTreePathStop utpStop = (UserTreePathStop)other.stops_.get(i);
            this.stops_.add(utpStop.clone());
        }
    }

    public UserTreePath(String id, String name) {
        this.id_ = id;
        this.name_ = name;
        this.stops_ = new ArrayList();
    }

    public UserTreePath(String name) {
        this.id_ = null;
        this.name_ = name;
        this.stops_ = new ArrayList();
    }

    public Object clone() {
        try {
            UserTreePath retval = (UserTreePath)super.clone();
            retval.stops_ = new ArrayList();
            int size = this.stops_.size();
            for (int i = 0; i < size; ++i) {
                UserTreePathStop utpStop = (UserTreePathStop)this.stops_.get(i);
                retval.stops_.add(utpStop.clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getID() {
        return this.id_;
    }

    public void setID(String id) {
        this.id_ = id;
    }

    public void addStop(UserTreePathStop pathStop, int stopIndex) {
        if (stopIndex > this.stops_.size()) {
            throw new IllegalArgumentException();
        }
        this.stops_.add(stopIndex, pathStop);
    }

    public void addStop(UserTreePathStop pathStop) {
        this.stops_.add(pathStop);
    }

    public void deleteStop(int i) {
        this.stops_.remove(i);
    }

    public void replaceStopModelID(int i, String newID) {
        UserTreePathStop stop = (UserTreePathStop)this.stops_.get(i);
        stop.setGenomeID(newID);
    }

    public void dropStopModule(int i, String moduleID) {
        UserTreePathStop stop = (UserTreePathStop)this.stops_.get(i);
        stop.dropModKey(moduleID);
    }

    public int getStopCount() {
        return this.stops_.size();
    }

    public UserTreePathStop getStop(int n) {
        return (UserTreePathStop)this.stops_.get(n);
    }

    public boolean containsStop(UserTreePathStop stop) {
        return this.stops_.contains(stop);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<userTreePath id=\"");
        out.print(this.id_);
        out.print("\" name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        int numStops = this.stops_.size();
        if (numStops == 0) {
            out.println("\" />");
            return;
        }
        out.println("\">");
        ind.up();
        for (int i = 0; i < numStops; ++i) {
            UserTreePathStop pathStop = this.getStop(i);
            pathStop.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</userTreePath>");
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            UserTreePath path = board.userTreePath;
            UserTreePathStop pathStop = board.userTreePathStop;
            path.addStop(pathStop);
            return null;
        }
    }

    public static class UserTreePathWorker
    extends AbstractFactoryClient {
        public UserTreePathWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("userTreePath");
            this.installWorker(new UserTreePathStop.UserTreePathStopWorker(whiteboard), new MyGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            UserTreePath retval = null;
            if (elemName.equals("userTreePath")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.userTreePath = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private UserTreePath buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "userTreePath", "id", true);
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "userTreePath", "name", true);
            name = CharacterEntityMapper.unmapEntities(name, false);
            return new UserTreePath(id, name);
        }
    }
}

