/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.systemsbiology.biotapestry.nav.UserTreePath;
import org.systemsbiology.biotapestry.nav.UserTreePathChange;
import org.systemsbiology.biotapestry.nav.UserTreePathStop;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UniqueLabeller;

public class UserTreePathManager {
    private static UserTreePathManager singleton_;
    private HashMap paths_ = new HashMap();
    private ArrayList pathOrder_ = new ArrayList();
    private UniqueLabeller labels_ = new UniqueLabeller();

    public void dropAllPaths() {
        this.paths_.clear();
        this.pathOrder_.clear();
        this.labels_ = new UniqueLabeller();
    }

    public int getPathCount() {
        return this.paths_.size();
    }

    public UserTreePath getPath(String key) {
        return (UserTreePath)this.paths_.get(key);
    }

    public int getPathIndex(String key) {
        return this.pathOrder_.indexOf(key);
    }

    public String getPathKey(int index) {
        String key = (String)this.pathOrder_.get(index);
        return key;
    }

    public UserTreePathChange addPath(String pathName, int index) {
        if (index > this.pathOrder_.size()) {
            throw new IllegalArgumentException();
        }
        UserTreePathChange utpc = new UserTreePathChange();
        UserTreePath newPath = new UserTreePath(pathName);
        String nextLabel = this.labels_.getNextLabel();
        newPath.setID(nextLabel);
        this.paths_.put(nextLabel, newPath);
        this.pathOrder_.add(index, nextLabel);
        utpc.newIndex = index;
        utpc.newPath = (UserTreePath)newPath.clone();
        return utpc;
    }

    public UserTreePathChange addPathStop(String pathKey, String genomeID, int stopIndex, String ovrKey, TaggedSet mods, TaggedSet revs) {
        UserTreePathChange utpc = new UserTreePathChange();
        utpc.oldIndex = -1;
        UserTreePath currPath = (UserTreePath)this.paths_.get(pathKey);
        utpc.oldPath = (UserTreePath)currPath.clone();
        UserTreePathStop newStop = new UserTreePathStop(genomeID, ovrKey, mods, revs);
        currPath.addStop(newStop, stopIndex);
        utpc.newIndex = -1;
        utpc.newPath = (UserTreePath)currPath.clone();
        return utpc;
    }

    public void addPreexistingPath(UserTreePath newPath) {
        this.labels_.addExistingLabel(newPath.getID());
        this.paths_.put(newPath.getID(), newPath);
        this.pathOrder_.add(newPath.getID());
    }

    public UserTreePathChange deletePath(String key) {
        UserTreePathChange utpc = new UserTreePathChange();
        utpc.oldIndex = this.pathOrder_.indexOf(key);
        UserTreePath delPath = (UserTreePath)this.paths_.get(key);
        utpc.oldPath = (UserTreePath)delPath.clone();
        this.paths_.remove(key);
        this.labels_.removeLabel(key);
        this.pathOrder_.remove(key);
        return utpc;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<userTreePaths>");
        ind.up();
        Iterator skit = this.pathOrder_.iterator();
        while (skit.hasNext()) {
            String key = (String)skit.next();
            UserTreePath utPath = (UserTreePath)this.paths_.get(key);
            utPath.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</userTreePaths>");
    }

    public UserTreePathChange deletePathStop(String pathKey, int stopIndex) {
        UserTreePathChange utpc = new UserTreePathChange();
        utpc.oldIndex = -1;
        UserTreePath currPath = (UserTreePath)this.paths_.get(pathKey);
        utpc.oldPath = (UserTreePath)currPath.clone();
        currPath.deleteStop(stopIndex);
        utpc.newIndex = -1;
        utpc.newPath = (UserTreePath)currPath.clone();
        return utpc;
    }

    public UserTreePathChange replacePathStop(String pathKey, int stopIndex, String newKey) {
        UserTreePathChange utpc = new UserTreePathChange();
        utpc.oldIndex = -1;
        UserTreePath currPath = (UserTreePath)this.paths_.get(pathKey);
        utpc.oldPath = (UserTreePath)currPath.clone();
        currPath.replaceStopModelID(stopIndex, newKey);
        utpc.newIndex = -1;
        utpc.newPath = (UserTreePath)currPath.clone();
        return utpc;
    }

    public UserTreePathChange dropPathStopModule(String pathKey, int stopIndex, String modKey) {
        UserTreePathChange utpc = new UserTreePathChange();
        utpc.oldIndex = -1;
        UserTreePath currPath = (UserTreePath)this.paths_.get(pathKey);
        utpc.oldPath = (UserTreePath)currPath.clone();
        currPath.dropStopModule(stopIndex, modKey);
        utpc.newIndex = -1;
        utpc.newPath = (UserTreePath)currPath.clone();
        return utpc;
    }

    public UserTreePathChange[] deleteAllPathStopsForModel(String modelKey) {
        ArrayList<UserTreePathChange> retvals = new ArrayList<UserTreePathChange>();
        ArrayList<String> deadPaths = new ArrayList<String>();
        Iterator pit = this.paths_.keySet().iterator();
        while (pit.hasNext()) {
            String pathKey = (String)pit.next();
            UserTreePath currPath = (UserTreePath)this.paths_.get(pathKey);
            int stopNum = currPath.getStopCount();
            int stopIndex = 0;
            while (stopIndex < stopNum) {
                UserTreePathStop currStop = currPath.getStop(stopIndex);
                if (currStop.getGenomeID().equals(modelKey)) {
                    retvals.add(this.deletePathStop(pathKey, stopIndex));
                    --stopNum;
                    continue;
                }
                ++stopIndex;
            }
            if (stopNum != 0) continue;
            deadPaths.add(pathKey);
        }
        Iterator dpit = deadPaths.iterator();
        while (dpit.hasNext()) {
            String deadKey = (String)dpit.next();
            retvals.add(this.deletePath(deadKey));
        }
        UserTreePathChange[] retval = new UserTreePathChange[retvals.size()];
        retvals.toArray(retval);
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changeUndo(UserTreePathChange undo) {
        if (undo.oldPath != null) {
            String oldKey = undo.oldPath.getID();
            if (undo.oldIndex != -1) {
                this.labels_.addExistingLabel(oldKey);
                this.paths_.put(oldKey, undo.oldPath.clone());
                this.pathOrder_.add(undo.oldIndex, oldKey);
                return;
            } else {
                this.paths_.put(oldKey, undo.oldPath.clone());
            }
            return;
        } else {
            if (undo.newPath == null) throw new IllegalArgumentException();
            String newKey = undo.newPath.getID();
            if (undo.newIndex == -1) throw new IllegalArgumentException();
            this.paths_.remove(newKey);
            this.labels_.removeLabel(newKey);
            this.pathOrder_.remove(newKey);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changeRedo(UserTreePathChange redo) {
        if (redo.newPath != null) {
            String newKey = redo.newPath.getID();
            if (redo.newIndex != -1) {
                this.labels_.addExistingLabel(newKey);
                this.paths_.put(newKey, redo.newPath.clone());
                this.pathOrder_.add(redo.newIndex, newKey);
                return;
            } else {
                this.paths_.put(newKey, redo.newPath.clone());
            }
            return;
        } else {
            if (redo.oldPath == null) throw new IllegalArgumentException();
            String oldKey = redo.oldPath.getID();
            if (redo.oldIndex == -1) throw new IllegalArgumentException();
            this.paths_.remove(oldKey);
            this.labels_.removeLabel(oldKey);
            this.pathOrder_.remove(oldKey);
        }
    }

    public Vector getPathChoices() {
        Vector<ObjChoiceContent> retval = new Vector<ObjChoiceContent>();
        Iterator skit = this.pathOrder_.iterator();
        while (skit.hasNext()) {
            String key = (String)skit.next();
            UserTreePath utPath = (UserTreePath)this.paths_.get(key);
            retval.add(new ObjChoiceContent(utPath.getName(), key));
        }
        return retval;
    }

    public ObjChoiceContent getPathChoice(String key) {
        UserTreePath utPath = (UserTreePath)this.paths_.get(key);
        return new ObjChoiceContent(utPath.getName(), key);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("userTreePaths");
        return retval;
    }

    public static synchronized UserTreePathManager getMgr() {
        if (singleton_ == null) {
            singleton_ = new UserTreePathManager();
        }
        return singleton_;
    }

    private UserTreePathManager() {
    }
}

