/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.nav;

import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.xml.sax.Attributes;

public class UserTreePathStop
implements Cloneable {
    private String genomeID_;
    private String ovrKey_;
    private TaggedSet modKeys_;
    private TaggedSet revKeys_;

    public UserTreePathStop(UserTreePathStop other) {
        this.genomeID_ = other.genomeID_;
        this.ovrKey_ = other.ovrKey_;
        this.modKeys_ = new TaggedSet(other.modKeys_);
        this.revKeys_ = new TaggedSet(other.revKeys_);
    }

    public UserTreePathStop(String genomeID, String ovrKey, TaggedSet modKeys, TaggedSet revKeys) {
        this.genomeID_ = genomeID;
        this.ovrKey_ = ovrKey;
        this.modKeys_ = modKeys == null ? new TaggedSet() : new TaggedSet(modKeys);
        this.revKeys_ = revKeys == null ? new TaggedSet() : new TaggedSet(revKeys);
        this.revKeys_.set.retainAll(this.modKeys_.set);
    }

    public Object clone() {
        try {
            UserTreePathStop retval = (UserTreePathStop)super.clone();
            retval.modKeys_ = (TaggedSet)this.modKeys_.clone();
            retval.revKeys_ = (TaggedSet)this.revKeys_.clone();
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof UserTreePathStop)) {
            return false;
        }
        UserTreePathStop otherPS = (UserTreePathStop)other;
        if (!this.genomeID_.equals(otherPS.genomeID_)) {
            return false;
        }
        if (this.ovrKey_ == null) {
            return otherPS.ovrKey_ == null;
        }
        if (!this.modKeys_.equals(otherPS.modKeys_)) {
            return false;
        }
        return this.revKeys_.equals(otherPS.revKeys_);
    }

    public String getGenomeID() {
        return this.genomeID_;
    }

    public void setGenomeID(String id) {
        this.genomeID_ = id;
    }

    public String getOverlay() {
        return this.ovrKey_;
    }

    public TaggedSet getModules() {
        return this.modKeys_;
    }

    public TaggedSet getRevealed() {
        return this.revKeys_;
    }

    public void dropModKey(String dropModKey) {
        this.modKeys_.set.remove(dropModKey);
        this.revKeys_.set.remove(dropModKey);
    }

    public void setModKeys(TaggedSet modKeys) {
        this.modKeys_ = modKeys == null ? new TaggedSet() : modKeys;
    }

    public void setRevKeys(TaggedSet revKeys) {
        this.revKeys_ = revKeys == null ? new TaggedSet() : revKeys;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<pathStop id=\"");
        out.print(this.genomeID_);
        if (this.ovrKey_ != null) {
            out.print("\" ovrKey=\"");
            out.print(this.ovrKey_);
        }
        if (this.ovrKey_ == null || this.modKeys_ == null) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        ind.up();
        if (this.modKeys_ != null) {
            ind.indent();
            if (this.modKeys_.set.isEmpty()) {
                out.println("<stopMods/>");
            } else {
                out.println("<stopMods>");
                ind.up();
                this.modKeys_.writeXML(out, ind);
                ind.down().indent();
                out.println("</stopMods>");
            }
        }
        if (this.revKeys_ != null) {
            ind.indent();
            if (this.revKeys_.set.isEmpty()) {
                out.println("<stopViz/>");
            } else {
                out.println("<stopViz>");
                ind.up();
                this.revKeys_.writeXML(out, ind);
                ind.down().indent();
                out.println("</stopViz>");
            }
        }
        ind.down().indent();
        out.println("</pathStop>");
    }

    public static class MyTSVGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            UserTreePathStop stop = board.userTreePathStop;
            TaggedSet tSet = board.currentTaggedSet;
            stop.setRevKeys(tSet);
            return null;
        }
    }

    public static class MyTSMGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            UserTreePathStop stop = board.userTreePathStop;
            TaggedSet tSet = board.currentTaggedSet;
            stop.setModKeys(tSet);
            return null;
        }
    }

    public static class VizWorker
    extends AbstractFactoryClient {
        public VizWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("stopViz");
            this.installWorker(new TaggedSet.TaggedSetWorker(whiteboard), new MyTSVGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            return null;
        }
    }

    public static class ModWorker
    extends AbstractFactoryClient {
        public ModWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("stopMods");
            this.installWorker(new TaggedSet.TaggedSetWorker(whiteboard), new MyTSMGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            return null;
        }
    }

    public static class UserTreePathStopWorker
    extends AbstractFactoryClient {
        public UserTreePathStopWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pathStop");
            this.installWorker(new ModWorker(whiteboard), null);
            this.installWorker(new VizWorker(whiteboard), null);
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            UserTreePathStop retval = null;
            if (elemName.equals("pathStop")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.userTreePathStop = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private UserTreePathStop buildFromXML(String elemName, Attributes attrs) throws IOException {
            String genomeID = AttributeExtractor.extractAttribute(elemName, attrs, "pathStop", "id", true);
            String ovrKey = AttributeExtractor.extractAttribute(elemName, attrs, "pathStop", "ovrKey", false);
            return new UserTreePathStop(genomeID, ovrKey, null, null);
        }
    }
}

