/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.xml.sax.Attributes;

public abstract class AbstractFactoryClient
implements ParserClient {
    protected Object container_;
    protected HashMap workerMap_;
    protected HashMap glueStickMap_;
    protected AbstractFactoryClient currWorker_;
    protected String currElem_;
    protected Object sharedWhiteboard_;
    protected HashSet myKeys_ = new HashSet();

    public AbstractFactoryClient(Object sharedWhiteboard) {
        this.workerMap_ = new HashMap();
        this.glueStickMap_ = new HashMap();
        this.sharedWhiteboard_ = sharedWhiteboard;
    }

    public void setContainer(Object container) {
        this.container_ = container;
    }

    public boolean finishElement(String elemName) throws IOException {
        if (this.currWorker_ != null) {
            boolean dropWorker = this.currWorker_.finishElement(elemName);
            if (dropWorker) {
                if (!elemName.equals(this.currElem_)) {
                    throw new IllegalStateException();
                }
                this.currWorker_ = null;
                this.currElem_ = null;
            }
            return this.myKeys_.contains(elemName);
        }
        this.localFinishElement(elemName);
        return this.myKeys_.contains(elemName);
    }

    public void processCharacters(char[] chars, int start, int length) {
        if (this.currWorker_ != null) {
            this.currWorker_.processCharacters(chars, start, length);
            return;
        }
        this.localProcessCharacters(chars, start, length);
    }

    public Set keywordsOfInterest() {
        return this.myKeys_;
    }

    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (this.currWorker_ != null) {
            return this.currWorker_.processElement(elemName, attrs);
        }
        AbstractFactoryClient assignedWorker = (AbstractFactoryClient)this.workerMap_.get(elemName);
        if (assignedWorker != null) {
            GlueStick glue;
            this.currElem_ = elemName;
            this.currWorker_ = assignedWorker;
            Object createdElement = this.currWorker_.processElement(elemName, attrs);
            if (createdElement != null && (glue = (GlueStick)this.glueStickMap_.get(elemName)) != null) {
                glue.glueKidToParent(createdElement, this, this.sharedWhiteboard_);
            }
            return createdElement;
        }
        return this.localProcessElement(elemName, attrs);
    }

    protected void installWorker(AbstractFactoryClient worker, GlueStick glue) {
        Set uniqueKeys = worker.keywordsOfInterest();
        Iterator ukit = uniqueKeys.iterator();
        while (ukit.hasNext()) {
            String key = (String)ukit.next();
            this.workerMap_.put(key, worker);
            if (glue == null) continue;
            this.glueStickMap_.put(key, glue);
        }
    }

    protected abstract Object localProcessElement(String var1, Attributes var2) throws IOException;

    protected void localFinishElement(String elemName) throws IOException {
    }

    protected void localProcessCharacters(char[] chars, int start, int length) {
    }
}

