/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SUParser
extends DefaultHandler {
    private XMLReader parser_;
    private HashMap clients_;
    private ParserClient currClient_;
    private String lastElement_;

    public SUParser(List citList) {
        this();
        Iterator cit = citList.iterator();
        this.clients_ = new HashMap();
        while (cit.hasNext()) {
            ParserClient pc = (ParserClient)cit.next();
            Set keys = pc.keywordsOfInterest();
            Iterator ki = keys.iterator();
            while (ki.hasNext()) {
                String key = (String)ki.next();
                ParserClient prev = this.clients_.put(key, pc);
                if (prev == null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.currClient_ = null;
        this.lastElement_ = null;
    }

    public void parse(File toParse) throws IOException {
        this.parse(toParse.getPath());
    }

    public void parse(String fileName) throws IOException {
        if (fileName.indexOf("file:///") != 0) {
            fileName = "file:///" + fileName;
        }
        try {
            this.parser_.parse(fileName);
        }
        catch (SAXException e) {
            String msg = this.formatSAXExceptionMessage(e);
            System.err.println("Got a SAX exception: " + msg);
            throw new IOException(msg);
        }
        catch (IOException e) {
            System.err.println("Got an IO exception: " + e);
            throw this.rebundleIOException(e);
        }
    }

    public void parse(URL source) throws IOException {
        try {
            this.parser_.parse(new InputSource(source.openStream()));
        }
        catch (SAXException e) {
            String msg = this.formatSAXExceptionMessage(e);
            System.err.println("Got a SAX exception: " + msg);
            throw new IOException(msg);
        }
        catch (IOException e) {
            System.err.println("Got an IO exception: " + e);
            throw this.rebundleIOException(e);
        }
    }

    public void parse(InputStream stream) throws IOException {
        try {
            this.parser_.parse(new InputSource(stream));
        }
        catch (SAXException e) {
            String msg = this.formatSAXExceptionMessage(e);
            System.err.println("Got a SAX exception: " + msg);
            throw new IOException(msg);
        }
        catch (IOException e) {
            System.err.println("Got an IO exception: " + e);
            throw this.rebundleIOException(e);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        if (this.currClient_ != null) {
            try {
                this.lastElement_ = local;
                Object target = this.currClient_.processElement(local, attrs);
                if (target != null) {
                    this.setTargets(target);
                }
            }
            catch (IOException ioe) {
                throw this.rebundleIOExceptionToSAX(ioe);
            }
            return;
        }
        ParserClient pc = (ParserClient)this.clients_.get(local);
        if (pc != null) {
            this.currClient_ = pc;
            try {
                this.lastElement_ = local;
                Object target = this.currClient_.processElement(local, attrs);
                if (target != null) {
                    this.setTargets(target);
                }
            }
            catch (IOException ioe) {
                throw this.rebundleIOExceptionToSAX(ioe);
            }
        }
    }

    public void endElement(String uri, String local, String raw) throws SAXException {
        if (this.currClient_ == null) {
            return;
        }
        try {
            if (this.currClient_.finishElement(local)) {
                this.currClient_ = null;
            }
        }
        catch (IOException ioe) {
            throw this.rebundleIOExceptionToSAX(ioe);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currClient_ != null) {
            this.currClient_.processCharacters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    public void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
    }

    public static void main(String[] argv) {
        try {
            SUParser sup = new SUParser();
            sup.parse("FIXME");
        }
        catch (IOException e) {
            System.err.println("Got an IO exception: " + e);
        }
    }

    private SUParser() {
        try {
            String jVer = System.getProperty("java.version");
            String pName = jVer.startsWith("1.4") ? "org.apache.crimson.parser.XMLReaderImpl" : "com.sun.org.apache.xerces.internal.parsers.SAXParser";
            this.parser_ = XMLReaderFactory.createXMLReader(pName);
            this.parser_.setContentHandler(this);
            this.parser_.setErrorHandler(this);
        }
        catch (SAXException e) {
            System.err.println("Got a SAX exception: " + e);
        }
    }

    private void printError(String type, SAXParseException ex) {
        System.err.print("Error: ");
        System.err.println(type);
        if (ex == null) {
            return;
        }
        String sid = ex.getSystemId();
        if (sid != null) {
            System.err.println(sid);
        }
        System.err.print("Line number: ");
        System.err.println(ex.getLineNumber());
        System.err.print("Column number:");
        System.err.println(ex.getColumnNumber());
        System.err.print("Message: ");
        System.err.println(ex.getMessage());
    }

    private void setTargets(Object target) {
        Iterator ci = this.clients_.values().iterator();
        while (ci.hasNext()) {
            ParserClient cli = (ParserClient)ci.next();
            cli.setContainer(target);
        }
    }

    private String formatSAXExceptionMessage(SAXException e) {
        String retval;
        ResourceManager rMan = ResourceManager.getManager();
        String exMsg = e.getMessage();
        Integer lineNo = null;
        Integer colNo = null;
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            lineNo = new Integer(spe.getLineNumber());
            colNo = new Integer(spe.getColumnNumber());
        }
        if (lineNo == null) {
            String format = rMan.getString("fileRead.SAXErrorFormat");
            retval = MessageFormat.format(format, exMsg);
        } else {
            String format = rMan.getString("fileRead.SAXParseErrorFormat");
            retval = MessageFormat.format(format, exMsg, lineNo, colNo);
        }
        return retval;
    }

    private IOException rebundleIOException(IOException e) {
        return new IOException(this.buildIOExceptionMsg(e));
    }

    private SAXException rebundleIOExceptionToSAX(IOException e) {
        return new SAXException(this.buildIOExceptionMsg(e));
    }

    private String buildIOExceptionMsg(IOException e) {
        String retmsg;
        String msg;
        ResourceManager rMan = ResourceManager.getManager();
        String string = msg = e == null ? null : e.getMessage();
        if (msg == null || msg.trim().equals("")) {
            if (this.lastElement_ == null) {
                retmsg = rMan.getString("fileRead.IOErrorNoDetails");
            } else {
                String format = rMan.getString("fileRead.IOErrorNoMsgWithElemFormat");
                retmsg = MessageFormat.format(format, this.lastElement_);
            }
        } else if (this.lastElement_ == null) {
            String format = rMan.getString("fileRead.IOErrorMsgNoElemFormat");
            retmsg = MessageFormat.format(format, msg);
        } else {
            String format = rMan.getString("fileRead.IOExtraMsgWithElemFormat");
            retmsg = MessageFormat.format(format, msg, this.lastElement_);
        }
        return retmsg;
    }

    class MyEntityResolver
    implements EntityResolver {
        private String resource_;

        public MyEntityResolver(String resource) {
            this.resource_ = resource;
        }

        public InputSource resolveEntity(String publicID, String systemId) throws SAXException, IOException {
            return new InputSource(this.getClass().getResourceAsStream(this.resource_));
        }
    }
}

