/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.perturb.ConditionDictionary;
import org.systemsbiology.biotapestry.util.BoundedDoubMinMax;
import org.systemsbiology.biotapestry.util.DataUtil;

public class CSVData {
    private ArrayList perturbs_ = new ArrayList();
    private String time_;
    private String date_;
    private String batchID_;
    private String condition_;
    private ArrayList investigators_;
    private HashMap measurements_;

    public CSVData(List expToks, String date, List investigators, String time, String condition, String key) {
        int numEt = expToks.size();
        for (int i = 0; i < numEt; ++i) {
            ExperimentTokens etok = (ExperimentTokens)expToks.get(i);
            this.perturbs_.add(etok);
        }
        this.time_ = time;
        this.date_ = date;
        ConditionDictionary cDict = Database.getDB().getPertData().getConditionDictionary();
        String stdName = cDict.getExprConditions(cDict.getStandardConditionKey()).getDescription();
        this.condition_ = condition == null || condition.trim().equals("") || condition.equalsIgnoreCase(stdName) ? stdName : condition;
        this.investigators_ = new ArrayList(investigators);
        this.batchID_ = key;
        this.measurements_ = new HashMap();
    }

    public static boolean isValidMeasurement(String value, BoundedDoubMinMax illegal) {
        double val;
        if (value == null) {
            return false;
        }
        String input = value.trim();
        if (input.equals("")) {
            return false;
        }
        try {
            val = Double.parseDouble(input);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (illegal == null) {
            return true;
        }
        return !illegal.contained(val);
    }

    public void addDataPoint(DataPoint dp) {
        String target = DataUtil.normKey(dp.target);
        ArrayList<DataPoint> values = (ArrayList<DataPoint>)this.measurements_.get(target);
        if (values == null) {
            values = new ArrayList<DataPoint>();
            this.measurements_.put(target, values);
        }
        values.add(dp);
    }

    public Set getTargets() {
        return this.measurements_.keySet();
    }

    public List getSources() {
        return this.perturbs_;
    }

    public String getTime() {
        return this.time_;
    }

    public String getDate() {
        return this.date_;
    }

    public List getInvestigators() {
        return this.investigators_;
    }

    public String getBatchID() {
        return this.batchID_;
    }

    public String getCondition() {
        return this.condition_;
    }

    public List getMeasurements(String target) {
        return (List)this.measurements_.get(target);
    }

    public String getOriginalTargetName(String targetKey) {
        List meas = (List)this.measurements_.get(targetKey);
        DataPoint dp = (DataPoint)meas.get(0);
        return dp.target;
    }

    public static String buildRowKey(List etoks, String date, List invests, String time, String condition, String fullBatchID) {
        StringBuffer buf = new StringBuffer();
        buf.append(date);
        buf.append("*$*");
        buf.append(time);
        buf.append("*$*");
        buf.append(condition);
        buf.append("*$*");
        buf.append(fullBatchID);
        buf.append("*$*");
        ArrayList sortInv = new ArrayList(invests);
        Collections.sort(sortInv);
        Iterator lit = invests.iterator();
        while (lit.hasNext()) {
            String invest = (String)lit.next();
            buf.append(invest);
            if (!lit.hasNext()) continue;
            buf.append("*$*");
        }
        StringBuffer buf2 = new StringBuffer();
        ArrayList<String> otoks = new ArrayList<String>();
        Iterator eit = etoks.iterator();
        while (eit.hasNext()) {
            ExperimentTokens tok = (ExperimentTokens)eit.next();
            buf2.setLength(0);
            buf2.append(tok.base);
            buf2.append(tok.expType);
            otoks.add(buf2.toString());
        }
        Collections.sort(otoks);
        Iterator oit = otoks.iterator();
        while (oit.hasNext()) {
            String tok = (String)oit.next();
            buf.append(tok);
            if (!oit.hasNext()) continue;
            buf.append("*$*");
        }
        return buf.toString();
    }

    public static String buildBatchKey(String date, List list, String repeatNum, String time, String condition, boolean useDate, boolean useTime, boolean useBatch, boolean useInvest, boolean useCondition) {
        StringBuffer buf = new StringBuffer();
        boolean isFirst = true;
        if (useDate) {
            buf.append(date);
            isFirst = false;
        }
        if (useInvest) {
            if (!isFirst) {
                buf.append("::");
            }
            isFirst = false;
            ArrayList sortInv = new ArrayList(list);
            Collections.sort(sortInv);
            Iterator lit = sortInv.iterator();
            while (lit.hasNext()) {
                String invest = (String)lit.next();
                buf.append(invest);
                if (!lit.hasNext()) continue;
                buf.append("::");
            }
        }
        if (useBatch) {
            if (!isFirst) {
                buf.append("::");
            }
            isFirst = false;
            buf.append(repeatNum);
        }
        if (useTime) {
            if (!isFirst) {
                buf.append("::");
            }
            isFirst = false;
            buf.append(time);
        }
        if (useCondition) {
            if (condition == null) {
                condition = "";
            }
            if (!isFirst) {
                buf.append("::");
            }
            isFirst = false;
            buf.append(condition);
        }
        return buf.toString();
    }

    public static class ExperimentTokens {
        public String base;
        public String expType;
        public String orig;

        public ExperimentTokens() {
        }

        public ExperimentTokens(String base, String expType, String orig) {
            this.base = base;
            this.expType = expType;
            this.orig = orig;
        }

        public boolean haveAMatch(String value, String name, String abbrev) {
            int expIndex = -1;
            boolean gottaMatch = false;
            String vuc = DataUtil.normKey(value);
            int chkIndex = vuc.indexOf(DataUtil.normKey(name));
            if (chkIndex != -1 && chkIndex == vuc.length() - name.length()) {
                expIndex = chkIndex;
                gottaMatch = true;
            }
            if (!gottaMatch && abbrev != null && (chkIndex = vuc.indexOf(DataUtil.normKey(abbrev))) != -1 && chkIndex == vuc.length() - abbrev.length()) {
                expIndex = chkIndex;
                gottaMatch = true;
            }
            if (gottaMatch) {
                this.expType = name;
                this.base = value.substring(0, expIndex);
                this.orig = value;
            }
            return gottaMatch;
        }
    }

    public static class DataPoint {
        public String target;
        public String value;
        public String isValid;
        public String comment;
        public String control;
        public List annots;
        public String measurement;
        public HashMap userFields;

        public DataPoint(String target, String value, String control, String isValid, String comment) {
            this.target = target;
            this.value = value;
            this.isValid = isValid;
            this.comment = comment;
            this.control = control;
            this.userFields = new HashMap();
        }
    }
}

