/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.perturb.ExperimentConditions;
import org.systemsbiology.biotapestry.perturb.ExperimentControl;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class ConditionDictionary
implements Cloneable {
    private HashMap cond_ = new HashMap();
    private UniqueLabeller labels_;
    private String defaultCond_;
    private HashMap controls_ = new HashMap();

    public ConditionDictionary() {
        this.labels_ = new UniqueLabeller();
        this.defaultCond_ = this.createDefaultCondition();
    }

    public String getNextDataKey() {
        return this.labels_.getNextLabel();
    }

    public String getStandardConditionKey() {
        return this.defaultCond_;
    }

    public boolean haveData() {
        return this.cond_.size() > 1 || !this.controls_.isEmpty();
    }

    public Object clone() {
        try {
            ConditionDictionary newVal = (ConditionDictionary)super.clone();
            newVal.cond_ = new HashMap();
            Iterator psit = this.cond_.keySet().iterator();
            while (psit.hasNext()) {
                String psKey = (String)psit.next();
                newVal.cond_.put(psKey, ((ExperimentConditions)this.cond_.get(psKey)).clone());
            }
            newVal.controls_ = new HashMap();
            Iterator conit = this.controls_.keySet().iterator();
            while (conit.hasNext()) {
                String contKey = (String)conit.next();
                newVal.controls_.put(contKey, ((ExperimentControl)this.controls_.get(contKey)).clone());
            }
            newVal.labels_ = (UniqueLabeller)this.labels_.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    private String createDefaultCondition() {
        String newID = this.labels_.getNextLabel();
        ExperimentConditions stdC = new ExperimentConditions(newID, "Standard");
        this.cond_.put(newID, stdC);
        return newID;
    }

    public Set getConditionNameSet() {
        HashSet<String> retval = new HashSet<String>();
        Iterator ckit = this.cond_.values().iterator();
        while (ckit.hasNext()) {
            ExperimentConditions ec = (ExperimentConditions)ckit.next();
            retval.add(ec.getDescription());
        }
        return retval;
    }

    public Iterator getKeys() {
        TreeSet ordered = new TreeSet(this.cond_.keySet());
        Iterator oit = ordered.iterator();
        return oit;
    }

    public ExperimentConditions getExprConditions(String key) {
        return (ExperimentConditions)this.cond_.get(key);
    }

    public void setExprCondition(ExperimentConditions eCond) {
        this.cond_.put(eCond.getID(), eCond);
    }

    public void addExprConditionsForIO(ExperimentConditions eCond) {
        String id = eCond.getID();
        this.labels_.addExistingLabel(id);
        this.cond_.put(id, eCond);
    }

    public void dropExprConditions(String key) {
        this.cond_.remove(key);
        this.labels_.removeLabel(key);
    }

    public String getConditionKeyFromName(String name) {
        String normName = DataUtil.normKey(name);
        Iterator ckit = this.cond_.keySet().iterator();
        while (ckit.hasNext()) {
            String cKey = (String)ckit.next();
            ExperimentConditions cond = (ExperimentConditions)this.cond_.get(cKey);
            if (!DataUtil.normKey(cond.getDescription()).equals(normName)) continue;
            return cKey;
        }
        return null;
    }

    public Iterator getControlKeys() {
        TreeSet ordered = new TreeSet(this.controls_.keySet());
        Iterator oit = ordered.iterator();
        return oit;
    }

    public int getExprControlCount() {
        return this.controls_.size();
    }

    public Set getControlNameSet() {
        HashSet<String> retval = new HashSet<String>();
        Iterator ckit = this.controls_.values().iterator();
        while (ckit.hasNext()) {
            ExperimentControl ec = (ExperimentControl)ckit.next();
            retval.add(ec.getDescription());
        }
        return retval;
    }

    public ExperimentControl getExprControl(String key) {
        return (ExperimentControl)this.controls_.get(key);
    }

    public void setExprControl(ExperimentControl eCond) {
        this.controls_.put(eCond.getID(), eCond);
    }

    public void addExprControlForIO(ExperimentControl eCond) {
        String id = eCond.getID();
        this.labels_.addExistingLabel(id);
        this.controls_.put(id, eCond);
    }

    public void dropExprControl(String key) {
        this.controls_.remove(key);
        this.labels_.removeLabel(key);
    }

    public String getControlKeyFromName(String name) {
        if (name == null) {
            return null;
        }
        String normName = DataUtil.normKey(name);
        Iterator ckit = this.controls_.keySet().iterator();
        while (ckit.hasNext()) {
            String cKey = (String)ckit.next();
            ExperimentControl ctrl = (ExperimentControl)this.controls_.get(cKey);
            if (!DataUtil.normKey(ctrl.getDescription()).equals(normName)) continue;
            return cKey;
        }
        return null;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        Cloneable pp;
        String key;
        ind.indent();
        out.println("<conditionDictionary>");
        ind.up().indent();
        out.println("<conditions>");
        ind.up();
        TreeSet ordered = new TreeSet(this.cond_.keySet());
        Iterator oit = ordered.iterator();
        while (oit.hasNext()) {
            key = (String)oit.next();
            pp = (ExperimentConditions)this.cond_.get(key);
            ((ExperimentConditions)pp).writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</conditions>");
        if (!this.controls_.isEmpty()) {
            ind.indent();
            out.println("<controls>");
            ind.up();
            ordered = new TreeSet(this.controls_.keySet());
            oit = ordered.iterator();
            while (oit.hasNext()) {
                key = (String)oit.next();
                pp = (ExperimentControl)this.controls_.get(key);
                ((ExperimentControl)pp).writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</controls>");
        }
        ind.down().indent();
        out.println("</conditionDictionary>");
    }

    public Vector getExprConditionsOptions() {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        Iterator oit = this.cond_.keySet().iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            sorted.add(this.getExprConditionsChoice(key));
        }
        return new Vector(sorted);
    }

    public TrueObjChoiceContent getExprConditionsChoice(String key) {
        ExperimentConditions mp = (ExperimentConditions)this.cond_.get(key);
        return new TrueObjChoiceContent(mp.getDisplayString(), key);
    }

    public Vector getExprControlOptions() {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        Iterator oit = this.controls_.keySet().iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            sorted.add(this.getExprControlChoice(key));
        }
        return new Vector(sorted);
    }

    public TrueObjChoiceContent getExprControlChoice(String key) {
        ExperimentControl mp = (ExperimentControl)this.controls_.get(key);
        return new TrueObjChoiceContent(mp.getDisplayString(), key);
    }

    public static class MyControlGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.cDict.addExprControlForIO(board.expControl);
            return null;
        }
    }

    public static class MyCondGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.cDict.addExprConditionsForIO(board.experCond);
            return null;
        }
    }

    public static class ConditionDictionaryWorker
    extends AbstractFactoryClient {
        public ConditionDictionaryWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("conditionDictionary");
            this.installWorker(new ExperimentConditions.ExperimentCondWorker(whiteboard), new MyCondGlue());
            this.installWorker(new ExperimentControl.ExperimentControlWorker(whiteboard), new MyControlGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            ConditionDictionary retval = null;
            if (elemName.equals("conditionDictionary")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.cDict = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private ConditionDictionary buildFromXML(String elemName, Attributes attrs) throws IOException {
            ConditionDictionary cDict = new ConditionDictionary();
            return cDict;
        }
    }
}

