/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.cmd.TimeCourseChangeCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.perturb.Experiment;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertDataPoint;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseChange;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class DependencyAnalyzer {
    private PerturbationData pd_;

    public DependencyAnalyzer(PerturbationData pd) {
        this.pd_ = pd;
    }

    public Dependencies getAnnotReferenceSet(String annotID) {
        HashSet<String> pSUses = new HashSet<String>();
        Iterator sdit = this.pd_.getSourceDefKeys();
        while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            List aids = chk.getAnnotationIDs();
            if (!aids.contains(annotID)) continue;
            pSUses.add(psdKey);
        }
        HashSet<String> pSIUses = new HashSet<String>();
        Iterator psit = this.pd_.getExperimentKeys();
        while (psit.hasNext()) {
            String psiKey = (String)psit.next();
            Experiment psi = this.pd_.getExperiment(psiKey);
            PertSources pss = psi.getSources();
            Iterator ppit = pss.getSources();
            while (ppit.hasNext()) {
                String srcID = (String)ppit.next();
                if (!pSUses.contains(srcID)) continue;
                pSIUses.add(psi.getID());
            }
        }
        HashSet<String> dpUses = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            String id = pdp.getID();
            if (pSIUses.contains(pdp.getExperimentKey())) {
                dpUses.add(id);
                continue;
            }
            List dpn = this.pd_.getDataPointNotes(id);
            if (dpn == null || !dpn.contains(annotID)) continue;
            dpUses.add(id);
        }
        HashSet<String> targUses = new HashSet<String>();
        Iterator tkit = this.pd_.getTargetKeys();
        while (tkit.hasNext()) {
            String targKey = (String)tkit.next();
            List tn = this.pd_.getFootnotesForTarget(targKey);
            if (tn == null || !tn.contains(annotID)) continue;
            targUses.add(targKey);
        }
        return new Dependencies(2, annotID, null, dpUses, pSIUses, pSUses, null, targUses, null, null);
    }

    public Dependencies getAnnotMergeSet(Set joinKeys, String commonKey) {
        HashSet<String> pSUses = new HashSet<String>();
        Iterator sdit = this.pd_.getSourceDefKeys();
        block0: while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            List aids = chk.getAnnotationIDs();
            int numa = aids.size();
            for (int i = 0; i < numa; ++i) {
                String annotKey = (String)aids.get(i);
                if (!joinKeys.contains(annotKey)) continue;
                pSUses.add(psdKey);
                continue block0;
            }
        }
        HashSet<String> dpUses = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPointNoteKeys();
        block2: while (dpit.hasNext()) {
            String id = (String)dpit.next();
            List aids = this.pd_.getDataPointNotes(id);
            int numa = aids.size();
            for (int i = 0; i < numa; ++i) {
                String annotKey = (String)aids.get(i);
                if (!joinKeys.contains(annotKey)) continue;
                dpUses.add(id);
                continue block2;
            }
        }
        HashSet targUses = new HashSet();
        Iterator tkit = this.pd_.getTargetKeys();
        block4: while (tkit.hasNext()) {
            String targKey = (String)tkit.next();
            List aids = this.pd_.getFootnotesForTarget(targKey);
            if (aids == null) continue;
            int numa = aids.size();
            for (int i = 0; i < numa; ++i) {
                String annotKey = (String)aids.get(i);
                if (!joinKeys.contains(annotKey)) continue;
                aids.add(targKey);
                continue block4;
            }
        }
        return new Dependencies(9, commonKey, new HashSet(joinKeys), dpUses, null, pSUses, null, targUses, null, null);
    }

    public Map getAllAnnotReferenceCounts() {
        String aid;
        int i;
        HashMap retval = new HashMap();
        Iterator sdit = this.pd_.getSourceDefKeys();
        while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            List aids = chk.getAnnotationIDs();
            int numAids = aids.size();
            for (i = 0; i < numAids; ++i) {
                aid = (String)aids.get(i);
                DataUtil.bumpCountMap(retval, aid);
            }
        }
        Iterator dpknit = this.pd_.getDataPointNoteKeys();
        while (dpknit.hasNext()) {
            String dpnkey = (String)dpknit.next();
            List dpn = this.pd_.getDataPointNotes(dpnkey);
            int numDpn = dpn.size();
            for (i = 0; i < numDpn; ++i) {
                aid = (String)dpn.get(i);
                DataUtil.bumpCountMap(retval, aid);
            }
        }
        Iterator tkit = this.pd_.getTargetKeys();
        while (tkit.hasNext()) {
            String targKey = (String)tkit.next();
            List tn = this.pd_.getFootnotesForTarget(targKey);
            if (tn == null) continue;
            int numTn = tn.size();
            for (int i2 = 0; i2 < numTn; ++i2) {
                String aid2 = (String)tn.get(i2);
                DataUtil.bumpCountMap(retval, aid2);
            }
        }
        return retval;
    }

    public Dependencies getExperimentReferenceSet(String psiID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!pdp.getExperimentKey().equals(psiID)) continue;
            retval.add(pdp.getID());
        }
        return new Dependencies(0, null, null, retval, null, null, null, null, null, null);
    }

    public Dependencies getInvestReferenceSet(String invID) {
        HashSet<String> pSIUses = new HashSet<String>();
        Iterator psit = this.pd_.getExperimentKeys();
        while (psit.hasNext()) {
            String psiKey = (String)psit.next();
            Experiment psi = this.pd_.getExperiment(psiKey);
            List invests = psi.getInvestigators();
            if (!invests.contains(invID)) continue;
            pSIUses.add(psi.getID());
        }
        HashSet<String> dpUses = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!pSIUses.contains(pdp.getExperimentKey())) continue;
            dpUses.add(pdp.getID());
        }
        return new Dependencies(1, invID, null, dpUses, pSIUses, null, null, null, null, null);
    }

    public Map getAllSrcDefReferenceCounts() {
        HashMap retval = new HashMap();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            Experiment exp = pdp.getExperiment(this.pd_);
            PertSources ps = exp.getSources();
            Iterator psit = ps.getSources();
            while (psit.hasNext()) {
                String psdKey = (String)psit.next();
                DataUtil.bumpCountMap(retval, psdKey);
            }
        }
        TimeCourseData tcd = Database.getDB().getTimeCourseData();
        Map psd = tcd.getPertSourceDependencies();
        Iterator tcit = psd.keySet().iterator();
        while (tcit.hasNext()) {
            String psdKey = (String)tcit.next();
            Set forKey = (Set)psd.get(psdKey);
            int fks = forKey.size();
            for (int i = 0; i < fks; ++i) {
                DataUtil.bumpCountMap(retval, psdKey);
            }
        }
        HashMap retvalClone = (HashMap)retval.clone();
        Iterator ekit = this.pd_.getExperimentKeys();
        while (ekit.hasNext()) {
            String eKey = (String)ekit.next();
            Experiment exp = this.pd_.getExperiment(eKey);
            PertSources ps = exp.getSources();
            Iterator psit = ps.getSources();
            while (psit.hasNext()) {
                String psdKey = (String)psit.next();
                if (retvalClone.get(psdKey) != null) continue;
                DataUtil.bumpCountMap(retval, psdKey);
            }
        }
        return retval;
    }

    public Map getAllInvestigatorReferenceCounts(boolean primaryOnly) {
        HashMap retval = new HashMap();
        if (!primaryOnly) {
            Iterator dpit = this.pd_.getDataPoints();
            while (dpit.hasNext()) {
                PertDataPoint pdp = (PertDataPoint)dpit.next();
                Experiment exp = pdp.getExperiment(this.pd_);
                List invs = exp.getInvestigators();
                int numi = invs.size();
                for (int i = 0; i < numi; ++i) {
                    String invKey = (String)invs.get(i);
                    DataUtil.bumpCountMap(retval, invKey);
                }
            }
        }
        HashMap retvalClone = primaryOnly ? null : (HashMap)retval.clone();
        Iterator ekit = this.pd_.getExperimentKeys();
        while (ekit.hasNext()) {
            String eKey = (String)ekit.next();
            Experiment psi = this.pd_.getExperiment(eKey);
            List invs = psi.getInvestigators();
            int numi = invs.size();
            for (int i = 0; i < numi; ++i) {
                String invKey = (String)invs.get(i);
                if (!primaryOnly && retvalClone.get(invKey) != null) continue;
                DataUtil.bumpCountMap(retval, invKey);
            }
        }
        return retval;
    }

    public Dependencies getInvestigatorMergeSet(Set investIDs, String commonKey) {
        HashSet<String> expUses = new HashSet<String>();
        Iterator ekit = this.pd_.getExperimentKeys();
        while (ekit.hasNext()) {
            String eKey = (String)ekit.next();
            Experiment psi = this.pd_.getExperiment(eKey);
            List invs = psi.getInvestigators();
            int numi = invs.size();
            for (int i = 0; i < numi; ++i) {
                String invKey = (String)invs.get(i);
                if (!investIDs.contains(invKey)) continue;
                expUses.add(eKey);
            }
        }
        return new Dependencies(6, commonKey, new HashSet(investIDs), null, expUses, null, null, null, null, null);
    }

    public Map getAllExperimentReferenceCounts() {
        HashMap retval = new HashMap();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            DataUtil.bumpCountMap(retval, pdp.getExperimentKey());
        }
        return retval;
    }

    public Dependencies getExperimentMergeSet(Set expIDs, String commonKey) {
        HashSet<String> expUsed = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            String expid = pdp.getExperimentKey();
            if (!expIDs.contains(expid)) continue;
            expUsed.add(pdp.getID());
        }
        return new Dependencies(13, commonKey, new HashSet(expIDs), expUsed, null, null, null, null, null, null);
    }

    public Map getAllExprConditionReferenceCounts() {
        HashMap retval = new HashMap();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            Experiment exp = pdp.getExperiment(this.pd_);
            DataUtil.bumpCountMap(retval, exp.getConditionKey());
        }
        HashMap retvalClone = (HashMap)retval.clone();
        Iterator ekit = this.pd_.getExperimentKeys();
        while (ekit.hasNext()) {
            String eKey = (String)ekit.next();
            Experiment exp = this.pd_.getExperiment(eKey);
            String condKey = exp.getConditionKey();
            if (retvalClone.get(condKey) != null) continue;
            DataUtil.bumpCountMap(retval, condKey);
        }
        return retval;
    }

    public Map getAllExprControlReferenceCounts() {
        HashMap retval = new HashMap();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            DataUtil.bumpCountMap(retval, pdp.getControl());
        }
        return retval;
    }

    public Dependencies getExprControlReferenceSet(String ctrl) {
        HashSet<String> dpUses = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            String id = pdp.getID();
            if (!ctrl.equals(pdp.getControl())) continue;
            dpUses.add(id);
        }
        return new Dependencies(3, ctrl, null, dpUses, null, null, null, null, null, null);
    }

    public Dependencies getExprConditionReferenceSet(String key) {
        HashSet<String> pSIUses = new HashSet<String>();
        Iterator psit = this.pd_.getExperimentKeys();
        while (psit.hasNext()) {
            String psiKey = (String)psit.next();
            Experiment psi = this.pd_.getExperiment(psiKey);
            String condKey = psi.getConditionKey();
            if (!condKey.equals(key)) continue;
            pSIUses.add(psi.getID());
        }
        HashSet<String> dpUses = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!pSIUses.contains(pdp.getExperimentKey())) continue;
            dpUses.add(pdp.getID());
        }
        return new Dependencies(0, null, null, dpUses, pSIUses, null, null, null, null, null);
    }

    public Dependencies getExprConditionMergeSet(Set ecIDs, String commonKey) {
        HashSet<String> expUsed = new HashSet<String>();
        Iterator psit = this.pd_.getExperimentKeys();
        while (psit.hasNext()) {
            String psiKey = (String)psit.next();
            Experiment psi = this.pd_.getExperiment(psiKey);
            if (!ecIDs.contains(psi.getConditionKey())) continue;
            expUsed.add(psiKey);
        }
        return new Dependencies(10, commonKey, new HashSet(ecIDs), null, expUsed, null, null, null, null, null);
    }

    public Dependencies getMeasureReferenceSet(String meaID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!pdp.getMeasurementTypeKey().equals(meaID)) continue;
            retval.add(pdp.getID());
        }
        return new Dependencies(0, null, null, retval, null, null, null, null, null, null);
    }

    public Dependencies getMeasScaleReferenceSet(String scaleID) {
        HashSet<String> mUsed = new HashSet<String>();
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        Iterator mkit = md.getKeys();
        while (mkit.hasNext()) {
            String mkey = (String)mkit.next();
            MeasureProps mp = md.getMeasureProps(mkey);
            if (!mp.getScaleKey().equals(scaleID)) continue;
            mUsed.add(mkey);
        }
        HashSet<String> dpUsed = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!mUsed.contains(pdp.getMeasurementTypeKey())) continue;
            dpUsed.add(pdp.getID());
        }
        return new Dependencies(0, null, null, dpUsed, null, null, mUsed, null, null, null);
    }

    public Map getAllPertPropReferenceCounts() {
        HashMap retval = new HashMap();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            Experiment exp = pdp.getExperiment(this.pd_);
            PertSources ps = exp.getSources();
            Iterator psit = ps.getSources();
            while (psit.hasNext()) {
                String psdKey = (String)psit.next();
                PertSource chk = this.pd_.getSourceDef(psdKey);
                DataUtil.bumpCountMap(retval, chk.getExpTypeKey());
            }
        }
        TimeCourseData tcd = Database.getDB().getTimeCourseData();
        Map psd = tcd.getPertSourceDependencies();
        Iterator tcit = psd.keySet().iterator();
        while (tcit.hasNext()) {
            String psdKey = (String)tcit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            String typeKey = chk.getExpTypeKey();
            Set forKey = (Set)psd.get(psdKey);
            int fks = forKey.size();
            for (int i = 0; i < fks; ++i) {
                DataUtil.bumpCountMap(retval, typeKey);
            }
        }
        HashMap retvalClone = (HashMap)retval.clone();
        Iterator ekit = this.pd_.getExperimentKeys();
        while (ekit.hasNext()) {
            String eKey = (String)ekit.next();
            Experiment exp = this.pd_.getExperiment(eKey);
            PertSources ps = exp.getSources();
            Iterator psit = ps.getSources();
            while (psit.hasNext()) {
                String psdKey = (String)psit.next();
                PertSource chk = this.pd_.getSourceDef(psdKey);
                String typeKey = chk.getExpTypeKey();
                if (retvalClone.get(typeKey) != null) continue;
                DataUtil.bumpCountMap(retval, typeKey);
            }
        }
        retvalClone = (HashMap)retval.clone();
        Iterator sdit = this.pd_.getSourceDefKeys();
        while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            String typeKey = chk.getExpTypeKey();
            if (retvalClone.get(typeKey) != null) continue;
            DataUtil.bumpCountMap(retval, typeKey);
        }
        return retval;
    }

    public Map getAllMeasureScaleReferenceCounts(boolean primaryOnly) {
        MeasureProps mp;
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        HashMap retval = new HashMap();
        if (!primaryOnly) {
            Iterator dpit = this.pd_.getDataPoints();
            while (dpit.hasNext()) {
                PertDataPoint pdp = (PertDataPoint)dpit.next();
                String mType = pdp.getMeasurementTypeKey();
                mp = md.getMeasureProps(mType);
                DataUtil.bumpCountMap(retval, mp.getScaleKey());
            }
        }
        HashMap retvalClone = primaryOnly ? null : (HashMap)retval.clone();
        Iterator mkit = md.getKeys();
        while (mkit.hasNext()) {
            String mKey = (String)mkit.next();
            mp = md.getMeasureProps(mKey);
            String scaleKey = mp.getScaleKey();
            if (!primaryOnly && retvalClone.get(scaleKey) != null) continue;
            DataUtil.bumpCountMap(retval, scaleKey);
        }
        return retval;
    }

    public Dependencies getMeasureScaleMergeSet(Set msIDs, String commonKey) {
        HashSet<String> mUsed = new HashSet<String>();
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        Iterator mkit = md.getKeys();
        while (mkit.hasNext()) {
            String mkey = (String)mkit.next();
            MeasureProps mp = md.getMeasureProps(mkey);
            if (!msIDs.contains(mp.getScaleKey())) continue;
            mUsed.add(mkey);
        }
        return new Dependencies(8, commonKey, new HashSet(msIDs), null, null, null, mUsed, null, null, null);
    }

    public Dependencies getMeasurePropMergeSet(Set mpIDs, String commonKey) {
        HashSet<String> dpUsed = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!mpIDs.contains(pdp.getMeasurementTypeKey())) continue;
            dpUsed.add(pdp.getID());
        }
        return new Dependencies(11, commonKey, new HashSet(mpIDs), dpUsed, null, null, null, null, null, null);
    }

    public Dependencies getPertPropMergeSet(Set ppIDs, String commonKey) {
        HashSet<String> pPUses = new HashSet<String>();
        Iterator sdit = this.pd_.getSourceDefKeys();
        while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            String tkey = chk.getExpTypeKey();
            if (!ppIDs.contains(tkey)) continue;
            pPUses.add(psdKey);
        }
        TimeCourseData tcd = Database.getDB().getTimeCourseData();
        Map psmd = tcd.getPertSourceMergeDependencies(pPUses);
        return new Dependencies(14, commonKey, new HashSet(ppIDs), null, null, pPUses, null, null, null, psmd);
    }

    public Map getAllMeasurePropReferenceCounts() {
        HashMap retval = new HashMap();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            DataUtil.bumpCountMap(retval, pdp.getMeasurementTypeKey());
        }
        return retval;
    }

    public Dependencies getPertTypeReferenceSets(String pertTypeID) {
        HashSet<String> pSUses = new HashSet<String>();
        Iterator sdit = this.pd_.getSourceDefKeys();
        PertDictionary pDict = this.pd_.getPertDictionary();
        while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            PertProperties pp = chk.getExpType(pDict);
            if (!pp.getID().equals(pertTypeID)) continue;
            pSUses.add(chk.getID());
        }
        HashSet<String> pSIUses = new HashSet<String>();
        Iterator psit = this.pd_.getExperimentKeys();
        while (psit.hasNext()) {
            String psiKey = (String)psit.next();
            Experiment psi = this.pd_.getExperiment(psiKey);
            PertSources pss = psi.getSources();
            Iterator ppit = pss.getSources();
            while (ppit.hasNext()) {
                String srcID = (String)ppit.next();
                if (!pSUses.contains(srcID)) continue;
                pSIUses.add(psi.getID());
            }
        }
        HashSet<String> dpUses = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!pSIUses.contains(pdp.getExperimentKey())) continue;
            dpUses.add(pdp.getID());
        }
        HashSet<String> tcdUses = new HashSet<String>();
        TimeCourseData tcd = Database.getDB().getTimeCourseData();
        Map psd = tcd.getPertSourceDependencies();
        Iterator psuit = pSUses.iterator();
        while (psuit.hasNext()) {
            String psID = (String)psuit.next();
            Set forPsID = (Set)psd.get(psID);
            if (forPsID == null) continue;
            tcdUses.add(psID);
        }
        return new Dependencies(0, null, null, dpUses, pSIUses, pSUses, null, null, tcdUses, null);
    }

    public Dependencies getTargetReferenceSet(String targID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!pdp.getTargetKey().equals(targID)) continue;
            retval.add(pdp.getID());
        }
        return new Dependencies(0, null, null, retval, null, null, null, null, null, null);
    }

    public Dependencies getTargetMergeSet(Set targIDs, String commonKey) {
        HashSet<String> retval = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!targIDs.contains(pdp.getTargetKey())) continue;
            retval.add(pdp.getID());
        }
        return new Dependencies(4, commonKey, new HashSet(targIDs), retval, null, null, null, null, null, null);
    }

    public Dependencies getExprControlMergeSet(Set ctrlIDs, String commonKey) {
        HashSet<String> retval = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!ctrlIDs.contains(pdp.getControl())) continue;
            retval.add(pdp.getID());
        }
        return new Dependencies(7, commonKey, new HashSet(ctrlIDs), retval, null, null, null, null, null, null);
    }

    public int getTargetReferenceCount(String targID) {
        Dependencies dep = this.getTargetReferenceSet(targID);
        return dep.dataPoints.size();
    }

    public Map getAllTargetReferenceCounts() {
        HashMap retval = new HashMap();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            String targKey = pdp.getTargetKey();
            DataUtil.bumpCountMap(retval, targKey);
        }
        return retval;
    }

    public Dependencies getSourceDefReferenceSets(String sourceDefID) {
        HashSet<String> pSInfoUses = new HashSet<String>();
        Iterator psit = this.pd_.getExperimentKeys();
        block0: while (psit.hasNext()) {
            String psiKey = (String)psit.next();
            Experiment psi = this.pd_.getExperiment(psiKey);
            PertSources pss = psi.getSources();
            Iterator pssit = pss.getSources();
            while (pssit.hasNext()) {
                String psid = (String)pssit.next();
                if (!psid.equals(sourceDefID)) continue;
                pSInfoUses.add(psi.getID());
                continue block0;
            }
        }
        HashSet<String> dpUses = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!pSInfoUses.contains(pdp.getExperimentKey())) continue;
            dpUses.add(pdp.getID());
        }
        HashSet<String> tcdUses = new HashSet<String>();
        TimeCourseData tcd = Database.getDB().getTimeCourseData();
        Map psd = tcd.getPertSourceDependencies();
        Set forKey = (Set)psd.get(sourceDefID);
        if (forKey != null) {
            tcdUses.add(sourceDefID);
        }
        return new Dependencies(0, null, null, dpUses, pSInfoUses, null, null, null, tcdUses, null);
    }

    public Set getMultiSourceDefCollapseMergeSet(Set sdIDs, String commonKey) {
        HashSet<String> sdUsed = new HashSet<String>();
        Iterator psit = this.pd_.getExperimentKeys();
        while (psit.hasNext()) {
            String psiKey = (String)psit.next();
            Experiment psi = this.pd_.getExperiment(psiKey);
            PertSources pss = psi.getSources();
            Iterator pssit = pss.getSources();
            int numDups = 0;
            while (pssit.hasNext()) {
                String psid = (String)pssit.next();
                if (!sdIDs.contains(psid)) continue;
                ++numDups;
            }
            if (numDups <= true) continue;
            sdUsed.add(psi.getID());
        }
        return sdUsed;
    }

    public Dependencies getSourceDefMergeSet(Set sdIDs, String commonKey) {
        HashSet<String> sdUsed = new HashSet<String>();
        Iterator psit = this.pd_.getExperimentKeys();
        block0: while (psit.hasNext()) {
            String psiKey = (String)psit.next();
            Experiment psi = this.pd_.getExperiment(psiKey);
            PertSources pss = psi.getSources();
            Iterator pssit = pss.getSources();
            while (pssit.hasNext()) {
                String psid = (String)pssit.next();
                if (!sdIDs.contains(psid)) continue;
                sdUsed.add(psi.getID());
                continue block0;
            }
        }
        TimeCourseData tcd = Database.getDB().getTimeCourseData();
        Map psmd = tcd.getPertSourceMergeDependencies(sdIDs);
        return new Dependencies(12, commonKey, new HashSet(sdIDs), null, sdUsed, null, null, null, null, psmd);
    }

    public Dependencies getSourceNameMergeSet(Set srcIDs, String commonKey) {
        HashSet<String> pSUses = new HashSet<String>();
        Iterator sdit = this.pd_.getSourceDefKeys();
        while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            if (chk.isAProxy() && srcIDs.contains(chk.getProxiedSpeciesKey())) {
                pSUses.add(chk.getID());
            }
            if (!srcIDs.contains(chk.getSourceNameKey())) continue;
            pSUses.add(chk.getID());
        }
        TimeCourseData tcd = Database.getDB().getTimeCourseData();
        Map psmd = tcd.getPertSourceMergeDependencies(pSUses);
        return new Dependencies(5, commonKey, new HashSet(srcIDs), null, null, pSUses, null, null, null, psmd);
    }

    public Dependencies getSourceNameReferenceSets(String sourceNameID) {
        HashSet<String> pSUses = new HashSet<String>();
        Iterator sdit = this.pd_.getSourceDefKeys();
        while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            if (chk.isAProxy() && chk.getProxiedSpeciesKey().equals(sourceNameID)) {
                pSUses.add(chk.getID());
            }
            if (!chk.getSourceNameKey().equals(sourceNameID)) continue;
            pSUses.add(chk.getID());
        }
        HashSet<String> pSInfoUses = new HashSet<String>();
        Iterator psit = this.pd_.getExperimentKeys();
        block1: while (psit.hasNext()) {
            String psiKey = (String)psit.next();
            Experiment psi = this.pd_.getExperiment(psiKey);
            PertSources pss = psi.getSources();
            Iterator pssit = pss.getSources();
            while (pssit.hasNext()) {
                String psid = (String)pssit.next();
                if (!pSUses.contains(psid)) continue;
                pSInfoUses.add(psi.getID());
                continue block1;
            }
        }
        HashSet<String> dpUses = new HashSet<String>();
        Iterator dpit = this.pd_.getDataPoints();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (!pSInfoUses.contains(pdp.getExperimentKey())) continue;
            dpUses.add(pdp.getID());
        }
        HashSet<String> tcdUses = new HashSet<String>();
        TimeCourseData tcd = Database.getDB().getTimeCourseData();
        Map psd = tcd.getPertSourceDependencies();
        Iterator psuit = pSUses.iterator();
        while (psuit.hasNext()) {
            String psID = (String)psuit.next();
            Set forPsID = (Set)psd.get(psID);
            if (forPsID == null) continue;
            tcdUses.add(psID);
        }
        return new Dependencies(0, null, null, dpUses, pSInfoUses, pSUses, null, null, tcdUses, null);
    }

    public int getSourceNameReferenceCount(String srcID) {
        Dependencies dep = this.getSourceNameReferenceSets(srcID);
        return dep.dataPoints.size() + dep.experiments.size() + dep.pertSources.size() + dep.timeCourseRefs.size();
    }

    public Map getAllSourceNameReferenceCounts(boolean primaryOnly) {
        HashMap retval = new HashMap();
        if (!primaryOnly) {
            Iterator dpit = this.pd_.getDataPoints();
            while (dpit.hasNext()) {
                PertDataPoint pdp = (PertDataPoint)dpit.next();
                Experiment exp = pdp.getExperiment(this.pd_);
                PertSources ps = exp.getSources();
                Iterator psit = ps.getSources();
                while (psit.hasNext()) {
                    String psdKey = (String)psit.next();
                    PertSource chk = this.pd_.getSourceDef(psdKey);
                    if (chk.isAProxy()) {
                        String proxKey = chk.getProxiedSpeciesKey();
                        DataUtil.bumpCountMap(retval, proxKey);
                    }
                    DataUtil.bumpCountMap(retval, chk.getSourceNameKey());
                }
            }
            TimeCourseData tcd = Database.getDB().getTimeCourseData();
            Map psd = tcd.getPertSourceDependencies();
            Iterator tcit = psd.keySet().iterator();
            while (tcit.hasNext()) {
                String psdKey = (String)tcit.next();
                Set forKey = (Set)psd.get(psdKey);
                int fks = forKey.size();
                for (int i = 0; i < fks; ++i) {
                    DataUtil.bumpCountMap(retval, psdKey);
                }
            }
        }
        HashMap retvalClone = primaryOnly ? null : (HashMap)retval.clone();
        Iterator sdit = this.pd_.getSourceDefKeys();
        while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = this.pd_.getSourceDef(psdKey);
            if (chk.isAProxy()) {
                String proxKey = chk.getProxiedSpeciesKey();
                if (primaryOnly || retvalClone.get(proxKey) == null) {
                    DataUtil.bumpCountMap(retval, proxKey);
                }
            }
            String srcKey = chk.getSourceNameKey();
            if (!primaryOnly && retvalClone.get(srcKey) != null) continue;
            DataUtil.bumpCountMap(retval, srcKey);
        }
        return retval;
    }

    public boolean mergeDependencies(Dependencies refs, UndoSupport support) {
        if (refs.type == 4) {
            if (refs.dataPoints != null && refs.dataPoints.size() > 0) {
                PertDataChange pdc = this.pd_.mergeDataPointTargetRefs(refs.dataPoints, refs.useKey);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 7) {
            if (refs.dataPoints != null && refs.dataPoints.size() > 0) {
                PertDataChange pdc = this.pd_.mergeDataPointControlRefs(refs.dataPoints, refs.useKey);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 5) {
            if (refs.timeCourseMergeRefs != null && refs.timeCourseMergeRefs.size() > 0) {
                TimeCourseData tcd = Database.getDB().getTimeCourseData();
                TimeCourseChange[] tcca = tcd.dropPertSourceMergeIssues(refs.timeCourseMergeRefs);
                for (int j = 0; j < tcca.length; ++j) {
                    support.addEdit(new TimeCourseChangeCmd(tcca[j]));
                }
            }
            if (refs.pertSources != null && refs.pertSources.size() > 0) {
                PertDataChange pdc = this.pd_.mergePertSourceNameRefs(refs.pertSources, refs.useKey, refs.abandonKeys);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 6) {
            if (refs.experiments != null && refs.experiments.size() > 0) {
                PertDataChange pdc = this.pd_.mergeInvestigatorRefs(refs.experiments, refs.useKey, refs.abandonKeys);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 8) {
            if (refs.measureProps != null && refs.measureProps.size() > 0) {
                PertDataChange pdc = this.pd_.mergeMeasureScaleRefs(refs.measureProps, refs.useKey);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 11) {
            if (refs.dataPoints != null && refs.dataPoints.size() > 0) {
                PertDataChange pdc = this.pd_.mergeMeasurePropRefs(refs.dataPoints, refs.useKey);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 14) {
            if (refs.timeCourseMergeRefs != null && refs.timeCourseMergeRefs.size() > 0) {
                TimeCourseData tcd = Database.getDB().getTimeCourseData();
                TimeCourseChange[] tcca = tcd.dropPertSourceMergeIssues(refs.timeCourseMergeRefs);
                for (int j = 0; j < tcca.length; ++j) {
                    support.addEdit(new TimeCourseChangeCmd(tcca[j]));
                }
            }
            if (refs.pertSources != null && refs.pertSources.size() > 0) {
                PertDataChange pdc = this.pd_.mergePertPropRefs(refs.pertSources, refs.useKey);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 12) {
            if (refs.timeCourseMergeRefs != null && refs.timeCourseMergeRefs.size() > 0) {
                TimeCourseData tcd = Database.getDB().getTimeCourseData();
                TimeCourseChange[] tcca = tcd.dropPertSourceMergeIssues(refs.timeCourseMergeRefs);
                for (int j = 0; j < tcca.length; ++j) {
                    support.addEdit(new TimeCourseChangeCmd(tcca[j]));
                }
            }
            if (refs.experiments != null && refs.experiments.size() > 0) {
                PertDataChange pdc = this.pd_.mergeSourceDefRefs(refs.experiments, refs.useKey, refs.abandonKeys);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 13) {
            if (refs.dataPoints != null && refs.dataPoints.size() > 0) {
                PertDataChange pdc = this.pd_.mergeExperimentRefs(refs.dataPoints, refs.useKey, refs.abandonKeys);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 9) {
            PertDataChange pdc;
            if (refs.dataPoints != null && refs.dataPoints.size() > 0) {
                pdc = this.pd_.mergeDataPointAnnotRefs(refs.dataPoints, refs.useKey, refs.abandonKeys);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
            if (refs.pertSources != null && refs.pertSources.size() > 0) {
                pdc = this.pd_.mergeSourceDefAnnotRefs(refs.pertSources, refs.useKey, refs.abandonKeys);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
            if (refs.targets != null && refs.targets.size() > 0) {
                pdc = this.pd_.mergeTargetAnnotRefs(refs.targets, refs.useKey, refs.abandonKeys);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 10) {
            if (refs.experiments != null && refs.experiments.size() > 0) {
                PertDataChange pdc = this.pd_.mergeExperimentCondRefs(refs.experiments, refs.useKey, refs.abandonKeys);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public boolean killOffDependencies(Dependencies refs, UndoSupport support) {
        if (refs.type == 0) {
            PertDataChange[] pdc;
            if (refs.timeCourseRefs != null && refs.timeCourseRefs.size() > 0) {
                TimeCourseData tcd = Database.getDB().getTimeCourseData();
                Iterator tcrit = refs.timeCourseRefs.iterator();
                while (tcrit.hasNext()) {
                    String key = (String)tcrit.next();
                    TimeCourseChange[] tcca = tcd.dropPertSourceDependencies(key);
                    for (int j = 0; j < tcca.length; ++j) {
                        support.addEdit(new TimeCourseChangeCmd(tcca[j]));
                    }
                }
            }
            if (refs.dataPoints != null && refs.dataPoints.size() > 0) {
                pdc = this.pd_.deleteDataPoints(refs.dataPoints);
                support.addEdit(new PertDataChangeCmd((PertDataChange)pdc));
            }
            if (refs.experiments != null && refs.experiments.size() > 0) {
                pdc = this.pd_.deleteExperiments(refs.experiments);
                support.addEdit(new PertDataChangeCmd((PertDataChange)pdc));
            }
            if (refs.pertSources != null && refs.pertSources.size() > 0) {
                pdc = this.pd_.deletePertSourceDefs(refs.pertSources);
                for (int j = 0; j < pdc.length; ++j) {
                    support.addEdit(new PertDataChangeCmd(pdc[j]));
                }
            }
            if (refs.measureProps != null && refs.measureProps.size() > 0) {
                Iterator mpit = refs.measureProps.iterator();
                while (mpit.hasNext()) {
                    String key = (String)mpit.next();
                    PertDataChange pdc2 = this.pd_.deleteMeasureProp(key);
                    support.addEdit(new PertDataChangeCmd(pdc2));
                }
            }
        } else if (refs.type == 1) {
            if (refs.experiments != null && refs.experiments.size() > 0) {
                PertDataChange pdc = this.pd_.dropInvestigator(refs.useKey, refs.experiments);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 2) {
            PertDataChange pdc;
            if (refs.dataPoints != null && refs.dataPoints.size() > 0 && (pdc = this.pd_.dropDataPointAnnotations(refs.useKey, refs.dataPoints)) != null) {
                support.addEdit(new PertDataChangeCmd(pdc));
            }
            if (refs.pertSources != null && refs.pertSources.size() > 0) {
                pdc = this.pd_.dropSourceDefAnnotations(refs.useKey, refs.pertSources);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
            if (refs.targets != null && refs.targets.size() > 0) {
                pdc = this.pd_.dropTargetAnnotations(refs.useKey, refs.targets);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else if (refs.type == 3) {
            PertDataChange pdc;
            if (refs.dataPoints != null && refs.dataPoints.size() > 0 && (pdc = this.pd_.dropDataPointControls(refs.useKey, refs.dataPoints)) != null) {
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public static class Dependencies {
        public static final int DESTROY = 0;
        public static final int PRUNE_INVEST = 1;
        public static final int PRUNE_ANNOT = 2;
        public static final int PRUNE_CONTROL = 3;
        public static final int MERGE_TARGETS = 4;
        public static final int MERGE_SOURCE_NAMES = 5;
        public static final int MERGE_INVEST = 6;
        public static final int MERGE_CONTROLS = 7;
        public static final int MERGE_MEASURE_SCALES = 8;
        public static final int MERGE_ANNOT = 9;
        public static final int MERGE_EXPR_COND = 10;
        public static final int MERGE_MEASURE_PROPS = 11;
        public static final int MERGE_SOURCE_DEFS = 12;
        public static final int MERGE_EXPERIMENTS = 13;
        public static final int MERGE_PERT_PROPS = 14;
        public Set dataPoints;
        public Set experiments;
        public Set pertSources;
        public Set measureProps;
        public Set targets;
        public int type;
        public String useKey;
        public Set abandonKeys;
        public Set timeCourseRefs;
        public Map timeCourseMergeRefs;

        Dependencies(int type, String useKey, Set abandonKeys, Set dataPoints, Set experiments, Set pertSources, Set measureProps, Set targets, Set timeCourseRefs, Map timeCourseMergeRefs) {
            this.type = type;
            this.useKey = useKey;
            this.dataPoints = dataPoints;
            this.experiments = experiments;
            this.pertSources = pertSources;
            this.measureProps = measureProps;
            this.abandonKeys = abandonKeys;
            this.targets = targets;
            this.timeCourseRefs = timeCourseRefs;
            this.timeCourseMergeRefs = timeCourseMergeRefs;
        }
    }
}

