/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterTarget;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.perturb.SourceSrc;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.DoubMinMax;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.Splitter;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.xml.sax.Attributes;

public class Experiment
implements Cloneable,
PertFilterTarget {
    public static final int NO_TIME = -1;
    private String id_;
    private PertSources sources_;
    private int time_;
    private String conditionKey_;
    private int legacyMaxTime_;
    private ArrayList invest_;

    public Experiment(String id, PertSources sources, int time, List investigators, String condKey) {
        this.id_ = id;
        this.sources_ = sources;
        this.time_ = time;
        this.legacyMaxTime_ = -1;
        this.conditionKey_ = condKey;
        this.invest_ = investigators == null ? new ArrayList() : new ArrayList(investigators);
    }

    public Experiment(String id, int time, int legacyMaxTime, String condKey) {
        this.id_ = id;
        this.sources_ = new PertSources();
        this.time_ = time;
        this.legacyMaxTime_ = legacyMaxTime;
        this.conditionKey_ = condKey;
        this.invest_ = new ArrayList();
    }

    public int getSign(SourceSrc ss) {
        if (!this.sources_.isSinglePert()) {
            return 4;
        }
        PertSource src = this.sources_.getSource(0, ss);
        return src.getSign(ss);
    }

    public int resolveLinkSign(double value, Double unchanged, SourceSrc ss) {
        if (!this.sources_.isSinglePert() || unchanged == null) {
            return 0;
        }
        PertSource src = this.sources_.getSource(0, ss);
        PertDictionary pDict = ss.getPertDictionary();
        PertProperties pprops = src.getExpType(pDict);
        if (src.isAProxy()) {
            return pprops.resolveWithProxy(src.getProxySign(), value, unchanged);
        }
        return pprops.resolve(value, unchanged);
    }

    public DoubMinMax getThresholds(String measureTypeKey, SourceSrc ss) {
        MeasureDictionary mDict = ss.getMeasureDictionary();
        MeasureProps mProps = mDict.getMeasureProps(measureTypeKey);
        DoubMinMax retval = new DoubMinMax(mProps.getNegThresh(), mProps.getPosThresh());
        return retval;
    }

    public String getConditionKey() {
        return this.conditionKey_;
    }

    public void setConditionKey(String coKey) {
        this.conditionKey_ = coKey;
    }

    public void setSources(PertSources pss) {
        this.sources_ = pss;
    }

    public void addToExperimentSet(Set sourceInfos, SourceSrc ss) {
        sourceInfos.add(this.getChoiceContent(ss));
    }

    public TrueObjChoiceContent getChoiceContent(SourceSrc ss) {
        String ds = this.getDisplayString(ss);
        return new TrueObjChoiceContent(ds, this.id_);
    }

    public String getDisplayString(SourceSrc ss) {
        String perts = this.getPertDisplayString(ss, 2);
        String times = this.getTimeDisplayString(true, true);
        String invest = this.getInvestigatorDisplayString(ss);
        String ds = Experiment.getDisplayString(perts, times, invest);
        return ds;
    }

    public void addToSourceSet(Set sources, SourceSrc ss) {
        this.sources_.addToSourceSet(sources, ss);
    }

    public void addToSourceNameSet(Set sources, SourceSrc ss, boolean orProxy) {
        this.sources_.addToSourceNameSet(sources, ss, orProxy);
    }

    public void addToPertSet(Set pertTypes, SourceSrc ss, PertDictionary pDict) {
        this.sources_.addToPertSet(pertTypes, ss, pDict);
    }

    public PertSources getSources() {
        return this.sources_;
    }

    public void deleteSource(int i) {
        this.sources_.deleteSource(i);
    }

    public void addSource(PertSource ps) {
        this.sources_.addSource(ps);
    }

    public PertSource getSource(int i, SourceSrc ss) {
        return this.sources_.getSource(i, ss);
    }

    public void setID(String id) {
        this.id_ = id;
    }

    public String getID() {
        return this.id_;
    }

    public Object clone() {
        try {
            Experiment newVal = (Experiment)super.clone();
            newVal.sources_ = (PertSources)this.sources_.clone();
            newVal.invest_ = (ArrayList)this.invest_.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int hashCode() {
        return this.id_.hashCode() + this.sources_.hashCode() + this.time_ + this.legacyMaxTime_ + this.invest_.hashCode();
    }

    public boolean equals(Object other) {
        if (!this.equalsMinusID(other)) {
            return false;
        }
        Experiment otherPI = (Experiment)other;
        return this.id_.equals(otherPI.id_);
    }

    public boolean equalsMinusID(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Experiment)) {
            return false;
        }
        Experiment otherPI = (Experiment)other;
        if (this.time_ != otherPI.time_) {
            return false;
        }
        if (this.legacyMaxTime_ != otherPI.legacyMaxTime_) {
            return false;
        }
        if (!this.sources_.equals(otherPI.sources_)) {
            return false;
        }
        return this.invest_.equals(otherPI.invest_);
    }

    public boolean matchesFilter(PertFilter pf, SourceSrc ss) {
        switch (pf.getCategory()) {
            case 0: {
                return pf.getStringValue().equals(this.id_);
            }
            case 11: {
                return pf.getStringValue().equals(this.conditionKey_);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                return this.sources_.matchesFilter(pf, ss);
            }
            case 5: {
                return true;
            }
            case 6: {
                MinMax filterTimes = pf.getIntRangeValue();
                return this.timeRangeMatches(pf.getMatchType(), filterTimes);
            }
            case 8: {
                String filterInvest = pf.getStringValue();
                int numI = this.invest_.size();
                for (int i = 0; i < numI; ++i) {
                    String investKey = (String)this.invest_.get(i);
                    if (!filterInvest.equals(investKey)) continue;
                    return true;
                }
                return false;
            }
            case 9: {
                String filterInvest = pf.getStringValue();
                return filterInvest.equals(this.getInvestigatorDisplayString(ss));
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean timeRangeMatches(int matchType, MinMax filterTimes) {
        int min = this.time_;
        int max = this.legacyMaxTime_ != -1 ? this.legacyMaxTime_ : min;
        MinMax mm = new MinMax(min, max);
        if (matchType == 7) {
            return mm.equals(filterTimes);
        }
        if (matchType == 8) {
            return mm.intersect(filterTimes) != null;
        }
        throw new IllegalArgumentException();
    }

    public boolean isSinglePerturbation() {
        return this.sources_.isSinglePert();
    }

    public boolean sourceMatch(List skeys) {
        return this.sources_.sourcesMatch(skeys);
    }

    public boolean timeMatches(int time) {
        if (this.legacyMaxTime_ == -1) {
            return time == this.time_;
        }
        return time >= this.time_ && time <= this.legacyMaxTime_;
    }

    public void setTime(int time) {
        this.time_ = time;
    }

    public void setLegacyMaxTime(int maxTime) {
        this.legacyMaxTime_ = maxTime;
    }

    public void setInvestigators(List invest) {
        this.invest_.clear();
        this.invest_.addAll(invest);
    }

    public void addInvestigator(String invest) {
        this.invest_.add(invest);
    }

    public int getTime() {
        return this.time_;
    }

    public MinMax getTimeRange() {
        int minTime = this.time_;
        int maxTime = this.legacyMaxTime_ == -1 ? this.time_ : this.legacyMaxTime_;
        return new MinMax(minTime, maxTime);
    }

    public int getLegacyMaxTime() {
        return this.legacyMaxTime_;
    }

    public List getInvestigators() {
        return this.invest_;
    }

    public void deleteInvestigator(int i) {
        this.invest_.remove(i);
    }

    public void deleteInvestigator(String key) {
        this.invest_.remove(key);
    }

    public void replaceInvestigator(int i, String invest) {
        this.invest_.set(i, invest);
    }

    public String getInvestigatorDisplayString(SourceSrc ss) {
        ArrayList<String> asNames = new ArrayList<String>();
        int numSrc = this.invest_.size();
        for (int i = 0; i < numSrc; ++i) {
            String investKey = (String)this.invest_.get(i);
            String invest = ss.getInvestigator(investKey);
            asNames.add(invest);
        }
        return DataUtil.getMultiDisplayString(asNames);
    }

    public SortedSet getInvestigatorSortedSet(SourceSrc ss, boolean normalized) {
        TreeSet<String> retval = new TreeSet<String>();
        int numInv = this.invest_.size();
        for (int i = 0; i < numInv; ++i) {
            String investKey = (String)this.invest_.get(i);
            String invest = ss.getInvestigator(investKey);
            if (normalized) {
                invest = DataUtil.normKey(invest);
            }
            retval.add(invest);
        }
        return retval;
    }

    public String getCondsDisplayString(SourceSrc ss) {
        return ss.getConditionDictionary().getExprConditions(this.conditionKey_).getDisplayString();
    }

    public String getPertDisplayString(SourceSrc ss, int footnoteMode) {
        return this.sources_.getDisplayString(ss, footnoteMode);
    }

    public SortedSet getPerturbsSortedSet(SourceSrc ss, boolean normalized) {
        return this.sources_.getPerturbsSortedSet(ss, normalized);
    }

    public String getTimeDisplayString(boolean showUnits, boolean abbreviate) {
        return Experiment.getTimeDisplayString(this.getTimeRange(), showUnits, abbreviate);
    }

    public void getAnnotationIDs(Set usedIDs, SourceSrc ss) {
        this.sources_.getAnnotationIDs(usedIDs, ss);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<experiment id=\"");
        out.print(this.id_);
        out.print("\"");
        if (this.time_ != -1) {
            out.print(" time=\"");
            out.print(this.time_);
            out.print("\"");
        }
        if (this.legacyMaxTime_ != -1) {
            out.print(" legMax=\"");
            out.print(this.legacyMaxTime_);
            out.print("\"");
        }
        out.print(" cond=\"");
        out.print(this.conditionKey_);
        out.print("\"");
        out.print(" srcs=\"");
        out.print(this.sources_.sourcesAsString());
        out.print("\"");
        int numInvest = this.invest_.size();
        if (numInvest != 0) {
            out.print(" invests=\"");
            out.print(Splitter.tokenJoin(this.invest_, ","));
            out.print("\"");
        }
        out.println("/>");
    }

    public static String getDisplayString(String perts, String times, String invest) {
        StringBuffer buf = new StringBuffer();
        buf.append(perts);
        buf.append(" @ ");
        buf.append(times);
        if (!invest.trim().equals("")) {
            buf.append(" (");
            buf.append(invest);
            buf.append(")");
        }
        return buf.toString();
    }

    public static String getTimeDisplayString(MinMax mm, boolean showUnits, boolean abbreviate) {
        if (mm == null) {
            return "";
        }
        String td = PerturbationData.getTimeDisplay(new Integer(mm.min), showUnits, abbreviate);
        if (mm.max == mm.min) {
            return td;
        }
        String ltd = PerturbationData.getTimeDisplay(new Integer(mm.max), showUnits, abbreviate);
        return td + " to " + ltd;
    }

    public String toString() {
        return "Experiment: perturbs = " + this.sources_.toString() + " time = " + this.time_ + " invest = " + this.invest_;
    }

    public static class PertSourcesInfoWorker
    extends AbstractFactoryClient {
        public PertSourcesInfoWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("experiment");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Experiment retval = null;
            if (elemName.equals("experiment")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.pertSrcInfo = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private Experiment buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "experiment", "id", true);
            String time = AttributeExtractor.extractAttribute(elemName, attrs, "experiment", "time", false);
            String legMax = AttributeExtractor.extractAttribute(elemName, attrs, "experiment", "legMax", false);
            String cond = AttributeExtractor.extractAttribute(elemName, attrs, "experiment", "cond", true);
            String srcs = AttributeExtractor.extractAttribute(elemName, attrs, "experiment", "srcs", true);
            String invests = AttributeExtractor.extractAttribute(elemName, attrs, "experiment", "invests", false);
            if (id == null) {
                throw new IOException();
            }
            int timeNum = -1;
            int legMaxNum = -1;
            try {
                if (time != null) {
                    timeNum = Integer.parseInt(time);
                }
                if (legMax != null) {
                    legMaxNum = Integer.parseInt(legMax);
                }
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            Experiment retval = new Experiment(id, timeNum, legMaxNum, cond);
            PertSources pss = new PertSources();
            ArrayList srcList = Splitter.stringBreak(srcs, ",", 0, false);
            int numSrc = srcList.size();
            for (int i = 0; i < numSrc; ++i) {
                String srcID = (String)srcList.get(i);
                pss.addSourceID(srcID);
            }
            retval.setSources(pss);
            if (invests != null) {
                ArrayList invList = Splitter.stringBreak(invests, ",", 0, false);
                int numI = invList.size();
                for (int i = 0; i < numI; ++i) {
                    String invID = (String)invList.get(i);
                    retval.addInvestigator(invID);
                }
            }
            return retval;
        }
    }
}

