/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class ExperimentConditions
implements Cloneable {
    private String id_;
    private String conditionDescription_;

    public ExperimentConditions(String id, String name) {
        this.id_ = id;
        this.conditionDescription_ = name;
    }

    public String getID() {
        return this.id_;
    }

    public String getDescription() {
        return this.conditionDescription_;
    }

    public void setDescription(String conditionDescription) {
        this.conditionDescription_ = conditionDescription;
    }

    public String getDisplayString() {
        return this.conditionDescription_;
    }

    public Object clone() {
        try {
            ExperimentConditions newVal = (ExperimentConditions)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ExperimentConditions)) {
            return false;
        }
        ExperimentConditions otherEC = (ExperimentConditions)other;
        if (!this.id_.equals(otherEC.id_)) {
            return false;
        }
        return this.conditionDescription_.equals(otherEC.conditionDescription_);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<experimentCond id=\"");
        out.print(this.id_);
        out.print("\" desc=\"");
        out.print(CharacterEntityMapper.mapEntities(this.conditionDescription_, false));
        out.println("\"/>");
    }

    public String toString() {
        return "ExperimentConditions: " + this.id_ + " " + this.conditionDescription_;
    }

    public static class ExperimentCondWorker
    extends AbstractFactoryClient {
        public ExperimentCondWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("experimentCond");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            ExperimentConditions retval = null;
            if (elemName.equals("experimentCond")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.experCond = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private ExperimentConditions buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "experimentCond", "id", true);
            String descStr = AttributeExtractor.extractAttribute(elemName, attrs, "experimentCond", "desc", true);
            descStr = CharacterEntityMapper.unmapEntities(descStr, false);
            return new ExperimentConditions(id, descStr);
        }
    }
}

