/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class ExperimentControl
implements Cloneable {
    private String id_;
    private String description_;

    public ExperimentControl(String id, String name) {
        this.id_ = id;
        this.description_ = name;
    }

    public String getID() {
        return this.id_;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public String getDisplayString() {
        return this.description_;
    }

    public Object clone() {
        try {
            ExperimentControl newVal = (ExperimentControl)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<experimentControl id=\"");
        out.print(this.id_);
        out.print("\" desc=\"");
        out.print(CharacterEntityMapper.mapEntities(this.description_, false));
        out.println("\"/>");
    }

    public String toString() {
        return "ExperimentControl: " + this.id_ + " " + this.description_;
    }

    public static class ExperimentControlWorker
    extends AbstractFactoryClient {
        public ExperimentControlWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("experimentControl");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            ExperimentControl retval = null;
            if (elemName.equals("experimentControl")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.expControl = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private ExperimentControl buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "experimentControl", "id", true);
            String descStr = AttributeExtractor.extractAttribute(elemName, attrs, "experimentControl", "desc", true);
            descStr = CharacterEntityMapper.unmapEntities(descStr, false);
            return new ExperimentControl(id, descStr);
        }
    }
}

