/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.xml.sax.Attributes;

public class LegacyPert
implements Cloneable {
    public String oldValue;
    public boolean unknownMultiCount;

    public LegacyPert(String oldValue) {
        this.oldValue = oldValue;
        this.unknownMultiCount = false;
    }

    public LegacyPert(String oldValue, boolean unknownMultiCount) {
        this.oldValue = oldValue;
        this.unknownMultiCount = unknownMultiCount;
    }

    public Object clone() {
        try {
            LegacyPert newVal = (LegacyPert)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof LegacyPert)) {
            return false;
        }
        LegacyPert otherLP = (LegacyPert)other;
        if (!this.oldValue.equals(otherLP.oldValue)) {
            return false;
        }
        return this.unknownMultiCount == otherLP.unknownMultiCount;
    }

    public void writeXMLSupport(PrintWriter out) {
        out.print("legV=\"");
        out.print(this.oldValue);
        out.print("\"");
        if (this.unknownMultiCount) {
            out.print(" mulc=\"true\"");
        }
    }

    public static LegacyPert buildFromXMLSupport(String elemName, Attributes attrs) throws IOException {
        String legVal = AttributeExtractor.extractAttribute(elemName, attrs, elemName, "legV", false);
        String mulc = AttributeExtractor.extractAttribute(elemName, attrs, elemName, "mulc", false);
        if (legVal == null) {
            return null;
        }
        if (mulc != null) {
            boolean multiCount = Boolean.valueOf(mulc);
            return new LegacyPert(legVal, multiCount);
        }
        return new LegacyPert(legVal);
    }
}

