/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.plugin.InternalLinkDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class LinkPertDataDisplayPlugIn
implements InternalLinkDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        return true;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String linkID) {
        return null;
    }

    public String getDataAsHTML(String genomeID, String linkID) {
        String baseSourceID;
        String baseTargID;
        StringBuffer buf = new StringBuffer();
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeID);
        Linkage link = genome.getLinkage(linkID);
        String targID = link.getTarget();
        String sourceID = link.getSource();
        PerturbationData pd = db.getPertData();
        if (!pd.haveDataForNode(baseTargID = GenomeItemInstance.getBaseID(targID), baseSourceID = GenomeItemInstance.getBaseID(sourceID))) {
            return " ";
        }
        buf.append("<center><h1>");
        String desc = ResourceManager.getManager().getString("dataWindow.pertDataForLink");
        buf.append(desc);
        buf.append("</h1></center>\n");
        boolean largeFont = DisplayOptionsManager.getMgr().isForBigScreen();
        String table = pd.getHTML(baseTargID, baseSourceID, true, largeFont);
        if (table != null) {
            buf.append(table);
        } else {
            buf.append("<center>");
            buf.append(ResourceManager.getManager().getString("dataWindow.noPertDataForLink"));
            buf.append("</center>");
        }
        return buf.toString();
    }
}

