/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.util.BoundedDoubMinMax;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class MeasureDictionary
implements Cloneable {
    public static final int POS_FOLD_INDEX = 0;
    public static final int SIGNED_FOLD_INDEX = 1;
    public static final int DDCT_INDEX = 2;
    public static final int DEFAULT_INDEX = 0;
    private HashMap meas_ = new HashMap();
    private UniqueLabeller labels_;
    private String[] defaultScales_;
    private HashMap scales_ = new HashMap();

    public MeasureDictionary() {
        this.labels_ = new UniqueLabeller();
        this.defaultScales_ = this.createDefaultScale();
    }

    public boolean haveData() {
        return this.scales_.size() > this.defaultScales_.length || !this.meas_.isEmpty();
    }

    public String getNextDataKey() {
        return this.labels_.getNextLabel();
    }

    public String[] getStandardScaleKeys() {
        return this.defaultScales_;
    }

    private String[] createDefaultScale() {
        String[] retval = new String[3];
        retval[1] = this.labels_.getNextLabel();
        MeasureScale.Conversion conv = new MeasureScale.Conversion(2, null);
        MeasureScale stdScale = new MeasureScale(retval[1], "Signed Fold Change", conv, new BoundedDoubMinMax(-1.0, 1.0, true, false), new Double(1.0));
        this.scales_.put(retval[1], stdScale);
        retval[0] = this.labels_.getNextLabel();
        conv = new MeasureScale.Conversion(0, null);
        MeasureScale stdScale2 = new MeasureScale(retval[0], "Fold Change", conv, new BoundedDoubMinMax(Double.NEGATIVE_INFINITY, 0.0, true, true), new Double(1.0));
        this.scales_.put(retval[0], stdScale2);
        retval[2] = this.labels_.getNextLabel();
        conv = new MeasureScale.Conversion(1, new Double(1.94));
        MeasureScale stdScale3 = new MeasureScale(retval[2], "DeltaDeltaCT", conv, null, new Double(0.0));
        this.scales_.put(retval[2], stdScale3);
        return retval;
    }

    public Object clone() {
        try {
            MeasureDictionary newVal = (MeasureDictionary)super.clone();
            newVal.meas_ = new HashMap();
            Iterator psit = this.meas_.keySet().iterator();
            while (psit.hasNext()) {
                String psKey = (String)psit.next();
                newVal.meas_.put(psKey, ((MeasureProps)this.meas_.get(psKey)).clone());
            }
            newVal.scales_ = new HashMap();
            Iterator scit = this.scales_.keySet().iterator();
            while (scit.hasNext()) {
                String psKey = (String)scit.next();
                newVal.scales_.put(psKey, ((MeasureScale)this.scales_.get(psKey)).clone());
            }
            newVal.labels_ = (UniqueLabeller)this.labels_.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public String createLegacyMeasureProps(double thresh) {
        String legKey = this.defaultScales_[2];
        String newID = this.labels_.getNextLabel();
        MeasureProps legMp = new MeasureProps(newID, "QPCR", legKey, new Double(-Math.abs(thresh)), new Double(Math.abs(thresh)));
        this.meas_.put(newID, legMp);
        return newID;
    }

    public Iterator getKeys() {
        TreeSet ordered = new TreeSet(this.meas_.keySet());
        Iterator oit = ordered.iterator();
        return oit;
    }

    public int getMeasurePropsCount() {
        return this.meas_.size();
    }

    public Set getMeasurePropsNameSet() {
        HashSet<String> retval = new HashSet<String>();
        Iterator ckit = this.meas_.values().iterator();
        while (ckit.hasNext()) {
            MeasureProps ec = (MeasureProps)ckit.next();
            retval.add(ec.getName());
        }
        return retval;
    }

    public MeasureProps getMeasureProps(String key) {
        return (MeasureProps)this.meas_.get(key);
    }

    public void setMeasureProp(MeasureProps mProps) {
        this.meas_.put(mProps.getID(), mProps);
    }

    public void addMeasurePropForIO(MeasureProps mProps) {
        String id = mProps.getID();
        this.labels_.addExistingLabel(id);
        this.meas_.put(id, mProps);
    }

    public void dropMeasureProp(String key) {
        this.meas_.remove(key);
        this.labels_.removeLabel(key);
    }

    public Iterator getScaleKeys() {
        TreeSet ordered = new TreeSet(this.scales_.keySet());
        Iterator oit = ordered.iterator();
        return oit;
    }

    public int getMeasureScaleCount() {
        return this.scales_.size();
    }

    public MeasureScale getMeasureScale(String key) {
        return (MeasureScale)this.scales_.get(key);
    }

    public Set getMeasureScaleNameSet() {
        HashSet<String> retval = new HashSet<String>();
        Iterator ckit = this.scales_.values().iterator();
        while (ckit.hasNext()) {
            MeasureScale ec = (MeasureScale)ckit.next();
            retval.add(ec.getName());
        }
        return retval;
    }

    public void setMeasureScale(MeasureScale mScale) {
        this.scales_.put(mScale.getID(), mScale);
    }

    public void addMeasureScaleForIO(MeasureScale mScale) {
        String id = mScale.getID();
        this.labels_.addExistingLabel(id);
        this.scales_.put(id, mScale);
    }

    public void dropMeasureScale(String key) {
        this.scales_.remove(key);
        this.labels_.removeLabel(key);
    }

    public String getMeasureScaleFromName(String name) {
        if (name == null) {
            return null;
        }
        String normName = DataUtil.normKey(name);
        Iterator skit = this.scales_.keySet().iterator();
        while (skit.hasNext()) {
            String sKey = (String)skit.next();
            MeasureScale scale = (MeasureScale)this.scales_.get(sKey);
            if (!DataUtil.normKey(scale.getName()).equals(normName)) continue;
            return sKey;
        }
        return null;
    }

    public String getMeasurePropsFromName(String name) {
        if (name == null) {
            return null;
        }
        String normName = DataUtil.normKey(name);
        Iterator skit = this.meas_.keySet().iterator();
        while (skit.hasNext()) {
            String sKey = (String)skit.next();
            MeasureProps mProps = (MeasureProps)this.meas_.get(sKey);
            if (!DataUtil.normKey(mProps.getName()).equals(normName)) continue;
            return sKey;
        }
        return null;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        Cloneable pp;
        String key;
        ind.indent();
        out.println("<measureDictionary>");
        ind.up().indent();
        out.println("<scales>");
        ind.up();
        TreeSet ordered = new TreeSet(this.scales_.keySet());
        Iterator oit = ordered.iterator();
        while (oit.hasNext()) {
            key = (String)oit.next();
            pp = (MeasureScale)this.scales_.get(key);
            ((MeasureScale)pp).writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</scales>");
        if (!this.meas_.isEmpty()) {
            ind.indent();
            out.println("<props>");
            ind.up();
            ordered = new TreeSet(this.meas_.keySet());
            oit = ordered.iterator();
            while (oit.hasNext()) {
                key = (String)oit.next();
                pp = (MeasureProps)this.meas_.get(key);
                ((MeasureProps)pp).writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</props>");
        }
        ind.down().indent();
        out.println("</measureDictionary>");
    }

    public Vector getMeasurementOptions() {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        Iterator oit = this.meas_.keySet().iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            sorted.add(this.getMeasurementChoice(key));
        }
        return new Vector(sorted);
    }

    public TrueObjChoiceContent getMeasurementChoice(String key) {
        MeasureProps mp = (MeasureProps)this.meas_.get(key);
        return new TrueObjChoiceContent(mp.getDisplayString(this), key);
    }

    public Vector getConvertibleScaleOptions() {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        Iterator oit = this.scales_.keySet().iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            MeasureScale ms = (MeasureScale)this.scales_.get(key);
            if (ms.getConvToFold() != null) {
                sorted.add(this.getScaleChoice(key));
                continue;
            }
            return new Vector();
        }
        return new Vector(sorted);
    }

    public Vector getScaleOptions() {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        Iterator oit = this.scales_.keySet().iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            sorted.add(this.getScaleChoice(key));
        }
        return new Vector(sorted);
    }

    public TrueObjChoiceContent getScaleChoice(String key) {
        MeasureScale ms = (MeasureScale)this.scales_.get(key);
        return new TrueObjChoiceContent(ms.getDisplayString(), key);
    }

    public static class MyScaleGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            MeasureDictionary mDict = board.mDict;
            MeasureScale mScale = board.measScale;
            mDict.addMeasureScaleForIO(mScale);
            return null;
        }
    }

    public static class MyPropsGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            MeasureDictionary mDict = board.mDict;
            MeasureProps mProps = board.measProps;
            mDict.addMeasurePropForIO(mProps);
            return null;
        }
    }

    public static class MeasureDictionaryWorker
    extends AbstractFactoryClient {
        public MeasureDictionaryWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("measureDictionary");
            this.installWorker(new MeasureProps.MeasurePropsWorker(whiteboard), new MyPropsGlue());
            this.installWorker(new MeasureScale.MeasureScaleWorker(whiteboard), new MyScaleGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            MeasureDictionary retval = null;
            if (elemName.equals("measureDictionary")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.mDict = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private MeasureDictionary buildFromXML(String elemName, Attributes attrs) throws IOException {
            MeasureDictionary mDict = new MeasureDictionary();
            return mDict;
        }
    }
}

