/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.SourceSrc;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class MeasureProps
implements Cloneable {
    private String id_;
    private String measureName_;
    private String scaleKey_;
    private Double negThresh_;
    private Double posThresh_;

    public MeasureProps(String id, String name, String scaleKey, Double negThresh, Double posThresh) {
        this.id_ = id;
        this.measureName_ = name;
        this.scaleKey_ = scaleKey;
        this.negThresh_ = negThresh;
        this.posThresh_ = posThresh;
    }

    public String getID() {
        return this.id_;
    }

    public String getName() {
        return this.measureName_;
    }

    public String getScaleKey() {
        return this.scaleKey_;
    }

    public Double getPosThresh() {
        return this.posThresh_;
    }

    public Double getNegThresh() {
        return this.negThresh_;
    }

    public void setName(String measureName) {
        this.measureName_ = measureName;
    }

    public void setScaleKey(String scaleKey) {
        this.scaleKey_ = scaleKey;
    }

    public void setPosThresh(Double posThresh) {
        this.posThresh_ = posThresh;
    }

    public void setNegThresh(Double negThresh) {
        this.negThresh_ = negThresh;
    }

    public String getDisplayString(MeasureDictionary md) {
        return this.measureName_ + " " + md.getMeasureScale(this.scaleKey_).getDisplayString();
    }

    public Object clone() {
        try {
            MeasureProps newVal = (MeasureProps)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<measureProp id=\"");
        out.print(this.id_);
        out.print("\" name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.measureName_, false));
        out.print("\" scale=\"");
        out.print(this.scaleKey_);
        if (this.posThresh_ != null) {
            out.print("\" posThresh=\"");
            out.print(this.posThresh_);
        }
        if (this.negThresh_ != null) {
            out.print("\" negThresh=\"");
            out.print(this.negThresh_);
        }
        out.println("\"/>");
    }

    public String toString() {
        return "MeasureProps: " + this.id_ + " " + this.measureName_ + " " + this.scaleKey_;
    }

    public boolean matchesFilter(PertFilter pf, SourceSrc sources) {
        switch (pf.getCategory()) {
            case 12: {
                return this.scaleKey_.equals(pf.getStringValue());
            }
            case 14: {
                return this.id_.equals(pf.getStringValue());
            }
        }
        throw new IllegalArgumentException();
    }

    public static class MeasurePropsWorker
    extends AbstractFactoryClient {
        public MeasurePropsWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("measureProp");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            MeasureProps retval = null;
            if (elemName.equals("measureProp")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.measProps = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private MeasureProps buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "measureProp", "id", true);
            String nameStr = AttributeExtractor.extractAttribute(elemName, attrs, "measureProp", "name", true);
            String scale = AttributeExtractor.extractAttribute(elemName, attrs, "measureProp", "scale", true);
            String pThresh = AttributeExtractor.extractAttribute(elemName, attrs, "measureProp", "posThresh", false);
            String nThresh = AttributeExtractor.extractAttribute(elemName, attrs, "measureProp", "negThresh", false);
            nameStr = CharacterEntityMapper.unmapEntities(nameStr, false);
            Double negThresh = null;
            Double posThresh = null;
            try {
                if (pThresh != null) {
                    posThresh = new Double(pThresh);
                }
                if (nThresh != null) {
                    negThresh = new Double(nThresh);
                }
            }
            catch (NumberFormatException nex) {
                throw new IOException();
            }
            return new MeasureProps(id, nameStr, scale, negThresh, posThresh);
        }
    }
}

