/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Vector;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.BoundedDoubMinMax;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class MeasureScale
implements Cloneable {
    public static final int INFINITY = 0;
    public static final int VALUE_EXCLUSIVE = 1;
    public static final int VALUE_INCLUSIVE = 2;
    private static final int NUM_VAL_OPTIONS_ = 3;
    private static final String INFINITY_STR_ = "infinity";
    private static final String VALUE_EXCLUSIVE_STR_ = "boundExclude";
    private static final String VALUE_INCLUSIVE_STR_ = "boundInclude";
    private String id_;
    private String scaleName_;
    private Conversion convToFold_;
    private BoundedDoubMinMax illegalRange_;
    private Double unchanged_;

    public MeasureScale(String id, String name, Conversion convToFold, BoundedDoubMinMax illegal, Double unchanged) {
        this.id_ = id;
        this.scaleName_ = name;
        this.convToFold_ = convToFold;
        this.illegalRange_ = illegal;
        this.unchanged_ = unchanged;
    }

    public String getID() {
        return this.id_;
    }

    public String getName() {
        return this.scaleName_;
    }

    public Double getUnchanged() {
        return this.unchanged_;
    }

    public void setUnchanged(Double unchanged) {
        this.unchanged_ = unchanged;
    }

    public Conversion getConvToFold() {
        return this.convToFold_;
    }

    public BoundedDoubMinMax getIllegalRange() {
        return this.illegalRange_;
    }

    public void setName(String name) {
        this.scaleName_ = name;
    }

    public void setConvToFold(Conversion convToFold) {
        this.convToFold_ = convToFold;
    }

    public void setIllegalRange(BoundedDoubMinMax illegal) {
        this.illegalRange_ = illegal;
    }

    public String getDisplayString() {
        return this.scaleName_;
    }

    public Object clone() {
        try {
            MeasureScale newVal = (MeasureScale)super.clone();
            newVal.illegalRange_ = this.illegalRange_ == null ? null : (BoundedDoubMinMax)this.illegalRange_.clone();
            newVal.convToFold_ = this.convToFold_ == null ? null : (Conversion)this.convToFold_.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<measureScale id=\"");
        out.print(this.id_);
        out.print("\" name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.scaleName_, false));
        if (this.unchanged_ != null) {
            out.print("\" unchanged=\"");
            out.print(this.unchanged_);
        }
        if (this.convToFold_ != null) {
            out.print("\" foldConvType=\"");
            out.print(Conversion.mapTypeToTag(this.convToFold_.type));
            if (this.convToFold_.factor != null) {
                out.print("\" foldConvFac=\"");
                out.print(this.convToFold_.factor);
            }
        }
        if (this.illegalRange_ != null) {
            out.print("\" illegalMin=\"");
            out.print(this.illegalRange_.min);
            out.print("\" incMin=\"");
            out.print(this.illegalRange_.includeMin);
            out.print("\" illegalMax=\"");
            out.print(this.illegalRange_.max);
            out.print("\" incMax=\"");
            out.print(this.illegalRange_.includeMax);
        }
        out.println("\"/>");
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof MeasureScale)) {
            return false;
        }
        MeasureScale otherMS = (MeasureScale)other;
        if (!this.id_.equals(otherMS.id_)) {
            return false;
        }
        if (!this.scaleName_.equals(otherMS.scaleName_)) {
            return false;
        }
        if (this.unchanged_ == null ? otherMS.unchanged_ != null : !this.unchanged_.equals(otherMS.unchanged_)) {
            return false;
        }
        if (this.convToFold_ == null ? otherMS.convToFold_ != null : !this.convToFold_.equals(otherMS.convToFold_)) {
            return false;
        }
        if (this.illegalRange_ == null) {
            return otherMS.illegalRange_ == null;
        }
        return this.illegalRange_.equals(otherMS.illegalRange_);
    }

    public String toString() {
        return "MeasureScale: " + this.id_ + " " + this.scaleName_ + " " + this.convToFold_ + " " + this.illegalRange_ + " " + this.unchanged_;
    }

    public static Vector getIllegalChoices(boolean forNeg) {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            retval.add(MeasureScale.convertTypeForCombo(i, forNeg));
        }
        return retval;
    }

    public static int rangeToType(BoundedDoubMinMax bdmm, boolean forNeg) {
        if (forNeg) {
            if (bdmm.min == Double.NEGATIVE_INFINITY) {
                return 0;
            }
            if (bdmm.includeMin) {
                return 2;
            }
            return 1;
        }
        if (bdmm.max == Double.POSITIVE_INFINITY) {
            return 0;
        }
        if (bdmm.includeMax) {
            return 2;
        }
        return 1;
    }

    public static ChoiceContent convertTypeForCombo(int type, boolean forNeg) {
        String rs = "illegalBoundOpt." + MeasureScale.mapTypeToTag(type);
        String suf = "";
        if (type == 0) {
            suf = forNeg ? "neg" : "pos";
        }
        return new ChoiceContent(ResourceManager.getManager().getString(rs + suf), type);
    }

    public static String mapTypeToTag(int value) {
        switch (value) {
            case 0: {
                return INFINITY_STR_;
            }
            case 1: {
                return VALUE_EXCLUSIVE_STR_;
            }
            case 2: {
                return VALUE_INCLUSIVE_STR_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapTagToType(String tag) {
        if (tag.equals(INFINITY_STR_)) {
            return 0;
        }
        if (tag.equals(VALUE_EXCLUSIVE_STR_)) {
            return 1;
        }
        if (tag.equals(VALUE_INCLUSIVE_STR_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static class Conversion
    implements Cloneable {
        public static final int NO_CONVERSION = 0;
        public static final int FACTOR_IS_EXPONENT_BASE = 1;
        public static final int NEGATIVE_RECIPROCAL_IF_LT_ONE = 2;
        private static final int NUM_CONVERT_OPTIONS_ = 3;
        private static final String NO_CONVERSION_STR_ = "none";
        private static final String FACTOR_IS_EXPONENT_BASE_STR_ = "expBase";
        private static final String NEGATIVE_RECIPROCAL_IF_LT_ONE_STR_ = "negRecip";
        public int type;
        public Double factor;

        public Conversion(int type, Double factor) {
            this.type = type;
            this.factor = factor;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Conversion)) {
                return false;
            }
            Conversion otherC = (Conversion)other;
            if (this.type != otherC.type) {
                return false;
            }
            if (this.factor == null) {
                return otherC.factor == null;
            }
            return this.factor.equals(otherC.factor);
        }

        public int hashCode() {
            return this.type + (this.factor == null ? 0 : (int)Math.round(this.factor * 1000.0));
        }

        public Object clone() {
            try {
                Conversion newVal = (Conversion)super.clone();
                return newVal;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public double toFold(double value) {
            double asFold;
            switch (this.type) {
                case 0: {
                    asFold = value;
                    break;
                }
                case 1: {
                    asFold = Math.pow(this.factor, value);
                    break;
                }
                case 2: {
                    if (value < 0.0) {
                        asFold = 1.0 / -value;
                        break;
                    }
                    asFold = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return asFold;
        }

        public double fromFold(double asFold) {
            double fromFold;
            switch (this.type) {
                case 0: {
                    fromFold = asFold;
                    break;
                }
                case 1: {
                    fromFold = Math.log(asFold) / Math.log(this.factor);
                    break;
                }
                case 2: {
                    if (asFold < 1.0) {
                        fromFold = -1.0 / asFold;
                        break;
                    }
                    fromFold = asFold;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return fromFold;
        }

        public String getDisplayString() {
            ResourceManager rMan = ResourceManager.getManager();
            switch (this.type) {
                case 0: {
                    return rMan.getString("scaleConvert.none");
                }
                case 1: {
                    String format = rMan.getString("scaleConvert.expBase");
                    return MessageFormat.format(format, this.factor);
                }
                case 2: {
                    return rMan.getString("scaleConvert.negRecip");
                }
            }
            throw new IllegalArgumentException();
        }

        public static Vector getConvertChoices() {
            Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
            for (int i = 0; i < 3; ++i) {
                retval.add(Conversion.convertTypeForCombo(i));
            }
            return retval;
        }

        public static ChoiceContent convertTypeForCombo(int type) {
            return new ChoiceContent(ResourceManager.getManager().getString("scaleConvertOpt." + Conversion.mapTypeToTag(type)), type);
        }

        public static String mapTypeToTag(int value) {
            switch (value) {
                case 0: {
                    return NO_CONVERSION_STR_;
                }
                case 1: {
                    return FACTOR_IS_EXPONENT_BASE_STR_;
                }
                case 2: {
                    return NEGATIVE_RECIPROCAL_IF_LT_ONE_STR_;
                }
            }
            throw new IllegalArgumentException();
        }

        public static int mapTagToType(String tag) {
            if (tag.equals(NO_CONVERSION_STR_)) {
                return 0;
            }
            if (tag.equals(FACTOR_IS_EXPONENT_BASE_STR_)) {
                return 1;
            }
            if (tag.equals(NEGATIVE_RECIPROCAL_IF_LT_ONE_STR_)) {
                return 2;
            }
            throw new IllegalArgumentException();
        }
    }

    public static class MeasureScaleWorker
    extends AbstractFactoryClient {
        public MeasureScaleWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("measureScale");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            MeasureScale retval = null;
            if (elemName.equals("measureScale")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.measScale = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private MeasureScale buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "measureScale", "id", true);
            String nameStr = AttributeExtractor.extractAttribute(elemName, attrs, "measureScale", "name", true);
            String foldConvTypeStr = AttributeExtractor.extractAttribute(elemName, attrs, "measureScale", "foldConvType", false);
            String foldConvFacStr = AttributeExtractor.extractAttribute(elemName, attrs, "measureScale", "foldConvFac", false);
            String illegalMin = AttributeExtractor.extractAttribute(elemName, attrs, "measureScale", "illegalMin", false);
            String illegalMax = AttributeExtractor.extractAttribute(elemName, attrs, "measureScale", "illegalMax", false);
            String illegalMinInc = AttributeExtractor.extractAttribute(elemName, attrs, "measureScale", "incMin", false);
            String illegalMaxInc = AttributeExtractor.extractAttribute(elemName, attrs, "measureScale", "incMax", false);
            String unchangedStr = AttributeExtractor.extractAttribute(elemName, attrs, "measureScale", "unchanged", false);
            nameStr = CharacterEntityMapper.unmapEntities(nameStr, false);
            Conversion conv = null;
            if (foldConvTypeStr != null) {
                Double foldConvFac = null;
                try {
                    if (foldConvFacStr != null) {
                        foldConvFac = new Double(foldConvFacStr);
                    }
                }
                catch (NumberFormatException nex) {
                    throw new IOException();
                }
                try {
                    int foldConvType = Conversion.mapTagToType(foldConvTypeStr);
                    conv = new Conversion(foldConvType, foldConvFac);
                }
                catch (IllegalArgumentException iaex) {
                    throw new IOException();
                }
            }
            if (!(illegalMinInc == null && illegalMaxInc == null || illegalMin != null && illegalMax != null)) {
                throw new IOException();
            }
            boolean incMin = illegalMinInc != null ? Boolean.valueOf(illegalMinInc) : true;
            boolean incMax = illegalMaxInc != null ? Boolean.valueOf(illegalMaxInc) : true;
            BoundedDoubMinMax illegal = null;
            try {
                Double min = null;
                Double max = null;
                if (illegalMin != null) {
                    if (illegalMax == null) {
                        throw new IOException();
                    }
                    min = new Double(illegalMin);
                }
                if (illegalMax != null) {
                    if (illegalMin == null) {
                        throw new IOException();
                    }
                    max = new Double(illegalMax);
                }
                if (min != null && max != null) {
                    if (min > max) {
                        throw new IOException();
                    }
                    illegal = new BoundedDoubMinMax(min, max, incMin, incMax);
                }
            }
            catch (NumberFormatException nex) {
                throw new IOException();
            }
            Double unchanged = null;
            try {
                if (unchangedStr != null) {
                    unchanged = new Double(unchangedStr);
                }
                if (illegal != null && illegal.contained(unchanged)) {
                    throw new IOException();
                }
            }
            catch (NumberFormatException nex) {
                throw new IOException();
            }
            return new MeasureScale(id, nameStr, conv, illegal, unchanged);
        }
    }
}

