/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class NameMapper
implements Cloneable {
    private HashMap mapToData_ = new HashMap();
    private long serialNumber_ = 0L;
    private String usage_;

    public NameMapper(String usage) {
        this.usage_ = usage;
    }

    public Object clone() {
        try {
            NameMapper newVal = (NameMapper)super.clone();
            newVal.mapToData_ = new HashMap();
            Iterator ksit = this.mapToData_.keySet().iterator();
            while (ksit.hasNext()) {
                String key = (String)ksit.next();
                ArrayList al = (ArrayList)this.mapToData_.get(key);
                newVal.mapToData_.put(key, al.clone());
            }
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public long getSerialNumber() {
        return this.serialNumber_;
    }

    public void setSerialNumber(long serialNumber) {
        this.serialNumber_ = serialNumber;
    }

    public String getUsage() {
        return this.usage_;
    }

    public void changeUndo(PertDataChange undo) {
        if (undo.nameMapperListOrig != null) {
            this.mapToData_.put(undo.nameMapperKey, undo.nameMapperListOrig);
        } else {
            this.mapToData_.remove(undo.nameMapperKey);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    public void changeRedo(PertDataChange redo) {
        if (redo.nameMapperListNew != null) {
            this.mapToData_.put(redo.nameMapperKey, redo.nameMapperListNew);
        } else {
            this.mapToData_.remove(redo.nameMapperKey);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public boolean haveData() {
        return this.mapToData_.size() > 0;
    }

    public void importLegacyMapEntry(String key, List entries, Map nameToKeys) {
        int numE = entries.size();
        if (numE == 0) {
            return;
        }
        ArrayList<String> mappedEntries = new ArrayList<String>();
        for (int i = 0; i < numE; ++i) {
            String oldName = (String)entries.get(i);
            String newKey = (String)nameToKeys.get(DataUtil.normKey(oldName));
            if (newKey == null || mappedEntries.contains(newKey)) continue;
            mappedEntries.add(newKey);
        }
        if (!mappedEntries.isEmpty()) {
            this.mapToData_.put(key, mappedEntries);
        }
    }

    public boolean haveCustomMapForNode(String nodeID) {
        List entryMapped = (List)this.mapToData_.get(nodeID);
        return entryMapped != null && entryMapped.size() != 0;
    }

    public boolean haveEmptyMapForNode(String nodeID) {
        List entryMapped = (List)this.mapToData_.get(nodeID);
        return entryMapped != null && entryMapped.size() == 0;
    }

    public PertDataChange[] dupAMapTo(String existingID, String dupID) {
        ArrayList<PertDataChange> retvalList = new ArrayList<PertDataChange>();
        Iterator mit = this.mapToData_.keySet().iterator();
        while (mit.hasNext()) {
            String mapKey = (String)mit.next();
            ArrayList targList = (ArrayList)this.mapToData_.get(mapKey);
            if (!targList.contains(existingID)) continue;
            PertDataChange pdc = new PertDataChange(this.serialNumber_, 24);
            pdc.nameMapperKey = mapKey;
            pdc.nameMapperMode = this.usage_;
            pdc.nameMapperListOrig = (ArrayList)targList.clone();
            targList.add(dupID);
            pdc.nameMapperListNew = (ArrayList)targList.clone();
            pdc.serialNumberNew = ++this.serialNumber_;
            retvalList.add(pdc);
            break;
        }
        return retvalList.toArray(new PertDataChange[retvalList.size()]);
    }

    public PertDataChange[] dropDanglingMapsFor(String deadID) {
        ArrayList<PertDataChange> retvalList = new ArrayList<PertDataChange>();
        Iterator mit = new HashSet(this.mapToData_.keySet()).iterator();
        block0: while (mit.hasNext()) {
            String mapKey = (String)mit.next();
            ArrayList targList = (ArrayList)this.mapToData_.get(mapKey);
            int tlSize = targList.size();
            for (int i = 0; i < tlSize; ++i) {
                String targ = (String)targList.get(i);
                if (!deadID.equals(targ)) continue;
                PertDataChange pdc = new PertDataChange(this.serialNumber_, 24);
                pdc.nameMapperKey = mapKey;
                pdc.nameMapperMode = this.usage_;
                pdc.nameMapperListOrig = (ArrayList)targList.clone();
                targList.remove(i);
                if (targList.isEmpty()) {
                    pdc.nameMapperListNew = null;
                    this.mapToData_.remove(mapKey);
                } else {
                    pdc.nameMapperListNew = (ArrayList)targList.clone();
                }
                pdc.serialNumberNew = ++this.serialNumber_;
                retvalList.add(pdc);
                continue block0;
            }
        }
        return retvalList.toArray(new PertDataChange[retvalList.size()]);
    }

    public PertDataChange[] mergeMapsFor(String keepID, List allIDs) {
        ArrayList<PertDataChange> retvalList = new ArrayList<PertDataChange>();
        Iterator mit = this.mapToData_.keySet().iterator();
        while (mit.hasNext()) {
            String mapKey = (String)mit.next();
            ArrayList<String> newList = new ArrayList<String>();
            ArrayList targList = (ArrayList)this.mapToData_.get(mapKey);
            int numTarg = targList.size();
            boolean changed = false;
            boolean gotKeepID = false;
            for (int i = 0; i < numTarg; ++i) {
                String targ = (String)targList.get(i);
                if (!allIDs.contains(targ)) {
                    newList.add(targ);
                    continue;
                }
                if (keepID.equals(targ)) {
                    newList.add(targ);
                    gotKeepID = true;
                    continue;
                }
                changed = true;
            }
            if (changed && !gotKeepID) {
                newList.add(keepID);
            }
            if (!changed) continue;
            PertDataChange pdc = new PertDataChange(this.serialNumber_, 24);
            pdc.nameMapperKey = mapKey;
            pdc.nameMapperMode = this.usage_;
            pdc.nameMapperListOrig = (ArrayList)targList.clone();
            targList.clear();
            targList.addAll(newList);
            pdc.nameMapperListNew = (ArrayList)targList.clone();
            pdc.serialNumberNew = ++this.serialNumber_;
            retvalList.add(pdc);
        }
        return retvalList.toArray(new PertDataChange[retvalList.size()]);
    }

    public PertDataChange[] dropIdentityMaps(Map nameResolver) {
        DBGenome genome = (DBGenome)Database.getDB().getGenome();
        ArrayList<PertDataChange> retvalList = new ArrayList<PertDataChange>();
        Iterator mit = new HashSet(this.mapToData_.keySet()).iterator();
        while (mit.hasNext()) {
            String nodeID = (String)mit.next();
            ArrayList<String> newList = new ArrayList<String>();
            ArrayList targList = (ArrayList)this.mapToData_.get(nodeID);
            String name = genome.getNode(nodeID).getName();
            int numTarg = targList.size();
            boolean changed = false;
            for (int i = 0; i < numTarg; ++i) {
                String targ = (String)targList.get(i);
                String targName = (String)nameResolver.get(targ);
                if (!DataUtil.keysEqual(name, targName)) {
                    newList.add(targ);
                    continue;
                }
                changed = true;
            }
            if (!changed) continue;
            PertDataChange pdc = new PertDataChange(this.serialNumber_, 24);
            pdc.nameMapperKey = nodeID;
            pdc.nameMapperMode = this.usage_;
            pdc.nameMapperListOrig = (ArrayList)targList.clone();
            targList.clear();
            targList.addAll(newList);
            if (targList.isEmpty()) {
                this.mapToData_.remove(nodeID);
                pdc.nameMapperListNew = null;
            } else {
                pdc.nameMapperListNew = (ArrayList)targList.clone();
            }
            pdc.serialNumberNew = ++this.serialNumber_;
            retvalList.add(pdc);
        }
        return retvalList.toArray(new PertDataChange[retvalList.size()]);
    }

    public PertDataChange setDataMap(String key, List entries) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 24);
        retval.nameMapperKey = key;
        retval.nameMapperMode = this.usage_;
        ArrayList orig = (ArrayList)this.mapToData_.get(key);
        ArrayList arrayList = retval.nameMapperListOrig = orig == null ? null : (ArrayList)orig.clone();
        if (entries != null && entries.size() > 0) {
            ArrayList<String> uniqueEntries = new ArrayList<String>();
            int numE = entries.size();
            for (int i = 0; i < numE; ++i) {
                String givenKey = (String)entries.get(i);
                if (uniqueEntries.contains(givenKey)) continue;
                uniqueEntries.add(givenKey);
            }
            this.mapToData_.put(key, uniqueEntries);
            retval.nameMapperListNew = (ArrayList)uniqueEntries.clone();
        } else {
            this.mapToData_.remove(key);
            retval.nameMapperListNew = null;
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public void initDataMapForIO(String key) {
        this.mapToData_.put(key, new ArrayList());
    }

    public void appendToDataMapForIO(String key, String newEntry) {
        ArrayList forKey = (ArrayList)this.mapToData_.get(key);
        forKey.add(newEntry);
    }

    public List getDataKeysWithDefault(String nodeId, String defaultKey) {
        ArrayList<String> retval = (ArrayList<String>)this.mapToData_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<String>();
            if (defaultKey == null) {
                return retval;
            }
            retval.add(defaultKey);
        }
        return retval;
    }

    public List getCustomDataKeys(String geneId) {
        List keyList = (List)this.mapToData_.get(geneId);
        return keyList == null ? null : new ArrayList(keyList);
    }

    public Set getDataKeyInverse(String key, Map nameResolver) {
        Set nodes;
        String resolvesToName;
        HashSet<String> retval = new HashSet<String>();
        DBGenome genome = (DBGenome)Database.getDB().getGenome();
        Node node = genome.getGeneWithName(resolvesToName = (String)nameResolver.get(key));
        if (node != null && !this.haveCustomMapForNode(node.getID())) {
            retval.add(node.getID());
        }
        if (!(nodes = genome.getNodesWithName(resolvesToName)).isEmpty()) {
            Iterator sit = nodes.iterator();
            while (sit.hasNext()) {
                node = (Node)sit.next();
                if (this.haveCustomMapForNode(node.getID())) continue;
                retval.add(node.getID());
            }
        }
        Iterator kit = this.mapToData_.keySet().iterator();
        while (kit.hasNext()) {
            String mdkey = (String)kit.next();
            List targs = (List)this.mapToData_.get(mdkey);
            if (!targs.contains(key)) continue;
            retval.add(mdkey);
        }
        return retval;
    }

    public boolean haveMapToEntry(String entryID) {
        Iterator kit = this.mapToData_.keySet().iterator();
        while (kit.hasNext()) {
            String mdkey = (String)kit.next();
            List targs = (List)this.mapToData_.get(mdkey);
            if (!targs.contains(entryID)) continue;
            return true;
        }
        return false;
    }

    public boolean onlyInverseIsDefault(String key, Map nameResolver) {
        String resolvesToName;
        DBGenome genome = (DBGenome)Database.getDB().getGenome();
        Node node = genome.getGeneWithName(resolvesToName = (String)nameResolver.get(key));
        if (node != null && !this.haveCustomMapForNode(node.getID())) {
            return true;
        }
        Set nodes = genome.getNodesWithName(resolvesToName);
        if (!nodes.isEmpty()) {
            Iterator sit = nodes.iterator();
            while (sit.hasNext()) {
                node = (Node)sit.next();
                if (this.haveCustomMapForNode(node.getID())) continue;
                return true;
            }
        }
        return false;
    }

    public Set getDataKeySet() {
        return this.mapToData_.keySet();
    }

    public PertDataChange dropDataKeys(String key) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 24);
        retval.nameMapperKey = key;
        retval.nameMapperMode = this.usage_;
        ArrayList orig = (ArrayList)this.mapToData_.get(key);
        retval.nameMapperListOrig = (ArrayList)orig.clone();
        this.mapToData_.remove(key);
        retval.nameMapperListNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<dataMap usage=\"");
        out.print(this.usage_);
        out.print("\"");
        if (this.serialNumber_ != 0L) {
            out.print(" serialNum=\"");
            out.print(this.serialNumber_);
            out.print("\"");
        }
        out.println(">");
        TreeSet sorted = new TreeSet();
        sorted.addAll(this.mapToData_.keySet());
        Iterator mapKeys = sorted.iterator();
        ind.up();
        while (mapKeys.hasNext()) {
            String key = (String)mapKeys.next();
            List elist = (List)this.mapToData_.get(key);
            ind.indent();
            out.print("<mapFrom");
            out.print(" key=\"");
            out.print(key);
            out.println("\">");
            ind.up();
            Iterator lit = elist.iterator();
            while (lit.hasNext()) {
                String mapTo = (String)lit.next();
                ind.indent();
                out.print("<mapTo nameKey=\"");
                out.print(mapTo);
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</mapFrom>");
        }
        ind.down().indent();
        out.println("</dataMap>");
    }

    public String toString() {
        return " NameMapper = " + this.mapToData_ + "  serial number = " + this.serialNumber_;
    }

    public static class MapToWorker
    extends AbstractFactoryClient {
        public MapToWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("mapTo");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            String retval = null;
            if (elemName.equals("mapTo")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.currPertMapTo = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private String buildFromXML(String elemName, Attributes attrs) throws IOException {
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "mapTo", "nameKey", true);
            return name;
        }
    }

    public static class MyMapToGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NameMapper nmap = board.currPertDataMap;
            nmap.appendToDataMapForIO(board.currPertMapFrom, board.currPertMapTo);
            return null;
        }
    }

    public static class MapFromWorker
    extends AbstractFactoryClient {
        public MapFromWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("mapFrom");
            this.installWorker(new MapToWorker(whiteboard), new MyMapToGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            String retval = null;
            if (elemName.equals("mapFrom")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.currPertMapFrom = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private String buildFromXML(String elemName, Attributes attrs) throws IOException {
            String key = AttributeExtractor.extractAttribute(elemName, attrs, "mapFrom", "key", true);
            return key;
        }
    }

    public static class MyMapFromGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NameMapper nmap = board.currPertDataMap;
            nmap.initDataMapForIO(board.currPertMapFrom);
            return null;
        }
    }

    public static class NameMapperWorker
    extends AbstractFactoryClient {
        public NameMapperWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("dataMap");
            this.installWorker(new MapFromWorker(whiteboard), new MyMapFromGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NameMapper retval = null;
            if (elemName.equals("dataMap")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.currPertDataMap = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private NameMapper buildFromXML(String elemName, Attributes attrs) throws IOException {
            String serNum = AttributeExtractor.extractAttribute(elemName, attrs, "dataMap", "serialNum", false);
            String usage = AttributeExtractor.extractAttribute(elemName, attrs, "dataMap", "usage", true);
            NameMapper retval = new NameMapper(usage);
            if (serNum != null) {
                try {
                    long sNum = Long.parseLong(serNum);
                    retval.setSerialNumber(sNum);
                }
                catch (NumberFormatException nfex) {
                    throw new IOException();
                }
            }
            return retval;
        }
    }
}

