/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class PertAnnotations
implements Cloneable {
    private UniqueLabeller labels_ = new UniqueLabeller();
    private TreeMap messages_ = new TreeMap();
    private HashMap mapToKeys_ = new HashMap();
    private Pattern pattern_ = Pattern.compile("[0-9][0-9]*");
    private Matcher matcher_ = this.pattern_.matcher("");

    public void mergeAnnotations(List joinKeys, String commonKey, String tag, String message) {
        this.editMessage(commonKey, tag, message);
        int numIDs = joinKeys.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)joinKeys.get(i);
            if (keyID.equals(commonKey)) continue;
            this.deleteMessage(keyID);
        }
    }

    public Object clone() {
        try {
            PertAnnotations retval = (PertAnnotations)super.clone();
            retval.labels_ = (UniqueLabeller)this.labels_.clone();
            retval.messages_ = (TreeMap)this.messages_.clone();
            retval.mapToKeys_ = (HashMap)this.mapToKeys_.clone();
            retval.pattern_ = Pattern.compile("[0-9][0-9]*");
            retval.matcher_ = retval.pattern_.matcher("");
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public String getMessage(String id) {
        return (String)this.messages_.get(id);
    }

    public String getTag(String id) {
        return (String)this.mapToKeys_.get(id);
    }

    public int getAnnotationCount() {
        return this.mapToKeys_.size();
    }

    public String messageExists(String message) {
        String normMessage = DataUtil.normKey(message);
        Iterator mit = this.messages_.keySet().iterator();
        while (mit.hasNext()) {
            String key = (String)mit.next();
            String chkMsg = (String)this.messages_.get(key);
            if (!normMessage.equals(DataUtil.normKey(chkMsg))) continue;
            return key;
        }
        return null;
    }

    public String addMessage(String message) {
        Iterator mit = this.messages_.keySet().iterator();
        while (mit.hasNext()) {
            String key = (String)mit.next();
            String chkMsg = (String)this.messages_.get(key);
            if (!chkMsg.equals(message)) continue;
            return key;
        }
        String nextLabel = this.labels_.getNextLabel();
        this.messages_.put(nextLabel, message);
        TreeSet<Integer> numsOnly = new TreeSet<Integer>();
        Iterator vit = this.mapToKeys_.values().iterator();
        while (vit.hasNext()) {
            String val = (String)vit.next();
            this.matcher_.reset(val);
            if (!this.matcher_.matches()) continue;
            numsOnly.add(new Integer(val));
        }
        Integer lastNum = numsOnly.isEmpty() ? new Integer(0) : (Integer)numsOnly.last();
        lastNum = new Integer(lastNum + 1);
        this.mapToKeys_.put(nextLabel, lastNum.toString());
        return nextLabel;
    }

    public String addMessage(String tag, String message) {
        String nextLabel = this.labels_.getNextLabel();
        this.messages_.put(nextLabel, message);
        this.mapToKeys_.put(nextLabel, tag);
        return nextLabel;
    }

    public void addMessageExistingKey(String useKey, String tag, String message) {
        this.labels_.addExistingLabel(useKey);
        this.messages_.put(useKey, message);
        this.mapToKeys_.put(useKey, tag);
    }

    public void editMessage(String id, String tag, String message) {
        this.messages_.put(id, message);
        this.mapToKeys_.put(id, tag);
    }

    public void deleteMessage(String id) {
        this.messages_.remove(id);
        this.mapToKeys_.remove(id);
        this.labels_.removeLabel(id);
    }

    public String addLegacyMessage(String legKey, String message) {
        Iterator kit = this.mapToKeys_.keySet().iterator();
        while (kit.hasNext()) {
            String id = (String)kit.next();
            String existing = (String)this.mapToKeys_.get(id);
            if (!existing.equals(legKey)) continue;
            String exMsg = (String)this.messages_.get(id);
            if (!exMsg.equals(message)) {
                return null;
            }
            return id;
        }
        String nextLabel = this.labels_.getNextLabel();
        this.messages_.put(nextLabel, message);
        this.mapToKeys_.put(nextLabel, legKey);
        return nextLabel;
    }

    public String getFootnoteListAsString(List noteIDs) {
        List flist = this.getFootnoteList(noteIDs);
        return PertAnnotations.convertFootnoteListToString(flist);
    }

    public String getFootnoteListAsNVString(List noteIDs) {
        if (noteIDs.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        List flist = this.getFootnoteList(noteIDs);
        SortedMap n2k = this.getFootTagToKeyMap();
        Iterator flit = flist.iterator();
        while (flit.hasNext()) {
            String tag = (String)flit.next();
            String key = (String)n2k.get(tag);
            String message = this.getMessage(key);
            buf.append(tag);
            buf.append("=");
            buf.append(message);
            if (!flit.hasNext()) continue;
            buf.append("; ");
        }
        buf.append("]");
        return buf.toString();
    }

    public List getFootnoteList(List noteIDs) {
        TreeSet<String> sortedKeys = new TreeSet<String>(new ReadOnlyTable.NumStrComparator());
        int nidNum = noteIDs.size();
        for (int i = 0; i < nidNum; ++i) {
            String noteID = (String)noteIDs.get(i);
            sortedKeys.add((String)this.mapToKeys_.get(noteID));
        }
        return new ArrayList(sortedKeys);
    }

    public boolean haveMessages() {
        return !this.messages_.isEmpty();
    }

    public SortedMap getFullMap() {
        TreeMap<String, String> retval = new TreeMap<String, String>(new ReadOnlyTable.NumStrComparator());
        Iterator mtnkit = this.mapToKeys_.keySet().iterator();
        while (mtnkit.hasNext()) {
            String id = (String)mtnkit.next();
            String key = (String)this.mapToKeys_.get(id);
            String message = (String)this.messages_.get(id);
            retval.put(key, message);
        }
        return retval;
    }

    public SortedMap getFootTagToKeyMap() {
        TreeMap<String, String> retval = new TreeMap<String, String>();
        Iterator mtnkit = this.mapToKeys_.keySet().iterator();
        while (mtnkit.hasNext()) {
            String id = (String)mtnkit.next();
            String tag = (String)this.mapToKeys_.get(id);
            retval.put(tag, id);
        }
        return retval;
    }

    public void beginAddAnnotForIO(Annot an) {
        this.labels_.addExistingLabel(an.id);
        this.mapToKeys_.put(an.id, an.tag);
        this.messages_.put(an.id, "Waiting for Godot...");
    }

    public void finishAddAnnotForIO(Annot an) {
        this.messages_.put(an.id, an.message);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<pertAnnotations>");
        ind.up();
        Iterator mkit = this.messages_.keySet().iterator();
        while (mkit.hasNext()) {
            String id = (String)mkit.next();
            String message = (String)this.messages_.get(id);
            String key = (String)this.mapToKeys_.get(id);
            ind.indent();
            out.print("<pAnnot id=\"");
            out.print(id);
            out.print("\" key=\"");
            out.print(CharacterEntityMapper.mapEntities(key, false));
            out.print("\">");
            if (message != null) {
                out.print(CharacterEntityMapper.mapEntities(message, false));
            }
            out.println("</pAnnot>");
        }
        ind.down().indent();
        out.println("</pertAnnotations>");
    }

    public String toString() {
        return "PertAnnotations";
    }

    public Vector getAnnotationOptions() {
        Vector<TrueObjChoiceContent> retval = new Vector<TrueObjChoiceContent>();
        StringBuffer buf = new StringBuffer();
        SortedMap fullMap = this.getFootTagToKeyMap();
        Iterator oit = fullMap.keySet().iterator();
        while (oit.hasNext()) {
            String tag = (String)oit.next();
            String key = (String)fullMap.get(tag);
            String message = this.getMessage(key);
            buf.setLength(0);
            buf.append(tag);
            buf.append("=");
            buf.append(message);
            retval.add(new TrueObjChoiceContent(buf.toString(), key));
        }
        return retval;
    }

    public Vector getAvailableTagChoices() {
        UniqueLabeller ul = new UniqueLabeller();
        Iterator kit = this.mapToKeys_.values().iterator();
        while (kit.hasNext()) {
            String tag = (String)kit.next();
            ul.addExistingLabel(tag);
        }
        Vector<TrueObjChoiceContent> retval = new Vector<TrueObjChoiceContent>();
        for (int i = 0; i < 20; ++i) {
            String newKey = ul.getNextLabel();
            retval.add(new TrueObjChoiceContent(newKey, newKey));
        }
        return retval;
    }

    public String getNextTempTag(Set otherTempTags) {
        UniqueLabeller ul = new UniqueLabeller();
        Iterator kit = this.mapToKeys_.values().iterator();
        while (kit.hasNext()) {
            String tag = (String)kit.next();
            ul.addExistingLabel(tag);
        }
        Iterator oit = otherTempTags.iterator();
        while (oit.hasNext()) {
            String tag = (String)oit.next();
            ul.addExistingLabel(tag);
        }
        return ul.getNextLabel();
    }

    public static String convertFootnoteListToString(List flist) {
        StringBuffer buf = new StringBuffer();
        Iterator snit = flist.iterator();
        while (snit.hasNext()) {
            String noteNum = (String)snit.next();
            buf.append(noteNum);
            if (!snit.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public static class AnnotWorker
    extends AbstractFactoryClient {
        private StringBuffer buf_ = new StringBuffer();
        private Annot currAnnot_;

        public AnnotWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pAnnot");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Annot retval = null;
            if (elemName.equals("pAnnot")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.annot = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        protected void localFinishElement(String elemName) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
            this.currAnnot_.message = CharacterEntityMapper.unmapEntities(this.buf_.toString(), false);
            PertAnnotations pa = board.pa;
            pa.finishAddAnnotForIO(this.currAnnot_);
        }

        protected void localProcessCharacters(char[] chars, int start, int length) {
            String nextString = new String(chars, start, length);
            this.buf_.append(nextString);
        }

        private Annot buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "pAnnot", "id", true);
            String key = AttributeExtractor.extractAttribute(elemName, attrs, "pAnnot", "key", true);
            key = CharacterEntityMapper.unmapEntities(key, false);
            this.buf_.setLength(0);
            this.currAnnot_ = new Annot(id, key, null);
            return this.currAnnot_;
        }
    }

    public static class Annot {
        public String id;
        public String tag;
        public String message;

        public Annot(String id, String tag, String message) {
            this.id = id;
            this.tag = tag;
            this.message = message;
        }
    }

    public static class MyAnnotGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            PertAnnotations pa = board.pa;
            Annot annot = board.annot;
            pa.beginAddAnnotForIO(annot);
            return null;
        }
    }

    public static class PertAnnotationsWorker
    extends AbstractFactoryClient {
        public PertAnnotationsWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pertAnnotations");
            this.installWorker(new AnnotWorker(whiteboard), new MyAnnotGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            PertAnnotations retval = null;
            if (elemName.equals("pertAnnotations")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.pa = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private PertAnnotations buildFromXML(String elemName, Attributes attrs) throws IOException {
            PertAnnotations pa = new PertAnnotations();
            return pa;
        }
    }
}

