/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.plugin.InternalNodeDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class PertDataDisplayPlugIn
implements InternalNodeDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        return false;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String nodeID) {
        return null;
    }

    public String getDataAsHTML(String genomeIDX, String nodeID) {
        nodeID = GenomeItemInstance.getBaseID(nodeID);
        StringBuffer buf = new StringBuffer();
        Database db = Database.getDB();
        PerturbationData pd = db.getPertData();
        if (!pd.haveDataForNode(nodeID, null)) {
            return "";
        }
        ResourceManager rMan = ResourceManager.getManager();
        buf.append("<center><h1>");
        buf.append(rMan.getString("dataWindow.pertDataForNode"));
        buf.append("</h1></center>\n");
        boolean largeFont = DisplayOptionsManager.getMgr().isForBigScreen();
        String table = pd.getHTML(nodeID, null, true, largeFont);
        if (table != null) {
            buf.append(table);
        } else {
            buf.append("<center>");
            buf.append(ResourceManager.getManager().getString("dataWindow.noPertDataForNode"));
            buf.append("</center>");
        }
        return buf.toString();
    }
}

