/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.perturb.ConditionDictionary;
import org.systemsbiology.biotapestry.perturb.Experiment;
import org.systemsbiology.biotapestry.perturb.ExperimentControl;
import org.systemsbiology.biotapestry.perturb.LegacyPert;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.perturb.PertAnnotations;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterTarget;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.perturb.SourceSrc;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.DoubMinMax;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.Splitter;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.xml.sax.Attributes;

public class PertDataPoint
implements Cloneable,
PertFilterTarget {
    public static final int ZERO = 0;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int UNKNOWN = 3;
    private String idKey_;
    private long timeStamp_;
    private String experimentKey_;
    private String target_;
    private double value_;
    private LegacyPert legacyVal_;
    private String measureTypeKey_;
    private String control_;
    private Boolean isSignificant_;
    private String comments_;
    private String date_;
    private String batchID_;

    public PertDataPoint(String key, long timeStamp, String srcInfoKey, String target, String measureTypeKey, double value) {
        this.idKey_ = key;
        this.timeStamp_ = timeStamp;
        this.experimentKey_ = srcInfoKey;
        this.target_ = target;
        this.value_ = value;
        this.measureTypeKey_ = measureTypeKey;
    }

    public boolean publishAsCSV(PrintWriter out, SourceSrc ss, Experiment prs, ConditionDictionary cdict, MeasureDictionary mdict, PertAnnotations pAn, PerturbationData.RegionRestrict rr, String invests) {
        out.print("\"");
        String bKey = this.getBatchKey();
        if (bKey.indexOf("_BT") == 0) {
            bKey = bKey + "::" + this.getTargetName(ss).toLowerCase();
        }
        out.print(bKey);
        out.print("\",\"");
        PertSources ps = prs.getSources();
        out.print(ps.getDisplayString(ss, 0).replaceAll(" ", ""));
        out.print("\",\"");
        out.print(this.getTargetName(ss));
        out.print("\",\"");
        out.print(this.getTimeDisplayString(ss, true, true).replaceAll(" ", "").replaceAll("to", "-"));
        out.print("\",\"");
        if (this.legacyVal_ == null) {
            out.print(this.value_);
        } else {
            out.print(this.legacyVal_.oldValue);
            if (this.legacyVal_.unknownMultiCount) {
                out.print("+");
            }
        }
        out.print("\",\"");
        MeasureProps mp = mdict.getMeasureProps(this.measureTypeKey_);
        out.print(mp.getName());
        out.print("\",\"");
        if (this.control_ != null) {
            ExperimentControl ctrl = cdict.getExprControl(this.control_);
            out.print(ctrl.getDescription());
        }
        out.print("\",\"");
        if (this.isSignificant_ != null) {
            out.print(this.isSignificant_ != false ? "Yes" : "No");
        }
        out.print("\",\"");
        if (this.date_ != null) {
            out.print(this.date_);
        }
        out.print("\",\"");
        if (this.comments_ != null) {
            out.print(this.comments_);
        }
        out.print("\",\"");
        HashSet used = new HashSet();
        this.getAnnotationIDs(used, ss);
        Iterator uit = used.iterator();
        while (uit.hasNext()) {
            String aid = (String)uit.next();
            out.print(pAn.getTag(aid));
            if (!uit.hasNext()) continue;
            out.print("+");
        }
        out.print("\",\"");
        if (invests != null) {
            out.print(invests);
        }
        out.print("\",\"");
        if (rr != null) {
            out.print(rr.getDisplayValue());
        }
        out.println("\"");
        return true;
    }

    public boolean willFallInSameBatchWithSameVal(PertDataPoint pdpOther) {
        if (!this.experimentKey_.equals(pdpOther.experimentKey_)) {
            return false;
        }
        if (!this.target_.equals(pdpOther.target_)) {
            return false;
        }
        if (!this.measureTypeKey_.equals(pdpOther.measureTypeKey_)) {
            return false;
        }
        if (this.batchID_ == null ? pdpOther.batchID_ != null : !this.batchID_.equals(pdpOther.batchID_)) {
            return false;
        }
        if (this.control_ == null ? pdpOther.control_ != null : !this.control_.equals(pdpOther.control_)) {
            return false;
        }
        if (this.legacyVal_ == null ? pdpOther.legacyVal_ != null : !this.legacyVal_.equals(pdpOther.legacyVal_)) {
            return false;
        }
        if (this.isSignificant_ == null ? pdpOther.isSignificant_ != null : !this.isSignificant_.equals(pdpOther.isSignificant_)) {
            return false;
        }
        Double myNumeric = this.extractNumericValue();
        Double otherNumeric = pdpOther.extractNumericValue();
        return !(myNumeric == null ? otherNumeric != null : !myNumeric.equals(otherNumeric));
    }

    public int getLink(SourceSrc ss) {
        Double numeric = this.extractNumericValue();
        if (numeric == null) {
            return 3;
        }
        double val = numeric;
        Experiment prs = ss.getExperiment(this.experimentKey_);
        DoubMinMax dmm = prs.getThresholds(this.measureTypeKey_, ss);
        if (!dmm.outsideOrOnBoundary(val)) {
            return 3;
        }
        MeasureDictionary md = ss.getMeasureDictionary();
        MeasureProps mp = md.getMeasureProps(this.measureTypeKey_);
        String myScaleKey = mp.getScaleKey();
        MeasureScale myScale = md.getMeasureScale(myScaleKey);
        Double unchanged = myScale.getUnchanged();
        return prs.resolveLinkSign(val, unchanged, ss);
    }

    public boolean isSignificant(SourceSrc ss) {
        Experiment prs = ss.getExperiment(this.experimentKey_);
        DoubMinMax dmm = prs.getThresholds(this.measureTypeKey_, ss);
        return this.isSignificant(dmm.max, dmm.min);
    }

    public boolean aboveThresholds(SourceSrc ss) {
        Double numeric = this.extractNumericValue();
        if (numeric == null) {
            return false;
        }
        double val = numeric;
        Experiment prs = ss.getExperiment(this.experimentKey_);
        DoubMinMax dmm = prs.getThresholds(this.measureTypeKey_, ss);
        return dmm.outsideOrOnBoundary(val);
    }

    public void getDataValuePerParams(Parameters params, List results, SourceSrc ss) {
        Double nsd = params.getNotSigDoub();
        Experiment prs = ss.getExperiment(this.experimentKey_);
        DoubMinMax dmm = prs.getThresholds(this.measureTypeKey_, ss);
        if (this.legacyVal_ != null) {
            String val = this.legacyVal_.oldValue;
            if (val == null) {
                return;
            }
            if (PertDataPoint.isValidForMissingData(val)) {
                return;
            }
            if (PertDataPoint.isNotSignificant(val, this.isSignificant_, dmm.min, dmm.max)) {
                Double sVal = this.doScalingOfaVal(params.getConvKey(), ss, nsd);
                double retval = sVal == null ? nsd.doubleValue() : sVal.doubleValue();
                boolean isForced = this.isSignificant_ != null;
                results.add(new ValueAndUnits(retval, params.getConvKey(), false, isForced, this.batchID_));
            }
        } else {
            boolean isForced = this.isSignificant_ != null;
            Double scaled = this.doScaling(params.getConvKey(), ss);
            double retval = scaled == null ? this.value_ : scaled;
            results.add(new ValueAndUnits(retval, params.getConvKey(), this.isSignificant(ss), isForced, this.batchID_));
        }
    }

    public Double extractNumericValue() {
        if (this.legacyVal_ != null) {
            return null;
        }
        if (this.isSignificant_ != null && !this.isSignificant_.booleanValue()) {
            return null;
        }
        return new Double(this.value_);
    }

    public Object clone() {
        try {
            PertDataPoint newVal = (PertDataPoint)super.clone();
            newVal.legacyVal_ = this.legacyVal_ == null ? null : (LegacyPert)this.legacyVal_.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public String getID() {
        return this.idKey_;
    }

    public long getTimeStamp() {
        return this.timeStamp_;
    }

    public void setLegacyPert(LegacyPert legPert) {
        this.legacyVal_ = legPert;
    }

    public void setIsSig(Boolean isSig) {
        this.isSignificant_ = isSig;
    }

    public void setComment(String comment) {
        this.comments_ = comment;
    }

    public void setControl(String ctrl) {
        this.control_ = ctrl;
    }

    public void setBatchKey(String batchKey) {
        this.batchID_ = batchKey;
    }

    public void setDate(String date) {
        this.date_ = date;
    }

    public LegacyPert getLegacyPert() {
        return this.legacyVal_;
    }

    public String getBatchKey() {
        return this.batchID_;
    }

    public String getDecoratedBatchKey(SourceSrc ss, boolean superKey) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.experimentKey_);
        buf.append(":_:");
        buf.append(this.batchID_);
        if (superKey) {
            buf.append(":_:");
            buf.append(this.control_ == null ? "--" : this.control_);
            buf.append(":_:");
            buf.append(this.measureTypeKey_);
        }
        return buf.toString();
    }

    public boolean hasLegacyBatchID() {
        return this.batchID_ != null && this.batchID_.indexOf("_BT_") == 0;
    }

    public String getMeasurementTypeKey() {
        return this.measureTypeKey_;
    }

    public void setMeasurementTypeKey(String meaKey) {
        this.measureTypeKey_ = meaKey;
    }

    public String getMeasurementDisplayString(SourceSrc sources) {
        MeasureDictionary md = sources.getMeasureDictionary();
        return md.getMeasureProps(this.measureTypeKey_).getDisplayString(md);
    }

    public String getDate() {
        return this.date_;
    }

    public PertSources getSources(SourceSrc sources) {
        Experiment prs = sources.getExperiment(this.experimentKey_);
        return prs.getSources();
    }

    public Experiment getExperiment(SourceSrc sources) {
        Experiment prs = sources.getExperiment(this.experimentKey_);
        return prs;
    }

    public PerturbationData.RegionRestrict getRegionRestriction(SourceSrc ss) {
        return ss.getRegionRestrictionForDataPoint(this.idKey_);
    }

    public String getInvestigatorDisplayString(SourceSrc sources) {
        Experiment prs = sources.getExperiment(this.experimentKey_);
        return prs.getInvestigatorDisplayString(sources);
    }

    public String getPertDisplayString(SourceSrc sources, int footnoteMode) {
        Experiment prs = sources.getExperiment(this.experimentKey_);
        return prs.getPertDisplayString(sources, footnoteMode);
    }

    public String getTimeDisplayString(SourceSrc sources, boolean showUnits, boolean abbreviate) {
        Experiment prs = sources.getExperiment(this.experimentKey_);
        return prs.getTimeDisplayString(showUnits, abbreviate);
    }

    public MinMax getTimeRange(SourceSrc sources) {
        Experiment prs = sources.getExperiment(this.experimentKey_);
        return prs.getTimeRange();
    }

    public String getExperimentKey() {
        return this.experimentKey_;
    }

    public void setExperimentKey(String newKey) {
        this.experimentKey_ = newKey;
    }

    public String getSingleSourceKey(SourceSrc ss) {
        Experiment prs = ss.getExperiment(this.experimentKey_);
        if (!prs.isSinglePerturbation()) {
            return null;
        }
        PertSource ps = prs.getSources().getSinglePert(ss);
        return ps.getSourceNameKey();
    }

    public void getCandidates(int filterCat, SortedSet fillUp, SourceSrc sources) {
        Experiment prs = sources.getExperiment(this.experimentKey_);
        switch (filterCat) {
            case 0: {
                prs.addToExperimentSet(fillUp, sources);
                return;
            }
            case 1: {
                prs.addToSourceSet(fillUp, sources);
                return;
            }
            case 2: 
            case 3: {
                prs.addToSourceNameSet(fillUp, sources, filterCat == 3);
                return;
            }
            case 4: {
                prs.addToPertSet(fillUp, sources, sources.getPertDictionary());
                return;
            }
            case 5: {
                fillUp.add(new TrueObjChoiceContent(sources.getTarget(this.target_), this.target_));
                return;
            }
            case 6: {
                int min = prs.getTime();
                int legMax = prs.getLegacyMaxTime();
                int max = legMax != -1 ? legMax : min;
                MinMax times = new MinMax(min, max);
                fillUp.add(new TrueObjChoiceContent(prs.getTimeDisplayString(true, true), times));
                return;
            }
            case 8: {
                List invests = prs.getInvestigators();
                int numI = invests.size();
                for (int i = 0; i < numI; ++i) {
                    String investKey = (String)invests.get(i);
                    String invest = sources.getInvestigator(investKey);
                    fillUp.add(new TrueObjChoiceContent(invest, investKey));
                }
                return;
            }
            case 9: {
                String dispStr = prs.getInvestigatorDisplayString(sources);
                fillUp.add(new TrueObjChoiceContent(dispStr, dispStr));
                return;
            }
            case 7: {
                String above;
                if (this.aboveThresholds(sources)) {
                    above = ResourceManager.getManager().getString("pertCand.aboveThresh");
                    fillUp.add(new TrueObjChoiceContent(above, new Integer(9)));
                }
                if (this.isSignificant(sources)) {
                    above = ResourceManager.getManager().getString("pertCand.significant");
                    fillUp.add(new TrueObjChoiceContent(above, new Integer(10)));
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean targetMatches(List trgs) {
        return DataUtil.containsKey(trgs, this.target_);
    }

    public boolean matchesFilter(PertFilter pf, SourceSrc sources) {
        switch (pf.getCategory()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                Experiment prs = sources.getExperiment(this.experimentKey_);
                return prs.matchesFilter(pf, sources);
            }
            case 5: {
                String filterTarget = pf.getStringValue();
                return filterTarget.equals(this.target_);
            }
            case 7: {
                if (pf.getMatchType() == 9) {
                    return this.aboveThresholds(sources);
                }
                if (pf.getMatchType() == 10) {
                    return this.isSignificant(sources);
                }
            }
            case 10: {
                if (pf.getMatchType() != 0) {
                    throw new IllegalArgumentException();
                }
                return this.control_ != null && this.control_.equals(pf.getStringValue());
            }
            case 12: 
            case 14: {
                if (pf.getMatchType() != 0) {
                    throw new IllegalArgumentException();
                }
                MeasureDictionary md = sources.getMeasureDictionary();
                MeasureProps mp = md.getMeasureProps(this.measureTypeKey_);
                return mp.matchesFilter(pf, sources);
            }
            case 13: {
                String filterStr = pf.getStringValue();
                List annotIDs = sources.getDataPointNotes(this.idKey_);
                if (annotIDs != null && annotIDs.contains(filterStr)) {
                    return true;
                }
                annotIDs = sources.getFootnotesForTarget(this.target_);
                if (annotIDs != null && annotIDs.contains(filterStr)) {
                    return true;
                }
                Experiment prs = sources.getExperiment(this.experimentKey_);
                return prs.matchesFilter(pf, sources);
            }
        }
        throw new IllegalArgumentException();
    }

    public int getSign() {
        if (this.isSignificant_ != null && !this.isSignificant_.booleanValue() || this.legacyVal_ != null) {
            return 0;
        }
        if (this.value_ < 0.0) {
            return 2;
        }
        if (this.value_ == 0.0) {
            return 0;
        }
        return 1;
    }

    public Double getPerturbValue(SourceSrc sources) {
        if (this.isSignificant_ != null && !this.isSignificant_.booleanValue() || this.legacyVal_ != null) {
            return null;
        }
        MeasureDictionary md = sources.getMeasureDictionary();
        String skey = md.getStandardScaleKeys()[2];
        return this.doScaling(skey, sources);
    }

    public void getAnnotationIDs(Set usedIDs, SourceSrc sources) {
        Experiment prs = sources.getExperiment(this.experimentKey_);
        prs.getAnnotationIDs(usedIDs, sources);
        List dpn = sources.getDataPointNotes(this.idKey_);
        if (dpn != null) {
            usedIDs.addAll(dpn);
        }
    }

    public String getTargetKey() {
        return this.target_;
    }

    public String getTargetName(SourceSrc sources) {
        return sources.getTarget(this.target_);
    }

    public void setTargetKey(String targKey) {
        this.target_ = targKey;
    }

    public boolean notForTableDisplay() {
        if (this.legacyVal_ == null) {
            return false;
        }
        return this.legacyVal_.unknownMultiCount;
    }

    public double getValue() {
        if (this.legacyVal_ != null) {
            throw new IllegalStateException();
        }
        return this.value_;
    }

    public void setValue(double val) {
        if (this.legacyVal_ != null) {
            throw new IllegalStateException();
        }
        this.value_ = val;
    }

    public String getScaledDisplayValue(String key, SourceSrc ss, boolean hiRes) {
        if (key == null || this.legacyVal_ != null) {
            return this.getDisplayValue();
        }
        Double scaled = this.doScaling(key, ss);
        if (scaled == null) {
            return Double.toString(this.value_);
        }
        return UiUtil.doubleFormat(scaled, hiRes);
    }

    public Double getScaledNumericValue(String key, SourceSrc ss) {
        if (key == null || this.legacyVal_ != null) {
            return null;
        }
        if (this.isSignificant_ != null && !this.isSignificant_.booleanValue()) {
            return null;
        }
        Double scaled = this.doScaling(key, ss);
        if (scaled == null) {
            return new Double(this.value_);
        }
        return scaled;
    }

    private Double doScaling(String key, SourceSrc ss) {
        return this.doScalingOfaVal(key, ss, this.value_);
    }

    private Double doScalingOfaVal(String key, SourceSrc ss, double value) {
        MeasureDictionary md = ss.getMeasureDictionary();
        MeasureProps mp = md.getMeasureProps(this.measureTypeKey_);
        String myScaleKey = mp.getScaleKey();
        if (key.equals(myScaleKey)) {
            return null;
        }
        String standard = md.getStandardScaleKeys()[0];
        MeasureScale myScale = md.getMeasureScale(myScaleKey);
        MeasureScale.Conversion convertVal = myScale.getConvToFold();
        if (convertVal == null) {
            throw new IllegalArgumentException();
        }
        double asFold = convertVal.toFold(value);
        if (key.equals(standard)) {
            return new Double(asFold);
        }
        MeasureScale destScale = md.getMeasureScale(key);
        MeasureScale.Conversion destConvertVal = destScale.getConvToFold();
        if (destConvertVal == null) {
            throw new IllegalArgumentException();
        }
        double fromFold = destConvertVal.fromFold(asFold);
        return new Double(fromFold);
    }

    public String getDisplayValue() {
        if (this.legacyVal_ != null) {
            return this.legacyVal_.oldValue;
        }
        return Double.toString(this.value_);
    }

    public String getScaledDisplayValueOldStyle(String key, SourceSrc ss, boolean hiRes) {
        Experiment psi = ss.getExperiment(this.experimentKey_);
        DoubMinMax dmm = psi.getThresholds(this.measureTypeKey_, ss);
        if (this.isSignificant_ != null) {
            return this.isSignificant_ != false ? this.getScaledDisplayValue(key, ss, hiRes) : "NS";
        }
        if (this.legacyVal_ != null) {
            return this.legacyVal_.oldValue;
        }
        if (!dmm.outsideOrOnBoundary(this.value_)) {
            return "NS";
        }
        return this.getScaledDisplayValue(key, ss, hiRes);
    }

    public boolean isSignificant(double posThreshold, double negThreshold) {
        if (this.isSignificant_ != null) {
            return this.isSignificant_;
        }
        if (this.legacyVal_ != null) {
            return false;
        }
        if (this.value_ <= negThreshold) {
            return true;
        }
        return this.value_ >= posThreshold;
    }

    public Boolean getForcedSignificance() {
        return this.isSignificant_;
    }

    public TrueObjChoiceContent getForcedSignificanceChoice() {
        return PertDataPoint.getSignificanceChoice(this.isSignificant_);
    }

    public String getControl() {
        return this.control_;
    }

    public String getComment() {
        return this.comments_;
    }

    public void writeXML(PrintWriter out, Indenter ind, SourceSrc src) {
        List notes;
        ind.indent();
        out.print("<dataPt id=\"");
        out.print(this.idKey_);
        out.print("\" trg=\"");
        out.print(CharacterEntityMapper.mapEntities(this.target_, false));
        out.print("\" src=\"");
        out.print(this.experimentKey_);
        out.print("\" meas=\"");
        out.print(this.measureTypeKey_);
        out.print("\"");
        if (this.legacyVal_ != null) {
            out.print(" ");
            this.legacyVal_.writeXMLSupport(out);
        } else {
            out.print(" val=\"");
            out.print(this.value_);
            out.print("\"");
        }
        if (this.date_ != null) {
            out.print(" date=\"");
            out.print(CharacterEntityMapper.mapEntities(this.date_, false));
            out.print("\"");
        }
        if (this.control_ != null && !this.control_.trim().equals("")) {
            out.print(" ctrl=\"");
            out.print(CharacterEntityMapper.mapEntities(this.control_, false));
            out.print("\"");
        }
        if (this.isSignificant_ != null) {
            out.print(" fSig=\"");
            out.print(this.isSignificant_);
            out.print("\"");
        }
        if (this.batchID_ != null && !this.batchID_.trim().equals("")) {
            out.print(" bID=\"");
            out.print(CharacterEntityMapper.mapEntities(this.batchID_, false));
            out.print("\"");
        }
        if (this.comments_ != null && !this.comments_.trim().equals("")) {
            out.print(" cmt=\"");
            out.print(CharacterEntityMapper.mapEntities(this.comments_, false));
            out.print("\"");
        }
        if (this.timeStamp_ != 0L) {
            out.print(" ts=\"");
            out.print(this.timeStamp_);
            out.print("\"");
        }
        if ((notes = src.getDataPointNotes(this.idKey_)) != null && !notes.isEmpty()) {
            String notesStr = Splitter.tokenJoin(notes, ",");
            out.print(" notes=\"");
            out.print(notesStr);
            out.print("\"");
        }
        out.println("/>");
    }

    public String displayString(double posThreshold, double negThreshold, SourceSrc ss) {
        StringBuffer buf = new StringBuffer();
        if (!this.isSignificant(posThreshold, negThreshold)) {
            buf.append("NS");
        }
        if (this.value_ > 0.0) {
            buf.append("+");
        }
        buf.append(this.value_);
        List annots = ss.getDataPointNotes(this.idKey_);
        if (annots != null) {
            buf.append(" [");
            String fns = ss.getFootnoteListAsString(annots);
            buf.append(fns);
            buf.append("]");
        }
        return buf.toString();
    }

    public String toString() {
        return "PertDataPoint: value = " + this.value_ + " target = " + this.target_;
    }

    public static Boolean convertSigInput(String isValid) {
        if (isValid != null) {
            if ((isValid = isValid.trim()).equalsIgnoreCase("YES") || isValid.equalsIgnoreCase("Y")) {
                return new Boolean(true);
            }
            if (!isValid.equals("")) {
                return new Boolean(false);
            }
            return null;
        }
        return null;
    }

    public static boolean sigCSVInputOK(String isValid) {
        String string = isValid = isValid == null ? "" : isValid.trim();
        return isValid.equals("") || isValid.equalsIgnoreCase("YES") || isValid.equalsIgnoreCase("Y") || isValid.equalsIgnoreCase("NO") || isValid.equalsIgnoreCase("N") || isValid.equalsIgnoreCase("NS");
    }

    public static boolean isValidForMissingData(String val) {
        if (val == null) {
            return false;
        }
        val = val.trim();
        int len = val.length();
        for (int i = 0; i < len; ++i) {
            if (val.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isBelowThreshold(String val, Boolean sigTag, double negThresh, double posThresh) {
        if (val == null) {
            return false;
        }
        String trim = val.trim();
        if (trim.equalsIgnoreCase("NS")) {
            return true;
        }
        if (PertDataPoint.isValidForMissingData(trim)) {
            return false;
        }
        if (sigTag != null) {
            return sigTag == false;
        }
        double doubVal = 0.0;
        try {
            doubVal = Double.parseDouble(trim);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException();
        }
        if (doubVal < 0.0) {
            return doubVal > negThresh;
        }
        return doubVal < posThresh;
    }

    public static boolean isNotSignificant(String val, Boolean sigTag, double negThresh, double posThresh) {
        return PertDataPoint.isBelowThreshold(val, sigTag, negThresh, posThresh);
    }

    public static Vector getSignificanceOptions() {
        Vector<TrueObjChoiceContent> retval = new Vector<TrueObjChoiceContent>();
        retval.add(PertDataPoint.getSignificanceChoice(null));
        retval.add(PertDataPoint.getSignificanceChoice(new Boolean(false)));
        retval.add(PertDataPoint.getSignificanceChoice(new Boolean(true)));
        return retval;
    }

    public static TrueObjChoiceContent getSignificanceChoice(Boolean sig) {
        ResourceManager rMan = ResourceManager.getManager();
        if (sig == null) {
            return new TrueObjChoiceContent(rMan.getString("pertData.sigNotSet"), null);
        }
        if (!sig.booleanValue()) {
            return new TrueObjChoiceContent(rMan.getString("pertData.notSig"), new Boolean(false));
        }
        return new TrueObjChoiceContent(rMan.getString("pertData.isSig"), new Boolean(true));
    }

    public static class ValueAndUnits {
        private double val_;
        private String scaleKey_;
        private boolean sigPerPertThresh_;
        private boolean sigWasForced_;
        private String batchID_;

        public ValueAndUnits(double val, String scaleKey, boolean sigPerPertThresh, boolean wasForced, String batchID) {
            this.val_ = val;
            this.scaleKey_ = scaleKey;
            this.sigPerPertThresh_ = sigPerPertThresh;
            this.sigWasForced_ = wasForced;
            this.batchID_ = batchID;
        }

        public String getScaleKey() {
            return this.scaleKey_;
        }

        public double getValue() {
            return this.val_;
        }

        public boolean getIsSignificant() {
            return this.sigPerPertThresh_;
        }

        public boolean getIsForced() {
            return this.sigWasForced_;
        }

        public String getBatchID() {
            return this.batchID_;
        }

        public static List convertToFlattenedDoubles(List aList) {
            ArrayList<Double> retval = new ArrayList<Double>();
            int numA = aList.size();
            for (int i = 0; i < numA; ++i) {
                retval.add(new Double(((ValueAndUnits)aList.get((int)i)).val_));
            }
            return retval;
        }

        public static List convertToBatchedDoubles(List aList) {
            HashMap<String, ArrayList<Double>> batToDoubles = new HashMap<String, ArrayList<Double>>();
            int numA = aList.size();
            for (int i = 0; i < numA; ++i) {
                ValueAndUnits vau = (ValueAndUnits)aList.get(i);
                ArrayList<Double> forBat = (ArrayList<Double>)batToDoubles.get(vau.batchID_);
                if (forBat == null) {
                    forBat = new ArrayList<Double>();
                    batToDoubles.put(vau.batchID_, forBat);
                }
                forBat.add(new Double(vau.val_));
            }
            return new ArrayList(batToDoubles.values());
        }

        public static List convertToFlattenedBooleans(List aList) {
            ArrayList<Boolean> retval = new ArrayList<Boolean>();
            int numA = aList.size();
            for (int i = 0; i < numA; ++i) {
                ValueAndUnits vau = (ValueAndUnits)aList.get(i);
                retval.add(new Boolean(vau.sigPerPertThresh_));
            }
            return retval;
        }

        public static List convertToBatchedBooleans(List aList) {
            HashMap<String, ArrayList<Boolean>> batToBools = new HashMap<String, ArrayList<Boolean>>();
            int numA = aList.size();
            for (int i = 0; i < numA; ++i) {
                ValueAndUnits vau = (ValueAndUnits)aList.get(i);
                ArrayList<Boolean> forBat = (ArrayList<Boolean>)batToBools.get(vau.batchID_);
                if (forBat == null) {
                    forBat = new ArrayList<Boolean>();
                    batToBools.put(vau.batchID_, forBat);
                }
                forBat.add(new Boolean(vau.sigPerPertThresh_));
            }
            return new ArrayList(batToBools.values());
        }

        private static List convertToBatchedVAUs(List aList) {
            HashMap<String, ArrayList<ValueAndUnits>> batToDoubles = new HashMap<String, ArrayList<ValueAndUnits>>();
            int numA = aList.size();
            for (int i = 0; i < numA; ++i) {
                ValueAndUnits vau = (ValueAndUnits)aList.get(i);
                ArrayList<ValueAndUnits> forBat = (ArrayList<ValueAndUnits>)batToDoubles.get(vau.batchID_);
                if (forBat == null) {
                    forBat = new ArrayList<ValueAndUnits>();
                    batToDoubles.put(vau.batchID_, forBat);
                }
                forBat.add(vau);
            }
            return new ArrayList(batToDoubles.values());
        }

        public static List convertToBatchedDoublesWithSig(List aList, Double unch, double neg, double pos) {
            List bList = ValueAndUnits.convertToBatchedVAUs(aList);
            ArrayList retval = new ArrayList();
            int numB = bList.size();
            for (int i = 0; i < numB; ++i) {
                List vauList = (List)bList.get(i);
                ArrayList<Double> batList = new ArrayList<Double>();
                retval.add(batList);
                int numV = vauList.size();
                for (int j = 0; j < numV; ++j) {
                    ValueAndUnits vau = (ValueAndUnits)vauList.get(j);
                    Double doub = ValueAndUnits.convertVAUWithSig(vau, unch, neg, pos);
                    batList.add(doub);
                }
            }
            return retval;
        }

        public static Double convertVAUWithSig(ValueAndUnits vau, Double unch, double neg, double pos) {
            if (!vau.sigWasForced_) {
                return new Double(vau.val_);
            }
            if (!vau.sigPerPertThresh_) {
                return unch;
            }
            if (vau.val_ <= neg || vau.val_ >= pos) {
                return new Double(vau.val_);
            }
            double negDiff = vau.val_ - neg;
            double posDiff = pos - vau.val_;
            return new Double(negDiff < posDiff ? neg : pos);
        }
    }

    public static class Parameters {
        private String convKey_;

        public Parameters() {
            MeasureDictionary md = Database.getDB().getPertData().getMeasureDictionary();
            this.convKey_ = md.getStandardScaleKeys()[2];
        }

        public Double getNotSigDoub() {
            MeasureDictionary md = Database.getDB().getPertData().getMeasureDictionary();
            return md.getMeasureScale(this.convKey_).getUnchanged();
        }

        public String getConvKey() {
            return this.convKey_;
        }
    }

    public static class PertDataPointWorker
    extends AbstractFactoryClient {
        public PertDataPointWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("dataPt");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            AugPertDataPoint retval = null;
            if (elemName.equals("dataPt")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.augPertDataPt = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private AugPertDataPoint buildFromXML(String elemName, Attributes attrs) throws IOException {
            String comment;
            String ctrl;
            String date;
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "id", true);
            String targ = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "trg", true);
            targ = CharacterEntityMapper.unmapEntities(targ, false);
            String src = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "src", true);
            LegacyPert lp = LegacyPert.buildFromXMLSupport(elemName, attrs);
            String meas = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "meas", true);
            String valStr = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "val", false);
            if (lp != null && valStr != null) {
                throw new IOException();
            }
            double vNum = 0.0;
            if (valStr != null) {
                try {
                    vNum = Double.parseDouble(valStr);
                }
                catch (NumberFormatException nfex) {
                    throw new IOException();
                }
            }
            if ((date = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "date", false)) != null) {
                date = CharacterEntityMapper.unmapEntities(date, false);
            }
            if ((ctrl = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "ctrl", false)) != null) {
                ctrl = CharacterEntityMapper.unmapEntities(ctrl, false);
            }
            String sigStr = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "fSig", false);
            Boolean isSig = null;
            if (sigStr != null) {
                isSig = Boolean.valueOf(sigStr);
            }
            if (lp != null && isSig != null) {
                throw new IOException();
            }
            String batchID = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "bID", false);
            if (batchID != null) {
                batchID = CharacterEntityMapper.unmapEntities(batchID, false);
            }
            if ((comment = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "cmt", false)) != null) {
                comment = CharacterEntityMapper.unmapEntities(comment, false);
            }
            String tsStr = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "ts", false);
            long timeStamp = 0L;
            if (tsStr != null) {
                try {
                    timeStamp = Long.parseLong(tsStr);
                }
                catch (NumberFormatException nfex) {
                    throw new IOException();
                }
            }
            String noteStr = AttributeExtractor.extractAttribute(elemName, attrs, "dataPt", "notes", false);
            ArrayList noteList = null;
            if (noteStr != null) {
                noteList = Splitter.stringBreak(noteStr, ",", 0, false);
            }
            PertDataPoint pdp = new PertDataPoint(id, timeStamp, src, targ, meas, vNum);
            if (lp != null) {
                pdp.setLegacyPert(lp);
                pdp.setIsSig(null);
            } else if (isSig != null) {
                pdp.setIsSig(isSig);
            }
            pdp.setBatchKey(batchID);
            pdp.setDate(date);
            pdp.setComment(comment);
            pdp.setControl(ctrl);
            return new AugPertDataPoint(pdp, noteList);
        }
    }

    public static class AugPertDataPoint {
        public PertDataPoint pdp;
        public List notes;

        public AugPertDataPoint(PertDataPoint pdp, List notes) {
            this.pdp = pdp;
            this.notes = notes;
        }
    }
}

