/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class PertDictionary
implements Cloneable {
    public static final int PERT_POS_LINK_POS = 0;
    public static final int PERT_NEG_LINK_POS = 1;
    public static final int PERT_ALWAYS_NEGATIVE = 2;
    public static final int PERT_ALWAYS_POSITIVE = 3;
    public static final int PERT_LINK_NO_RELATION = 4;
    public static final int PERT_LINK_OTHER = 5;
    private static final int NUM_PERT_LINK_REL_ = 6;
    public static final String PERT_POS_LINK_POS_STR_ = "pertPosLinkPos";
    public static final String PERT_NEG_LINK_POS_STR_ = "pertNegLinkPos";
    public static final String PERT_ALWAYS_NEGATIVE_STR_ = "pertAlwaysNeg";
    public static final String PERT_ALWAYS_POSITIVE_STR_ = "pertAlwaysPos";
    public static final String PERT_LINK_NO_RELATION_STR_ = "pertLinkNoRelation";
    public static final String PERT_LINK_OTHER_STR_ = "pertLinkOther";
    public static final int MASSIVE_HACKO_LEGACY_MASO_TYPE = 0;
    public static final int MASSIVE_HACKO_LEGACY_MOE_TYPE = 1;
    public static final int MASSIVE_HACKO_LEGACY_ENGRAILED_TYPE = 2;
    private static final String MASO_TYPE_ = "MASO";
    private static final String MOE_TYPE_ = "MOE";
    private static final String ENGRAILED_TYPE_ = "Engrailed";
    private static final String ENGRAILED_ABBREV_ = "-En";
    private static final String ENGRAILED_ALT_ = "EN";
    private HashMap perts_ = new HashMap();
    private UniqueLabeller labels_ = new UniqueLabeller();

    public String getNextDataKey() {
        return this.labels_.getNextLabel();
    }

    public Vector getLinkRelationshipOptions() {
        Vector<TrueObjChoiceContent> retval = new Vector<TrueObjChoiceContent>();
        for (int i = 0; i < 6; ++i) {
            retval.add(this.getRelationshipChoice(i));
        }
        return retval;
    }

    public TrueObjChoiceContent getRelationshipChoice(int val) {
        ResourceManager rMan = ResourceManager.getManager();
        String tag = PertDictionary.mapPertLinkValToTag(val);
        return new TrueObjChoiceContent(rMan.getString("pertDict.relation" + tag), new Integer(val));
    }

    public Object clone() {
        try {
            PertDictionary newVal = (PertDictionary)super.clone();
            newVal.perts_ = new HashMap();
            Iterator psit = this.perts_.keySet().iterator();
            while (psit.hasNext()) {
                String psKey = (String)psit.next();
                newVal.perts_.put(psKey, ((PertProperties)this.perts_.get(psKey)).clone());
            }
            newVal.labels_ = (UniqueLabeller)this.labels_.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public void createAllLegacyPerturbProps() {
        this.createLegacyPerturbProp(MASO_TYPE_);
        this.createLegacyPerturbProp(MOE_TYPE_);
        this.createLegacyPerturbProp(ENGRAILED_TYPE_);
    }

    public Iterator getKeys() {
        TreeSet ordered = new TreeSet(this.perts_.keySet());
        Iterator oit = ordered.iterator();
        return oit;
    }

    public int getPerturbPropsCount() {
        return this.perts_.size();
    }

    public PertProperties getPerturbProps(String key) {
        return (PertProperties)this.perts_.get(key);
    }

    public Set getPerturbPropNameSet() {
        HashSet<String> retval = new HashSet<String>();
        Iterator ckit = this.perts_.values().iterator();
        while (ckit.hasNext()) {
            PertProperties ec = (PertProperties)ckit.next();
            retval.add(ec.getType());
        }
        return retval;
    }

    public void setPerturbProp(PertProperties pProps) {
        this.perts_.put(pProps.getID(), pProps);
    }

    public void addPerturbPropForIO(PertProperties pProps) {
        String id = pProps.getID();
        this.labels_.addExistingLabel(id);
        this.perts_.put(id, pProps);
    }

    public void dropPerturbProp(String key) {
        this.perts_.remove(key);
        this.labels_.removeLabel(key);
    }

    public String getPerturbPropsFromName(String legacyStr) {
        Iterator pit = this.perts_.keySet().iterator();
        while (pit.hasNext()) {
            String key = (String)pit.next();
            PertProperties pp = (PertProperties)this.perts_.get(key);
            if (!DataUtil.keysEqual(pp.getType(), legacyStr)) continue;
            return key;
        }
        return null;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<pertDictionary>");
        ind.up();
        TreeSet ordered = new TreeSet(this.perts_.keySet());
        Iterator oit = ordered.iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            PertProperties pp = (PertProperties)this.perts_.get(key);
            pp.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</pertDictionary>");
    }

    public String createLegacyPerturbProp(String expType) {
        PertProperties legPP;
        String newID = this.labels_.getNextLabel();
        if (expType.equalsIgnoreCase(MASO_TYPE_)) {
            legPP = new PertProperties(newID, MASO_TYPE_, null, 1);
        } else if (expType.equalsIgnoreCase(MOE_TYPE_)) {
            legPP = new PertProperties(newID, MOE_TYPE_, null, 0);
        } else if (expType.equalsIgnoreCase(ENGRAILED_TYPE_)) {
            legPP = new PertProperties(newID, ENGRAILED_TYPE_, ENGRAILED_ABBREV_, 2);
            legPP.setLegacyAlt(ENGRAILED_ALT_);
        } else {
            throw new IllegalArgumentException();
        }
        this.perts_.put(newID, legPP);
        return newID;
    }

    public String getLegacyKeyMassiveHacko(int legacyType) {
        String lookFor;
        if (legacyType == 0) {
            lookFor = MASO_TYPE_;
        } else if (legacyType == 1) {
            lookFor = MOE_TYPE_;
        } else if (legacyType == 2) {
            lookFor = ENGRAILED_TYPE_;
        } else {
            throw new IllegalArgumentException();
        }
        Iterator pkit = this.perts_.keySet().iterator();
        while (pkit.hasNext()) {
            String key = (String)pkit.next();
            PertProperties pp = (PertProperties)this.perts_.get(key);
            if (!pp.getType().equals(lookFor)) continue;
            return key;
        }
        throw new IllegalStateException();
    }

    public void getNVPairs(Map nvPairs, Set allNames, Set allVals) {
        Iterator pkit = this.perts_.keySet().iterator();
        while (pkit.hasNext()) {
            String key = (String)pkit.next();
            PertProperties pp = (PertProperties)this.perts_.get(key);
            Iterator kit = pp.getNvpKeys();
            while (kit.hasNext()) {
                String name = (String)kit.next();
                String value = pp.getValue(name);
                String normName = DataUtil.normKey(name);
                HashSet<String> valsForName = (HashSet<String>)nvPairs.get(normName);
                if (valsForName == null) {
                    valsForName = new HashSet<String>();
                    nvPairs.put(normName, valsForName);
                }
                allNames.add(name);
                allVals.add(value);
                valsForName.add(value);
            }
        }
    }

    public Vector getExperimentTypes() {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        Iterator oit = this.perts_.keySet().iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            sorted.add(this.getExperimentTypeChoice(key));
        }
        return new Vector(sorted);
    }

    public TrueObjChoiceContent getExperimentTypeChoice(String pertKey) {
        PertProperties pp = (PertProperties)this.perts_.get(pertKey);
        return new TrueObjChoiceContent(pp.getType(), pertKey);
    }

    public static boolean linkSignUndetermined(int relation) {
        switch (relation) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String mapPertLinkValToTag(int value) {
        switch (value) {
            case 0: {
                return PERT_POS_LINK_POS_STR_;
            }
            case 1: {
                return PERT_NEG_LINK_POS_STR_;
            }
            case 2: {
                return PERT_ALWAYS_NEGATIVE_STR_;
            }
            case 3: {
                return PERT_ALWAYS_POSITIVE_STR_;
            }
            case 4: {
                return PERT_LINK_NO_RELATION_STR_;
            }
            case 5: {
                return PERT_LINK_OTHER_STR_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapPertLinkTagToVal(String tag) {
        if (tag.equals(PERT_POS_LINK_POS_STR_)) {
            return 0;
        }
        if (tag.equals(PERT_NEG_LINK_POS_STR_)) {
            return 1;
        }
        if (tag.equals(PERT_ALWAYS_NEGATIVE_STR_)) {
            return 2;
        }
        if (tag.equals(PERT_ALWAYS_POSITIVE_STR_)) {
            return 3;
        }
        if (tag.equals(PERT_LINK_NO_RELATION_STR_)) {
            return 4;
        }
        if (tag.equals(PERT_LINK_OTHER_STR_)) {
            return 5;
        }
        throw new IllegalArgumentException();
    }

    public static class MyPropsGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            PertDictionary pDict = board.pDict;
            PertProperties pProps = board.pertProps;
            pDict.addPerturbPropForIO(pProps);
            return null;
        }
    }

    public static class PertDictionaryWorker
    extends AbstractFactoryClient {
        public PertDictionaryWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pertDictionary");
            this.installWorker(new PertProperties.PertPropsWorker(whiteboard), new MyPropsGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            PertDictionary retval = null;
            if (elemName.equals("pertDictionary")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.pDict = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private PertDictionary buildFromXML(String elemName, Attributes attrs) throws IOException {
            PertDictionary pDict = new PertDictionary();
            return pDict;
        }
    }
}

