/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biotapestry.perturb.PertFilterOpTarget;
import org.systemsbiology.biotapestry.perturb.PertFilterTarget;
import org.systemsbiology.biotapestry.perturb.SourceSrc;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;

public class PertFilter
implements Cloneable,
PertFilterOpTarget {
    public static final int EXPERIMENT = 0;
    public static final int SOURCE = 1;
    public static final int SOURCE_NAME = 2;
    public static final int SOURCE_OR_PROXY_NAME = 3;
    public static final int PERT = 4;
    public static final int TARGET = 5;
    public static final int TIME = 6;
    public static final int VALUE = 7;
    public static final int INVEST = 8;
    public static final int INVEST_LIST = 9;
    public static final int EXP_CONTROL = 10;
    public static final int EXP_CONDITION = 11;
    public static final int MEASURE_SCALE = 12;
    public static final int ANNOTATION = 13;
    public static final int MEASURE_TECH = 14;
    public static final int NUM_CAT = 15;
    public static final String INVEST_STR = "Investigator";
    public static final String INVEST_LIST_STR = "InvestigatorList";
    public static final int STR_EQUALS = 0;
    public static final int STR_CONTAINS = 1;
    public static final int NUMB_EQ = 2;
    public static final int NUMB_GTE = 3;
    public static final int NUMB_LTE = 4;
    public static final int NUMB_ABS_GTE = 5;
    public static final int NUMB_ABS_LTE = 6;
    public static final int RANGE_EQUALS = 7;
    public static final int RANGE_OVERLAPS = 8;
    public static final int ABOVE_THRESH = 9;
    public static final int IS_SIGNIFICANT = 10;
    private int category_;
    private Object value_;
    private int matchType_;

    public PertFilter(int category, int matchType, Object value) {
        this.category_ = category;
        this.value_ = value;
        this.matchType_ = matchType;
    }

    public Object clone() {
        try {
            PertFilter newVal = (PertFilter)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int getCategory() {
        return this.category_;
    }

    public String getStringValue() {
        return (String)this.value_;
    }

    public double getDoubleValue() {
        return (Double)this.value_;
    }

    public int getIntValue() {
        return (Integer)this.value_;
    }

    public MinMax getIntRangeValue() {
        return (MinMax)this.value_;
    }

    public int getMatchType() {
        return this.matchType_;
    }

    public SortedSet getFilteredResult(SortedSet input, SortedMap source, SourceSrc ss) {
        TreeSet<String> retval = new TreeSet<String>();
        Iterator iit = input.iterator();
        while (iit.hasNext()) {
            String key = (String)iit.next();
            PertFilterTarget pft = (PertFilterTarget)source.get(key);
            if (!pft.matchesFilter(this, ss)) continue;
            retval.add(key);
        }
        return retval;
    }

    public String toString() {
        return "[pertFilt: " + this.category_ + ",t=" + this.matchType_ + ",v=" + this.value_ + "]";
    }

    public static Vector getMatchOptions() {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        sorted.add(PertFilter.getMatchOptionsChoice(0));
        sorted.add(PertFilter.getMatchOptionsChoice(1));
        return new Vector(sorted);
    }

    public static TrueObjChoiceContent getMatchOptionsChoice(int choice) {
        if (choice == 0) {
            return new TrueObjChoiceContent(ResourceManager.getManager().getString("pertFilt.equals"), new Integer(choice));
        }
        if (choice == 1) {
            return new TrueObjChoiceContent(ResourceManager.getManager().getString("pertFilt.contains"), new Integer(choice));
        }
        throw new IllegalArgumentException();
    }

    public static String mapCategory(int cat) {
        switch (cat) {
            case 8: {
                return INVEST_STR;
            }
            case 9: {
                return INVEST_LIST_STR;
            }
        }
        throw new IllegalArgumentException();
    }
}

