/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterOpTarget;
import org.systemsbiology.biotapestry.perturb.SourceSrc;

public class PertFilterExpression
implements Cloneable,
PertFilterOpTarget {
    public static final int NEVER_OP = 0;
    public static final int ALWAYS_OP = 1;
    public static final int NO_OP = 2;
    public static final int AND_OP = 3;
    public static final int OR_OP = 4;
    public static final int NOT_OP = 5;
    private static final int NUM_OP_ = 6;
    private int op_;
    private PertFilterOpTarget target1_;
    private PertFilterOpTarget target2_;

    public PertFilterExpression(int op, PertFilterOpTarget targ1, PertFilterOpTarget targ2) {
        this.op_ = op;
        this.target1_ = targ1;
        this.target2_ = targ2;
    }

    public PertFilterExpression(PertFilter filter) {
        this.op_ = 2;
        this.target1_ = filter;
        this.target2_ = null;
    }

    public PertFilterExpression(int useop) {
        if (useop != 0 && useop != 1) {
            throw new IllegalArgumentException();
        }
        this.op_ = useop;
        this.target1_ = null;
        this.target2_ = null;
    }

    public boolean isAlwaysFilter() {
        return this.op_ == 1;
    }

    public boolean isNeverFilter() {
        return this.op_ == 0;
    }

    public Object clone() {
        try {
            PertFilterExpression newVal = (PertFilterExpression)super.clone();
            newVal.target1_ = this.target1_ instanceof PertFilter ? (PertFilter)((PertFilter)this.target1_).clone() : (PertFilterExpression)((PertFilterExpression)this.target1_).clone();
            if (this.target2_ != null) {
                newVal.target2_ = this.target2_ instanceof PertFilter ? (PertFilter)((PertFilter)this.target2_).clone() : (PertFilterExpression)((PertFilterExpression)this.target2_).clone();
            }
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int getOperator() {
        return this.op_;
    }

    public PertFilterOpTarget getTarget1() {
        return this.target1_;
    }

    public PertFilterOpTarget getTarget2() {
        return this.target2_;
    }

    public String toString() {
        return "(pertExp: " + this.op_ + "," + this.target1_ + "," + this.target2_ + ")";
    }

    public SortedSet getFilteredResult(SortedSet input, SortedMap source, SourceSrc ss) {
        if (this.isAlwaysFilter()) {
            return input;
        }
        if (this.isNeverFilter()) {
            return new TreeSet();
        }
        SortedSet t1Result = this.target1_.getFilteredResult(input, source, ss);
        if (this.op_ == 2) {
            return t1Result;
        }
        if (this.op_ == 5) {
            TreeSet retval = new TreeSet(input);
            retval.removeAll(t1Result);
            return retval;
        }
        SortedSet t2Result = this.target2_.getFilteredResult(input, source, ss);
        TreeSet retval = new TreeSet(t1Result);
        if (this.op_ == 3) {
            retval.retainAll(t2Result);
        } else if (this.op_ == 4) {
            retval.addAll(t2Result);
        } else {
            throw new IllegalStateException();
        }
        return retval;
    }
}

