/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.xml.sax.Attributes;

public class PertProperties
implements Cloneable {
    public static final int UNSIGNED_LINK = 0;
    public static final int REPRESS_LINK = 1;
    public static final int PROMOTE_LINK = 2;
    public static final int NO_LINK = 3;
    private String id_;
    private String expType_;
    private String expAbbrev_;
    private String legacyAltTag_;
    private int linkRelation_;
    private HashMap nameValuePairs_;

    public PertProperties(String id, String type, String abbrev, int linkRelation) {
        this.id_ = id;
        this.expType_ = type;
        this.expAbbrev_ = abbrev;
        this.legacyAltTag_ = null;
        this.linkRelation_ = linkRelation;
        this.nameValuePairs_ = new HashMap();
    }

    public boolean semiEquals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof PertProperties)) {
            return false;
        }
        PertProperties otherPP = (PertProperties)other;
        if (!this.expType_.equalsIgnoreCase(otherPP.expType_)) {
            return false;
        }
        if (this.legacyAltTag_ == null ? otherPP.legacyAltTag_ != null : !this.legacyAltTag_.equalsIgnoreCase(otherPP.legacyAltTag_)) {
            return false;
        }
        return this.linkRelation_ == otherPP.linkRelation_;
    }

    public int getRelationWithProxy(String proxSign) {
        boolean reverse = proxSign.equals("oppositeSign");
        switch (this.linkRelation_) {
            case 0: {
                return reverse ? 1 : this.linkRelation_;
            }
            case 1: {
                return reverse ? 0 : this.linkRelation_;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.linkRelation_;
            }
        }
        throw new IllegalArgumentException();
    }

    public int resolveWithProxy(String proxSign, double value, double unchanged) {
        return PertProperties.resolve(this.getRelationWithProxy(proxSign), value, unchanged);
    }

    public int resolve(double value, double unchanged) {
        return PertProperties.resolve(this.linkRelation_, value, unchanged);
    }

    public int getLinkSignRelationship() {
        return this.linkRelation_;
    }

    public void setLinkSignRelationship(int lsRel) {
        this.linkRelation_ = lsRel;
    }

    public String getID() {
        return this.id_;
    }

    public String getLegacyAlt() {
        return this.legacyAltTag_;
    }

    public void setLegacyAlt(String altTag) {
        this.legacyAltTag_ = altTag;
    }

    public String getType() {
        return this.expType_;
    }

    public String getLegacyType() {
        return this.legacyAltTag_ == null ? this.expType_ : this.legacyAltTag_;
    }

    public String getAbbrev() {
        return this.expAbbrev_;
    }

    public void setType(String type) {
        this.expType_ = type;
    }

    public void setAbbrev(String abbrev) {
        this.expAbbrev_ = abbrev;
    }

    public String getValue(String key) {
        return (String)this.nameValuePairs_.get(key);
    }

    public boolean getBooleanValue(String key) {
        String val = (String)this.nameValuePairs_.get(key);
        return val != null && Boolean.valueOf(val) != false;
    }

    public void setNameValue(NameValuePair nvPair) {
        if (this.nameValuePairs_.get(nvPair.getName()) != null) {
            throw new IllegalArgumentException();
        }
        this.nameValuePairs_.put(nvPair.getName(), nvPair.getValue());
    }

    public void clearNameValuePairs() {
        this.nameValuePairs_.clear();
    }

    public Iterator getNvpKeys() {
        TreeSet ordered = new TreeSet(this.nameValuePairs_.keySet());
        Iterator oit = ordered.iterator();
        return oit;
    }

    public TrueObjChoiceContent getExperimentTypeEntry() {
        return new TrueObjChoiceContent(this.expType_, this.id_);
    }

    public Object clone() {
        try {
            PertProperties newVal = (PertProperties)super.clone();
            newVal.nameValuePairs_ = new HashMap();
            Iterator nvpit = this.nameValuePairs_.keySet().iterator();
            while (nvpit.hasNext()) {
                String name = (String)nvpit.next();
                String val = (String)this.nameValuePairs_.get(name);
                newVal.nameValuePairs_.put(name, val);
            }
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<pertProp id=\"");
        out.print(this.id_);
        out.print("\" type=\"");
        out.print(CharacterEntityMapper.mapEntities(this.expType_, false));
        out.print("\"");
        out.print(" linkRel=\"");
        out.print(PertDictionary.mapPertLinkValToTag(this.linkRelation_));
        out.print("\"");
        if (this.expAbbrev_ != null) {
            out.print(" abbrev=\"");
            out.print(CharacterEntityMapper.mapEntities(this.expAbbrev_, false));
            out.print("\"");
        }
        if (this.legacyAltTag_ != null) {
            out.print(" altTag=\"");
            out.print(CharacterEntityMapper.mapEntities(this.legacyAltTag_, false));
            out.print("\"");
        }
        if (!this.nameValuePairs_.isEmpty()) {
            out.println(">");
            ind.up();
            TreeSet ordered = new TreeSet(this.nameValuePairs_.keySet());
            Iterator oit = ordered.iterator();
            while (oit.hasNext()) {
                String key = (String)oit.next();
                String val = (String)this.nameValuePairs_.get(key);
                ind.indent();
                out.print("<nVPair name=\"");
                out.print(CharacterEntityMapper.mapEntities(key, false));
                out.print("\" val=\"");
                out.print(CharacterEntityMapper.mapEntities(val, false));
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</pertProp>");
        } else {
            out.println("/>");
        }
    }

    public String toString() {
        return "PertProperty: " + this.expType_;
    }

    public static int mapLinkSignToMeasurementSign(int sign) {
        switch (sign) {
            case -1: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int resolve(int relation, double value, double unchanged) {
        switch (relation) {
            case 0: {
                return value >= unchanged ? 2 : 1;
            }
            case 1: {
                return value >= unchanged ? 1 : 2;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean consistent(int relation, int linkType, double value, Double unchangedObj) {
        switch (relation) {
            case 0: {
                if (unchangedObj == null) {
                    return false;
                }
                if (linkType == 0) {
                    return true;
                }
                return linkType == 2 ? value >= unchangedObj : value <= unchangedObj;
            }
            case 1: {
                if (unchangedObj == null) {
                    return false;
                }
                if (linkType == 0) {
                    return true;
                }
                return linkType == 1 ? value >= unchangedObj : value <= unchangedObj;
            }
            case 2: {
                if (unchangedObj == null) {
                    return false;
                }
                return value <= unchangedObj;
            }
            case 3: {
                if (unchangedObj == null) {
                    return false;
                }
                return value >= unchangedObj;
            }
            case 4: 
            case 5: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean signImpliesIndirect(int relation, double value, Double unchangedObj) {
        switch (relation) {
            case 2: {
                if (unchangedObj == null) {
                    return false;
                }
                return value >= unchangedObj;
            }
            case 3: {
                if (unchangedObj == null) {
                    return false;
                }
                return value <= unchangedObj;
            }
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    public static class NVPairWorker
    extends AbstractFactoryClient {
        public NVPairWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("nVPair");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NameValuePair retval = null;
            if (elemName.equals("nVPair")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.nvPair = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private NameValuePair buildFromXML(String elemName, Attributes attrs) throws IOException {
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "nVPair", "name", true);
            String val = AttributeExtractor.extractAttribute(elemName, attrs, "nVPair", "val", true);
            name = CharacterEntityMapper.unmapEntities(name, false);
            val = CharacterEntityMapper.unmapEntities(val, false);
            NameValuePair retval = new NameValuePair(name, val);
            return retval;
        }
    }

    public static class MyNVGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            PertProperties pProps = board.pertProps;
            NameValuePair nvp = board.nvPair;
            pProps.setNameValue(nvp);
            return null;
        }
    }

    public static class PertPropsWorker
    extends AbstractFactoryClient {
        public PertPropsWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pertProp");
            this.installWorker(new NVPairWorker(whiteboard), new MyNVGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            PertProperties retval = null;
            if (elemName.equals("pertProp")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.pertProps = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private PertProperties buildFromXML(String elemName, Attributes attrs) throws IOException {
            int linkRelVal;
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "pertProp", "id", true);
            String typeStr = AttributeExtractor.extractAttribute(elemName, attrs, "pertProp", "type", true);
            String linkRel = AttributeExtractor.extractAttribute(elemName, attrs, "pertProp", "linkRel", true);
            String abbrev = AttributeExtractor.extractAttribute(elemName, attrs, "pertProp", "abbrev", false);
            String altTag = AttributeExtractor.extractAttribute(elemName, attrs, "pertProp", "altTag", false);
            typeStr = CharacterEntityMapper.unmapEntities(typeStr, false);
            if (abbrev != null) {
                abbrev = CharacterEntityMapper.unmapEntities(abbrev, false);
            }
            if (altTag != null) {
                altTag = CharacterEntityMapper.unmapEntities(altTag, false);
            }
            try {
                linkRelVal = PertDictionary.mapPertLinkTagToVal(linkRel);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
            PertProperties retval = new PertProperties(id, typeStr, abbrev, linkRelVal);
            retval.setLegacyAlt(altTag);
            return retval;
        }
    }
}

