/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.perturb.PertAnnotations;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.SourceSrc;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.Splitter;
import org.xml.sax.Attributes;

public class PertSource
implements Cloneable {
    public static final int NO_PROXY_INDEX = 0;
    public static final String NO_PROXY = "noProxy";
    public static final String SAME_SIGN_PROXY = "sameSign";
    public static final String OPPOSITE_SIGN_PROXY = "oppositeSign";
    private String id_;
    private String srcNameKey_;
    private String proxyForKey_;
    private String proxySign_;
    private String typeKey_;
    private ArrayList annotations_;

    public PertSource(String id, String srcNameKey, String typeKey, String proxyForKey, String proxySign) throws IOException {
        this.id_ = id;
        this.srcNameKey_ = srcNameKey;
        this.annotations_ = new ArrayList();
        if (proxySign == null) {
            this.proxySign_ = NO_PROXY;
        } else {
            if (!(proxySign.equals(NO_PROXY) || proxySign.equals(SAME_SIGN_PROXY) || proxySign.equals(OPPOSITE_SIGN_PROXY))) {
                throw new IOException();
            }
            this.proxySign_ = proxySign;
        }
        if (typeKey == null) {
            throw new IOException();
        }
        this.typeKey_ = typeKey;
        if (proxyForKey != null && this.proxySign_.equals(NO_PROXY)) {
            throw new IOException();
        }
        this.proxyForKey_ = proxyForKey;
    }

    public PertSource(String id, String srcNameKey, String typeKey, List annotations) {
        this.id_ = id;
        this.srcNameKey_ = srcNameKey;
        this.typeKey_ = typeKey;
        this.proxyForKey_ = null;
        this.proxySign_ = NO_PROXY;
        this.annotations_ = new ArrayList(annotations);
    }

    public Object clone() {
        try {
            PertSource newVal = (PertSource)super.clone();
            newVal.annotations_ = (ArrayList)this.annotations_.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int getSign(SourceSrc ss) {
        PertDictionary pDict = ss.getPertDictionary();
        PertProperties pprops = this.getExpType(pDict);
        if (this.isAProxy()) {
            return pprops.getRelationWithProxy(this.getProxySign());
        }
        return pprops.getLinkSignRelationship();
    }

    public int compareSrcAndType(PertSource other) {
        int diff = this.srcNameKey_.compareTo(other.srcNameKey_);
        if (diff != 0) {
            return diff;
        }
        diff = this.typeKey_.compareTo(other.typeKey_);
        return diff;
    }

    public int hashCode() {
        int retval = this.id_.hashCode() + this.srcNameKey_.hashCode() + this.typeKey_.hashCode() + this.proxySign_.hashCode() + this.annotations_.hashCode();
        return retval += this.proxyForKey_ == null ? 0 : this.proxyForKey_.hashCode();
    }

    public boolean equals(Object other) {
        if (!this.equalsMinusID(other)) {
            return false;
        }
        PertSource otherPS = (PertSource)other;
        return this.id_.equals(otherPS.id_);
    }

    public boolean equalsMinusID(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof PertSource)) {
            return false;
        }
        PertSource otherPS = (PertSource)other;
        if (!this.srcNameKey_.equals(otherPS.srcNameKey_)) {
            return false;
        }
        if (!this.typeKey_.equals(otherPS.typeKey_)) {
            return false;
        }
        if (!this.proxySign_.equals(otherPS.proxySign_)) {
            return false;
        }
        if (!this.proxySign_.equals(NO_PROXY) && !this.proxyForKey_.equals(otherPS.proxyForKey_)) {
            return false;
        }
        return new HashSet(this.annotations_).equals(new HashSet(otherPS.annotations_));
    }

    public void setID(String id) {
        this.id_ = id;
    }

    public String getID() {
        return this.id_;
    }

    public List getAnnotationIDs() {
        return this.annotations_;
    }

    public void setAnnotationIDs(List annots) {
        this.annotations_.clear();
        this.annotations_.addAll(annots);
    }

    public PertProperties getExpType(PertDictionary pd) {
        return pd.getPerturbProps(this.typeKey_);
    }

    public String getExpTypeKey() {
        return this.typeKey_;
    }

    public void setExpType(String key) {
        this.typeKey_ = key;
    }

    public String getSourceName(SourceSrc ss) {
        return ss.getSourceName(this.srcNameKey_);
    }

    public String getSourceNameKey() {
        return this.srcNameKey_;
    }

    public void setSourceNameKey(String srcNameKey) {
        this.srcNameKey_ = srcNameKey;
    }

    public String getDisplayValue(SourceSrc ss) {
        StringBuffer buf = new StringBuffer();
        PertDictionary pd = ss.getPertDictionary();
        PertProperties pp = pd.getPerturbProps(this.typeKey_);
        String name = ss.getSourceName(this.srcNameKey_);
        buf.append(name);
        String useMe = pp.getAbbrev();
        if (useMe == null) {
            buf.append(" ");
            buf.append(pp.getType());
        } else {
            buf.append(useMe);
        }
        return buf.toString();
    }

    public String getDisplayValueWithFootnotes(SourceSrc ss, boolean asSuper) {
        PertAnnotations pa = ss.getPertAnnotations();
        StringBuffer buf = new StringBuffer();
        buf.append(this.getDisplayValue(ss));
        if (!this.annotations_.isEmpty()) {
            buf.append(asSuper ? "<sup>" : " [");
            buf.append(pa.getFootnoteListAsString(this.annotations_));
            buf.append(asSuper ? "</sup>" : "]");
        }
        return buf.toString();
    }

    public void setNotes(List notes) {
        this.annotations_.clear();
        this.annotations_.addAll(notes);
    }

    public void addNote(String note) {
        this.annotations_.add(note);
    }

    public void deleteNote(String noteID) {
        this.annotations_.remove(noteID);
    }

    public String getProxiedSpeciesKey() {
        return this.proxyForKey_;
    }

    public String getProxiedSpeciesName(SourceSrc ss) {
        return ss.getSourceName(this.proxyForKey_);
    }

    public void setProxiedSpeciesKey(String speciesKey) {
        this.proxyForKey_ = speciesKey;
    }

    public boolean isAProxy() {
        return !this.proxySign_.equals(NO_PROXY);
    }

    public String getProxySign() {
        return this.proxySign_;
    }

    public void setProxySign(String proxySign) {
        this.proxySign_ = proxySign;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<pertSrc id=\"");
        out.print(this.id_);
        out.print("\" src=\"");
        out.print(this.srcNameKey_);
        out.print("\" type=\"");
        out.print(this.typeKey_);
        out.print("\"");
        if (!this.proxySign_.equals(NO_PROXY)) {
            out.print(" proxy=\"");
            out.print(this.proxyForKey_);
            out.print("\"");
            out.print(" proxySign=\"");
            out.print(this.proxySign_);
            out.print("\"");
        }
        if (!this.annotations_.isEmpty()) {
            String notesStr = Splitter.tokenJoin(this.annotations_, ",");
            out.print(" notes=\"");
            out.print(notesStr);
            out.print("\"");
        }
        out.println("/>");
    }

    public String toString() {
        return "PertSource: id = " + this.id_ + " name = " + this.srcNameKey_ + " typekey = " + this.typeKey_;
    }

    public static List getProxySignValues() {
        ArrayList<ObjChoiceContent> retval = new ArrayList<ObjChoiceContent>();
        retval.add(PertSource.getProxySignValue(NO_PROXY));
        retval.add(PertSource.getProxySignValue(SAME_SIGN_PROXY));
        retval.add(PertSource.getProxySignValue(OPPOSITE_SIGN_PROXY));
        return retval;
    }

    public static ObjChoiceContent getProxySignValue(String proxVal) {
        return new ObjChoiceContent(ResourceManager.getManager().getString("proxyTypes." + proxVal), proxVal);
    }

    public static String mapProxySignIndex(int index) {
        switch (index) {
            case 0: {
                return NO_PROXY;
            }
            case 1: {
                return SAME_SIGN_PROXY;
            }
            case 2: {
                return OPPOSITE_SIGN_PROXY;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String mapLegacyProxySign(String legacy) {
        return legacy;
    }

    public static class PertSourceWorker
    extends AbstractFactoryClient {
        public PertSourceWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pertSrc");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            PertSource retval = null;
            if (elemName.equals("pertSrc")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.pertSrc = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private PertSource buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "pertSrc", "id", true);
            String src = AttributeExtractor.extractAttribute(elemName, attrs, "pertSrc", "src", true);
            String type = AttributeExtractor.extractAttribute(elemName, attrs, "pertSrc", "type", true);
            type = CharacterEntityMapper.unmapEntities(type, false);
            String proxyKey = AttributeExtractor.extractAttribute(elemName, attrs, "pertSrc", "proxy", false);
            String proxySign = AttributeExtractor.extractAttribute(elemName, attrs, "pertSrc", "proxySign", false);
            if (proxySign == null && proxyKey != null) {
                throw new IOException();
            }
            String notes = AttributeExtractor.extractAttribute(elemName, attrs, "pertSrc", "notes", false);
            PertSource nps = new PertSource(id, src, type, proxyKey, proxySign);
            if (notes != null) {
                nps.setNotes(Splitter.stringBreak(notes, ",", 0, false));
            }
            return nps;
        }
    }
}

