/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterTarget;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.perturb.SourceSrc;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Splitter;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;

public class PertSources
implements Comparable,
Cloneable,
PertFilterTarget {
    public static final int NO_FOOTS = 0;
    public static final int SUPER_FOOTS = 1;
    public static final int BRACKET_FOOTS = 2;
    private ArrayList sources_;

    public PertSources() {
        this.sources_ = new ArrayList();
    }

    public PertSources(String sourceID) {
        this.sources_ = new ArrayList();
        this.sources_.add(sourceID);
    }

    public PertSources(List sources) {
        this.sources_ = new ArrayList(sources);
    }

    public Object clone() {
        try {
            PertSources retval = (PertSources)super.clone();
            retval.sources_ = (ArrayList)this.sources_.clone();
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int hashCode() {
        int code = 0;
        int numSrc = this.sources_.size();
        for (int i = 0; i < numSrc; ++i) {
            String pskey = (String)this.sources_.get(i);
            code += pskey.hashCode();
        }
        return code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof PertSources)) {
            return false;
        }
        PertSources otherPS = (PertSources)other;
        return this.sources_.equals(otherPS.sources_);
    }

    public int compareTo(Object o) {
        PertSources other = (PertSources)o;
        PerturbationData pd = Database.getDB().getPertData();
        String me = this.getDisplayString(pd, 0);
        String him = other.getDisplayString(pd, 0);
        return me.compareTo(him);
    }

    public boolean matchesFilter(PertFilter pf, SourceSrc ss) {
        int category = pf.getCategory();
        switch (category) {
            case 1: {
                String filterSrc = pf.getStringValue();
                int numSrc = this.sources_.size();
                for (int i = 0; i < numSrc; ++i) {
                    String pskey = (String)this.sources_.get(i);
                    if (!filterSrc.equals(pskey)) continue;
                    return true;
                }
                return false;
            }
            case 2: 
            case 3: 
            case 13: {
                String filterStr = pf.getStringValue();
                int numSrcN = this.sources_.size();
                for (int i = 0; i < numSrcN; ++i) {
                    String pskey = (String)this.sources_.get(i);
                    PertSource ps = ss.getSourceDef(pskey);
                    if (category == 13) {
                        List annotIDs = ps.getAnnotationIDs();
                        if (annotIDs == null || !annotIDs.contains(filterStr)) continue;
                        return true;
                    }
                    if (filterStr.equals(ps.getSourceNameKey())) {
                        return true;
                    }
                    if (pf.getCategory() != 3 || !ps.isAProxy() || !filterStr.equals(ps.getProxiedSpeciesKey())) continue;
                    return true;
                }
                return false;
            }
            case 4: {
                String filterPert = pf.getStringValue();
                int numSrc = this.sources_.size();
                for (int i = 0; i < numSrc; ++i) {
                    String pskey = (String)this.sources_.get(i);
                    PertSource ps = ss.getSourceDef(pskey);
                    if (!filterPert.equals(ps.getExpTypeKey())) continue;
                    return true;
                }
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    public void addToSourceSet(Set sources, SourceSrc ss) {
        int numSrc = this.sources_.size();
        for (int i = 0; i < numSrc; ++i) {
            String pskey = (String)this.sources_.get(i);
            PertSource ps = ss.getSourceDef(pskey);
            String sName = ps.getDisplayValue(ss);
            sources.add(new TrueObjChoiceContent(sName, pskey));
        }
    }

    public void addToSourceNameSet(Set sources, SourceSrc ss, boolean orProxy) {
        int numSrc = this.sources_.size();
        for (int i = 0; i < numSrc; ++i) {
            String pskey = (String)this.sources_.get(i);
            PertSource ps = ss.getSourceDef(pskey);
            String sNameKey = ps.getSourceNameKey();
            String psName = ps.getSourceName(ss);
            if (orProxy && ps.isAProxy()) {
                sNameKey = ps.getProxiedSpeciesKey();
                psName = ps.getProxiedSpeciesName(ss);
            }
            sources.add(new TrueObjChoiceContent(psName, sNameKey));
        }
    }

    public void addToPertSet(Set pertTypes, SourceSrc ss, PertDictionary pDict) {
        int numSrc = this.sources_.size();
        for (int i = 0; i < numSrc; ++i) {
            String pskey = (String)this.sources_.get(i);
            PertSource ps = ss.getSourceDef(pskey);
            pertTypes.add(new TrueObjChoiceContent(ps.getExpType(pDict).getType(), ps.getExpTypeKey()));
        }
    }

    public void addSource(PertSource ps) {
        this.sources_.add(ps.getID());
    }

    public void addSourceID(String psID) {
        this.sources_.add(psID);
    }

    public void deleteSource(int i) {
        this.sources_.remove(i);
    }

    public int getNumSources() {
        return this.sources_.size();
    }

    public PertSource getSource(int i, SourceSrc ss) {
        String srcID = (String)this.sources_.get(i);
        PertSource ps = ss.getSourceDef(srcID);
        return ps;
    }

    public boolean isSinglePert() {
        return this.sources_.size() == 1;
    }

    public PertSource getSinglePert(SourceSrc ss) {
        if (this.sources_.size() != 1) {
            throw new IllegalStateException();
        }
        String srcID = (String)this.sources_.get(0);
        return ss.getSourceDef(srcID);
    }

    public Iterator getSources() {
        return this.sources_.iterator();
    }

    public boolean sourcesMatch(List srcs) {
        int numSrc = this.sources_.size();
        for (int i = 0; i < numSrc; ++i) {
            String srcID = (String)this.sources_.get(i);
            if (!srcs.contains(srcID)) continue;
            return true;
        }
        return false;
    }

    public void getAnnotationIDs(Set usedIDs, SourceSrc ss) {
        int numSrc = this.sources_.size();
        for (int i = 0; i < numSrc; ++i) {
            String srcID = (String)this.sources_.get(i);
            PertSource pSrc = ss.getSourceDef(srcID);
            usedIDs.addAll(pSrc.getAnnotationIDs());
        }
    }

    public String getDisplayString(SourceSrc ss, int footnoteMode) {
        ArrayList<String> asNames = new ArrayList<String>();
        int numSrc = this.sources_.size();
        for (int i = 0; i < numSrc; ++i) {
            String srcID = (String)this.sources_.get(i);
            PertSource pSrc = ss.getSourceDef(srcID);
            if (footnoteMode != 0) {
                asNames.add(pSrc.getDisplayValueWithFootnotes(ss, footnoteMode == 1));
                continue;
            }
            asNames.add(pSrc.getDisplayValue(ss));
        }
        return DataUtil.getMultiDisplayString(asNames);
    }

    public SortedSet getPerturbsSortedSet(SourceSrc ss, boolean normalized) {
        TreeSet<String> retval = new TreeSet<String>();
        int numSrc = this.sources_.size();
        for (int i = 0; i < numSrc; ++i) {
            String srcID = (String)this.sources_.get(i);
            PertSource pSrc = ss.getSourceDef(srcID);
            String disp = pSrc.getDisplayValue(ss);
            if (normalized) {
                disp = DataUtil.normKey(disp);
            }
            retval.add(disp);
        }
        return retval;
    }

    public String sourcesAsString() {
        return Splitter.tokenJoin(this.sources_, ",");
    }

    public String toString() {
        return "PertSources: " + (this.sources_.isEmpty() ? "empty " : this.sources_.get(0).toString());
    }
}

