/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.BatchCollision;
import org.systemsbiology.biotapestry.perturb.CSVData;
import org.systemsbiology.biotapestry.perturb.ConditionDictionary;
import org.systemsbiology.biotapestry.perturb.Experiment;
import org.systemsbiology.biotapestry.perturb.ExperimentConditions;
import org.systemsbiology.biotapestry.perturb.ExperimentControl;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.perturb.PertAnnotations;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertDataPoint;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.TimeAxisSetupDialog;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.BatchDupReportDialog;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.NewbieReportingDialog;
import org.systemsbiology.biotapestry.util.BoundedDoubMinMax;
import org.systemsbiology.biotapestry.util.CSVParser;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PerturbCsvFormatFactory {
    public static final String NEWBIE_INVEST = "NewbieInvest";
    public static final String NEWBIE_PERT_SOURCE = "NewbiePertSource";
    public static final String NEWBIE_TARGET = "NewbieTarget";
    public static final String NEWBIE_CONTROL = "NewbieControl";
    public static final String NEWBIE_SCALE = "NewbieScale";
    public static final String NEWBIE_MEASURE_TYPE = "NewbieMeasureType";
    public static final String NEWBIE_PERT_TYPE = "NewbiePertType";
    public static final String NEWBIE_EXP_COND = "NewbieExpCond";
    public static final String NEWBIE_USER_FIELD = "NewbieUserField";
    public static final String NEWBIE_ANNOTATION = "NewbieAnnotation";
    public static final String NEWBIE_EXPERIMENT = "NewbieExperiment";
    private JFrame frame_;
    private HashMap newParamsInFile_;
    private HashMap paramNameToPdKeyMap_;
    private boolean useDate_;
    private boolean useTime_;
    private boolean useBatch_;
    private boolean useInvest_;
    private boolean useCondition_;

    public PerturbCsvFormatFactory(JFrame frame, boolean useDate, boolean useTime, boolean useBatch, boolean useInvest, boolean useCondition) {
        this.frame_ = frame;
        this.newParamsInFile_ = new HashMap();
        this.paramNameToPdKeyMap_ = new HashMap();
        this.useDate_ = useDate;
        this.useTime_ = useTime;
        this.useBatch_ = useBatch;
        this.useInvest_ = useInvest;
        this.useCondition_ = useCondition;
    }

    public boolean parsePerturbCSV(File infile, UndoManager undo) throws IOException {
        DatabaseChange dc;
        PerturbationData pd = Database.getDB().getPertData();
        List blockList = this.fileToLineBlocks(infile);
        Iterator blit = blockList.iterator();
        ArrayList<CSVState> csvList = new ArrayList<CSVState>();
        int setNumber = 1;
        int blockNum = 0;
        CSVState csvState = null;
        while (blit.hasNext()) {
            List block = (List)blit.next();
            if (blockNum % 2 == 0) {
                csvState = new CSVState(false, setNumber++, this.paramNameToPdKeyMap_, this.useDate_, this.useTime_, this.useBatch_, this.useInvest_, this.useCondition_);
                csvList.add(csvState);
                blockNum = 0;
            }
            this.processLineBlock(block, blockNum++, csvState, pd);
        }
        TaggedTAD ttad = this.handleTimeDefinition(undo);
        if (!ttad.keepGoing) {
            return false;
        }
        HashMap allNewbies = new HashMap();
        HashMap newbieClosest = new HashMap();
        TreeMap batchDups = new TreeMap();
        boolean haveNP = this.flagNewbieParams(pd, allNewbies);
        boolean haveN = this.flagNewbies(csvList, pd, allNewbies, newbieClosest, batchDups, ttad.tad);
        if (haveNP || haveN) {
            this.findNewbieNeighbors(pd, allNewbies, newbieClosest);
            NewbieReportingDialog nrd = new NewbieReportingDialog(this.frame_, allNewbies, newbieClosest);
            nrd.show();
            if (!nrd.keepGoing()) {
                return false;
            }
        }
        if (!batchDups.isEmpty()) {
            BatchDupReportDialog bdrd = new BatchDupReportDialog(this.frame_, batchDups, "batchDup.CSVDialog", "batchDup.CSVTable");
            bdrd.show();
            if (!bdrd.keepGoing()) {
                return false;
            }
        }
        if (this.reportBadMeasurements(csvList, ttad.tad)) {
            return false;
        }
        UndoSupport support = new UndoSupport(undo, "undo.pertCsv");
        if (ttad.tad != null && (dc = Database.getDB().setTimeAxisDefinition(ttad.tad)) != null) {
            DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc);
            support.addEdit(dcc);
        }
        this.paramsToDatabase(pd, support);
        this.extractMeasurements(csvList, pd, support);
        support.addEvent(new GeneralChangeEvent(2));
        support.finish();
        return true;
    }

    private TaggedTAD handleTimeDefinition(UndoManager undo) throws IOException {
        Database db = Database.getDB();
        TimeAxisDefinition tad = db.getTimeAxisDefinition();
        TimeAxisDefinition newtad = null;
        if (!tad.isInitialized()) {
            Map newTS = (Map)this.newParamsInFile_.get(CSVState.TIME_SCALE_PARAM_UC_);
            if (newTS == null || newTS.size() != 1) {
                boolean keepGoing = TimeAxisSetupDialog.timeAxisSetupDialogWrapperWrapper((JFrame)this.frame_, (UndoManager)undo);
                if (!keepGoing) {
                    return new TaggedTAD(null, false);
                }
            } else {
                int units;
                String timeVal = (String)newTS.values().iterator().next();
                try {
                    units = TimeAxisDefinition.mapUnitTypeTag(timeVal);
                }
                catch (IllegalArgumentException iaex) {
                    throw new IOException(this.buildNoLineErrorMessage("csvInput.badTimeUnits", timeVal));
                }
                if (TimeAxisDefinition.wantsCustomUnits(units)) {
                    throw new IOException(this.buildNoLineErrorMessage("csvInput.customTimeNotSupported", timeVal));
                }
                newtad = new TimeAxisDefinition();
                newtad.setDefinition(units, null, null, false, null);
            }
        } else {
            int units;
            Map newTS = (Map)this.newParamsInFile_.get(CSVState.TIME_SCALE_PARAM_UC_);
            if (newTS == null || newTS.isEmpty()) {
                return new TaggedTAD(null, true);
            }
            String timeVal = (String)newTS.values().iterator().next();
            if (newTS.size() > 1) {
                throw new IOException(this.buildNoLineErrorMessage("csvInput.multipleTimeDefs", timeVal));
            }
            try {
                units = TimeAxisDefinition.mapUnitTypeTag(timeVal);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException(this.buildNoLineErrorMessage("csvInput.badTimeUnits", timeVal));
            }
            if (TimeAxisDefinition.wantsCustomUnits(units)) {
                throw new IOException(this.buildNoLineErrorMessage("csvInput.customTimeNotSupported", timeVal));
            }
            if (tad.getUnits() != units) {
                throw new IOException(this.buildNoLineErrorMessage("csvInput.timeDefMismatchWithCurrent", timeVal));
            }
        }
        return new TaggedTAD(newtad, true);
    }

    private boolean flagNewbieParams(PerturbationData pd, Map retval) {
        Iterator cit;
        Map exprConds;
        HashSet<String> newbieExpCond;
        Map scales;
        boolean haveNewbie = false;
        MeasureDictionary md = pd.getMeasureDictionary();
        PertDictionary pdict = pd.getPertDictionary();
        ConditionDictionary cdict = pd.getConditionDictionary();
        PertAnnotations pa = pd.getPertAnnotations();
        HashSet<String> newbieScales = (HashSet<String>)retval.get(NEWBIE_SCALE);
        if (newbieScales == null) {
            newbieScales = new HashSet<String>();
            retval.put(NEWBIE_SCALE, newbieScales);
        }
        if ((scales = (Map)this.newParamsInFile_.get(CSVState.SCALE_PARAM_UC_)) != null) {
            Iterator sit = scales.keySet().iterator();
            while (sit.hasNext()) {
                String skey = (String)sit.next();
                MeasureScaleParam sp = (MeasureScaleParam)scales.get(skey);
                newbieScales.add(sp.name);
                haveNewbie = true;
            }
        }
        if (md.getMeasurePropsCount() > 0) {
            Map measurements;
            HashSet<String> newbieMeasProps = (HashSet<String>)retval.get(NEWBIE_MEASURE_TYPE);
            if (newbieMeasProps == null) {
                newbieMeasProps = new HashSet<String>();
                retval.put(NEWBIE_MEASURE_TYPE, newbieMeasProps);
            }
            if ((measurements = (Map)this.newParamsInFile_.get(CSVState.MEASURE_TYPE_PARAM_UC_)) != null) {
                Iterator mit = measurements.keySet().iterator();
                while (mit.hasNext()) {
                    String mkey = (String)mit.next();
                    MeasureParam mp = (MeasureParam)measurements.get(mkey);
                    newbieMeasProps.add(mp.name);
                    haveNewbie = true;
                }
            }
        }
        if (pdict.getPerturbPropsCount() > 0) {
            Map pertTypes;
            HashSet<String> newbiePertProps = (HashSet<String>)retval.get(NEWBIE_PERT_TYPE);
            if (newbiePertProps == null) {
                newbiePertProps = new HashSet<String>();
                retval.put(NEWBIE_PERT_TYPE, newbiePertProps);
            }
            if ((pertTypes = (Map)this.newParamsInFile_.get(CSVState.PERT_TYPE_PARAM_UC_)) != null) {
                Iterator pit = pertTypes.keySet().iterator();
                while (pit.hasNext()) {
                    String pkey = (String)pit.next();
                    PertPropParam ppp = (PertPropParam)pertTypes.get(pkey);
                    newbiePertProps.add(ppp.name);
                    haveNewbie = true;
                }
            }
        }
        if ((newbieExpCond = (HashSet<String>)retval.get(NEWBIE_EXP_COND)) == null) {
            newbieExpCond = new HashSet<String>();
            retval.put(NEWBIE_EXP_COND, newbieExpCond);
        }
        if ((exprConds = (Map)this.newParamsInFile_.get(CSVState.CONDITION_PARAM_UC_)) != null) {
            Iterator cit2 = exprConds.keySet().iterator();
            while (cit2.hasNext()) {
                String ekey = (String)cit2.next();
                String condName = (String)exprConds.get(ekey);
                newbieExpCond.add(condName);
                haveNewbie = true;
            }
        }
        if (cdict.getExprControlCount() > 0) {
            Map ctrls;
            HashSet<String> newbieExpControl = (HashSet<String>)retval.get(NEWBIE_CONTROL);
            if (newbieExpControl == null) {
                newbieExpControl = new HashSet<String>();
                retval.put(NEWBIE_CONTROL, newbieExpControl);
            }
            if ((ctrls = (Map)this.newParamsInFile_.get(CSVState.CONTROL_PARAM_UC_)) != null) {
                cit = ctrls.keySet().iterator();
                while (cit.hasNext()) {
                    String tkey = (String)cit.next();
                    String ctrlName = (String)ctrls.get(tkey);
                    newbieExpControl.add(ctrlName);
                    haveNewbie = true;
                }
            }
        }
        if (pd.getUserFieldCount() > 0) {
            Map uFields;
            HashSet<String> newbieFields = (HashSet<String>)retval.get(NEWBIE_USER_FIELD);
            if (newbieFields == null) {
                newbieFields = new HashSet<String>();
                retval.put(NEWBIE_USER_FIELD, newbieFields);
            }
            if ((uFields = (Map)this.newParamsInFile_.get(CSVState.USER_FIELD_PARAM_UC_)) != null) {
                cit = uFields.keySet().iterator();
                while (cit.hasNext()) {
                    String fkey = (String)cit.next();
                    String fieldName = (String)uFields.get(fkey);
                    newbieFields.add(fieldName);
                    haveNewbie = true;
                }
            }
        }
        if (pa.getAnnotationCount() > 0) {
            Map annots;
            HashSet<String> newbieAnnots = (HashSet<String>)retval.get(NEWBIE_ANNOTATION);
            if (newbieAnnots == null) {
                newbieAnnots = new HashSet<String>();
                retval.put(NEWBIE_ANNOTATION, newbieAnnots);
            }
            if ((annots = (Map)this.newParamsInFile_.get(CSVState.ANNOT_PARAM_UC_)) != null) {
                Iterator ait = annots.keySet().iterator();
                while (ait.hasNext()) {
                    String akey = (String)ait.next();
                    AnnotParam aparm = (AnnotParam)annots.get(akey);
                    newbieAnnots.add(aparm.num);
                    haveNewbie = true;
                }
            }
        }
        return haveNewbie;
    }

    private boolean flagNewbies(List cssList, PerturbationData pd, Map retval, Map closest, Map batchDups, TimeAxisDefinition pendingTAD) throws IOException {
        boolean haveNewbie = false;
        Iterator cssit = cssList.iterator();
        while (cssit.hasNext()) {
            CSVState csvs = (CSVState)cssit.next();
            Iterator csvit = csvs.getValues().iterator();
            while (csvit.hasNext()) {
                Set matches;
                int numMatch;
                CSVData csv = (CSVData)csvit.next();
                if (pd.getInvestigatorCount() > 0) {
                    HashSet<String> newbieInvest = (HashSet<String>)retval.get(NEWBIE_INVEST);
                    if (newbieInvest == null) {
                        newbieInvest = new HashSet<String>();
                        retval.put(NEWBIE_INVEST, newbieInvest);
                    }
                    List invests = csv.getInvestigators();
                    int numInv = invests.size();
                    for (int i = 0; i < numInv; ++i) {
                        String invest = (String)invests.get(i);
                        String investKey = pd.getInvestKeyFromName(invest);
                        if (investKey != null) continue;
                        newbieInvest.add(invest);
                        haveNewbie = true;
                    }
                }
                if (pd.getTargetCount() > 0) {
                    HashSet<String> newbieTargets = (HashSet<String>)retval.get(NEWBIE_TARGET);
                    if (newbieTargets == null) {
                        newbieTargets = new HashSet<String>();
                        retval.put(NEWBIE_TARGET, newbieTargets);
                    }
                    Set targets = csv.getTargets();
                    Iterator trit = targets.iterator();
                    while (trit.hasNext()) {
                        String targetKey = (String)trit.next();
                        String tkey = pd.getTargetFromName(csv.getOriginalTargetName(targetKey));
                        if (tkey != null) continue;
                        newbieTargets.add(csv.getOriginalTargetName(targetKey));
                        haveNewbie = true;
                    }
                }
                if (pd.getPertSourceCount() > 0) {
                    String multiDisp;
                    HashSet<String> newbiePertSource = (HashSet<String>)retval.get(NEWBIE_PERT_SOURCE);
                    if (newbiePertSource == null) {
                        newbiePertSource = new HashSet<String>();
                        retval.put(NEWBIE_PERT_SOURCE, newbiePertSource);
                    }
                    if ((multiDisp = this.multiMatchingSources(csv, pd)) != null) {
                        throw new IOException(this.buildNoLineErrorMessage("csvInput.multiSourceMatch", multiDisp));
                    }
                    List srcs = csv.getSources();
                    int numSrcs = srcs.size();
                    for (int i = 0; i < numSrcs; ++i) {
                        CSVData.ExperimentTokens etok = (CSVData.ExperimentTokens)srcs.get(i);
                        String psKey = pd.getPertSourceFromName(etok.base);
                        if (psKey != null) continue;
                        newbiePertSource.add(etok.base);
                        haveNewbie = true;
                    }
                }
                if (pd.getExperimentCount() <= 0) continue;
                HashSet<String> newbieExperiments = (HashSet<String>)retval.get(NEWBIE_EXPERIMENT);
                if (newbieExperiments == null) {
                    newbieExperiments = new HashSet<String>();
                    retval.put(NEWBIE_EXPERIMENT, newbieExperiments);
                }
                if ((numMatch = (matches = this.matchingExperiments(csv, pd, pendingTAD, true)).size()) != 1) {
                    int time = this.processTime(csv, pendingTAD);
                    String times = Experiment.getTimeDisplayString(new MinMax(time, time), true, true);
                    String invests = DataUtil.getMultiDisplayString(csv.getInvestigators());
                    ArrayList<String> tokStrs = new ArrayList<String>();
                    List srcs = csv.getSources();
                    int numSrcs = srcs.size();
                    for (int i = 0; i < numSrcs; ++i) {
                        CSVData.ExperimentTokens etok = (CSVData.ExperimentTokens)srcs.get(i);
                        tokStrs.add(etok.orig);
                    }
                    String perts = DataUtil.getMultiDisplayString(tokStrs);
                    String dispStr = Experiment.getDisplayString(perts, times, invests);
                    if (numMatch == 0) {
                        newbieExperiments.add(dispStr);
                        this.findNewbieExperimentNeighbor(dispStr, csv, pd, pendingTAD, closest);
                        haveNewbie = true;
                        continue;
                    }
                    throw new IOException(this.buildNoLineErrorMessage("csvInput.multiMatch", dispStr));
                }
                String expKey = (String)matches.iterator().next();
                Map batchKeys = pd.mergeExperimentBatchCollisions(matches);
                Set targets = csv.getTargets();
                Iterator trit = targets.iterator();
                while (trit.hasNext()) {
                    BatchCollision bc;
                    TreeMap<String, BatchCollision> perTarg;
                    List vals;
                    String targetKey = (String)trit.next();
                    String targName = csv.getOriginalTargetName(targetKey);
                    String tkey = pd.getTargetFromName(targName);
                    if (tkey == null) continue;
                    Map forTarg = (Map)batchKeys.get(tkey);
                    String batchID = csv.getBatchID();
                    if (forTarg == null || (vals = (List)forTarg.get(batchID)) == null) continue;
                    String dispKey = pd.getExperiment(expKey).getDisplayString(pd);
                    TreeMap forExp = (TreeMap)batchDups.get(dispKey);
                    if (forExp == null) {
                        forExp = new TreeMap();
                        batchDups.put(dispKey, forExp);
                    }
                    if ((perTarg = (TreeMap<String, BatchCollision>)forExp.get(targetKey)) == null) {
                        perTarg = new TreeMap<String, BatchCollision>();
                        forExp.put(targetKey, perTarg);
                    }
                    if ((bc = (BatchCollision)perTarg.get(batchID)) == null) {
                        bc = new BatchCollision(dispKey, targName, batchID);
                        perTarg.put(batchID, bc);
                        bc.vals.addAll(vals);
                    }
                    List mea = csv.getMeasurements(targetKey);
                    int numMea = mea.size();
                    for (int i = 0; i < numMea; ++i) {
                        CSVData.DataPoint dp = (CSVData.DataPoint)mea.get(i);
                        bc.vals.add(dp.value);
                    }
                }
            }
        }
        return haveNewbie;
    }

    private void findNewbieExperimentNeighbor(String tag, CSVData csv, PerturbationData pd, TimeAxisDefinition pendingTAD, Map retval) {
        HashMap<String, String> closest = (HashMap<String, String>)retval.get(NEWBIE_EXPERIMENT);
        if (closest == null) {
            closest = new HashMap<String, String>();
            retval.put(NEWBIE_EXPERIMENT, closest);
        }
        TreeSet csvInv = new TreeSet(DataUtil.normalizeList(csv.getInvestigators()));
        Set matchExp = this.matchingExperiments(csv, pd, pendingTAD, false);
        if (!matchExp.isEmpty()) {
            int minDist = Integer.MAX_VALUE;
            String minKey = null;
            Iterator meit = matchExp.iterator();
            while (meit.hasNext()) {
                String key = (String)meit.next();
                Experiment exp = pd.getExperiment(key);
                SortedSet invSet = exp.getInvestigatorSortedSet(pd, true);
                int distance = DataUtil.setDistance(invSet, csvInv);
                if (distance >= minDist) continue;
                minDist = distance;
                minKey = key;
            }
            if (minKey != null) {
                Experiment exp = pd.getExperiment(minKey);
                closest.put(tag, exp.getDisplayString(pd));
            }
        }
    }

    private Map findNewbieNeighbors(PerturbationData pd, Map allNewbies, Map retval) {
        MeasureDictionary md = pd.getMeasureDictionary();
        PertDictionary pdict = pd.getPertDictionary();
        ConditionDictionary cdict = pd.getConditionDictionary();
        this.closestNewbieMatch(NEWBIE_USER_FIELD, pd.getUserFieldNameSet(), allNewbies, retval, 3);
        this.closestNewbieMatch(NEWBIE_CONTROL, cdict.getControlNameSet(), allNewbies, retval, 3);
        this.closestNewbieMatch(NEWBIE_PERT_TYPE, pdict.getPerturbPropNameSet(), allNewbies, retval, 3);
        this.closestNewbieMatch(NEWBIE_SCALE, md.getMeasureScaleNameSet(), allNewbies, retval, 5);
        this.closestNewbieMatch(NEWBIE_MEASURE_TYPE, md.getMeasurePropsNameSet(), allNewbies, retval, 3);
        this.closestNewbieMatch(NEWBIE_EXP_COND, cdict.getConditionNameSet(), allNewbies, retval, 3);
        this.closestNewbieMatch(NEWBIE_PERT_SOURCE, pd.getSourceNameSet(), allNewbies, retval, 3);
        this.closestNewbieMatch(NEWBIE_INVEST, pd.getInvestigatorSet(), allNewbies, retval, 4);
        this.closestNewbieMatch(NEWBIE_TARGET, pd.getTargetSet(), allNewbies, retval, 3);
        return retval;
    }

    private void closestNewbieMatch(String whichNewbie, Set matchCand, Map allNewbies, Map results, int tol) {
        HashSet newbies = (HashSet)allNewbies.get(whichNewbie);
        if (newbies != null && !newbies.isEmpty()) {
            HashMap<String, String> closest = new HashMap<String, String>();
            results.put(whichNewbie, closest);
            Iterator nskit = newbies.iterator();
            while (nskit.hasNext()) {
                String newbie = (String)nskit.next();
                closest.put(newbie, DataUtil.getClosestStringToName(newbie, tol, matchCand));
            }
        }
    }

    private Set matchingExperiments(CSVData csv, PerturbationData pd, TimeAxisDefinition pendingTAD, boolean withInvests) {
        HashSet<String> retval = new HashSet<String>();
        int time = this.processTime(csv, pendingTAD);
        TreeSet csvInv = withInvests ? new TreeSet(DataUtil.normalizeList(csv.getInvestigators())) : null;
        TreeSet<String> csvPs = new TreeSet<String>();
        List srcs = csv.getSources();
        int numSrcs = srcs.size();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < numSrcs; ++i) {
            CSVData.ExperimentTokens etok = (CSVData.ExperimentTokens)srcs.get(i);
            buf.setLength(0);
            buf.append(etok.base);
            buf.append(etok.expType);
            csvPs.add(DataUtil.normKey(buf.toString()));
        }
        String condition = csv.getCondition();
        Iterator ekit = pd.getExperimentKeys();
        while (ekit.hasNext()) {
            SortedSet pset;
            SortedSet invSet;
            String expKey = (String)ekit.next();
            Experiment exp = pd.getExperiment(expKey);
            if (exp.getTime() != time || exp.getLegacyMaxTime() != -1 || !DataUtil.keysEqual(exp.getCondsDisplayString(pd), condition) || withInvests && !csvInv.equals(invSet = exp.getInvestigatorSortedSet(pd, true)) || !csvPs.equals(pset = exp.getPerturbsSortedSet(pd, true))) continue;
            retval.add(expKey);
        }
        return retval;
    }

    private String multiMatchingSources(CSVData csv, PerturbationData pd) {
        List srcs = csv.getSources();
        int numSrcs = srcs.size();
        StringBuffer buf = new StringBuffer();
        PertDictionary pDict = pd.getPertDictionary();
        for (int i = 0; i < numSrcs; ++i) {
            CSVData.ExperimentTokens etok = (CSVData.ExperimentTokens)srcs.get(i);
            buf.setLength(0);
            buf.append(etok.base);
            buf.append(etok.expType);
            String checkStr = DataUtil.normKey(buf.toString());
            int matchCount = 0;
            Iterator sdit = pd.getSourceDefKeys();
            while (sdit.hasNext()) {
                String sdKey = (String)sdit.next();
                PertSource ps = pd.getSourceDef(sdKey);
                String sn = ps.getSourceName(pd);
                PertProperties pp = ps.getExpType(pDict);
                buf.setLength(0);
                buf.append(sn);
                buf.append(pp.getType());
                String testName = DataUtil.normKey(buf.toString());
                if (!checkStr.equals(testName) || ++matchCount <= 1) continue;
                return etok.orig;
            }
        }
        return null;
    }

    private void extractMeasurements(List cssList, PerturbationData pd, UndoSupport support) throws IOException {
        long timeStamp = System.currentTimeMillis();
        Iterator cssit = cssList.iterator();
        while (cssit.hasNext()) {
            CSVState csvs = (CSVState)cssit.next();
            Iterator csvit = csvs.getValues().iterator();
            while (csvit.hasNext()) {
                PerturbationData.KeyAndDataChange kdac;
                CSVData csv = (CSVData)csvit.next();
                ArrayList<String> investIDs = new ArrayList<String>();
                List invests = csv.getInvestigators();
                int numInv = invests.size();
                for (int i = 0; i < numInv; ++i) {
                    String invest = (String)invests.get(i);
                    PerturbationData.KeyAndDataChange kdac2 = pd.provideInvestigator(invest);
                    if (kdac2.undoInfo != null) {
                        support.addEdit(new PertDataChangeCmd(kdac2.undoInfo));
                    }
                    investIDs.add(kdac2.key);
                }
                List srcs = csv.getSources();
                int numSrcs = srcs.size();
                PertSources pss = new PertSources();
                for (int i = 0; i < numSrcs; ++i) {
                    CSVData.ExperimentTokens etok = (CSVData.ExperimentTokens)srcs.get(i);
                    kdac = pd.providePertSrcName(etok.base);
                    if (kdac.undoInfo != null) {
                        support.addEdit(new PertDataChangeCmd(kdac.undoInfo));
                    }
                    String pertKey = csvs.getPDKey("PerturbationType", etok.expType);
                    kdac = pd.providePertSrc(kdac.key, pertKey, null, "noProxy", new ArrayList(), true);
                    if (kdac.undoInfo != null) {
                        support.addEdit(new PertDataChangeCmd(kdac.undoInfo));
                    }
                    pss.addSourceID(kdac.key);
                }
                int time = this.processTime(csv, null);
                String condKey = csvs.getPDKey("Condition", csv.getCondition());
                kdac = pd.provideExperiment(pss, time, -1, investIDs, condKey);
                if (kdac.undoInfo != null) {
                    support.addEdit(new PertDataChangeCmd(kdac.undoInfo));
                }
                String psiKey = kdac.key;
                Set targets = csv.getTargets();
                Iterator trit = targets.iterator();
                while (trit.hasNext()) {
                    String targetKey = (String)trit.next();
                    kdac = pd.provideTarget(csv.getOriginalTargetName(targetKey));
                    String targKey = kdac.key;
                    if (kdac.undoInfo != null) {
                        support.addEdit(new PertDataChangeCmd(kdac.undoInfo));
                    }
                    List meas = csv.getMeasurements(targetKey);
                    int numM = meas.size();
                    for (int i = 0; i < numM; ++i) {
                        int j;
                        CSVData.DataPoint dp = (CSVData.DataPoint)meas.get(i);
                        double measv = Double.NaN;
                        try {
                            measv = Double.parseDouble(dp.value);
                        }
                        catch (NumberFormatException nfex) {
                            throw new IllegalStateException();
                        }
                        String mKey = csvs.getPDKey("MeasureType", dp.measurement);
                        PertDataPoint pdp = new PertDataPoint(pd.getNextDataKey(), timeStamp, psiKey, targKey, mKey, measv);
                        pdp.setBatchKey(csv.getBatchID());
                        pdp.setDate(csv.getDate());
                        pdp.setComment(dp.comment);
                        if (dp.control != null && !dp.control.trim().equals("")) {
                            kdac = pd.provideExpControl(dp.control);
                            if (kdac.undoInfo != null) {
                                support.addEdit(new PertDataChangeCmd(kdac.undoInfo));
                            }
                            pdp.setControl(kdac.key);
                        }
                        pdp.setIsSig(PerturbCsvFormatFactory.convertSigInput(dp.isValid));
                        PertDataChange pdc = pd.setDataPoint(pdp);
                        support.addEdit(new PertDataChangeCmd(pdc));
                        if (dp.annots != null && !dp.annots.isEmpty()) {
                            Map aToKey = (Map)this.paramNameToPdKeyMap_.get(CSVState.ANNOT_PARAM_UC_);
                            ArrayList keyList = new ArrayList();
                            int numdpa = dp.annots.size();
                            for (j = 0; j < numdpa; ++j) {
                                String tag = (String)dp.annots.get(j);
                                keyList.add(aToKey.get(tag));
                            }
                            pdc = pd.setFootnotesForDataPoint(pdp.getID(), keyList);
                            support.addEdit(new PertDataChangeCmd(pdc));
                        }
                        boolean allEmpty = true;
                        ArrayList<String> userV = new ArrayList<String>();
                        int ufCount = pd.getUserFieldCount();
                        for (j = 0; j < ufCount; ++j) {
                            String ufName = pd.getUserFieldName(j);
                            String ufVal = (String)dp.userFields.get(DataUtil.normKey(ufName));
                            if (ufVal == null) {
                                ufVal = "";
                            }
                            if (!(ufVal = ufVal.trim()).equals("")) {
                                allEmpty = false;
                            }
                            userV.add(ufVal);
                        }
                        pdc = pd.setUserFieldValues(pdp.getID(), allEmpty ? null : userV);
                        if (pdc == null) continue;
                        support.addEdit(new PertDataChangeCmd(pdc));
                    }
                }
            }
        }
    }

    void paramsToDatabase(PerturbationData pd, UndoSupport support) {
        MeasureDictionary md = pd.getMeasureDictionary();
        PertDictionary pdict = pd.getPertDictionary();
        ConditionDictionary cdict = pd.getConditionDictionary();
        Map sToKey = (Map)this.paramNameToPdKeyMap_.get(CSVState.SCALE_PARAM_UC_);
        Map scales = (Map)this.newParamsInFile_.get(CSVState.SCALE_PARAM_UC_);
        if (scales != null) {
            Iterator sit = scales.keySet().iterator();
            while (sit.hasNext()) {
                String skey = (String)sit.next();
                MeasureScaleParam sp = (MeasureScaleParam)scales.get(skey);
                String nextID = md.getNextDataKey();
                MeasureScale newScale = new MeasureScale(nextID, sp.name, sp.conv, sp.illegal, sp.unchanged);
                PertDataChange pdc = pd.setMeasureScale(newScale);
                sToKey.put(skey, nextID);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        }
        Map mToKey = (Map)this.paramNameToPdKeyMap_.get(CSVState.MEASURE_TYPE_PARAM_UC_);
        Map measurements = (Map)this.newParamsInFile_.get(CSVState.MEASURE_TYPE_PARAM_UC_);
        if (measurements != null) {
            Iterator mit = measurements.keySet().iterator();
            while (mit.hasNext()) {
                String mkey = (String)mit.next();
                MeasureParam mp = (MeasureParam)measurements.get(mkey);
                String nextID = md.getNextDataKey();
                String scKey = (String)sToKey.get(DataUtil.normKey(mp.scaleName));
                MeasureProps mProps = new MeasureProps(nextID, mp.name, scKey, mp.negThresh, mp.posThresh);
                PertDataChange pdc = pd.setMeasureProp(mProps);
                mToKey.put(mkey, nextID);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        }
        Map pToKey = (Map)this.paramNameToPdKeyMap_.get(CSVState.PERT_TYPE_PARAM_UC_);
        Map pertTypes = (Map)this.newParamsInFile_.get(CSVState.PERT_TYPE_PARAM_UC_);
        if (pertTypes != null) {
            Iterator pit = pertTypes.keySet().iterator();
            while (pit.hasNext()) {
                String pkey = (String)pit.next();
                PertPropParam ppp = (PertPropParam)pertTypes.get(pkey);
                String nextID = pdict.getNextDataKey();
                PertProperties pProps = new PertProperties(nextID, ppp.name, ppp.abbrev, ppp.linkRelation);
                PertDataChange pdc = pd.setPerturbationProp(pProps);
                pToKey.put(pkey, nextID);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        }
        Map eToKey = (Map)this.paramNameToPdKeyMap_.get(CSVState.CONDITION_PARAM_UC_);
        Map exprConds = (Map)this.newParamsInFile_.get(CSVState.CONDITION_PARAM_UC_);
        if (exprConds != null) {
            Iterator cit = exprConds.keySet().iterator();
            while (cit.hasNext()) {
                String ekey = (String)cit.next();
                String condName = (String)exprConds.get(ekey);
                String nextID = cdict.getNextDataKey();
                ExperimentConditions eCond = new ExperimentConditions(nextID, condName);
                PertDataChange pdc = pd.setExperimentConditions(eCond);
                eToKey.put(ekey, nextID);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        }
        Map tToKey = (Map)this.paramNameToPdKeyMap_.get(CSVState.CONTROL_PARAM_UC_);
        Map ctrls = (Map)this.newParamsInFile_.get(CSVState.CONTROL_PARAM_UC_);
        if (ctrls != null) {
            Iterator cit = ctrls.keySet().iterator();
            while (cit.hasNext()) {
                String tkey = (String)cit.next();
                String ctrlName = (String)ctrls.get(tkey);
                String nextID = cdict.getNextDataKey();
                ExperimentControl ctrl = new ExperimentControl(nextID, ctrlName);
                PertDataChange pdc = pd.setExperimentControl(ctrl);
                tToKey.put(tkey, nextID);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        }
        Map uToKey = (Map)this.paramNameToPdKeyMap_.get(CSVState.USER_FIELD_PARAM_UC_);
        Map uFields = (Map)this.newParamsInFile_.get(CSVState.USER_FIELD_PARAM_UC_);
        if (uFields != null) {
            Iterator cit = uFields.keySet().iterator();
            while (cit.hasNext()) {
                String fkey = (String)cit.next();
                String fieldName = (String)uFields.get(fkey);
                String nextID = Integer.toString(pd.getUserFieldCount());
                PertDataChange pdc = pd.setUserFieldName(nextID, fieldName);
                uToKey.put(fkey, nextID);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        }
        Map aToKey = (Map)this.paramNameToPdKeyMap_.get(CSVState.ANNOT_PARAM_UC_);
        Map annots = (Map)this.newParamsInFile_.get(CSVState.ANNOT_PARAM_UC_);
        if (annots != null) {
            Iterator ait = annots.keySet().iterator();
            while (ait.hasNext()) {
                String akey = (String)ait.next();
                AnnotParam aparm = (AnnotParam)annots.get(akey);
                PertDataChange pdc = pd.addAnnotation(aparm.num, aparm.message);
                aToKey.put(akey, pdc.annotKey);
                support.addEdit(new PertDataChangeCmd(pdc));
            }
        }
    }

    public static Boolean convertSigInput(String isValid) {
        if (isValid != null) {
            if ((isValid = isValid.trim()).equalsIgnoreCase("YES") || isValid.equalsIgnoreCase("Y")) {
                return new Boolean(true);
            }
            if (!isValid.equals("")) {
                return new Boolean(false);
            }
            return null;
        }
        return null;
    }

    private boolean reportBadMeasurements(List csvList, TimeAxisDefinition pendingTAD) {
        boolean retval = false;
        Iterator cssit = csvList.iterator();
        while (cssit.hasNext()) {
            CSVState csvs = (CSVState)cssit.next();
            Iterator csvit = csvs.getValues().iterator();
            while (csvit.hasNext()) {
                CSVData csv = (CSVData)csvit.next();
                if (this.processTime(csv, pendingTAD) == Integer.MIN_VALUE) {
                    return true;
                }
                Set targets = csv.getTargets();
                Iterator trit = targets.iterator();
                while (trit.hasNext()) {
                    String target = (String)trit.next();
                    List vals = csv.getMeasurements(target);
                    int vSize = vals.size();
                    for (int i = 0; i < vSize; ++i) {
                        boolean skipMessages;
                        CSVData.DataPoint dpt = (CSVData.DataPoint)vals.get(i);
                        BoundedDoubMinMax illegal = csvs.getIllegalBounds(dpt.measurement);
                        if (CSVData.isValidMeasurement(dpt.value, illegal)) continue;
                        retval = true;
                        ResourceManager rMan = ResourceManager.getManager();
                        String desc = MessageFormat.format(rMan.getString("qpcrcsv.badMeasurement"), dpt.value);
                        int result = JOptionPane.showOptionDialog(this.frame_, desc, rMan.getString("qpcrcsv.badMeasurementTitle"), -1, 0, null, new Object[]{rMan.getString("dialogs.skipMessages"), rMan.getString("dialogs.ok")}, rMan.getString("dialogs.ok"));
                        boolean bl = skipMessages = result == 0;
                        if (!skipMessages) continue;
                        return retval;
                    }
                }
            }
        }
        return retval;
    }

    private int processTime(CSVData csv, TimeAxisDefinition pendingTAD) {
        TimeAxisDefinition tad = pendingTAD != null ? pendingTAD : Database.getDB().getTimeAxisDefinition();
        Integer parsed = tad.timeStringParse(csv.getTime());
        if (parsed == null || parsed < 0) {
            ResourceManager rMan = ResourceManager.getManager();
            String desc = MessageFormat.format(rMan.getString("qpcrcsv.badTimeValue"), csv.getTime());
            JOptionPane.showMessageDialog(this.frame_, desc, rMan.getString("qpcrcsv.badTimeValueTitle"), 0);
            return Integer.MIN_VALUE;
        }
        return parsed;
    }

    protected List fileToLineBlocks(File infile) throws IOException {
        ArrayList blockList = new ArrayList();
        ArrayList<String> currExp = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(infile));
        Pattern pat = Pattern.compile("^,+$");
        Matcher commaMatch = pat.matcher("");
        String line = null;
        while ((line = in.readLine()) != null) {
            if (line.trim().equals("") || commaMatch.reset(line).matches()) {
                if (currExp.size() <= 0) continue;
                blockList.add(currExp);
                currExp = new ArrayList();
                continue;
            }
            currExp.add(line);
        }
        if (currExp.size() > 0) {
            blockList.add(currExp);
        }
        in.close();
        return blockList;
    }

    private void processLineBlock(List lines, int blockNum, CSVState csvState, PerturbationData pd) throws IOException {
        CSVParser csvp = new CSVParser(true);
        int rowNum = 0;
        Iterator lit = lines.iterator();
        while (lit.hasNext()) {
            String line = (String)lit.next();
            List argList = csvp.processCSVLine(line);
            if (blockNum == 0) {
                if (rowNum == 0) {
                    csvState.startTheBlock(argList);
                } else {
                    csvState.parseParameter(argList, this.newParamsInFile_);
                }
            } else if (blockNum == 1) {
                if (rowNum == 0) {
                    csvState.gatherHeadings(argList, pd, this.newParamsInFile_);
                } else {
                    csvState.readDataLine(argList, rowNum);
                }
            }
            ++rowNum;
        }
    }

    String buildNoLineErrorMessage(String rStr, String tok) {
        ResourceManager rMan = ResourceManager.getManager();
        String errStr = rMan.getString(rStr);
        String formStr = rMan.getString("csvInput.errFormatNoLine");
        return MessageFormat.format(formStr, errStr, tok);
    }

    private static class TaggedTAD {
        TimeAxisDefinition tad;
        boolean keepGoing;

        TaggedTAD(TimeAxisDefinition tad, boolean keepGoing) {
            this.tad = tad;
            this.keepGoing = keepGoing;
        }
    }

    private static class PertPropParam {
        String name;
        String abbrev;
        int linkRelation;

        PertPropParam(String name, String abbrev, String pertLinkTag, CSVState csvState) throws IOException {
            this.name = name;
            this.abbrev = abbrev == null ? null : (abbrev.trim().equals("") ? null : abbrev);
            try {
                this.linkRelation = PertDictionary.mapPertLinkTagToVal(pertLinkTag);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException(csvState.buildParamErrorMessage("csvInput.incorrectParamArgs", name));
            }
        }

        PertPropParam(PertProperties pp) {
            this.name = pp.getType();
            this.abbrev = pp.getAbbrev();
            this.linkRelation = pp.getLinkSignRelationship();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof PertPropParam)) {
                return false;
            }
            PertPropParam otherPPP = (PertPropParam)other;
            if (!DataUtil.keysEqual(this.name, otherPPP.name)) {
                return false;
            }
            if (this.abbrev == null ? otherPPP.abbrev != null : !DataUtil.keysEqual(this.abbrev, otherPPP.abbrev)) {
                return false;
            }
            return this.linkRelation == otherPPP.linkRelation;
        }
    }

    private static class MeasureScaleParam {
        String name;
        MeasureScale.Conversion conv;
        BoundedDoubMinMax illegal;
        Double unchanged;

        MeasureScaleParam(String name, String convToFoldTypeTag, String convToFoldFacStr, String minIllegalStr, String minIncludeStr, String maxIllegalStr, String maxIncludeStr, String unchangedStr, CSVState csvState) throws IOException {
            Integer convToFoldType;
            Double maxIllegal;
            Double minIllegal;
            Double convToFoldFac;
            this.name = name;
            try {
                convToFoldFac = convToFoldFacStr == null || convToFoldFacStr.trim().equals("") ? null : new Double(convToFoldFacStr);
                minIllegal = minIllegalStr == null ? null : new Double(minIllegalStr);
                maxIllegal = maxIllegalStr == null ? null : new Double(maxIllegalStr);
                this.unchanged = unchangedStr == null || unchangedStr.trim().equals("") ? null : new Double(unchangedStr);
            }
            catch (NumberFormatException nfex) {
                throw new IOException(csvState.buildParamErrorMessage("csvInput.incorrectParamArgs", name));
            }
            boolean minInclude = minIncludeStr == null || minIncludeStr.trim().equals("") ? true : Boolean.valueOf(minIncludeStr);
            boolean maxInclude = maxIncludeStr == null || maxIncludeStr.trim().equals("") ? true : Boolean.valueOf(maxIncludeStr);
            try {
                convToFoldType = convToFoldTypeTag == null || convToFoldTypeTag.trim().equals("") ? null : new Integer(MeasureScale.Conversion.mapTagToType(convToFoldTypeTag));
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException(csvState.buildParamErrorMessage("csvInput.incorrectParamArgs", name));
            }
            if (minIllegal != null || maxIllegal != null) {
                if (minIllegal == null || maxIllegal == null) {
                    throw new IOException(csvState.buildParamErrorMessage("csvInput.incorrectParamArgs", name));
                }
                this.illegal = new BoundedDoubMinMax(minIllegal, maxIllegal, minInclude, maxInclude);
            } else {
                this.illegal = null;
            }
            if (convToFoldType == null) {
                this.conv = null;
            } else {
                if (convToFoldType == 1 && convToFoldFac == null) {
                    throw new IOException(csvState.buildParamErrorMessage("csvInput.incorrectParamArgs", name));
                }
                this.conv = new MeasureScale.Conversion(convToFoldType, convToFoldFac);
            }
        }

        MeasureScaleParam(MeasureScale scale) {
            this.name = scale.getName();
            this.conv = scale.getConvToFold();
            this.illegal = scale.getIllegalRange();
            this.unchanged = scale.getUnchanged();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof MeasureScaleParam)) {
                return false;
            }
            MeasureScaleParam otherMSP = (MeasureScaleParam)other;
            if (!DataUtil.keysEqual(this.name, otherMSP.name)) {
                return false;
            }
            if (this.unchanged == null ? otherMSP.unchanged != null : !this.unchanged.equals(otherMSP.unchanged)) {
                return false;
            }
            if (this.conv == null ? otherMSP.conv != null : !this.conv.equals(otherMSP.conv)) {
                return false;
            }
            return !(this.illegal == null ? otherMSP.illegal != null : !this.illegal.equals(otherMSP.illegal));
        }
    }

    private static class MeasureParam {
        String name;
        String scaleName;
        Double negThresh;
        Double posThresh;

        MeasureParam(String name, String scaleName, String negThresh, String posThresh, CSVState csvState) throws IOException {
            this.name = name;
            this.scaleName = scaleName;
            try {
                this.negThresh = new Double(negThresh);
                this.posThresh = new Double(posThresh);
            }
            catch (NumberFormatException nfex) {
                throw new IOException(csvState.buildParamErrorMessage("csvInput.incorrectParamArgs", name));
            }
        }

        MeasureParam(MeasureProps props, PerturbationData pd) {
            this.name = props.getName();
            this.scaleName = pd.getMeasureDictionary().getMeasureScale(props.getScaleKey()).getName();
            this.negThresh = props.getNegThresh();
            this.posThresh = props.getPosThresh();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof MeasureParam)) {
                return false;
            }
            MeasureParam otherMP = (MeasureParam)other;
            if (!DataUtil.keysEqual(this.name, otherMP.name)) {
                return false;
            }
            if (!DataUtil.keysEqual(this.scaleName, otherMP.scaleName)) {
                return false;
            }
            if (this.negThresh == null ? otherMP.negThresh != null : !this.negThresh.equals(otherMP.negThresh)) {
                return false;
            }
            return !(this.posThresh == null ? otherMP.posThresh != null : !this.posThresh.equals(otherMP.posThresh));
        }
    }

    private static class AnnotParam {
        String num;
        String message;

        AnnotParam(String num, String message) {
            this.num = num;
            this.message = message;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof AnnotParam)) {
                return false;
            }
            AnnotParam otherAP = (AnnotParam)other;
            if (!DataUtil.keysEqual(this.num, otherAP.num)) {
                return false;
            }
            return DataUtil.keysEqual(this.message, otherAP.message);
        }
    }

    public static class CSVState {
        public static final String BATCH_ID = "BatchID";
        public static final String PERT_AGENT = "PerturbationAgent";
        public static final String MEAS_GENE = "MeasuredGene";
        public static final String TIME = "Time";
        public static final String DEL_DEL_CT = "DeltaDeltaCt";
        public static final String CONTROL = "ExpControl";
        public static final String FORCE = "ForceSignificance";
        public static final String COMMENTS = "Comments";
        public static final String CONDITION = "Condition";
        public static final String MEASURE_TYPE = "MeasureType";
        public static final String MEASUREMENT = "Measurement";
        public static final String ANNOT = "Annot";
        public static final String BATCH_ID_UC = "BatchID".toUpperCase();
        public static final String PERT_AGENT_UC = "PerturbationAgent".toUpperCase();
        public static final String MEAS_GENE_UC = "MeasuredGene".toUpperCase();
        public static final String TIME_UC = "Time".toUpperCase();
        public static final String DEL_DEL_CT_UC = "DeltaDeltaCt".toUpperCase();
        public static final String CONTROL_UC = "ExpControl".toUpperCase();
        public static final String FORCE_UC = "ForceSignificance".toUpperCase();
        public static final String COMMENTS_UC = "Comments".toUpperCase();
        public static final String CONDITION_UC = "Condition".toUpperCase();
        public static final String MEASURE_TYPE_UC = "MeasureType".toUpperCase();
        public static final String MEASUREMENT_UC = "Measurement".toUpperCase();
        public static final String ANNOT_UC = "Annot".toUpperCase();
        static final String USER_FIELD_PARAM_ = "UserField";
        static final String TIME_SCALE_PARAM_ = "TimeScale";
        static final String MEASURE_TYPE_PARAM_ = "MeasureType";
        static final String SCALE_PARAM_ = "MeasureScale";
        static final String CONTROL_PARAM_ = "Control";
        static final String CONDITION_PARAM_ = "Condition";
        static final String PERT_TYPE_PARAM_ = "PerturbationType";
        static final String DATE_PARAM_ = "Date";
        static final String ANNOT_PARAM_ = "Annot";
        static final String USER_FIELD_PARAM_UC_ = "UserField".toUpperCase();
        static final String TIME_SCALE_PARAM_UC_ = "TimeScale".toUpperCase();
        static final String MEASURE_TYPE_PARAM_UC_ = "MeasureType".toUpperCase();
        static final String SCALE_PARAM_UC_ = "MeasureScale".toUpperCase();
        static final String CONTROL_PARAM_UC_ = "Control".toUpperCase();
        static final String CONDITION_PARAM_UC_ = "Condition".toUpperCase();
        static final String PERT_TYPE_PARAM_UC_ = "PerturbationType".toUpperCase();
        static final String DATE_PARAM_UC_ = "Date".toUpperCase();
        static final String ANNOT_PARAM_UC_ = "Annot".toUpperCase();
        private int setNumber_;
        private ArrayList investigators_;
        private String date_;
        private HashMap userFieldToColMap_;
        private HashMap argToColMap_;
        private HashSet vocabulary_;
        private HashSet paramVocab_;
        private HashSet required_;
        private HashMap paramMap_;
        private Map nameToPdKey_;
        private HashMap csvMap_;
        private boolean legacy_;
        private String singleAnnot_;
        private boolean haveMultiAnnots_;
        private Set requiredUFields_;
        private boolean useDate_;
        private boolean useTime_;
        private boolean useBatch_;
        private boolean useInvest_;
        private boolean useCondition_;

        CSVState(boolean legacy, int setNumber, Map nameToPdKey, boolean useDate, boolean useTime, boolean useBatch, boolean useInvest, boolean useCondition) {
            this.setNumber_ = setNumber;
            this.investigators_ = new ArrayList();
            this.date_ = null;
            this.vocabulary_ = new HashSet();
            this.required_ = new HashSet();
            this.paramVocab_ = new HashSet();
            this.csvMap_ = new HashMap();
            this.paramMap_ = new HashMap();
            this.nameToPdKey_ = nameToPdKey;
            this.legacy_ = legacy;
            this.useDate_ = useDate;
            this.useTime_ = useTime;
            this.useBatch_ = useBatch;
            this.useInvest_ = useInvest;
            this.useCondition_ = useCondition;
            this.buildParamVocabulary();
        }

        List getValues() {
            return new ArrayList(this.csvMap_.values());
        }

        void readDataLine(List argList, int rowNum) throws IOException {
            String fullBatchID;
            String condition;
            int batchCol = (Integer)this.argToColMap_.get(BATCH_ID_UC);
            int pertCol = (Integer)this.argToColMap_.get(PERT_AGENT_UC);
            int timeCol = (Integer)this.argToColMap_.get(TIME_UC);
            int numArgs = argList.size();
            if (numArgs <= batchCol || numArgs <= pertCol || numArgs <= timeCol) {
                throw new IOException(this.buildTokenErrorMessage("csvInput.badRow", rowNum, Integer.toString(numArgs)));
            }
            String time = (String)argList.get(timeCol);
            String batch = (String)argList.get(batchCol);
            List etoks = this.experimentParse((String)argList.get(pertCol), rowNum);
            String keyForLine = CSVData.buildRowKey(etoks, this.date_, this.investigators_, time, condition = this.conditionParse(argList, rowNum), fullBatchID = CSVData.buildBatchKey(this.date_, this.investigators_, batch, time, condition, this.useDate_, this.useTime_, this.useBatch_, this.useInvest_, this.useCondition_));
            CSVData csvMatch = (CSVData)this.csvMap_.get(keyForLine);
            if (csvMatch == null) {
                csvMatch = new CSVData(etoks, this.date_, this.investigators_, time, condition, fullBatchID);
                this.csvMap_.put(keyForLine, csvMatch);
            }
            CSVData.DataPoint dp = this.buildMeasurement(argList, rowNum);
            csvMatch.addDataPoint(dp);
        }

        String getPDKey(String paramKey, String name) {
            Map toKey = (Map)this.nameToPdKey_.get(DataUtil.normKey(paramKey));
            return (String)toKey.get(DataUtil.normKey(name));
        }

        void augmentParameters(PerturbationData pd, Map newParamsInFile) throws IOException {
            this.augmentScaleParameters(pd, newParamsInFile);
            this.augmentMeasureParameters(pd, newParamsInFile);
            this.augmentPertPropParameters(pd, newParamsInFile);
            this.augmentConditionParameters(pd, newParamsInFile);
            this.augmentAnnotParameters(pd, newParamsInFile);
            this.augmentControlParameters(pd, newParamsInFile);
            this.augmentUserFieldParameters(pd, newParamsInFile);
        }

        private void augmentScaleParameters(PerturbationData pd, Map newParamsInFile) throws IOException {
            HashMap<String, MeasureScaleParam> scales;
            MeasureDictionary md = pd.getMeasureDictionary();
            HashMap<String, String> scToKey = (HashMap<String, String>)this.nameToPdKey_.get(SCALE_PARAM_UC_);
            if (scToKey == null) {
                scToKey = new HashMap<String, String>();
                this.nameToPdKey_.put(SCALE_PARAM_UC_, scToKey);
            }
            if ((scales = (HashMap<String, MeasureScaleParam>)this.paramMap_.get(SCALE_PARAM_UC_)) == null) {
                scales = new HashMap<String, MeasureScaleParam>();
                this.paramMap_.put(SCALE_PARAM_UC_, scales);
            }
            Map newScales = (Map)newParamsInFile.get(SCALE_PARAM_UC_);
            Iterator skit = md.getScaleKeys();
            while (skit.hasNext()) {
                String key = (String)skit.next();
                MeasureScale scale = md.getMeasureScale(key);
                MeasureScaleParam msp = new MeasureScaleParam(scale);
                String scaleName = DataUtil.normKey(scale.getName());
                MeasureScaleParam nameMatch = (MeasureScaleParam)scales.get(scaleName);
                if (nameMatch != null) {
                    if (!nameMatch.equals(msp)) {
                        throw new IOException(this.buildParamErrorMessage("csvInput.measureScaleInconsistent", nameMatch.name));
                    }
                    scToKey.put(scaleName, scale.getID());
                    newScales.remove(scaleName);
                    continue;
                }
                scales.put(scaleName, msp);
                scToKey.put(scaleName, scale.getID());
            }
        }

        private void augmentMeasureParameters(PerturbationData pd, Map newParamsInFile) throws IOException {
            HashMap<String, MeasureParam> mPropMap;
            MeasureDictionary md = pd.getMeasureDictionary();
            HashMap<String, String> mpToKey = (HashMap<String, String>)this.nameToPdKey_.get(MEASURE_TYPE_PARAM_UC_);
            if (mpToKey == null) {
                mpToKey = new HashMap<String, String>();
                this.nameToPdKey_.put(MEASURE_TYPE_PARAM_UC_, mpToKey);
            }
            if ((mPropMap = (HashMap<String, MeasureParam>)this.paramMap_.get(MEASURE_TYPE_PARAM_UC_)) == null) {
                mPropMap = new HashMap<String, MeasureParam>();
                this.paramMap_.put(MEASURE_TYPE_PARAM_UC_, mPropMap);
            }
            Map newProps = (Map)newParamsInFile.get(MEASURE_TYPE_PARAM_UC_);
            Iterator mpkit = md.getKeys();
            while (mpkit.hasNext()) {
                String key = (String)mpkit.next();
                MeasureProps mProps = md.getMeasureProps(key);
                MeasureParam mp = new MeasureParam(mProps, pd);
                String propName = DataUtil.normKey(mProps.getName());
                MeasureParam nameMatch = (MeasureParam)mPropMap.get(propName);
                if (nameMatch != null) {
                    if (!nameMatch.equals(mp)) {
                        throw new IOException(this.buildParamErrorMessage("csvInput.measureParamInconsistent", nameMatch.name));
                    }
                    mpToKey.put(propName, mProps.getID());
                    newProps.remove(propName);
                    continue;
                }
                mPropMap.put(propName, mp);
                mpToKey.put(propName, mProps.getID());
            }
        }

        private void augmentPertPropParameters(PerturbationData pd, Map newParamsInFile) throws IOException {
            HashMap<String, PertPropParam> pertTypes;
            PertDictionary pDict = pd.getPertDictionary();
            HashMap<String, String> pToKey = (HashMap<String, String>)this.nameToPdKey_.get(PERT_TYPE_PARAM_UC_);
            if (pToKey == null) {
                pToKey = new HashMap<String, String>();
                this.nameToPdKey_.put(PERT_TYPE_PARAM_UC_, pToKey);
            }
            if ((pertTypes = (HashMap<String, PertPropParam>)this.paramMap_.get(PERT_TYPE_PARAM_UC_)) == null) {
                pertTypes = new HashMap<String, PertPropParam>();
                this.paramMap_.put(PERT_TYPE_PARAM_UC_, pertTypes);
            }
            Map newPerts = (Map)newParamsInFile.get(PERT_TYPE_PARAM_UC_);
            Iterator pdkit = pDict.getKeys();
            while (pdkit.hasNext()) {
                String key = (String)pdkit.next();
                PertProperties pProps = pDict.getPerturbProps(key);
                PertPropParam ppp = new PertPropParam(pProps);
                String propName = DataUtil.normKey(pProps.getType());
                PertPropParam nameMatch = (PertPropParam)pertTypes.get(propName);
                if (nameMatch != null) {
                    if (!nameMatch.equals(ppp)) {
                        throw new IOException(this.buildParamErrorMessage("csvInput.pertPropInconsistent", nameMatch.name));
                    }
                    pToKey.put(propName, pProps.getID());
                    newPerts.remove(propName);
                    continue;
                }
                pertTypes.put(propName, ppp);
                pToKey.put(propName, pProps.getID());
            }
        }

        private void augmentConditionParameters(PerturbationData pd, Map newParamsInFile) throws IOException {
            HashMap<String, String> condTypes;
            ConditionDictionary cDict = pd.getConditionDictionary();
            HashMap<String, String> eToKey = (HashMap<String, String>)this.nameToPdKey_.get(CONDITION_PARAM_UC_);
            if (eToKey == null) {
                eToKey = new HashMap<String, String>();
                this.nameToPdKey_.put(CONDITION_PARAM_UC_, eToKey);
            }
            if ((condTypes = (HashMap<String, String>)this.paramMap_.get(CONDITION_PARAM_UC_)) == null) {
                condTypes = new HashMap<String, String>();
                this.paramMap_.put(CONDITION_PARAM_UC_, condTypes);
            }
            Map newCond = (Map)newParamsInFile.get(CONDITION_PARAM_UC_);
            Iterator pdkit = cDict.getKeys();
            while (pdkit.hasNext()) {
                String key = (String)pdkit.next();
                ExperimentConditions eCond = cDict.getExprConditions(key);
                String condName = DataUtil.normKey(eCond.getDescription());
                String nameMatch = (String)condTypes.get(condName);
                if (nameMatch != null) {
                    if (!DataUtil.keysEqual(nameMatch, condName)) {
                        throw new IOException(this.buildParamErrorMessage("csvInput.conditionInconsistent", nameMatch));
                    }
                    eToKey.put(condName, eCond.getID());
                    newCond.remove(condName);
                    continue;
                }
                condTypes.put(condName, eCond.getDescription());
                eToKey.put(condName, eCond.getID());
            }
        }

        private void augmentAnnotParameters(PerturbationData pd, Map newParamsInFile) throws IOException {
            HashMap<String, AnnotParam> annotMap;
            PertAnnotations pa = pd.getPertAnnotations();
            HashMap aToKey = (HashMap)this.nameToPdKey_.get(ANNOT_PARAM_UC_);
            if (aToKey == null) {
                aToKey = new HashMap();
                this.nameToPdKey_.put(ANNOT_PARAM_UC_, aToKey);
            }
            if ((annotMap = (HashMap<String, AnnotParam>)this.paramMap_.get(ANNOT_PARAM_UC_)) == null) {
                annotMap = new HashMap<String, AnnotParam>();
                this.paramMap_.put(ANNOT_PARAM_UC_, annotMap);
            }
            if (annotMap.size() == 1) {
                this.singleAnnot_ = (String)annotMap.keySet().iterator().next();
            } else if (annotMap.size() > 1) {
                this.haveMultiAnnots_ = true;
            }
            Map newAnnot = (Map)newParamsInFile.get(ANNOT_PARAM_UC_);
            SortedMap fullMap = pa.getFullMap();
            SortedMap tagToKey = pa.getFootTagToKeyMap();
            Iterator tkit = fullMap.keySet().iterator();
            while (tkit.hasNext()) {
                String key = (String)tkit.next();
                String message = (String)fullMap.get(key);
                AnnotParam dbAnnot = new AnnotParam(key, message);
                String annotNum = DataUtil.normKey(key);
                AnnotParam nameMatch = (AnnotParam)annotMap.get(annotNum);
                if (nameMatch != null) {
                    if (!nameMatch.equals(dbAnnot)) {
                        throw new IOException(this.buildParamErrorMessage("csvInput.annotInconsistent", nameMatch.num));
                    }
                    aToKey.put(annotNum, tagToKey.get(key));
                    newAnnot.remove(annotNum);
                    continue;
                }
                annotMap.put(annotNum, dbAnnot);
                aToKey.put(annotNum, tagToKey.get(key));
            }
        }

        private void augmentControlParameters(PerturbationData pd, Map newParamsInFile) throws IOException {
            HashMap<String, String> ctrlMap;
            ConditionDictionary cDict = pd.getConditionDictionary();
            HashMap<String, String> ctToKey = (HashMap<String, String>)this.nameToPdKey_.get(CONTROL_PARAM_UC_);
            if (ctToKey == null) {
                ctToKey = new HashMap<String, String>();
                this.nameToPdKey_.put(CONTROL_PARAM_UC_, ctToKey);
            }
            if ((ctrlMap = (HashMap<String, String>)this.paramMap_.get(CONTROL_PARAM_UC_)) == null) {
                ctrlMap = new HashMap<String, String>();
                this.paramMap_.put(CONTROL_PARAM_UC_, ctrlMap);
            }
            Map newCtrl = (Map)newParamsInFile.get(CONTROL_PARAM_UC_);
            Iterator ctkit = cDict.getControlKeys();
            while (ctkit.hasNext()) {
                String key = (String)ctkit.next();
                ExperimentControl ectrl = cDict.getExprControl(key);
                String ctrlName = DataUtil.normKey(ectrl.getDescription());
                String nameMatch = (String)ctrlMap.get(ctrlName);
                if (nameMatch != null) {
                    if (!DataUtil.normKey(nameMatch).equals(ctrlName)) {
                        throw new IOException(this.buildParamErrorMessage("csvInput.controlInconsistent", nameMatch));
                    }
                    ctToKey.put(ctrlName, ectrl.getID());
                    newCtrl.remove(ctrlName);
                    continue;
                }
                ctrlMap.put(ctrlName, ectrl.getDescription());
                ctToKey.put(ctrlName, ectrl.getID());
            }
        }

        private void augmentUserFieldParameters(PerturbationData pd, Map newParamsInFile) throws IOException {
            HashMap<String, String> ufMap;
            HashMap<String, String> ufToKey = (HashMap<String, String>)this.nameToPdKey_.get(USER_FIELD_PARAM_UC_);
            if (ufToKey == null) {
                ufToKey = new HashMap<String, String>();
                this.nameToPdKey_.put(USER_FIELD_PARAM_UC_, ufToKey);
            }
            if ((ufMap = (HashMap<String, String>)this.paramMap_.get(USER_FIELD_PARAM_UC_)) == null) {
                ufMap = new HashMap<String, String>();
                this.paramMap_.put(USER_FIELD_PARAM_UC_, ufMap);
            }
            if (ufMap != null && !ufMap.isEmpty()) {
                this.requiredUFields_ = new HashSet(ufMap.keySet());
            }
            Map newUF = (Map)newParamsInFile.get(USER_FIELD_PARAM_UC_);
            int numUF = pd.getUserFieldCount();
            for (int i = 0; i < numUF; ++i) {
                String ufn = pd.getUserFieldName(i);
                String ufnNorm = DataUtil.normKey(ufn);
                String nameMatch = (String)ufMap.get(ufnNorm);
                if (nameMatch != null) {
                    if (!DataUtil.normKey(nameMatch).equals(ufnNorm)) {
                        throw new IOException(this.buildParamErrorMessage("csvInput.userFieldInconsistent", nameMatch));
                    }
                    ufToKey.put(ufnNorm, Integer.toString(i));
                    newUF.remove(ufnNorm);
                    continue;
                }
                ufMap.put(ufnNorm, ufn);
                ufToKey.put(ufnNorm, Integer.toString(i));
            }
        }

        String buildTokenErrorMessage(String rStr, int rowNum, String tok) {
            ResourceManager rMan = ResourceManager.getManager();
            String errStr = rMan.getString(rStr);
            String formStr = rMan.getString("csvInput.tokErrFormat");
            return MessageFormat.format(formStr, errStr, new Integer(this.setNumber_), new Integer(rowNum), tok);
        }

        String buildParamErrorMessage(String rStr, String tok) {
            ResourceManager rMan = ResourceManager.getManager();
            String errStr = rMan.getString(rStr);
            String formStr = rMan.getString("csvInput.paramErrFormat");
            return MessageFormat.format(formStr, errStr, new Integer(this.setNumber_), tok);
        }

        String buildHeadingErrorMessage(String rStr, String tok) {
            ResourceManager rMan = ResourceManager.getManager();
            String errStr = rMan.getString(rStr);
            String formStr = rMan.getString("csvInput.headingErrFormat");
            return MessageFormat.format(formStr, errStr, new Integer(this.setNumber_), tok);
        }

        private CSVData.DataPoint buildMeasurement(List args, int rowNum) throws IOException {
            int commCol;
            String isValid;
            int numArgs = args.size();
            int targCol = (Integer)this.argToColMap_.get(MEAS_GENE_UC);
            String target = (String)args.get(targCol);
            if (target == null || target.trim().equals("")) {
                throw new IOException(this.buildTokenErrorMessage("csvInput.badTarget", rowNum, target));
            }
            String meaKey = this.legacy_ ? DEL_DEL_CT_UC : MEASUREMENT_UC;
            int valCol = (Integer)this.argToColMap_.get(meaKey);
            String value = (String)args.get(valCol);
            if (value == null || value.trim().equals("")) {
                throw new IOException(this.buildTokenErrorMessage("csvInput.badMeasurement", rowNum, value));
            }
            int isValCol = (Integer)this.argToColMap_.get(FORCE_UC);
            String string = isValid = numArgs >= isValCol + 1 ? (String)args.get(isValCol) : null;
            if (!this.sigCSVInputOK(isValid)) {
                throw new IOException(this.buildTokenErrorMessage("csvInput.badSignificance", rowNum, isValid));
            }
            if (isValid != null && (isValid = isValid.trim()).equals("")) {
                isValid = null;
            }
            String comment = numArgs >= (commCol = ((Integer)this.argToColMap_.get(COMMENTS_UC)).intValue()) + 1 ? (String)args.get(commCol) : "";
            comment = comment == null ? null : comment.trim();
            String control = null;
            Map controls = (Map)this.paramMap_.get(CONTROL_PARAM_UC_);
            if (controls != null && controls.size() > 1) {
                int contCol = (Integer)this.argToColMap_.get(CONTROL_UC);
                String string2 = control = numArgs >= contCol + 1 ? (String)args.get(contCol) : "";
                if (control != null) {
                    control = control.trim();
                    if (!controls.keySet().contains(DataUtil.normKey(control))) {
                        throw new IOException(this.buildTokenErrorMessage("csvInput.badControl", rowNum, control));
                    }
                }
            }
            String measurement = null;
            Map measurements = (Map)this.paramMap_.get(MEASURE_TYPE_PARAM_UC_);
            if (measurements != null) {
                if (measurements.size() > 1) {
                    int measCol = (Integer)this.argToColMap_.get(MEASURE_TYPE_PARAM_UC_);
                    String string3 = measurement = numArgs >= measCol + 1 ? (String)args.get(measCol) : "";
                    if (measurement != null) {
                        measurement = measurement.trim();
                        if (!measurements.keySet().contains(DataUtil.normKey(measurement))) {
                            throw new IOException(this.buildTokenErrorMessage("csvInput.badMeasureType", rowNum, measurement));
                        }
                    }
                } else {
                    measurement = (String)measurements.keySet().iterator().next();
                }
            }
            ArrayList<String> annotList = new ArrayList<String>();
            Integer annotColObj = (Integer)this.argToColMap_.get(ANNOT_PARAM_UC_);
            if (annotColObj == null) {
                if (this.singleAnnot_ != null) {
                    annotList.add(this.singleAnnot_);
                }
            } else {
                String annotListStr;
                Map annots = (Map)this.paramMap_.get(ANNOT_PARAM_UC_);
                int annotCol = annotColObj;
                String string4 = annotListStr = numArgs >= annotCol + 1 ? (String)args.get(annotCol) : "";
                if (annotListStr != null) {
                    StringTokenizer strTok = new StringTokenizer(annotListStr.trim(), "+");
                    while (strTok.hasMoreTokens()) {
                        String tok = strTok.nextToken();
                        annotList.add(tok);
                        if (annots.keySet().contains(DataUtil.normKey(tok))) continue;
                        throw new IOException(this.buildTokenErrorMessage("csvInput.badAnnotType", rowNum, tok));
                    }
                }
            }
            HashMap<String, String> ufs = new HashMap<String, String>();
            Iterator ufit = this.userFieldToColMap_.keySet().iterator();
            while (ufit.hasNext()) {
                String ufname = (String)ufit.next();
                int ufCol = (Integer)this.userFieldToColMap_.get(ufname);
                String ufVal = numArgs >= ufCol + 1 ? (String)args.get(ufCol) : "";
                ufs.put(ufname, ufVal);
            }
            CSVData.DataPoint dp = new CSVData.DataPoint(target.trim(), value.trim(), control, isValid, comment);
            dp.measurement = measurement;
            dp.annots = annotList;
            dp.userFields.putAll(ufs);
            return dp;
        }

        private boolean sigCSVInputOK(String isValid) {
            String string = isValid = isValid == null ? "" : isValid.trim();
            return isValid.equals("") || isValid.equalsIgnoreCase("YES") || isValid.equalsIgnoreCase("Y") || isValid.equalsIgnoreCase("NO") || isValid.equalsIgnoreCase("N") || isValid.equalsIgnoreCase("NS");
        }

        void gatherHeadings(List argList, PerturbationData pd, Map newParamsInFile) throws IOException {
            this.extractDate();
            this.augmentParameters(pd, newParamsInFile);
            this.buildVocabulary();
            this.parseHeadingRow(argList, pd);
        }

        void startTheBlock(List argList) throws IOException {
            if (argList.size() < 1) {
                throw new IOException(this.buildParamErrorMessage("csvInput.badBlockStart", ""));
            }
            String firstInvest = (String)argList.get(0);
            if (firstInvest == null || firstInvest.trim().equals("")) {
                throw new IOException(this.buildParamErrorMessage("csvInput.badInvestigator", firstInvest));
            }
            int numInvest = argList.size();
            for (int i = 0; i < numInvest; ++i) {
                String nextInvest = (String)argList.get(i);
                if (nextInvest == null || nextInvest.trim().equals("")) continue;
                this.investigators_.add(nextInvest.trim());
            }
        }

        void extractDate() throws IOException {
            HashMap dates = (HashMap)this.paramMap_.get(DATE_PARAM_UC_);
            if (dates == null || dates.size() != 1) {
                throw new IOException(this.buildParamErrorMessage("csvInput.badDateDef", ""));
            }
            this.date_ = (String)dates.values().iterator().next();
            if (this.date_ == null || this.date_.trim().equals("")) {
                throw new IOException(this.buildParamErrorMessage("csvInput.badDate", this.date_));
            }
        }

        BoundedDoubMinMax getIllegalBounds(String meaKey) {
            Map measures = (Map)this.paramMap_.get(MEASURE_TYPE_PARAM_UC_);
            MeasureParam mp = (MeasureParam)measures.get(DataUtil.normKey(meaKey));
            Map scales = (Map)this.paramMap_.get(SCALE_PARAM_UC_);
            MeasureScaleParam ms = (MeasureScaleParam)scales.get(DataUtil.normKey(mp.scaleName));
            return ms.illegal;
        }

        private List experimentParse(String value, int rowNum) throws IOException {
            ArrayList<CSVData.ExperimentTokens> retval = new ArrayList<CSVData.ExperimentTokens>();
            StringTokenizer strTok = new StringTokenizer(value.trim(), "&");
            block0: while (strTok.hasMoreTokens()) {
                String tok = strTok.nextToken();
                CSVData.ExperimentTokens exptok = new CSVData.ExperimentTokens();
                Map pertTypes = (Map)this.paramMap_.get(PERT_TYPE_PARAM_UC_);
                Iterator kit = pertTypes.keySet().iterator();
                while (kit.hasNext()) {
                    String ptKey = (String)kit.next();
                    PertPropParam ppp = (PertPropParam)pertTypes.get(ptKey);
                    if (!exptok.haveAMatch(tok, ppp.name, ppp.abbrev)) continue;
                    retval.add(exptok);
                    continue block0;
                }
            }
            if (retval.isEmpty()) {
                throw new IOException(this.buildTokenErrorMessage("csvInput.pertPropMismatch", rowNum, value));
            }
            return retval;
        }

        private String conditionParse(List args, int rowNum) throws IOException {
            String condition;
            int numArgs = args.size();
            Map conditions = (Map)this.paramMap_.get(CONDITION_PARAM_UC_);
            if (conditions != null) {
                if (conditions.size() > 1) {
                    int condCol = (Integer)this.argToColMap_.get(CONDITION_PARAM_UC_);
                    String string = condition = numArgs >= condCol + 1 ? (String)args.get(condCol) : "";
                    if (condition != null) {
                        condition = condition.trim();
                        if (!conditions.keySet().contains(DataUtil.normKey(condition))) {
                            throw new IOException(this.buildTokenErrorMessage("csvInput.badCondition", rowNum, condition));
                        }
                    }
                } else {
                    condition = (String)conditions.keySet().iterator().next();
                }
            } else {
                ConditionDictionary cDict = Database.getDB().getPertData().getConditionDictionary();
                condition = cDict.getExprConditions(cDict.getStandardConditionKey()).getDescription();
            }
            return condition;
        }

        private void parseHeadingRow(List argList, PerturbationData pd) throws IOException {
            HashSet remaining = new HashSet(this.vocabulary_);
            HashSet stillRequired = new HashSet(this.required_);
            this.userFieldToColMap_ = new HashMap();
            this.argToColMap_ = new HashMap();
            HashSet<String> userFields = new HashSet<String>();
            int numUF = pd.getUserFieldCount();
            for (int i = 0; i < numUF; ++i) {
                String ufn = pd.getUserFieldName(i);
                String ufnNorm = DataUtil.normKey(ufn);
                userFields.add(ufnNorm);
            }
            if (this.requiredUFields_ != null) {
                userFields.addAll(this.requiredUFields_);
            }
            int listSize = argList.size();
            for (int i = 0; i < listSize; ++i) {
                String arg = ((String)argList.get(i)).trim();
                String normArg = DataUtil.normKey(arg);
                if (!this.vocabulary_.contains(normArg)) {
                    throw new IOException(this.buildHeadingErrorMessage("csvInput.badHeading", normArg));
                }
                if (!remaining.contains(normArg)) {
                    throw new IOException(this.buildHeadingErrorMessage("csvInput.duplicateHeading", normArg));
                }
                remaining.remove(normArg);
                stillRequired.remove(normArg);
                Integer colObj = new Integer(i);
                if (userFields.contains(normArg)) {
                    this.userFieldToColMap_.put(normArg, colObj);
                    continue;
                }
                this.argToColMap_.put(normArg, colObj);
            }
            if (!stillRequired.isEmpty()) {
                String stillR = (String)stillRequired.iterator().next();
                throw new IOException(this.buildHeadingErrorMessage("csvInput.missingRequiredHeading", stillR));
            }
        }

        void buildVocabulary() {
            Map measures;
            this.vocabulary_.add(BATCH_ID_UC);
            this.required_.add(BATCH_ID_UC);
            this.vocabulary_.add(PERT_AGENT_UC);
            this.required_.add(PERT_AGENT_UC);
            this.vocabulary_.add(MEAS_GENE_UC);
            this.required_.add(MEAS_GENE_UC);
            this.vocabulary_.add(TIME_UC);
            this.required_.add(TIME_UC);
            if (this.legacy_) {
                this.vocabulary_.add(DEL_DEL_CT_UC);
                this.required_.add(DEL_DEL_CT_UC);
            } else {
                this.vocabulary_.add(MEASUREMENT_UC);
                this.required_.add(MEASUREMENT_UC);
            }
            if (this.legacy_) {
                this.vocabulary_.add(CONTROL_UC);
                this.required_.add(CONTROL_UC);
            } else {
                Map controls = (Map)this.paramMap_.get(CONTROL_PARAM_UC_);
                if (controls != null && controls.size() > 1) {
                    this.vocabulary_.add(CONTROL_UC);
                    this.required_.add(CONTROL_UC);
                }
            }
            Map conditions = (Map)this.paramMap_.get(CONDITION_PARAM_UC_);
            if (conditions != null && conditions.size() > 1) {
                this.vocabulary_.add(CONDITION_UC);
                this.required_.add(CONDITION_UC);
            }
            this.vocabulary_.add(FORCE_UC);
            this.vocabulary_.add(COMMENTS_UC);
            Map userFields = (Map)this.paramMap_.get(USER_FIELD_PARAM_UC_);
            if (userFields != null) {
                Iterator ufit = userFields.values().iterator();
                while (ufit.hasNext()) {
                    String ufield = (String)ufit.next();
                    this.vocabulary_.add(DataUtil.normKey(ufield));
                }
                if (this.requiredUFields_ != null) {
                    this.required_.addAll(this.requiredUFields_);
                }
            }
            if ((measures = (Map)this.paramMap_.get(MEASURE_TYPE_PARAM_UC_)) != null && measures.size() > 1) {
                this.vocabulary_.add(MEASURE_TYPE_UC);
                this.required_.add(MEASURE_TYPE_UC);
            }
            this.vocabulary_.add(ANNOT_UC);
            if (this.haveMultiAnnots_) {
                this.required_.add(ANNOT_UC);
            }
        }

        private void buildParamVocabulary() {
            this.paramVocab_.add(USER_FIELD_PARAM_UC_);
            this.paramVocab_.add(TIME_SCALE_PARAM_UC_);
            this.paramVocab_.add(MEASURE_TYPE_PARAM_UC_);
            this.paramVocab_.add(SCALE_PARAM_UC_);
            this.paramVocab_.add(CONTROL_PARAM_UC_);
            this.paramVocab_.add(CONDITION_PARAM_UC_);
            this.paramVocab_.add(PERT_TYPE_PARAM_UC_);
            this.paramVocab_.add(DATE_PARAM_UC_);
            this.paramVocab_.add(ANNOT_PARAM_UC_);
        }

        private void parseParameter(List argList, Map newParamsInFile) throws IOException {
            HashMap parms = null;
            ArrayList<String> buildList = new ArrayList<String>();
            String normArg = null;
            int listSize = argList.size();
            for (int i = 0; i < listSize; ++i) {
                String arg = ((String)argList.get(i)).trim();
                if (i == 0) {
                    normArg = DataUtil.normKey(arg);
                    if (!this.paramVocab_.contains(normArg)) {
                        throw new IOException(this.buildParamErrorMessage("csvInput.badParameterName", arg));
                    }
                    parms = (HashMap)this.paramMap_.get(normArg);
                    if (parms != null) continue;
                    parms = new HashMap();
                    this.paramMap_.put(normArg, parms);
                    continue;
                }
                buildList.add(arg);
            }
            this.buildParameter(normArg, buildList, parms, newParamsInFile);
        }

        private void buildParameter(String normArg, List buildList, HashMap parms, Map newParamsInFile) throws IOException {
            if (buildList.isEmpty()) {
                throw new IOException(this.buildParamErrorMessage("csvInput.invalidParameterDefinition", normArg));
            }
            String key = DataUtil.normKey((String)buildList.get(0));
            if (normArg.equals(MEASURE_TYPE_PARAM_UC_)) {
                this.buildMeasureParameter(key, buildList, parms, newParamsInFile);
            } else if (normArg.equals(SCALE_PARAM_UC_)) {
                this.buildScaleParameter(key, buildList, parms, newParamsInFile);
            } else if (normArg.equals(ANNOT_PARAM_UC_)) {
                this.buildAnnotParameter(key, buildList, parms, newParamsInFile);
            } else if (normArg.equals(CONTROL_PARAM_UC_)) {
                this.buildSimpleNameParameter(key, buildList, parms, newParamsInFile, CONTROL_PARAM_UC_);
            } else if (normArg.equals(CONDITION_PARAM_UC_)) {
                this.buildSimpleNameParameter(key, buildList, parms, newParamsInFile, CONDITION_PARAM_UC_);
            } else if (normArg.equals(PERT_TYPE_PARAM_UC_)) {
                this.buildPertTypeParameter(key, buildList, parms, newParamsInFile);
            } else if (normArg.equals(USER_FIELD_PARAM_UC_)) {
                this.buildSimpleNameParameter(key, buildList, parms, newParamsInFile, USER_FIELD_PARAM_UC_);
            } else if (normArg.equals(TIME_SCALE_PARAM_UC_)) {
                this.buildSimpleNameParameter(key, buildList, parms, newParamsInFile, TIME_SCALE_PARAM_UC_);
            } else if (normArg.equals(DATE_PARAM_UC_)) {
                this.buildSimpleNameParameter(key, buildList, parms, newParamsInFile, DATE_PARAM_UC_);
            } else {
                throw new IOException(this.buildParamErrorMessage("csvInput.badParameterDef", normArg));
            }
        }

        private void buildMeasureParameter(String key, List buildList, HashMap parms, Map newParamsInFile) throws IOException {
            MeasureParam alreadySeen;
            if (buildList.size() != 4 || parms.get(key) != null) {
                throw new IOException(this.buildParamErrorMessage("csvInput.incorrectParamArgs", key));
            }
            String newMeasureName = (String)buildList.get(0);
            MeasureParam toAdd = new MeasureParam(newMeasureName, (String)buildList.get(1), (String)buildList.get(2), (String)buildList.get(3), this);
            HashMap<String, MeasureParam> newMeas = (HashMap<String, MeasureParam>)newParamsInFile.get(MEASURE_TYPE_PARAM_UC_);
            if (newMeas == null) {
                newMeas = new HashMap<String, MeasureParam>();
                newParamsInFile.put(MEASURE_TYPE_PARAM_UC_, newMeas);
                alreadySeen = null;
            } else {
                alreadySeen = (MeasureParam)newMeas.get(DataUtil.normKey(newMeasureName));
            }
            if (alreadySeen != null) {
                if (!alreadySeen.equals(toAdd)) {
                    throw new IOException(this.buildParamErrorMessage("csvInput.inconsistentParamArgs", key));
                }
            } else {
                newMeas.put(key, toAdd);
            }
            parms.put(key, toAdd);
        }

        private void buildPertTypeParameter(String key, List buildList, HashMap parms, Map newParamsInFile) throws IOException {
            PertPropParam alreadySeen;
            if (buildList.size() != 3 || parms.get(key) != null) {
                throw new IOException(this.buildParamErrorMessage("csvInput.incorrectParamArgs", key));
            }
            String newPertPropName = (String)buildList.get(0);
            PertPropParam toAdd = new PertPropParam(newPertPropName, (String)buildList.get(1), (String)buildList.get(2), this);
            HashMap<String, PertPropParam> newPP = (HashMap<String, PertPropParam>)newParamsInFile.get(PERT_TYPE_PARAM_UC_);
            if (newPP == null) {
                newPP = new HashMap<String, PertPropParam>();
                newParamsInFile.put(PERT_TYPE_PARAM_UC_, newPP);
                alreadySeen = null;
            } else {
                alreadySeen = (PertPropParam)newPP.get(key);
            }
            if (alreadySeen != null) {
                if (!alreadySeen.equals(toAdd)) {
                    throw new IOException(this.buildParamErrorMessage("csvInput.inconsistentParamArgs", key));
                }
            } else {
                newPP.put(key, toAdd);
            }
            parms.put(key, toAdd);
        }

        private void buildSimpleNameParameter(String key, List buildList, HashMap parms, Map newParamsInFile, String pKey) throws IOException {
            String alreadySeen;
            pKey = DataUtil.normKey(pKey);
            if (buildList.size() != 1 || parms.get(key) != null) {
                throw new IOException(this.buildParamErrorMessage("csvInput.incorrectParamArgs", key));
            }
            String newSimpleName = (String)buildList.get(0);
            HashMap<String, String> newCP = (HashMap<String, String>)newParamsInFile.get(pKey);
            if (newCP == null) {
                newCP = new HashMap<String, String>();
                newParamsInFile.put(pKey, newCP);
                alreadySeen = null;
            } else {
                alreadySeen = (String)newCP.get(key);
            }
            if (alreadySeen != null) {
                if (!DataUtil.normKey(alreadySeen).equals(key)) {
                    throw new IOException(this.buildParamErrorMessage("csvInput.inconsistentParamArgs", key));
                }
            } else {
                newCP.put(key, newSimpleName);
            }
            parms.put(key, newSimpleName);
        }

        private void buildScaleParameter(String key, List buildList, HashMap parms, Map newParamsInFile) throws IOException {
            MeasureScaleParam alreadySeen;
            int blSize = buildList.size();
            if (blSize > 8 || parms.get(key) != null) {
                throw new IOException(this.buildParamErrorMessage("csvInput.incorrectParamArgs", key));
            }
            String newScaleName = (String)buildList.get(0);
            String unchangedStr = blSize > 1 ? (String)buildList.get(1) : null;
            String convToFoldTypeTag = blSize > 2 ? (String)buildList.get(2) : null;
            String convToFoldFacStr = blSize > 3 ? (String)buildList.get(3) : null;
            String minIllegalStr = blSize > 4 ? (String)buildList.get(4) : null;
            String minIncludeStr = blSize > 5 ? (String)buildList.get(5) : null;
            String maxIllegalStr = blSize > 6 ? (String)buildList.get(6) : null;
            String maxIncludeStr = blSize > 7 ? (String)buildList.get(7) : null;
            MeasureScaleParam toAdd = new MeasureScaleParam(newScaleName, convToFoldTypeTag, convToFoldFacStr, minIllegalStr, minIncludeStr, maxIllegalStr, maxIncludeStr, unchangedStr, this);
            HashMap<String, MeasureScaleParam> newScales = (HashMap<String, MeasureScaleParam>)newParamsInFile.get(SCALE_PARAM_UC_);
            if (newScales == null) {
                newScales = new HashMap<String, MeasureScaleParam>();
                newParamsInFile.put(SCALE_PARAM_UC_, newScales);
                alreadySeen = null;
            } else {
                alreadySeen = (MeasureScaleParam)newScales.get(key);
            }
            if (alreadySeen != null) {
                if (!alreadySeen.equals(toAdd)) {
                    throw new IOException(this.buildParamErrorMessage("csvInput.inconsistentParamArgs", key));
                }
            } else {
                newScales.put(key, toAdd);
            }
            parms.put(key, toAdd);
        }

        private void buildAnnotParameter(String key, List buildList, HashMap parms, Map newParamsInFile) throws IOException {
            AnnotParam alreadySeen;
            if (buildList.size() != 2 || parms.get(key) != null) {
                throw new IOException(this.buildParamErrorMessage("csvInput.incorrectParamArgs", key));
            }
            String newAnnotTag = (String)buildList.get(0);
            AnnotParam toAdd = new AnnotParam(newAnnotTag, (String)buildList.get(1));
            HashMap<String, AnnotParam> newAnnots = (HashMap<String, AnnotParam>)newParamsInFile.get(ANNOT_PARAM_UC_);
            if (newAnnots == null) {
                newAnnots = new HashMap<String, AnnotParam>();
                newParamsInFile.put(ANNOT_PARAM_UC_, newAnnots);
                alreadySeen = null;
            } else {
                alreadySeen = (AnnotParam)newAnnots.get(key);
            }
            if (alreadySeen != null) {
                if (!alreadySeen.equals(toAdd)) {
                    throw new IOException(this.buildParamErrorMessage("csvInput.inconsistentParamArgs", key));
                }
            } else {
                newAnnots.put(key, toAdd);
            }
            parms.put(key, toAdd);
        }
    }
}

