/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.perturb;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.perturb.BatchCollision;
import org.systemsbiology.biotapestry.perturb.ConditionDictionary;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.Experiment;
import org.systemsbiology.biotapestry.perturb.ExperimentConditions;
import org.systemsbiology.biotapestry.perturb.ExperimentControl;
import org.systemsbiology.biotapestry.perturb.LinkCandidate;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.perturb.NameMapper;
import org.systemsbiology.biotapestry.perturb.PertAnnotations;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertDataPoint;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.SourceSrc;
import org.systemsbiology.biotapestry.qpcr.QpcrLegacyPublicExposed;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.BoundedDoubMinMax;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.Splitter;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class PerturbationData
implements Cloneable,
SourceSrc {
    public static final int NO_COLLAPSE = 0;
    public static final int DISTINCT_PLUS_MINUS = 1;
    public static final int FULL_COLLAPSE_DROP_SIGN = 2;
    public static final int FULL_COLLAPSE_KEEP_SIGN = 3;
    public static final int NO_LEGACY_DATA = 0;
    public static final int HAVE_LEGACY_PERT = 1;
    public static final int HAVE_LEGACY_TIME_SPAN = 2;
    public static final int HAVE_LEGACY_NULL_REGION = 4;
    static final String SN_SET_XML_TAG_ = "serNumSet";
    private static final int NO_LINK_ = 0;
    private static final int PLUS_ = 1;
    private static final int MINUS_ = 2;
    private static final int UNDEFINED_ = 4;
    private static final int P_AND_M_ = 3;
    private static final int P_AND_U_ = 5;
    private static final int M_AND_U_ = 6;
    private static final int ALL_VALS_ = 7;
    private static final int P_AND_M_DISTINCT_PM_ = 3;
    private static final int P_AND_U_DISTINCT_PM_ = 1;
    private static final int M_AND_U_DISTINCT_PM_ = 2;
    private static final int ALL_VALS_DISTINCT_PM_ = 3;
    private static final int P_AND_M_FULL_COLLAPSE_DROP_SIGN_ = 4;
    private static final int P_AND_U_FULL_COLLAPSE_DROP_SIGN_ = 4;
    private static final int M_AND_U_FULL_COLLAPSE_DROP_SIGN_ = 4;
    private static final int ALL_VALS_FULL_COLLAPSE_DROP_SIGN_ = 4;
    private static final int P_AND_M_FULL_COLLAPSE_KEEP_SIGN_ = 4;
    private static final int P_AND_U_FULL_COLLAPSE_KEEP_SIGN_ = 1;
    private static final int M_AND_U_FULL_COLLAPSE_KEEP_SIGN_ = 2;
    private static final int ALL_VALS_FULL_COLLAPSE_KEEP_SIGN_ = 4;
    private HashMap dataPoints_;
    private HashMap sourceDefs_;
    private HashMap experiments_;
    private HashMap targetGeneNotes_;
    private HashMap dataPointNotes_;
    private HashMap userData_;
    private HashMap investigators_;
    private HashMap targets_;
    private HashMap sourceNames_;
    private ConditionDictionary condDict_;
    private PertAnnotations pertAnnot_;
    private HashMap regionRestrictions_;
    private NameMapper entryMap_;
    private NameMapper sourceMap_;
    private long serialNumber_ = 0L;
    private long qpcrForDisplayVersionSN_ = 0L;
    private long qpcrForDisplaySourceVersionSN_;
    private long qpcrForDisplayEntryVersionSN_;
    private PertDictionary pertDict_;
    private MeasureDictionary measureDict_;
    private UniqueLabeller labels_ = new UniqueLabeller();
    private QpcrLegacyPublicExposed legacyQPCR_ = null;
    private ArrayList userFields_;
    private long sigPertCacheVersionSN_ = 0L;
    private List sigPertCache_ = null;
    private long invertSrcNameCacheVersionSN_ = 0L;
    private HashMap invertSrcNameCache_ = null;
    private long invertTargNameCacheVersionSN_ = 0L;
    private HashMap invertTargNameCache_ = null;

    public PerturbationData() {
        this.experiments_ = new HashMap();
        this.sourceDefs_ = new HashMap();
        this.dataPointNotes_ = new HashMap();
        this.userData_ = new HashMap();
        this.targetGeneNotes_ = new HashMap();
        this.dataPoints_ = new HashMap();
        this.regionRestrictions_ = new HashMap();
        this.entryMap_ = new NameMapper("targets");
        this.sourceMap_ = new NameMapper("sources");
        this.pertDict_ = new PertDictionary();
        this.measureDict_ = new MeasureDictionary();
        this.condDict_ = new ConditionDictionary();
        this.pertAnnot_ = new PertAnnotations();
        this.investigators_ = new HashMap();
        this.targets_ = new HashMap();
        this.sourceNames_ = new HashMap();
        this.userFields_ = new ArrayList();
    }

    public PerturbationData(long serNum) {
        this();
        this.serialNumber_ = serNum;
    }

    public int getExistingLegacyModes() {
        int retval = 0;
        Iterator dpit = this.dataPoints_.values().iterator();
        while (dpit.hasNext()) {
            PertDataPoint pdp = (PertDataPoint)dpit.next();
            if (pdp.getLegacyPert() == null) continue;
            retval |= 1;
            break;
        }
        Iterator oit = this.experiments_.values().iterator();
        while (oit.hasNext()) {
            Experiment exp = (Experiment)oit.next();
            if (exp.getLegacyMaxTime() == -1) continue;
            retval |= 2;
            break;
        }
        Iterator rit = this.regionRestrictions_.values().iterator();
        while (rit.hasNext()) {
            RegionRestrict rr = (RegionRestrict)rit.next();
            if (!rr.isLegacyNullStyle()) continue;
            retval |= 4;
            break;
        }
        return retval;
    }

    public Vector getExperimentOptions() {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        Iterator oit = this.experiments_.keySet().iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            sorted.add(this.getExperimentChoice(key));
        }
        return new Vector(sorted);
    }

    public TrueObjChoiceContent getExperimentChoice(String key) {
        Experiment expr = (Experiment)this.experiments_.get(key);
        return expr.getChoiceContent(this);
    }

    public Vector getSourceNameOptions() {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        Iterator oit = this.sourceNames_.keySet().iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            sorted.add(this.getSourceOrProxyNameChoiceContent(key));
        }
        return new Vector(sorted);
    }

    public Vector getTargetOptions(boolean showAnnots) {
        TreeSet<TrueObjChoiceContent> sorted = new TreeSet<TrueObjChoiceContent>();
        Iterator oit = this.targets_.keySet().iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            sorted.add(this.getTargetChoiceContent(key, showAnnots));
        }
        return new Vector(sorted);
    }

    public Iterator getTargetKeys() {
        return this.targets_.keySet().iterator();
    }

    public DependencyAnalyzer getDependencyAnalyzer() {
        return new DependencyAnalyzer(this);
    }

    public void transferFromLegacy() {
        if (this.legacyQPCR_ != null) {
            this.pertDict_.createAllLegacyPerturbProps();
            this.legacyQPCR_.transferFromLegacy();
        }
    }

    public void setLegacyQPCR(QpcrLegacyPublicExposed qpcr) {
        this.legacyQPCR_ = qpcr;
    }

    public boolean columnDefinitionsLocked() {
        Iterator oit = this.experiments_.values().iterator();
        while (oit.hasNext()) {
            Experiment exp = (Experiment)oit.next();
            if (exp.getLegacyMaxTime() == -1) continue;
            return true;
        }
        return false;
    }

    public PertDataPoint getDataPoint(String key) {
        return (PertDataPoint)this.dataPoints_.get(key);
    }

    public boolean haveUserFieldsDefined() {
        return !this.userFields_.isEmpty();
    }

    public void addUserFieldNameForIO(String name) {
        this.userFields_.add(name);
    }

    public Iterator getUserFieldNames() {
        return this.userFields_.iterator();
    }

    public Set getUserFieldNameSet() {
        return new HashSet(this.userFields_);
    }

    public int getUserFieldCount() {
        return this.userFields_.size();
    }

    public String getUserFieldName(int index) {
        return (String)this.userFields_.get(index);
    }

    public Integer getUserFieldIndexFromNameAsInt(String name) {
        String normName = DataUtil.normKey(name);
        int numf = this.userFields_.size();
        for (int i = 0; i < numf; ++i) {
            String ufn = (String)this.userFields_.get(i);
            if (!DataUtil.normKey(ufn).equals(normName)) continue;
            return new Integer(i);
        }
        return null;
    }

    public String getUserFieldIndexFromName(String name) {
        Integer retval = this.getUserFieldIndexFromNameAsInt(name);
        return retval == null ? null : retval.toString();
    }

    public String getUserFieldValue(String pdpID, int index) {
        ArrayList list = (ArrayList)this.userData_.get(pdpID);
        if (list == null) {
            return null;
        }
        if (index >= list.size()) {
            return null;
        }
        return (String)list.get(index);
    }

    public PertDataChange setUserFieldValues(String pdpID, List values) {
        if (this.userFields_.isEmpty()) {
            return null;
        }
        if (pdpID == null) {
            throw new IllegalArgumentException();
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 6);
        retval.userDataKey = pdpID;
        retval.userDataOrig = (ArrayList)this.userData_.get(pdpID);
        if (values == null || values.isEmpty()) {
            if (retval.userDataOrig == null) {
                return null;
            }
            retval.userDataOrig = (ArrayList)retval.userDataOrig.clone();
            this.userData_.remove(pdpID);
            retval.userDataNew = null;
        } else {
            retval.userDataOrig = retval.userDataOrig == null ? null : (ArrayList)retval.userDataOrig.clone();
            this.userData_.put(pdpID, new ArrayList(values));
            retval.userDataNew = new ArrayList(values);
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void userFieldValsUndo(PertDataChange undo) {
        if (undo.userDataOrig == null) {
            this.userData_.remove(undo.userDataKey);
        } else if (undo.userDataNew == null) {
            ArrayList udo = (ArrayList)undo.userDataOrig.clone();
            this.userData_.put(undo.userDataKey, udo);
        } else {
            ArrayList udo = (ArrayList)undo.userDataOrig.clone();
            this.userData_.put(undo.userDataKey, udo);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void userFieldValsRedo(PertDataChange redo) {
        if (redo.userDataOrig == null) {
            ArrayList udn = (ArrayList)redo.userDataNew.clone();
            this.userData_.put(redo.userDataKey, udn);
        } else if (redo.userDataNew == null) {
            this.userData_.remove(redo.userDataKey);
        } else {
            ArrayList udn = (ArrayList)redo.userDataNew.clone();
            this.userData_.put(redo.userDataKey, udn);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    private void userFieldNameUndo(PertDataChange undo) {
        if (undo.userFieldNameOrig == null) {
            this.userFields_.remove(undo.userFieldIndex);
        } else if (undo.userFieldNameNew == null) {
            this.userFields_.add(undo.userFieldIndex, undo.userFieldNameOrig);
            Iterator udkit = undo.userDataSubsetOrig.keySet().iterator();
            this.userData_.clear();
            while (udkit.hasNext()) {
                String key = (String)udkit.next();
                ArrayList ud = (ArrayList)undo.userDataSubsetOrig.get(key);
                ArrayList udc = (ArrayList)ud.clone();
                this.userData_.put(key, udc);
            }
        } else {
            this.userFields_.set(undo.userFieldIndex, undo.userFieldNameOrig);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void userFieldNameRedo(PertDataChange redo) {
        if (redo.userFieldNameOrig == null) {
            this.userFields_.add(redo.userFieldNameNew);
        } else if (redo.userFieldNameNew == null) {
            this.userFields_.remove(redo.userFieldIndex);
            Iterator udkit = redo.userDataSubsetNew.keySet().iterator();
            this.userData_.clear();
            while (udkit.hasNext()) {
                String key = (String)udkit.next();
                ArrayList ud = (ArrayList)redo.userDataSubsetNew.get(key);
                ArrayList udc = (ArrayList)ud.clone();
                this.userData_.put(key, udc);
            }
        } else {
            this.userFields_.set(redo.userFieldIndex, redo.userFieldNameNew);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange setUserFieldName(String indexStr, String name) {
        int index;
        PertDataChange retval = new PertDataChange(this.serialNumber_, 7);
        try {
            index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException nfex) {
            throw new IllegalArgumentException();
        }
        int currentSize = this.userFields_.size();
        if (index > currentSize) {
            throw new IllegalArgumentException();
        }
        retval.userFieldIndex = index;
        String string = retval.userFieldNameOrig = index == currentSize ? null : (String)this.userFields_.get(index);
        if (index == currentSize) {
            this.userFields_.add(name);
        } else {
            this.userFields_.set(index, name);
        }
        retval.userFieldNameNew = name;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deleteUserFieldName(String indexStr) {
        ArrayList userDataList;
        String key;
        int index;
        PertDataChange retval = new PertDataChange(this.serialNumber_, 7);
        retval.userDataSubsetOrig = new HashMap();
        Iterator kit = this.userData_.keySet().iterator();
        while (kit.hasNext()) {
            String key2 = (String)kit.next();
            ArrayList userDataList2 = (ArrayList)this.userData_.get(key2);
            retval.userDataSubsetOrig.put(key2, userDataList2.clone());
        }
        try {
            index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException nfex) {
            throw new IllegalArgumentException();
        }
        int currentSize = this.userFields_.size();
        if (index >= currentSize) {
            throw new IllegalArgumentException();
        }
        retval.userFieldIndex = index;
        retval.userFieldNameOrig = (String)this.userFields_.get(index);
        this.userFields_.remove(index);
        kit = this.userData_.keySet().iterator();
        while (kit.hasNext()) {
            key = (String)kit.next();
            userDataList = (ArrayList)this.userData_.get(key);
            if (index >= userDataList.size()) continue;
            userDataList.remove(index);
        }
        retval.userDataSubsetNew = new HashMap();
        kit = this.userData_.keySet().iterator();
        while (kit.hasNext()) {
            key = (String)kit.next();
            userDataList = (ArrayList)this.userData_.get(key);
            retval.userDataSubsetNew.put(key, userDataList.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public ConditionDictionary getConditionDictionary() {
        return this.condDict_;
    }

    public PertDictionary getPertDictionary() {
        return this.pertDict_;
    }

    public MeasureDictionary getMeasureDictionary() {
        return this.measureDict_;
    }

    public SortedMap getPertAnnotationsMap() {
        return this.pertAnnot_.getFullMap();
    }

    public PertAnnotations getPertAnnotations() {
        return this.pertAnnot_;
    }

    public void dropCachedDisplayState() {
        if (this.legacyQPCR_ == null) {
            return;
        }
        this.legacyQPCR_.dropCurrentStateForDisplay();
        this.qpcrForDisplayVersionSN_ = 0L;
        this.qpcrForDisplaySourceVersionSN_ = 0L;
        this.qpcrForDisplayEntryVersionSN_ = 0L;
    }

    private void stockQPCR() {
        if (this.legacyQPCR_ == null) {
            this.legacyQPCR_ = new QpcrLegacyPublicExposed();
        }
        long srcSN = this.sourceMap_.getSerialNumber();
        long trgSN = this.entryMap_.getSerialNumber();
        if (!this.legacyQPCR_.readyForDisplay() || this.qpcrForDisplayVersionSN_ != this.serialNumber_ || this.qpcrForDisplaySourceVersionSN_ != srcSN || this.qpcrForDisplayEntryVersionSN_ != trgSN) {
            this.legacyQPCR_.createQPCRFromPerts(this);
            this.qpcrForDisplayVersionSN_ = this.serialNumber_;
            this.qpcrForDisplaySourceVersionSN_ = srcSN;
            this.qpcrForDisplayEntryVersionSN_ = trgSN;
        }
    }

    public String getHTML(String geneId, String sourceID, boolean noCss, boolean bigScreen) {
        this.stockQPCR();
        String ret = this.legacyQPCR_.getHTML(geneId, sourceID, noCss, bigScreen);
        return ret;
    }

    public boolean publish(File pubFile) {
        this.stockQPCR();
        return this.legacyQPCR_.publish(pubFile);
    }

    public boolean publishAsCSV(PrintWriter out) {
        StringBuffer buf = new StringBuffer();
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        String units = tad.unitDisplayString();
        TreeMap<String, TreeSet<String>> expKeys = new TreeMap<String, TreeSet<String>>();
        Iterator oit = this.experiments_.keySet().iterator();
        while (oit.hasNext()) {
            String expKey = (String)oit.next();
            Experiment exp = (Experiment)this.experiments_.get(expKey);
            buf.setLength(0);
            buf.append(exp.getInvestigatorDisplayString(this).toUpperCase());
            buf.append("::---BT---::");
            buf.append(exp.getPertDisplayString(this, 0).toUpperCase());
            buf.append("::---BT---::");
            buf.append(exp.getTimeDisplayString(false, true));
            String ord = buf.toString();
            TreeSet<String> hs = (TreeSet<String>)expKeys.get(ord);
            if (hs == null) {
                hs = new TreeSet<String>();
                expKeys.put(ord, hs);
            }
            hs.add(expKey);
        }
        Iterator expit = expKeys.values().iterator();
        while (expit.hasNext()) {
            TreeSet exKeySet = (TreeSet)expit.next();
            Iterator exksit = exKeySet.iterator();
            while (exksit.hasNext()) {
                String expKey = (String)exksit.next();
                Experiment exp = (Experiment)this.experiments_.get(expKey);
                TreeSet<String> dates = new TreeSet<String>();
                TreeSet<String> measureScales = new TreeSet<String>();
                TreeSet<String> measureProps = new TreeSet<String>();
                TreeMap<String, TreeSet<String>> pointKeys = new TreeMap<String, TreeSet<String>>();
                TreeSet<String> controls = new TreeSet<String>();
                TreeSet used = new TreeSet();
                Iterator dpit = this.dataPoints_.keySet().iterator();
                while (dpit.hasNext()) {
                    String dpKey = (String)dpit.next();
                    PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(dpKey);
                    String dpExpKey = pdp.getExperimentKey();
                    if (!dpExpKey.equals(expKey)) continue;
                    String targ = pdp.getTargetName(this).toUpperCase();
                    String bid = pdp.getBatchKey();
                    buf.setLength(0);
                    buf.append(targ);
                    buf.append("::--------BT---------::");
                    buf.append(bid);
                    String ord = buf.toString();
                    TreeSet<String> hs = (TreeSet<String>)pointKeys.get(ord);
                    if (hs == null) {
                        hs = new TreeSet<String>();
                        pointKeys.put(ord, hs);
                    }
                    hs.add(dpKey);
                    String date = pdp.getDate();
                    if (date == null) {
                        date = "01/01/1970";
                    }
                    dates.add(date);
                    String mTypeKey = pdp.getMeasurementTypeKey();
                    measureProps.add(mTypeKey);
                    MeasureProps mType = this.measureDict_.getMeasureProps(mTypeKey);
                    measureScales.add(mType.getScaleKey());
                    String ctrlKey = pdp.getControl();
                    if (ctrlKey != null) {
                        controls.add(ctrlKey);
                    }
                    pdp.getAnnotationIDs(used, this);
                }
                if (pointKeys.isEmpty()) continue;
                String invests = exp.getInvestigatorDisplayString(this);
                Iterator uit = used.iterator();
                while (uit.hasNext()) {
                    String aKey = (String)uit.next();
                    out.print("\"Annot\",\"");
                    out.print(this.pertAnnot_.getTag(aKey));
                    out.print("\",\"");
                    out.print(this.pertAnnot_.getMessage(aKey));
                    out.println("\"");
                }
                out.println("\"BatchID\",\"PerturbationAgent\",\"MeasuredGene\",\"Time\",\"Measurement\",\"MeasureType\",\"ExpControl\",\"ForceSignificance\",\"Date\",\"Comments\",\"Annot\",\"RegRestrict\"");
                Iterator pkit = pointKeys.values().iterator();
                while (pkit.hasNext()) {
                    TreeSet dpKeySet = (TreeSet)pkit.next();
                    Iterator dpksit = dpKeySet.iterator();
                    while (dpksit.hasNext()) {
                        String dpKey = (String)dpksit.next();
                        PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(dpKey);
                        RegionRestrict rr = this.getRegionRestrictionForDataPoint(dpKey);
                        pdp.publishAsCSV(out, this, exp, this.condDict_, this.measureDict_, this.pertAnnot_, rr, invests);
                    }
                }
                out.println();
            }
        }
        return true;
    }

    public String getNextDataKey() {
        return this.labels_.getNextLabel();
    }

    public String getFootnoteListAsString(List noteIDs) {
        return this.pertAnnot_.getFootnoteListAsString(noteIDs);
    }

    public String getFootnoteListAsNVString(List noteIDs) {
        return this.pertAnnot_.getFootnoteListAsNVString(noteIDs);
    }

    public List getFootnoteList(List noteIDs) {
        return this.pertAnnot_.getFootnoteList(noteIDs);
    }

    public String addLegacyMessage(String key, String message) {
        return this.pertAnnot_.addLegacyMessage(key, message);
    }

    public String addMessage(String message) {
        return this.pertAnnot_.addMessage(message);
    }

    public int getInvestigatorCount() {
        return this.investigators_.size();
    }

    public Iterator getInvestigatorKeys() {
        return this.investigators_.keySet().iterator();
    }

    public String getInvestigator(String key) {
        return (String)this.investigators_.get(key);
    }

    public Set getInvestigatorSet() {
        return new HashSet(this.investigators_.values());
    }

    public String getTarget(String key) {
        return (String)this.targets_.get(key);
    }

    public Set getTargetSet() {
        return new HashSet(this.targets_.values());
    }

    public Set getSourceNameSet() {
        return new HashSet(this.sourceNames_.values());
    }

    public Iterator getSourceNameKeys() {
        return this.sourceNames_.keySet().iterator();
    }

    public String getSourceName(String key) {
        return (String)this.sourceNames_.get(key);
    }

    public String getSourceOrTarget(String key) {
        String retval = (String)this.targets_.get(key);
        if (retval == null) {
            retval = (String)this.sourceNames_.get(key);
        }
        return retval;
    }

    public boolean sourceTargetEquivalent(String sKey, String tKey) {
        String tName = (String)this.targets_.get(tKey);
        String sName = (String)this.sourceNames_.get(sKey);
        return DataUtil.keysEqual(tName, sName);
    }

    public String getInvestKeyFromName(String name) {
        String normName = DataUtil.normKey(name);
        Iterator ikit = this.investigators_.keySet().iterator();
        while (ikit.hasNext()) {
            String iKey = (String)ikit.next();
            String inv = (String)this.investigators_.get(iKey);
            if (!DataUtil.normKey(inv).equals(normName)) continue;
            return iKey;
        }
        return null;
    }

    public String getSourceKeyFromName(String name) {
        String normName = DataUtil.normKey(name);
        Map isnc = this.buildInvertSrcNameCache();
        return (String)isnc.get(normName);
    }

    private Map buildInvertSrcNameCache() {
        if (this.invertSrcNameCache_ == null || this.invertSrcNameCacheVersionSN_ != this.serialNumber_) {
            this.invertSrcNameCache_ = new HashMap();
            Iterator ikit = this.sourceNames_.keySet().iterator();
            while (ikit.hasNext()) {
                String srcKey = (String)ikit.next();
                String src = (String)this.sourceNames_.get(srcKey);
                this.invertSrcNameCache_.put(DataUtil.normKey(src), srcKey);
            }
            this.invertSrcNameCacheVersionSN_ = this.serialNumber_;
        }
        return this.invertSrcNameCache_;
    }

    public String getTargKeyFromName(String name) {
        String normName = DataUtil.normKey(name);
        Map itnc = this.buildInvertTrgNameCache();
        return (String)itnc.get(normName);
    }

    private Map buildInvertTrgNameCache() {
        if (this.invertTargNameCache_ == null || this.invertTargNameCacheVersionSN_ != this.serialNumber_) {
            this.invertTargNameCache_ = new HashMap();
            Iterator ikit = this.targets_.keySet().iterator();
            while (ikit.hasNext()) {
                String trgKey = (String)ikit.next();
                String trg = (String)this.targets_.get(trgKey);
                this.invertTargNameCache_.put(DataUtil.normKey(trg), trgKey);
            }
            this.invertTargNameCacheVersionSN_ = this.serialNumber_;
        }
        return this.invertTargNameCache_;
    }

    public boolean isSourceName(String geneName) {
        String normName = DataUtil.normKey(geneName);
        Iterator snit = this.sourceNames_.values().iterator();
        while (snit.hasNext()) {
            String checkName = (String)snit.next();
            if (!normName.equals(DataUtil.normKey(checkName))) continue;
            return true;
        }
        return false;
    }

    public boolean isTargetName(String geneName) {
        String normName = DataUtil.normKey(geneName);
        Iterator ikit = this.targets_.keySet().iterator();
        while (ikit.hasNext()) {
            String trgKey = (String)ikit.next();
            String trg = (String)this.targets_.get(trgKey);
            if (!normName.equals(DataUtil.normKey(trg))) continue;
            return true;
        }
        return false;
    }

    public void setUserDataForIO(String pdID, Map indexToVals) {
        ArrayList<String> myData = new ArrayList<String>();
        int numVals = this.userFields_.size();
        for (int i = 0; i < numVals; ++i) {
            String strIndx = Integer.toString(i);
            String val = (String)indexToVals.get(strIndx);
            if (val == null) {
                val = "";
            }
            myData.add(val);
        }
        this.userData_.put(pdID, myData);
    }

    public void setRegionRestrictionForDataPointForIO(String pdID, RegionRestrict regReg) {
        this.regionRestrictions_.put(pdID, regReg);
    }

    public PertDataChange setRegionRestrictionForDataPoint(String pdpID, RegionRestrict regReg) {
        if (pdpID == null) {
            throw new IllegalArgumentException();
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 8);
        retval.dataRegResKey = pdpID;
        retval.dataRegResOrig = (RegionRestrict)this.regionRestrictions_.get(pdpID);
        if (regReg == null) {
            if (retval.dataRegResOrig == null) {
                return null;
            }
            retval.dataRegResOrig = (RegionRestrict)retval.dataRegResOrig.clone();
            this.regionRestrictions_.remove(pdpID);
            retval.dataRegResNew = null;
        } else {
            retval.dataRegResOrig = retval.dataRegResOrig == null ? null : (RegionRestrict)retval.dataRegResOrig.clone();
            this.regionRestrictions_.put(pdpID, regReg.clone());
            retval.dataRegResNew = (RegionRestrict)regReg.clone();
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public void regRestrictUndo(PertDataChange undo) {
        if (undo.dataRegResOrig == null) {
            this.regionRestrictions_.remove(undo.dataRegResKey);
        } else if (undo.dataRegResNew == null) {
            RegionRestrict rro = (RegionRestrict)undo.dataRegResOrig.clone();
            this.regionRestrictions_.put(undo.dataRegResKey, rro);
        } else {
            RegionRestrict rro = (RegionRestrict)undo.dataRegResOrig.clone();
            this.regionRestrictions_.put(undo.dataRegResKey, rro);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    public void regRestrictRedo(PertDataChange redo) {
        if (redo.dataRegResOrig == null) {
            RegionRestrict rrn = (RegionRestrict)redo.dataRegResNew.clone();
            this.regionRestrictions_.put(redo.dataRegResKey, rrn);
        } else if (redo.dataRegResNew == null) {
            this.regionRestrictions_.remove(redo.dataRegResKey);
        } else {
            RegionRestrict rrn = (RegionRestrict)redo.dataRegResNew.clone();
            this.regionRestrictions_.put(redo.dataRegResKey, rrn);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public RegionRestrict getRegionRestrictionForDataPoint(String pdID) {
        return (RegionRestrict)this.regionRestrictions_.get(pdID);
    }

    public PertDataChange[] changeRegionNameForRegionRestrictions(String oldName, String newName) {
        ArrayList<PertDataChange> allRets = new ArrayList<PertDataChange>();
        Iterator rrit = this.regionRestrictions_.keySet().iterator();
        while (rrit.hasNext()) {
            String key = (String)rrit.next();
            RegionRestrict regReg = (RegionRestrict)this.regionRestrictions_.get(key);
            RegionRestrict changed = regReg.changeRegionName(oldName, newName);
            if (changed == null) continue;
            PertDataChange retval = new PertDataChange(this.serialNumber_, 8);
            retval.dataRegResKey = key;
            retval.dataRegResOrig = (RegionRestrict)regReg.clone();
            this.regionRestrictions_.put(key, changed);
            retval.dataRegResNew = (RegionRestrict)changed.clone();
            retval.serialNumberNew = ++this.serialNumber_;
            allRets.add(retval);
        }
        PertDataChange[] changes = allRets.toArray(new PertDataChange[allRets.size()]);
        return changes;
    }

    public PertDataChange[] dropRegionNameForRegionRestrictions(String dropName) {
        ArrayList<PertDataChange> allRets = new ArrayList<PertDataChange>();
        HashSet<String> testSet = new HashSet<String>();
        testSet.add(dropName);
        Iterator rrit = new HashSet(this.regionRestrictions_.keySet()).iterator();
        while (rrit.hasNext()) {
            String key = (String)rrit.next();
            RegionRestrict regReg = (RegionRestrict)this.regionRestrictions_.get(key);
            if (!regReg.containsRegionName(testSet)) continue;
            RegionRestrict dropped = regReg.dropRegionName(dropName);
            PertDataChange retval = new PertDataChange(this.serialNumber_, 8);
            retval.dataRegResKey = key;
            retval.dataRegResOrig = (RegionRestrict)regReg.clone();
            if (dropped == null) {
                this.regionRestrictions_.remove(key);
                retval.dataRegResNew = null;
            } else {
                this.regionRestrictions_.put(key, dropped);
                retval.dataRegResNew = (RegionRestrict)dropped.clone();
            }
            retval.serialNumberNew = ++this.serialNumber_;
            allRets.add(retval);
        }
        PertDataChange[] changes = allRets.toArray(new PertDataChange[allRets.size()]);
        return changes;
    }

    public boolean haveRegionNameInRegionRestrictions(Set dropNames) {
        Iterator rrit = this.regionRestrictions_.keySet().iterator();
        while (rrit.hasNext()) {
            String key = (String)rrit.next();
            RegionRestrict regReg = (RegionRestrict)this.regionRestrictions_.get(key);
            if (!regReg.containsRegionName(dropNames)) continue;
            return true;
        }
        return false;
    }

    public void setFootnotesForDataPointForIO(String pdID, List noteMsgIDs) {
        this.dataPointNotes_.put(pdID, new ArrayList(noteMsgIDs));
    }

    public PertDataChange setFootnotesForDataPoint(String pdpID, List noteMsgIDs) {
        if (pdpID == null) {
            throw new IllegalArgumentException();
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 9);
        retval.dataAnnotsKey = pdpID;
        retval.dataAnnotsOrig = (ArrayList)this.dataPointNotes_.get(pdpID);
        if (noteMsgIDs == null || noteMsgIDs.isEmpty()) {
            if (retval.dataAnnotsOrig == null) {
                return null;
            }
            retval.dataAnnotsOrig = (ArrayList)retval.dataAnnotsOrig.clone();
            this.dataPointNotes_.remove(pdpID);
            retval.dataAnnotsNew = null;
        } else {
            retval.dataAnnotsOrig = retval.dataAnnotsOrig == null ? null : (ArrayList)retval.dataAnnotsOrig.clone();
            this.dataPointNotes_.put(pdpID, new ArrayList(noteMsgIDs));
            retval.dataAnnotsNew = new ArrayList(noteMsgIDs);
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public void dataAnnotUndo(PertDataChange undo) {
        if (undo.dataAnnotsOrig == null) {
            this.dataPointNotes_.remove(undo.dataAnnotsKey);
        } else if (undo.dataAnnotsNew == null) {
            ArrayList dao = (ArrayList)undo.dataAnnotsOrig.clone();
            this.dataPointNotes_.put(undo.dataAnnotsKey, dao);
        } else {
            ArrayList dao = (ArrayList)undo.dataAnnotsOrig.clone();
            this.dataPointNotes_.put(undo.dataAnnotsKey, dao);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    public void dataAnnotRedo(PertDataChange redo) {
        if (redo.dataAnnotsOrig == null) {
            ArrayList dan = (ArrayList)redo.dataAnnotsNew.clone();
            this.dataPointNotes_.put(redo.dataAnnotsKey, dan);
        } else if (redo.dataAnnotsNew == null) {
            this.dataPointNotes_.remove(redo.dataAnnotsKey);
        } else {
            ArrayList dan = (ArrayList)redo.dataAnnotsNew.clone();
            this.dataPointNotes_.put(redo.dataAnnotsKey, dan);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public void setFootnotesForTargetIO(String targKey, List noteMsgIDs) {
        this.targetGeneNotes_.put(targKey, new ArrayList(noteMsgIDs));
    }

    private PertDataChange setFootnotesForTarget(String targKey, List noteMsgIDs) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 10);
        retval.targetAnnotKey = targKey;
        retval.targetAnnotOrig = (ArrayList)this.targetGeneNotes_.get(targKey);
        if (noteMsgIDs == null || noteMsgIDs.isEmpty()) {
            if (retval.targetAnnotOrig == null) {
                return null;
            }
            retval.targetAnnotOrig = (ArrayList)retval.targetAnnotOrig.clone();
            this.targetGeneNotes_.remove(targKey);
            retval.targetAnnotNew = null;
        } else {
            retval.targetAnnotOrig = retval.targetAnnotOrig == null ? null : (ArrayList)retval.targetAnnotOrig.clone();
            this.targetGeneNotes_.put(targKey, new ArrayList(noteMsgIDs));
            retval.targetAnnotNew = new ArrayList(noteMsgIDs);
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public void targetAnnotUndo(PertDataChange undo) {
        if (undo.targetAnnotOrig == null) {
            this.targetGeneNotes_.remove(undo.targetAnnotKey);
        } else if (undo.targetAnnotNew == null) {
            ArrayList tao = (ArrayList)undo.targetAnnotOrig.clone();
            this.targetGeneNotes_.put(undo.targetAnnotKey, tao);
        } else {
            ArrayList tao = (ArrayList)undo.targetAnnotOrig.clone();
            this.targetGeneNotes_.put(undo.targetAnnotKey, tao);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    public void targetAnnotRedo(PertDataChange redo) {
        if (redo.targetAnnotOrig == null) {
            ArrayList tan = (ArrayList)redo.targetAnnotNew.clone();
            this.targetGeneNotes_.put(redo.targetAnnotKey, tan);
        } else if (redo.targetAnnotNew == null) {
            this.targetGeneNotes_.remove(redo.targetAnnotKey);
        } else {
            ArrayList tan = (ArrayList)redo.targetAnnotNew.clone();
            this.targetGeneNotes_.put(redo.targetAnnotKey, tan);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public List getFootnotesForTarget(String targKey) {
        return (List)this.targetGeneNotes_.get(targKey);
    }

    public String getAnnotatedTargetDisplay(String targKey) {
        List foots = (List)this.targetGeneNotes_.get(targKey);
        String targ = (String)this.targets_.get(targKey);
        if (foots == null || foots.isEmpty()) {
            return targ;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(targ);
        buf.append(" [");
        buf.append(this.getFootnoteListAsString(foots));
        buf.append("]");
        return buf.toString();
    }

    public int getExperimentCount() {
        return this.experiments_.size();
    }

    public KeyAndDataChange provideExperiment(PertSources srcs, int time, int legacyMax, List investList, String condKey) {
        Experiment prs = new Experiment("", srcs, time, investList, condKey);
        if (legacyMax != -1) {
            prs.setLegacyMaxTime(legacyMax);
        }
        Iterator prsit = this.experiments_.values().iterator();
        while (prsit.hasNext()) {
            Experiment chk = (Experiment)prsit.next();
            if (!chk.equalsMinusID(prs)) continue;
            return new KeyAndDataChange(chk.getID(), null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 2);
        retval.expOrig = null;
        String nextID = this.labels_.getNextLabel();
        prs.setID(nextID);
        retval.expNew = (Experiment)prs.clone();
        this.experiments_.put(nextID, prs);
        retval.serialNumberNew = ++this.serialNumber_;
        return new KeyAndDataChange(nextID, retval);
    }

    public int getPertSourceCount() {
        return this.sourceNames_.size();
    }

    public String getPertSourceFromName(String srcName) {
        String normName = DataUtil.normKey(srcName);
        Iterator snkit = this.sourceNames_.keySet().iterator();
        while (snkit.hasNext()) {
            String chkID = (String)snkit.next();
            String chkName = (String)this.sourceNames_.get(chkID);
            if (!normName.equals(DataUtil.normKey(chkName))) continue;
            return chkID;
        }
        return null;
    }

    public KeyAndDataChange providePertSrcName(String srcName) {
        String foundID = this.getPertSourceFromName(srcName);
        if (foundID != null) {
            return new KeyAndDataChange(foundID, null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 11);
        retval.srcNameOrig = null;
        retval.srcNameKey = this.labels_.getNextLabel();
        retval.srcNameNew = srcName;
        this.sourceNames_.put(retval.srcNameKey, srcName);
        retval.serialNumberNew = ++this.serialNumber_;
        return new KeyAndDataChange(retval.srcNameKey, retval);
    }

    private void sourceNameUndo(PertDataChange undo) {
        if (undo.srcNameOrig == null) {
            this.sourceNames_.remove(undo.srcNameKey);
            this.labels_.removeLabel(undo.srcNameKey);
        } else if (undo.srcNameNew == null) {
            this.sourceNames_.put(undo.srcNameKey, undo.srcNameOrig);
            this.labels_.addExistingLabel(undo.srcNameKey);
        } else {
            this.sourceNames_.put(undo.srcNameKey, undo.srcNameOrig);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void sourceNameRedo(PertDataChange redo) {
        if (redo.srcNameOrig == null) {
            this.sourceNames_.put(redo.srcNameKey, redo.srcNameNew);
            this.labels_.addExistingLabel(redo.srcNameKey);
        } else if (redo.srcNameNew == null) {
            this.sourceNames_.remove(redo.srcNameKey);
            this.labels_.removeLabel(redo.srcNameKey);
        } else {
            this.sourceNames_.put(redo.srcNameKey, redo.srcNameNew);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    private void targetNameUndo(PertDataChange undo) {
        if (undo.targetOrig == null) {
            this.targets_.remove(undo.targetKey);
            this.labels_.removeLabel(undo.targetKey);
        } else if (undo.targetNew == null) {
            this.targets_.put(undo.targetKey, undo.targetOrig);
            this.labels_.addExistingLabel(undo.targetKey);
        } else {
            this.targets_.put(undo.targetKey, undo.targetOrig);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void targetNameRedo(PertDataChange redo) {
        if (redo.targetOrig == null) {
            this.targets_.put(redo.targetKey, redo.targetNew);
            this.labels_.addExistingLabel(redo.targetKey);
        } else if (redo.targetNew == null) {
            this.targets_.remove(redo.targetKey);
            this.labels_.removeLabel(redo.targetKey);
        } else {
            this.targets_.put(redo.targetKey, redo.targetNew);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public KeyAndDataChange providePertSrc(String srcNameKey, String typeKey, String proxyForKey, String proxySign, List annotations, boolean justSrcAndType) {
        PertSource ps = new PertSource("", srcNameKey, typeKey, annotations);
        if (!proxySign.equals("noProxy")) {
            ps.setProxiedSpeciesKey(proxyForKey);
            ps.setProxySign(proxySign);
        }
        Iterator sdit = this.sourceDefs_.values().iterator();
        while (sdit.hasNext()) {
            PertSource chk = (PertSource)sdit.next();
            if (!(justSrcAndType ? chk.compareSrcAndType(ps) == 0 : chk.equalsMinusID(ps))) continue;
            return new KeyAndDataChange(chk.getID(), null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 5);
        retval.srcDefOrig = null;
        String nextID = this.labels_.getNextLabel();
        ps.setID(nextID);
        this.sourceDefs_.put(nextID, ps);
        retval.srcDefNew = (PertSource)ps.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return new KeyAndDataChange(nextID, retval);
    }

    public KeyAndDataChange provideMeasureScale(String scaleDesc, MeasureScale.Conversion convToFold, BoundedDoubMinMax illegal, Double unchanged) {
        if (scaleDesc == null) {
            return null;
        }
        String exist = this.measureDict_.getMeasureScaleFromName(scaleDesc);
        if (exist != null) {
            MeasureScale scale = this.measureDict_.getMeasureScale(exist);
            if (convToFold == null ? scale.getConvToFold() != null : !convToFold.equals(scale.getConvToFold())) {
                return null;
            }
            if (illegal == null ? scale.getIllegalRange() != null : !illegal.equals(scale.getIllegalRange())) {
                return null;
            }
            if (unchanged == null ? scale.getUnchanged() != null : !unchanged.equals(scale.getUnchanged())) {
                return null;
            }
            return new KeyAndDataChange(exist, null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 18);
        retval.mScaleOrig = null;
        String nextID = this.measureDict_.getNextDataKey();
        MeasureScale scale = new MeasureScale(nextID, scaleDesc, convToFold, illegal, unchanged);
        this.measureDict_.setMeasureScale(scale);
        retval.mScaleNew = (MeasureScale)scale.clone();
        return new KeyAndDataChange(nextID, retval);
    }

    public KeyAndDataChange provideMeasureProps(String measName, String scaleKey, Double negThresh, Double posThresh) {
        if (measName == null) {
            return null;
        }
        String exist = this.measureDict_.getMeasurePropsFromName(measName);
        if (exist != null) {
            MeasureProps mProps = this.measureDict_.getMeasureProps(exist);
            if (!(scaleKey.equals(mProps.getScaleKey()) && negThresh.equals(mProps.getNegThresh()) && posThresh.equals(mProps.getPosThresh()))) {
                return null;
            }
            return new KeyAndDataChange(exist, null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 16);
        retval.mpOrig = null;
        String nextID = this.measureDict_.getNextDataKey();
        MeasureProps mProps = new MeasureProps(nextID, measName, scaleKey, negThresh, posThresh);
        this.measureDict_.setMeasureProp(mProps);
        retval.mpNew = (MeasureProps)mProps.clone();
        return new KeyAndDataChange(nextID, retval);
    }

    public KeyAndDataChange providePertProps(String propName, String abbrev, int linkRelation) {
        if (propName == null) {
            return null;
        }
        String exist = this.pertDict_.getPerturbPropsFromName(propName);
        if (exist != null) {
            PertProperties chkProps = new PertProperties("", propName, abbrev, linkRelation);
            PertProperties pProps = this.pertDict_.getPerturbProps(exist);
            if (!chkProps.semiEquals(pProps)) {
                return null;
            }
            return new KeyAndDataChange(exist, null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 21);
        retval.ppOrig = null;
        String nextID = this.pertDict_.getNextDataKey();
        PertProperties pProps = new PertProperties(nextID, propName, abbrev, linkRelation);
        this.pertDict_.setPerturbProp(pProps);
        retval.ppNew = (PertProperties)pProps.clone();
        return new KeyAndDataChange(nextID, retval);
    }

    private void pertPropUndo(PertDataChange undo) {
        if (undo.ppOrig == null) {
            String rescueID = undo.ppNew.getID();
            this.pertDict_.dropPerturbProp(rescueID);
        } else if (undo.ppNew == null) {
            PertProperties ppr = (PertProperties)undo.ppOrig.clone();
            this.pertDict_.addPerturbPropForIO(ppr);
        } else {
            PertProperties ppr = (PertProperties)undo.ppOrig.clone();
            this.pertDict_.setPerturbProp(ppr);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void pertPropRedo(PertDataChange redo) {
        if (redo.ppOrig == null) {
            PertProperties ppr = (PertProperties)redo.ppNew.clone();
            this.pertDict_.addPerturbPropForIO(ppr);
        } else if (redo.ppNew == null) {
            String rescueID = redo.ppOrig.getID();
            this.pertDict_.dropPerturbProp(rescueID);
        } else {
            PertProperties ppr = (PertProperties)redo.ppNew.clone();
            this.pertDict_.setPerturbProp(ppr);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public KeyAndDataChange provideUserField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String exist = this.getUserFieldIndexFromName(fieldName);
        if (exist != null) {
            return new KeyAndDataChange(exist, null);
        }
        String nextID = Integer.toString(this.getUserFieldCount());
        PertDataChange pdc = this.setUserFieldName(nextID, fieldName);
        return new KeyAndDataChange(nextID, pdc);
    }

    public KeyAndDataChange provideExpControl(String ctrlDesc) {
        if (ctrlDesc == null) {
            return null;
        }
        String exist = this.condDict_.getControlKeyFromName(ctrlDesc);
        if (exist != null) {
            return new KeyAndDataChange(exist, null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 12);
        retval.ectrlOrig = null;
        String nextID = this.condDict_.getNextDataKey();
        ExperimentControl ctrl = new ExperimentControl(nextID, ctrlDesc);
        this.condDict_.setExprControl(ctrl);
        retval.ectrlNew = (ExperimentControl)ctrl.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return new KeyAndDataChange(nextID, retval);
    }

    public KeyAndDataChange provideExpCondition(String condDesc) {
        if (condDesc == null) {
            return null;
        }
        String exist = this.condDict_.getConditionKeyFromName(condDesc);
        if (exist != null) {
            return new KeyAndDataChange(exist, null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 17);
        retval.ecOrig = null;
        String nextID = this.condDict_.getNextDataKey();
        ExperimentConditions eCond = new ExperimentConditions(nextID, condDesc);
        this.condDict_.setExprCondition(eCond);
        retval.ecNew = (ExperimentConditions)eCond.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return new KeyAndDataChange(nextID, retval);
    }

    public KeyAndDataChange provideInvestigator(String investName) {
        String nextID;
        String exist = this.getInvestKeyFromName(investName);
        if (exist != null) {
            return new KeyAndDataChange(exist, null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 13);
        retval.investOrig = null;
        retval.investKey = nextID = this.labels_.getNextLabel();
        retval.investNew = investName;
        this.investigators_.put(nextID, investName);
        retval.serialNumberNew = ++this.serialNumber_;
        return new KeyAndDataChange(nextID, retval);
    }

    private void investUndo(PertDataChange undo) {
        if (undo.investOrig == null) {
            this.investigators_.remove(undo.investKey);
            this.labels_.removeLabel(undo.investKey);
        } else if (undo.investNew == null) {
            this.investigators_.put(undo.investKey, undo.investOrig);
            this.labels_.addExistingLabel(undo.investKey);
        } else {
            this.investigators_.put(undo.investKey, undo.investOrig);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void investRedo(PertDataChange redo) {
        if (redo.investOrig == null) {
            this.investigators_.put(redo.investKey, redo.investNew);
            this.labels_.addExistingLabel(redo.investKey);
        } else if (redo.investNew == null) {
            this.investigators_.remove(redo.investKey);
            this.labels_.removeLabel(redo.investKey);
        } else {
            this.investigators_.put(redo.investKey, redo.investNew);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange setInvestigator(String key, String investName) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 13);
        retval.investOrig = (String)this.investigators_.get(key);
        retval.investKey = key;
        retval.investNew = investName;
        this.investigators_.put(key, investName);
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergeInvestigatorRefs(Set expsToMerge, String investKey, Set abandonKeys) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 4);
        retval.expSubsetOrig = new HashMap();
        retval.expSubsetNew = new HashMap();
        Iterator k2dit = expsToMerge.iterator();
        while (k2dit.hasNext()) {
            String key = (String)k2dit.next();
            Experiment exp = (Experiment)this.experiments_.get(key);
            List investList = exp.getInvestigators();
            boolean haveAChange = false;
            int numInv = investList.size();
            ArrayList<String> replaceInvest = new ArrayList<String>();
            for (int i = 0; i < numInv; ++i) {
                boolean iChange;
                String chkKey = (String)investList.get(i);
                boolean bl = iChange = abandonKeys.contains(chkKey) && !chkKey.equals(investKey);
                if (iChange) {
                    if (!replaceInvest.contains(investKey)) {
                        replaceInvest.add(investKey);
                    }
                } else if (!replaceInvest.contains(chkKey)) {
                    replaceInvest.add(chkKey);
                }
                haveAChange = haveAChange || iChange;
            }
            if (!haveAChange) continue;
            retval.expSubsetOrig.put(key, exp.clone());
            exp.setInvestigators(replaceInvest);
            retval.expSubsetNew.put(key, exp.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergeSourceDefRefs(Set expsToMerge, String sdefKey, Set abandonKeys) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 4);
        retval.expSubsetOrig = new HashMap();
        retval.expSubsetNew = new HashMap();
        Iterator k2dit = expsToMerge.iterator();
        while (k2dit.hasNext()) {
            String key = (String)k2dit.next();
            Experiment exp = (Experiment)this.experiments_.get(key);
            ArrayList<String> replaceSources = new ArrayList<String>();
            boolean haveAChange = false;
            PertSources pss = exp.getSources();
            Iterator pssit = pss.getSources();
            while (pssit.hasNext()) {
                boolean iChange;
                String psid = (String)pssit.next();
                boolean bl = iChange = abandonKeys.contains(psid) && !psid.equals(sdefKey);
                if (iChange) {
                    if (!replaceSources.contains(sdefKey)) {
                        replaceSources.add(sdefKey);
                    }
                } else if (!replaceSources.contains(psid)) {
                    replaceSources.add(psid);
                }
                haveAChange = haveAChange || iChange;
            }
            if (!haveAChange) continue;
            retval.expSubsetOrig.put(key, exp.clone());
            PertSources pss2 = new PertSources(replaceSources);
            exp.setSources(pss2);
            retval.expSubsetNew.put(key, exp.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergeExperimentCondRefs(Set expsToMerge, String condKey, Set abandonKeys) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 4);
        retval.expSubsetOrig = new HashMap();
        retval.expSubsetNew = new HashMap();
        Iterator k2dit = expsToMerge.iterator();
        while (k2dit.hasNext()) {
            String key = (String)k2dit.next();
            Experiment exp = (Experiment)this.experiments_.get(key);
            String currCond = exp.getConditionKey();
            if (condKey.equals(currCond)) continue;
            retval.expSubsetOrig.put(key, exp.clone());
            exp.setConditionKey(condKey);
            retval.expSubsetNew.put(key, exp.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergeDataPointAnnotRefs(Set dpToMerge, String annotKey, Set abandonKeys) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 14);
        retval.dataPtNotesSubsetOrig = new HashMap();
        retval.dataPtNotesSubsetNew = new HashMap();
        Iterator dpkit = dpToMerge.iterator();
        while (dpkit.hasNext()) {
            String key = (String)dpkit.next();
            ArrayList annots = (ArrayList)this.dataPointNotes_.get(key);
            boolean haveAChange = false;
            int numA = annots.size();
            ArrayList<String> replaceAnnots = new ArrayList<String>();
            for (int i = 0; i < numA; ++i) {
                boolean iChange;
                String chkKey = (String)annots.get(i);
                boolean bl = iChange = abandonKeys.contains(chkKey) && !chkKey.equals(annotKey);
                if (iChange) {
                    if (!replaceAnnots.contains(annotKey)) {
                        replaceAnnots.add(annotKey);
                    }
                } else if (!replaceAnnots.contains(chkKey)) {
                    replaceAnnots.add(chkKey);
                }
                haveAChange = haveAChange || iChange;
            }
            if (!haveAChange) continue;
            retval.dataPtNotesSubsetOrig.put(key, annots.clone());
            this.dataPointNotes_.put(key, replaceAnnots);
            retval.dataPtNotesSubsetNew.put(key, replaceAnnots.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergeTargetAnnotRefs(Set trgToMerge, String annotKey, Set abandonKeys) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 22);
        retval.targetNotesSubsetOrig = new HashMap();
        retval.targetNotesSubsetNew = new HashMap();
        Iterator trgkit = trgToMerge.iterator();
        while (trgkit.hasNext()) {
            String key = (String)trgkit.next();
            ArrayList annots = (ArrayList)this.targetGeneNotes_.get(key);
            boolean haveAChange = false;
            int numA = annots.size();
            ArrayList<String> replaceAnnots = new ArrayList<String>();
            for (int i = 0; i < numA; ++i) {
                boolean iChange;
                String chkKey = (String)annots.get(i);
                boolean bl = iChange = abandonKeys.contains(chkKey) && !chkKey.equals(annotKey);
                if (iChange) {
                    if (!replaceAnnots.contains(annotKey)) {
                        replaceAnnots.add(annotKey);
                    }
                } else if (!replaceAnnots.contains(chkKey)) {
                    replaceAnnots.add(chkKey);
                }
                haveAChange = haveAChange || iChange;
            }
            if (!haveAChange) continue;
            retval.targetNotesSubsetOrig.put(key, annots.clone());
            this.targetGeneNotes_.put(key, replaceAnnots);
            retval.targetNotesSubsetNew.put(key, replaceAnnots.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void targetAnnotSetUndo(PertDataChange undo) {
        Iterator dpnkit = undo.targetNotesSubsetOrig.keySet().iterator();
        while (dpnkit.hasNext()) {
            String key = (String)dpnkit.next();
            ArrayList dpn = (ArrayList)undo.targetNotesSubsetOrig.get(key);
            ArrayList dpnc = (ArrayList)dpn.clone();
            this.targetGeneNotes_.put(key, dpnc);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void targetAnnotSetRedo(PertDataChange redo) {
        Iterator dpnkit = redo.targetNotesSubsetNew.keySet().iterator();
        while (dpnkit.hasNext()) {
            String key = (String)dpnkit.next();
            ArrayList dpn = (ArrayList)redo.targetNotesSubsetNew.get(key);
            ArrayList dpnc = (ArrayList)dpn.clone();
            if (dpnc.isEmpty()) {
                this.targetGeneNotes_.remove(key);
                continue;
            }
            this.targetGeneNotes_.put(key, dpnc);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange mergeSourceDefAnnotRefs(Set sdToMerge, String annotKey, Set abandonKeys) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 15);
        retval.srcDefsSubsetOrig = new HashMap();
        retval.srcDefsSubsetNew = new HashMap();
        Iterator sdit = sdToMerge.iterator();
        while (sdit.hasNext()) {
            String psdKey = (String)sdit.next();
            PertSource chk = (PertSource)this.sourceDefs_.get(psdKey);
            List annots = chk.getAnnotationIDs();
            boolean haveAChange = false;
            int numA = annots.size();
            ArrayList<String> replaceAnnots = new ArrayList<String>();
            for (int i = 0; i < numA; ++i) {
                boolean iChange;
                String chkKey = (String)annots.get(i);
                boolean bl = iChange = abandonKeys.contains(chkKey) && !chkKey.equals(annotKey);
                if (iChange) {
                    if (!replaceAnnots.contains(annotKey)) {
                        replaceAnnots.add(annotKey);
                    }
                } else if (!replaceAnnots.contains(chkKey)) {
                    replaceAnnots.add(chkKey);
                }
                haveAChange = haveAChange || iChange;
            }
            if (!haveAChange) continue;
            retval.srcDefsSubsetOrig.put(psdKey, chk.clone());
            chk.setAnnotationIDs(replaceAnnots);
            retval.srcDefsSubsetNew.put(psdKey, chk.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange[] mergeInvestigatorNames(List keyIDs, String useKey, String newName) {
        ArrayList<PertDataChange> allRets = new ArrayList<PertDataChange>();
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            PertDataChange retval = new PertDataChange(this.serialNumber_, 13);
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                retval.investOrig = (String)this.investigators_.get(keyID);
                retval.investKey = keyID;
                retval.investNew = newName;
                this.investigators_.put(keyID, newName);
            } else {
                retval.investOrig = (String)this.investigators_.get(keyID);
                retval.investKey = keyID;
                retval.investNew = null;
                this.investigators_.remove(keyID);
                this.labels_.removeLabel(keyID);
            }
            retval.serialNumberNew = ++this.serialNumber_;
            allRets.add(retval);
        }
        PertDataChange[] changes = allRets.toArray(new PertDataChange[allRets.size()]);
        return changes;
    }

    public PertDataChange deleteInvestigator(String keyID) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 13);
        retval.investKey = keyID;
        retval.investOrig = (String)this.investigators_.get(keyID);
        this.investigators_.remove(keyID);
        this.labels_.removeLabel(keyID);
        retval.investNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void annotationUndo(PertDataChange undo) {
        if (undo.annotTagOrig == null) {
            this.pertAnnot_.deleteMessage(undo.annotKey);
        } else if (undo.annotTagNew == null) {
            this.pertAnnot_.addMessageExistingKey(undo.annotKey, undo.annotTagOrig, undo.annotMsgOrig);
        } else {
            this.pertAnnot_.editMessage(undo.annotKey, undo.annotTagOrig, undo.annotMsgOrig);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void annotationRedo(PertDataChange redo) {
        if (redo.annotTagOrig == null) {
            this.pertAnnot_.addMessageExistingKey(redo.annotKey, redo.annotTagNew, redo.annotMsgNew);
        } else if (redo.annotTagNew == null) {
            this.pertAnnot_.deleteMessage(redo.annotKey);
        } else {
            this.pertAnnot_.editMessage(redo.annotKey, redo.annotTagNew, redo.annotMsgNew);
        }
        this.serialNumber_ = redo.serialNumberOrig;
    }

    public PertDataChange addAnnotation(String tag, String message) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 20);
        retval.annotMsgOrig = null;
        retval.annotTagOrig = null;
        retval.annotKey = this.pertAnnot_.addMessage(tag, message);
        retval.annotMsgNew = message;
        retval.annotTagNew = tag;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange editAnnotation(String id, String tag, String message) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 20);
        retval.annotKey = id;
        retval.annotMsgOrig = this.pertAnnot_.getMessage(id);
        retval.annotTagOrig = this.pertAnnot_.getTag(id);
        this.pertAnnot_.editMessage(id, tag, message);
        retval.annotMsgNew = message;
        retval.annotTagNew = tag;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deleteAnnotation(String id) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 20);
        retval.annotKey = id;
        retval.annotMsgOrig = this.pertAnnot_.getMessage(id);
        retval.annotTagOrig = this.pertAnnot_.getTag(id);
        this.pertAnnot_.deleteMessage(id);
        retval.annotMsgNew = null;
        retval.annotTagNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergeAnnotations(List joinKeys, String commonKey, String tag, String message) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 23);
        retval.pAnnotOrig = (PertAnnotations)this.pertAnnot_.clone();
        this.pertAnnot_.mergeAnnotations(joinKeys, commonKey, tag, message);
        retval.pAnnotNew = (PertAnnotations)this.pertAnnot_.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void annotModuleUndo(PertDataChange undo) {
        this.pertAnnot_ = undo.pAnnotOrig;
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void annotModuleRedo(PertDataChange redo) {
        this.pertAnnot_ = redo.pAnnotNew;
        this.serialNumber_ = redo.serialNumberNew;
    }

    public int getTargetCount() {
        return this.targets_.size();
    }

    public String getTargetFromName(String targName) {
        String normName = DataUtil.normKey(targName);
        Iterator ikit = this.targets_.keySet().iterator();
        while (ikit.hasNext()) {
            String trgKey = (String)ikit.next();
            String trg = (String)this.targets_.get(trgKey);
            if (!normName.equals(DataUtil.normKey(trg))) continue;
            return trgKey;
        }
        return null;
    }

    public KeyAndDataChange provideTarget(String targName) {
        String nextID;
        String foundTarg = this.getTargetFromName(targName);
        if (foundTarg != null) {
            return new KeyAndDataChange(foundTarg, null);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 19);
        retval.targetOrig = null;
        retval.targetKey = nextID = this.labels_.getNextLabel();
        retval.targetNew = targName;
        this.targets_.put(nextID, targName);
        retval.serialNumberNew = ++this.serialNumber_;
        return new KeyAndDataChange(nextID, retval);
    }

    public void addInvestForIO(Invest invest) {
        this.investigators_.put(invest.id, invest.name);
        this.labels_.addExistingLabel(invest.id);
    }

    public void addSourceNameForIO(SourceName sn) {
        this.sourceNames_.put(sn.id, sn.name);
        this.labels_.addExistingLabel(sn.id);
    }

    public void addTargetForIO(AugTarget augt) {
        this.targets_.put(augt.id, augt.name);
        this.labels_.addExistingLabel(augt.id);
        if (augt.notes != null) {
            this.setFootnotesForTargetIO(augt.id, augt.notes);
        }
    }

    void addPertSrcInfoForIO(Experiment psi) {
        this.experiments_.put(psi.getID(), psi);
        this.labels_.addExistingLabel(psi.getID());
    }

    void addPertSrcDefForIO(PertSource ps) {
        this.sourceDefs_.put(ps.getID(), ps);
        this.labels_.addExistingLabel(ps.getID());
    }

    public PertDataChange[] setTargetName(String keyID, String name, List annots) {
        return this.setTargetNameManageIdents(keyID, name, annots, true);
    }

    private PertDataChange[] setTargetNameManageIdents(String keyID, String name, List annots, boolean doIdents) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        PertDataChange retval = new PertDataChange(this.serialNumber_, 19);
        retval.targetKey = keyID;
        retval.targetOrig = (String)this.targets_.get(keyID);
        this.targets_.put(keyID, name);
        retval.targetNew = name;
        retval.serialNumberNew = ++this.serialNumber_;
        retlist.add(retval);
        PertDataChange fnpdc = this.setFootnotesForTarget(keyID, annots);
        if (fnpdc != null) {
            retlist.add(fnpdc);
        }
        if (doIdents) {
            retlist.addAll(Arrays.asList(this.entryMap_.dropIdentityMaps(this.targets_)));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    private PertDataChange[] changeTargetNameManageIdents(String keyID, String name) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        PertDataChange retval = new PertDataChange(this.serialNumber_, 19);
        retval.targetKey = keyID;
        retval.targetOrig = (String)this.targets_.get(keyID);
        this.targets_.put(keyID, name);
        retval.targetNew = name;
        retval.serialNumberNew = ++this.serialNumber_;
        retlist.add(retval);
        retlist.addAll(Arrays.asList(this.entryMap_.dropIdentityMaps(this.targets_)));
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange[] deleteTargetName(String keyID) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        PertDataChange fnpdc = this.setFootnotesForTarget(keyID, null);
        if (fnpdc != null) {
            retlist.add(fnpdc);
        }
        PertDataChange[] vals = this.entryMap_.dropDanglingMapsFor(keyID);
        for (int i = 0; i < vals.length; ++i) {
            retlist.add(vals[i]);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 19);
        retval.targetKey = keyID;
        retval.targetOrig = (String)this.targets_.get(keyID);
        this.targets_.remove(keyID);
        this.labels_.removeLabel(keyID);
        retval.targetNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        retlist.add(retval);
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange[] mergeTargetNames(List keyIDs, String useKey, String newName, List newFoots) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        retlist.addAll(Arrays.asList(this.entryMap_.mergeMapsFor(useKey, keyIDs)));
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                retlist.addAll(Arrays.asList(this.setTargetNameManageIdents(useKey, newName, newFoots, false)));
                continue;
            }
            retlist.addAll(Arrays.asList(this.deleteTargetName(keyID)));
        }
        retlist.addAll(Arrays.asList(this.entryMap_.dropIdentityMaps(this.targets_)));
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange[] mergeExprControls(List keyIDs, String useKey, ExperimentControl revisedECtrl) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                retlist.add(this.setExperimentControl(revisedECtrl));
                continue;
            }
            retlist.add(this.deleteExperimentControl(keyID));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange[] mergeMeasureProps(List keyIDs, String useKey, MeasureProps revisedMp) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                retlist.add(this.setMeasureProp(revisedMp));
                continue;
            }
            retlist.add(this.deleteMeasureProp(keyID));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange[] mergePertProps(List keyIDs, String useKey, PertProperties revisedPp) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                retlist.add(this.setPerturbationProp(revisedPp));
                continue;
            }
            retlist.add(this.deletePerturbationProp(keyID));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange[] mergeExprConditions(List keyIDs, String useKey, ExperimentConditions revisedECond) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                retlist.add(this.setExperimentConditions(revisedECond));
                continue;
            }
            retlist.add(this.deleteExperimentConditions(keyID));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange[] mergeSourceNames(List keyIDs, String useKey, String newName) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        retlist.addAll(Arrays.asList(this.sourceMap_.mergeMapsFor(useKey, keyIDs)));
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                retlist.addAll(Arrays.asList(this.setSourceNameManageIdents(useKey, newName, false)));
                continue;
            }
            retlist.addAll(Arrays.asList(this.deleteSourceName(keyID)));
        }
        retlist.addAll(Arrays.asList(this.sourceMap_.dropIdentityMaps(this.sourceNames_)));
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange[] setSourceName(String keyID, String name) {
        return this.setSourceNameManageIdents(keyID, name, true);
    }

    private PertDataChange[] setSourceNameManageIdents(String keyID, String name, boolean dropIdent) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        PertDataChange retval = new PertDataChange(this.serialNumber_, 11);
        retval.srcNameKey = keyID;
        retval.srcNameOrig = (String)this.sourceNames_.get(keyID);
        this.sourceNames_.put(keyID, name);
        retval.srcNameNew = name;
        retval.serialNumberNew = ++this.serialNumber_;
        retlist.add(retval);
        if (dropIdent) {
            retlist.addAll(Arrays.asList(this.sourceMap_.dropIdentityMaps(this.sourceNames_)));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange[] duplicateSourceNameMap(String existingID, String dupID) {
        return this.sourceMap_.dupAMapTo(existingID, dupID);
    }

    public PertDataChange[] duplicateTargetNameMap(String existingID, String dupID) {
        return this.entryMap_.dupAMapTo(existingID, dupID);
    }

    public boolean haveSourceNameMapTo(String chkID) {
        return this.sourceMap_.haveMapToEntry(chkID);
    }

    public boolean haveTargetNameMapTo(String chkID) {
        return this.entryMap_.haveMapToEntry(chkID);
    }

    public PertDataChange[] deleteSourceName(String keyID) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        PertDataChange[] vals = this.sourceMap_.dropDanglingMapsFor(keyID);
        for (int i = 0; i < vals.length; ++i) {
            retlist.add(vals[i]);
        }
        PertDataChange retval = new PertDataChange(this.serialNumber_, 11);
        retval.srcNameKey = keyID;
        retval.srcNameOrig = (String)this.sourceNames_.get(keyID);
        this.sourceNames_.remove(keyID);
        this.labels_.removeLabel(keyID);
        retval.srcNameNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        retlist.add(retval);
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange setMeasureProp(MeasureProps mprops) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 16);
        String key = mprops.getID();
        MeasureProps orig = this.measureDict_.getMeasureProps(key);
        retval.mpOrig = orig == null ? null : (MeasureProps)orig.clone();
        this.measureDict_.setMeasureProp(mprops);
        retval.mpNew = (MeasureProps)mprops.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deleteMeasureProp(String key) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 16);
        MeasureProps orig = this.measureDict_.getMeasureProps(key);
        retval.mpOrig = (MeasureProps)orig.clone();
        this.measureDict_.dropMeasureProp(key);
        retval.mpNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void measurePropUndo(PertDataChange undo) {
        if (undo.mpOrig == null) {
            String rescueID = undo.mpNew.getID();
            this.measureDict_.dropMeasureProp(rescueID);
        } else if (undo.mpNew == null) {
            MeasureProps mpo = (MeasureProps)undo.mpOrig.clone();
            this.measureDict_.addMeasurePropForIO(mpo);
        } else {
            MeasureProps mpo = (MeasureProps)undo.mpOrig.clone();
            this.measureDict_.setMeasureProp(mpo);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void measurePropRedo(PertDataChange redo) {
        if (redo.mpOrig == null) {
            MeasureProps mpn = (MeasureProps)redo.mpNew.clone();
            this.measureDict_.addMeasurePropForIO(mpn);
        } else if (redo.mpNew == null) {
            String rescueID = redo.mpOrig.getID();
            this.measureDict_.dropMeasureProp(rescueID);
        } else {
            MeasureProps mpn = (MeasureProps)redo.mpNew.clone();
            this.measureDict_.setMeasureProp(mpn);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange setExperimentConditions(ExperimentConditions expCond) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 17);
        String key = expCond.getID();
        ExperimentConditions orig = this.condDict_.getExprConditions(key);
        retval.ecOrig = orig == null ? null : (ExperimentConditions)orig.clone();
        this.condDict_.setExprCondition(expCond);
        retval.ecNew = (ExperimentConditions)expCond.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deleteExperimentConditions(String key) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 17);
        ExperimentConditions orig = this.condDict_.getExprConditions(key);
        retval.ecOrig = (ExperimentConditions)orig.clone();
        this.condDict_.dropExprConditions(key);
        retval.ecNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void expCondUndo(PertDataChange undo) {
        if (undo.ecOrig == null) {
            String rescueID = undo.ecNew.getID();
            this.condDict_.dropExprConditions(rescueID);
        } else if (undo.ecNew == null) {
            ExperimentConditions eco = (ExperimentConditions)undo.ecOrig.clone();
            this.condDict_.addExprConditionsForIO(eco);
        } else {
            ExperimentConditions eco = (ExperimentConditions)undo.ecOrig.clone();
            this.condDict_.setExprCondition(eco);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void expCondRedo(PertDataChange redo) {
        if (redo.ecOrig == null) {
            ExperimentConditions ecn = (ExperimentConditions)redo.ecNew.clone();
            this.condDict_.addExprConditionsForIO(ecn);
        } else if (redo.ecNew == null) {
            String rescueID = redo.ecOrig.getID();
            this.condDict_.dropExprConditions(rescueID);
        } else {
            ExperimentConditions ecn = (ExperimentConditions)redo.ecNew.clone();
            this.condDict_.setExprCondition(ecn);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange setExperimentControl(ExperimentControl expCtrl) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 12);
        String key = expCtrl.getID();
        ExperimentControl orig = this.condDict_.getExprControl(key);
        retval.ectrlOrig = orig == null ? null : (ExperimentControl)orig.clone();
        this.condDict_.setExprControl(expCtrl);
        retval.ectrlNew = (ExperimentControl)expCtrl.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deleteExperimentControl(String key) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 12);
        ExperimentControl orig = this.condDict_.getExprControl(key);
        retval.ectrlOrig = (ExperimentControl)orig.clone();
        this.condDict_.dropExprControl(key);
        retval.ectrlNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void expControlUndo(PertDataChange undo) {
        if (undo.ectrlOrig == null) {
            String rescueID = undo.ectrlNew.getID();
            this.condDict_.dropExprControl(rescueID);
        } else if (undo.ectrlNew == null) {
            ExperimentControl eco = (ExperimentControl)undo.ectrlOrig.clone();
            this.condDict_.addExprControlForIO(eco);
        } else {
            ExperimentControl eco = (ExperimentControl)undo.ectrlOrig.clone();
            this.condDict_.setExprControl(eco);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void expControlRedo(PertDataChange redo) {
        if (redo.ectrlOrig == null) {
            ExperimentControl ecn = (ExperimentControl)redo.ectrlNew.clone();
            this.condDict_.addExprControlForIO(ecn);
        } else if (redo.ectrlNew == null) {
            String rescueID = redo.ectrlOrig.getID();
            this.condDict_.dropExprControl(rescueID);
        } else {
            ExperimentControl ecn = (ExperimentControl)redo.ectrlNew.clone();
            this.condDict_.setExprControl(ecn);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange setMeasureScale(MeasureScale mScale) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 18);
        String key = mScale.getID();
        MeasureScale orig = this.measureDict_.getMeasureScale(key);
        retval.mScaleOrig = orig == null ? null : (MeasureScale)orig.clone();
        this.measureDict_.setMeasureScale(mScale);
        retval.mScaleNew = (MeasureScale)mScale.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deleteMeasureScale(String key) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 18);
        MeasureScale orig = this.measureDict_.getMeasureScale(key);
        retval.mScaleOrig = (MeasureScale)orig.clone();
        this.measureDict_.dropMeasureScale(key);
        retval.mScaleNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void measureScaleUndo(PertDataChange undo) {
        if (undo.mScaleOrig == null) {
            String rescueID = undo.mScaleNew.getID();
            this.measureDict_.dropMeasureScale(rescueID);
        } else if (undo.mScaleNew == null) {
            MeasureScale mso = (MeasureScale)undo.mScaleOrig.clone();
            this.measureDict_.addMeasureScaleForIO(mso);
        } else {
            MeasureScale mso = (MeasureScale)undo.mScaleOrig.clone();
            this.measureDict_.setMeasureScale(mso);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void measureScaleRedo(PertDataChange redo) {
        if (redo.mScaleOrig == null) {
            MeasureScale msn = (MeasureScale)redo.mScaleNew.clone();
            this.measureDict_.addMeasureScaleForIO(msn);
        } else if (redo.mScaleNew == null) {
            String rescueID = redo.mScaleOrig.getID();
            this.measureDict_.dropMeasureScale(rescueID);
        } else {
            MeasureScale msn = (MeasureScale)redo.mScaleNew.clone();
            this.measureDict_.setMeasureScale(msn);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange mergeMeasureScaleRefs(Set mPropsToMerge, String scaleKey) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 25);
        retval.mPropsSubsetOrig = new HashMap();
        retval.mPropsSubsetNew = new HashMap();
        Iterator k2dit = mPropsToMerge.iterator();
        while (k2dit.hasNext()) {
            String key = (String)k2dit.next();
            MeasureProps mp = this.measureDict_.getMeasureProps(key);
            if (scaleKey.equals(mp.getScaleKey())) continue;
            retval.mPropsSubsetOrig.put(key, mp.clone());
            mp = (MeasureProps)mp.clone();
            mp.setScaleKey(scaleKey);
            this.measureDict_.setMeasureProp(mp);
            retval.mPropsSubsetNew.put(key, mp.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void measurePropSetUndo(PertDataChange undo) {
        Iterator dpnkit = undo.mPropsSubsetOrig.keySet().iterator();
        while (dpnkit.hasNext()) {
            String key = (String)dpnkit.next();
            MeasureProps mp = (MeasureProps)undo.mPropsSubsetOrig.get(key);
            MeasureProps mpc = (MeasureProps)mp.clone();
            this.measureDict_.setMeasureProp(mpc);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void measurePropSetRedo(PertDataChange redo) {
        Iterator dpnkit = redo.mPropsSubsetNew.keySet().iterator();
        while (dpnkit.hasNext()) {
            String key = (String)dpnkit.next();
            MeasureProps mp = (MeasureProps)redo.mPropsSubsetNew.get(key);
            MeasureProps mpc = (MeasureProps)mp.clone();
            this.measureDict_.setMeasureProp(mpc);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange[] mergeMeasureScales(List keyIDs, String useKey, MeasureScale scale) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                if (!scale.getID().equals(useKey)) {
                    throw new IllegalArgumentException();
                }
                retlist.add(this.setMeasureScale((MeasureScale)scale.clone()));
                continue;
            }
            retlist.add(this.deleteMeasureScale(keyID));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange setPerturbationProp(PertProperties pprops) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 21);
        String key = pprops.getID();
        PertProperties orig = this.pertDict_.getPerturbProps(key);
        retval.ppOrig = orig == null ? null : (PertProperties)orig.clone();
        this.pertDict_.setPerturbProp(pprops);
        retval.ppNew = (PertProperties)pprops.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deletePerturbationProp(String key) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 21);
        PertProperties orig = this.pertDict_.getPerturbProps(key);
        retval.ppOrig = (PertProperties)orig.clone();
        this.pertDict_.dropPerturbProp(key);
        retval.ppNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public Object clone() {
        try {
            PerturbationData newVal = (PerturbationData)super.clone();
            newVal.dataPoints_ = new HashMap();
            Iterator dpit = this.dataPoints_.keySet().iterator();
            while (dpit.hasNext()) {
                String dpKey = (String)dpit.next();
                newVal.dataPoints_.put(dpKey, ((PertDataPoint)this.dataPoints_.get(dpKey)).clone());
            }
            newVal.sourceDefs_ = new HashMap();
            Iterator sdit = this.sourceDefs_.keySet().iterator();
            while (sdit.hasNext()) {
                String sdKey = (String)sdit.next();
                newVal.sourceDefs_.put(sdKey, ((PertSource)this.sourceDefs_.get(sdKey)).clone());
            }
            newVal.experiments_ = new HashMap();
            Iterator psit = this.experiments_.keySet().iterator();
            while (psit.hasNext()) {
                String psKey = (String)psit.next();
                newVal.experiments_.put(psKey, ((Experiment)this.experiments_.get(psKey)).clone());
            }
            newVal.dataPointNotes_ = new HashMap();
            Iterator dpnit = this.dataPointNotes_.keySet().iterator();
            while (dpnit.hasNext()) {
                String dpKey = (String)dpnit.next();
                newVal.dataPointNotes_.put(dpKey, ((ArrayList)this.dataPointNotes_.get(dpKey)).clone());
            }
            newVal.userData_ = new HashMap();
            Iterator udit = this.userData_.keySet().iterator();
            while (udit.hasNext()) {
                String udKey = (String)udit.next();
                newVal.userData_.put(udKey, ((ArrayList)this.dataPointNotes_.get(udKey)).clone());
            }
            newVal.pertAnnot_ = (PertAnnotations)this.pertAnnot_.clone();
            newVal.labels_ = (UniqueLabeller)this.labels_.clone();
            newVal.entryMap_ = (NameMapper)this.entryMap_.clone();
            newVal.sourceMap_ = (NameMapper)this.sourceMap_.clone();
            newVal.investigators_ = (HashMap)this.investigators_.clone();
            newVal.targets_ = (HashMap)this.targets_.clone();
            newVal.sourceNames_ = (HashMap)this.sourceNames_.clone();
            newVal.regionRestrictions_ = new HashMap();
            Iterator rrit = this.regionRestrictions_.keySet().iterator();
            while (rrit.hasNext()) {
                String rKey = (String)rrit.next();
                newVal.regionRestrictions_.put(rKey, ((RegionRestrict)this.regionRestrictions_.get(rKey)).clone());
            }
            newVal.pertDict_ = (PertDictionary)this.pertDict_.clone();
            newVal.measureDict_ = (MeasureDictionary)this.measureDict_.clone();
            newVal.condDict_ = (ConditionDictionary)this.condDict_.clone();
            newVal.userFields_ = (ArrayList)this.userFields_.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public TrueObjChoiceContent getTargetChoiceContent(String key, boolean showAnnots) {
        String targ = showAnnots ? this.getAnnotatedTargetDisplay(key) : (String)this.targets_.get(key);
        return new TrueObjChoiceContent(targ, key);
    }

    public TrueObjChoiceContent getSourceOrProxyNameChoiceContent(String key) {
        String sname = (String)this.sourceNames_.get(key);
        return new TrueObjChoiceContent(sname, key);
    }

    public TrueObjChoiceContent getInvestigatorChoiceContent(String key) {
        String invest = (String)this.investigators_.get(key);
        return new TrueObjChoiceContent(invest, key);
    }

    public SortedSet getAllAvailableCandidates(int filterCat) {
        TreeSet<TrueObjChoiceContent> retval = new TreeSet<TrueObjChoiceContent>();
        switch (filterCat) {
            case 0: {
                Iterator prsit = this.experiments_.values().iterator();
                while (prsit.hasNext()) {
                    Experiment chk = (Experiment)prsit.next();
                    chk.addToExperimentSet(retval, this);
                }
                return retval;
            }
            case 5: {
                Iterator tkit = this.targets_.keySet().iterator();
                while (tkit.hasNext()) {
                    String tkey = (String)tkit.next();
                    retval.add(this.getTargetChoiceContent(tkey, true));
                }
                return retval;
            }
            case 3: {
                Iterator snkit = this.sourceNames_.keySet().iterator();
                while (snkit.hasNext()) {
                    String snkey = (String)snkit.next();
                    retval.add(this.getSourceOrProxyNameChoiceContent(snkey));
                }
                return retval;
            }
            case 8: {
                Iterator invkit = this.investigators_.keySet().iterator();
                while (invkit.hasNext()) {
                    String ikey = (String)invkit.next();
                    retval.add(this.getInvestigatorChoiceContent(ikey));
                }
                return retval;
            }
        }
        throw new IllegalArgumentException();
    }

    public SortedSet getCandidates(List chooseFrom, int filterCat) {
        TreeSet retval = new TreeSet();
        if (chooseFrom == null) {
            chooseFrom = new ArrayList(this.dataPoints_.values());
        }
        int numRs = chooseFrom.size();
        for (int i = 0; i < numRs; ++i) {
            PertDataPoint pdp = (PertDataPoint)chooseFrom.get(i);
            pdp.getCandidates(filterCat, retval, this);
        }
        return retval;
    }

    public SortedSet getCandidates(int filterCat) {
        return this.getCandidates(null, filterCat);
    }

    public List getPerturbations(PertFilterExpression pfe) {
        TreeMap sorted = new TreeMap(this.dataPoints_);
        TreeSet sortedKeys = new TreeSet(sorted.keySet());
        ArrayList retval = new ArrayList();
        SortedSet result = pfe.getFilteredResult(sortedKeys, sorted, this);
        Iterator resIt = result.iterator();
        while (resIt.hasNext()) {
            String pdpID = (String)resIt.next();
            retval.add(sorted.get(pdpID));
        }
        return retval;
    }

    public Iterator getSourceDefKeys() {
        return this.sourceDefs_.keySet().iterator();
    }

    public PertSource getSourceDef(String key) {
        return (PertSource)this.sourceDefs_.get(key);
    }

    public List getDataPointNotes(String dpkey) {
        return (List)this.dataPointNotes_.get(dpkey);
    }

    public Iterator getDataPointNoteKeys() {
        return this.dataPointNotes_.keySet().iterator();
    }

    public void addDataPointForIO(PertDataPoint meas) {
        this.dataPoints_.put(meas.getID(), meas);
        this.labels_.addExistingLabel(meas.getID());
    }

    public Iterator getDataPoints() {
        return this.dataPoints_.values().iterator();
    }

    public int getDataPointCount() {
        return this.dataPoints_.size();
    }

    private void dataPointSetUndo(PertDataChange undo) {
        if (undo.dataPtsSubsetOrig == null) {
            throw new IllegalStateException();
        }
        if (undo.dataPtsSubsetNew == null) {
            String key;
            Iterator kit = undo.dataPtsSubsetOrig.keySet().iterator();
            while (kit.hasNext()) {
                String key2 = (String)kit.next();
                PertDataPoint pdp = (PertDataPoint)undo.dataPtsSubsetOrig.get(key2);
                PertDataPoint pdpc = (PertDataPoint)pdp.clone();
                this.dataPoints_.put(key2, pdpc);
                this.labels_.addExistingLabel(key2);
            }
            if (undo.dataPtRegResSubsetOrig != null) {
                Iterator rrkit = undo.dataPtRegResSubsetOrig.keySet().iterator();
                while (rrkit.hasNext()) {
                    key = (String)rrkit.next();
                    RegionRestrict rr = (RegionRestrict)undo.dataPtRegResSubsetOrig.get(key);
                    RegionRestrict rrc = (RegionRestrict)rr.clone();
                    this.regionRestrictions_.put(key, rrc);
                }
            }
            if (undo.userDataSubsetOrig != null) {
                Iterator udkit = undo.userDataSubsetOrig.keySet().iterator();
                while (udkit.hasNext()) {
                    key = (String)udkit.next();
                    ArrayList ud = (ArrayList)undo.userDataSubsetOrig.get(key);
                    ArrayList udc = (ArrayList)ud.clone();
                    this.userData_.put(key, udc);
                }
            }
            if (undo.dataPtNotesSubsetOrig != null) {
                Iterator dpnkit = undo.dataPtNotesSubsetOrig.keySet().iterator();
                while (dpnkit.hasNext()) {
                    key = (String)dpnkit.next();
                    ArrayList dpn = (ArrayList)undo.dataPtNotesSubsetOrig.get(key);
                    ArrayList dpnc = (ArrayList)dpn.clone();
                    this.dataPointNotes_.put(key, dpnc);
                }
            }
        } else {
            Iterator kit = undo.dataPtsSubsetOrig.keySet().iterator();
            while (kit.hasNext()) {
                String key = (String)kit.next();
                PertDataPoint pdp = (PertDataPoint)undo.dataPtsSubsetOrig.get(key);
                PertDataPoint pdpc = (PertDataPoint)pdp.clone();
                this.dataPoints_.put(key, pdpc);
            }
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void dataPointSetRedo(PertDataChange redo) {
        if (redo.dataPtsSubsetOrig == null) {
            throw new IllegalStateException();
        }
        if (redo.dataPtsSubsetNew == null) {
            String key;
            Iterator kit = redo.dataPtsSubsetOrig.keySet().iterator();
            while (kit.hasNext()) {
                String key2 = (String)kit.next();
                this.dataPoints_.remove(key2);
                this.labels_.removeLabel(key2);
            }
            if (redo.dataPtRegResSubsetOrig != null) {
                Iterator rrkit = redo.dataPtRegResSubsetOrig.keySet().iterator();
                while (rrkit.hasNext()) {
                    key = (String)rrkit.next();
                    this.regionRestrictions_.remove(key);
                }
            }
            if (redo.userDataSubsetOrig != null) {
                Iterator udkit = redo.userDataSubsetOrig.keySet().iterator();
                while (udkit.hasNext()) {
                    key = (String)udkit.next();
                    this.userData_.remove(key);
                }
            }
            if (redo.dataPtNotesSubsetOrig != null) {
                Iterator dpnkit = redo.dataPtNotesSubsetOrig.keySet().iterator();
                while (dpnkit.hasNext()) {
                    key = (String)dpnkit.next();
                    this.dataPointNotes_.remove(key);
                }
            }
        } else {
            Iterator kit = redo.dataPtsSubsetNew.keySet().iterator();
            while (kit.hasNext()) {
                String key = (String)kit.next();
                PertDataPoint pdp = (PertDataPoint)redo.dataPtsSubsetNew.get(key);
                PertDataPoint pdpc = (PertDataPoint)pdp.clone();
                this.dataPoints_.put(key, pdpc);
            }
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange deleteDataPoints(Set keysToDrop) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 3);
        retval.dataPtsSubsetOrig = new HashMap();
        Iterator k2dit = keysToDrop.iterator();
        while (k2dit.hasNext()) {
            ArrayList noteList;
            ArrayList userDataList;
            String key = (String)k2dit.next();
            RegionRestrict regReg = (RegionRestrict)this.regionRestrictions_.get(key);
            if (regReg != null) {
                if (retval.dataPtRegResSubsetOrig == null) {
                    retval.dataPtRegResSubsetOrig = new HashMap();
                }
                retval.dataPtRegResSubsetOrig.put(key, regReg.clone());
                this.regionRestrictions_.remove(key);
            }
            if ((userDataList = (ArrayList)this.userData_.get(key)) != null) {
                if (retval.userDataSubsetOrig == null) {
                    retval.userDataSubsetOrig = new HashMap();
                }
                retval.userDataSubsetOrig.put(key, userDataList.clone());
                this.userData_.remove(key);
            }
            if ((noteList = (ArrayList)this.dataPointNotes_.get(key)) != null) {
                if (retval.dataPtNotesSubsetOrig == null) {
                    retval.dataPtNotesSubsetOrig = new HashMap();
                }
                retval.dataPtNotesSubsetOrig.put(key, noteList.clone());
                this.dataPointNotes_.remove(key);
            }
            PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(key);
            retval.dataPtsSubsetOrig.put(key, pdp.clone());
            this.dataPoints_.remove(key);
            this.labels_.removeLabel(key);
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergeDataPointTargetRefs(Set pointsToMerge, String targKey) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 3);
        retval.dataPtsSubsetOrig = new HashMap();
        retval.dataPtsSubsetNew = new HashMap();
        Iterator k2dit = pointsToMerge.iterator();
        while (k2dit.hasNext()) {
            String key = (String)k2dit.next();
            PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(key);
            if (pdp.getTargetKey().equals(targKey)) continue;
            retval.dataPtsSubsetOrig.put(key, pdp.clone());
            pdp.setTargetKey(targKey);
            retval.dataPtsSubsetNew.put(key, pdp.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergeDataPointControlRefs(Set pointsToMerge, String ctrlKey) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 3);
        retval.dataPtsSubsetOrig = new HashMap();
        retval.dataPtsSubsetNew = new HashMap();
        Iterator k2dit = pointsToMerge.iterator();
        while (k2dit.hasNext()) {
            String key = (String)k2dit.next();
            PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(key);
            if (pdp.getControl().equals(ctrlKey)) continue;
            retval.dataPtsSubsetOrig.put(key, pdp.clone());
            pdp.setControl(ctrlKey);
            retval.dataPtsSubsetNew.put(key, pdp.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergeMeasurePropRefs(Set pointsToMerge, String mpKey) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 3);
        retval.dataPtsSubsetOrig = new HashMap();
        retval.dataPtsSubsetNew = new HashMap();
        Iterator k2dit = pointsToMerge.iterator();
        while (k2dit.hasNext()) {
            String key = (String)k2dit.next();
            PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(key);
            if (pdp.getMeasurementTypeKey().equals(mpKey)) continue;
            retval.dataPtsSubsetOrig.put(key, pdp.clone());
            pdp.setMeasurementTypeKey(mpKey);
            retval.dataPtsSubsetNew.put(key, pdp.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deleteExperiments(Set keysToDrop) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 4);
        retval.expSubsetOrig = new HashMap();
        Iterator k2dit = keysToDrop.iterator();
        while (k2dit.hasNext()) {
            String dropkey = (String)k2dit.next();
            Experiment psi = (Experiment)this.experiments_.get(dropkey);
            retval.expSubsetOrig.put(dropkey, psi.clone());
            this.experiments_.remove(dropkey);
            this.labels_.removeLabel(dropkey);
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange dropInvestigator(String investID, Set keysToPrune) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 4);
        retval.expSubsetOrig = new HashMap();
        retval.expSubsetNew = new HashMap();
        Iterator k2dit = keysToPrune.iterator();
        while (k2dit.hasNext()) {
            String pruneKey = (String)k2dit.next();
            Experiment psi = (Experiment)this.experiments_.get(pruneKey);
            retval.expSubsetOrig.put(pruneKey, psi.clone());
            psi.deleteInvestigator(investID);
            retval.expSubsetNew.put(pruneKey, psi.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange dropDataPointAnnotations(String annotID, Set keysToPrune) {
        PertDataChange retval = null;
        Iterator kpit = keysToPrune.iterator();
        while (kpit.hasNext()) {
            String dpkey = (String)kpit.next();
            ArrayList noteList = (ArrayList)this.dataPointNotes_.get(dpkey);
            if (noteList == null) continue;
            if (retval == null) {
                retval = new PertDataChange(this.serialNumber_, 14);
                retval.dataPtNotesSubsetOrig = new HashMap();
                retval.dataPtNotesSubsetNew = new HashMap();
            }
            retval.dataPtNotesSubsetOrig.put(dpkey, noteList.clone());
            noteList.remove(annotID);
            if (noteList.isEmpty()) {
                this.dataPointNotes_.remove(dpkey);
            }
            retval.dataPtNotesSubsetNew.put(dpkey, noteList.clone());
        }
        if (retval != null) {
            retval.serialNumberNew = ++this.serialNumber_;
        }
        return retval;
    }

    private void dataPointAnnotSetUndo(PertDataChange undo) {
        Iterator dpnkit = undo.dataPtNotesSubsetOrig.keySet().iterator();
        while (dpnkit.hasNext()) {
            String key = (String)dpnkit.next();
            ArrayList dpn = (ArrayList)undo.dataPtNotesSubsetOrig.get(key);
            ArrayList dpnc = (ArrayList)dpn.clone();
            this.dataPointNotes_.put(key, dpnc);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void dataPointAnnotSetRedo(PertDataChange redo) {
        Iterator dpnkit = redo.dataPtNotesSubsetNew.keySet().iterator();
        while (dpnkit.hasNext()) {
            String key = (String)dpnkit.next();
            ArrayList dpn = (ArrayList)redo.dataPtNotesSubsetNew.get(key);
            ArrayList dpnc = (ArrayList)dpn.clone();
            if (dpnc.isEmpty()) {
                this.dataPointNotes_.remove(key);
                continue;
            }
            this.dataPointNotes_.put(key, dpnc);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange dropDataPointControls(String annotID, Set keysToPrune) {
        PertDataChange retval = null;
        Iterator kpit = keysToPrune.iterator();
        while (kpit.hasNext()) {
            String dpkey = (String)kpit.next();
            PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(dpkey);
            if (retval == null) {
                retval = new PertDataChange(this.serialNumber_, 3);
                retval.dataPtsSubsetOrig = new HashMap();
                retval.dataPtsSubsetNew = new HashMap();
            }
            retval.dataPtsSubsetOrig.put(dpkey, pdp.clone());
            pdp.setControl(null);
            retval.dataPtsSubsetNew.put(dpkey, pdp.clone());
        }
        if (retval != null) {
            retval.serialNumberNew = ++this.serialNumber_;
        }
        return retval;
    }

    public PertDataChange dropSourceDefAnnotations(String annotID, Set keysToPrune) {
        PertSource ps;
        PertDataChange retval = new PertDataChange(this.serialNumber_, 15);
        retval.srcDefsSubsetOrig = new HashMap();
        Iterator psdit = keysToPrune.iterator();
        while (psdit.hasNext()) {
            String sdkey = (String)psdit.next();
            PertSource ps2 = (PertSource)this.sourceDefs_.get(sdkey);
            retval.srcDefsSubsetOrig.put(sdkey, ps2.clone());
        }
        Iterator k2dit = keysToPrune.iterator();
        while (k2dit.hasNext()) {
            String pruneKey = (String)k2dit.next();
            ps = (PertSource)this.sourceDefs_.get(pruneKey);
            ArrayList psan = new ArrayList(ps.getAnnotationIDs());
            psan.remove(annotID);
            ps.setAnnotationIDs(psan);
        }
        retval.srcDefsSubsetNew = new HashMap();
        psdit = keysToPrune.iterator();
        while (psdit.hasNext()) {
            String sdkey = (String)psdit.next();
            ps = (PertSource)this.sourceDefs_.get(sdkey);
            retval.srcDefsSubsetNew.put(sdkey, ps.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void sourceDefSetUndo(PertDataChange undo) {
        Iterator dpnkit = undo.srcDefsSubsetOrig.keySet().iterator();
        while (dpnkit.hasNext()) {
            String key = (String)dpnkit.next();
            PertSource ps = (PertSource)undo.srcDefsSubsetOrig.get(key);
            PertSource psc = (PertSource)ps.clone();
            this.sourceDefs_.put(key, psc);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void sourceDefSetRedo(PertDataChange redo) {
        Iterator dpnkit = redo.srcDefsSubsetNew.keySet().iterator();
        while (dpnkit.hasNext()) {
            String key = (String)dpnkit.next();
            PertSource ps = (PertSource)redo.srcDefsSubsetNew.get(key);
            PertSource psc = (PertSource)ps.clone();
            this.sourceDefs_.put(key, psc);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange dropTargetAnnotations(String annotID, Set keysToPrune) {
        PertDataChange retval = null;
        Iterator kpit = keysToPrune.iterator();
        while (kpit.hasNext()) {
            String dpkey = (String)kpit.next();
            ArrayList noteList = (ArrayList)this.targetGeneNotes_.get(dpkey);
            if (noteList == null) continue;
            if (retval == null) {
                retval = new PertDataChange(this.serialNumber_, 22);
                retval.targetNotesSubsetOrig = new HashMap();
                retval.targetNotesSubsetNew = new HashMap();
            }
            retval.targetNotesSubsetOrig.put(dpkey, noteList.clone());
            noteList.remove(annotID);
            if (noteList.isEmpty()) {
                this.targetGeneNotes_.remove(dpkey);
            }
            retval.targetNotesSubsetNew.put(dpkey, noteList.clone());
        }
        if (retval != null) {
            retval.serialNumberNew = ++this.serialNumber_;
        }
        return retval;
    }

    public PertDataChange[] deletePertSourceDefs(Set keysToDrop) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        Iterator kit = keysToDrop.iterator();
        while (kit.hasNext()) {
            String keyID = (String)kit.next();
            retlist.add(this.deleteSourceDef(keyID));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange mergePertSourceNameRefs(Set defsToMerge, String srcKey, Set abandonKeys) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 15);
        retval.srcDefsSubsetOrig = new HashMap();
        retval.srcDefsSubsetNew = new HashMap();
        Iterator k2dit = defsToMerge.iterator();
        while (k2dit.hasNext()) {
            String srcNameKey;
            String key = (String)k2dit.next();
            PertSource psd = (PertSource)this.sourceDefs_.get(key);
            boolean replaceProx = false;
            boolean replaceSrc = false;
            if (psd.isAProxy()) {
                String proxKey = psd.getProxiedSpeciesKey();
                replaceProx = abandonKeys.contains(proxKey) && !proxKey.equals(srcKey);
            }
            boolean bl = replaceSrc = abandonKeys.contains(srcNameKey = psd.getSourceNameKey()) && !srcNameKey.equals(srcKey);
            if (!replaceProx && !replaceSrc) continue;
            retval.srcDefsSubsetOrig.put(key, psd.clone());
            if (replaceProx) {
                psd.setProxiedSpeciesKey(srcKey);
            }
            if (replaceSrc) {
                psd.setSourceNameKey(srcKey);
            }
            retval.srcDefsSubsetNew.put(key, psd.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange mergePertPropRefs(Set defsToMerge, String typeKey) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 15);
        retval.srcDefsSubsetOrig = new HashMap();
        retval.srcDefsSubsetNew = new HashMap();
        Iterator k2dit = defsToMerge.iterator();
        while (k2dit.hasNext()) {
            String key = (String)k2dit.next();
            PertSource psd = (PertSource)this.sourceDefs_.get(key);
            if (psd.getExpTypeKey().equals(typeKey)) continue;
            retval.srcDefsSubsetOrig.put(key, psd.clone());
            psd.setExpType(typeKey);
            retval.srcDefsSubsetNew.put(key, psd.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public SerialNumberSet getSerialNumbers() {
        return new SerialNumberSet(this.serialNumber_, this.entryMap_.getSerialNumber(), this.sourceMap_.getSerialNumber());
    }

    public void setSerialNumber(long serialNumber) {
        this.serialNumber_ = serialNumber;
    }

    public void changeUndo(PertDataChange undo) {
        switch (undo.mode) {
            case 1: {
                this.dataPointUndo(undo);
                return;
            }
            case 2: {
                this.experimentUndo(undo);
                return;
            }
            case 3: {
                this.dataPointSetUndo(undo);
                return;
            }
            case 4: {
                this.experimentSetUndo(undo);
                return;
            }
            case 5: {
                this.sourceDefUndo(undo);
                return;
            }
            case 6: {
                this.userFieldValsUndo(undo);
                return;
            }
            case 7: {
                this.userFieldNameUndo(undo);
                return;
            }
            case 8: {
                this.regRestrictUndo(undo);
                return;
            }
            case 9: {
                this.dataAnnotUndo(undo);
                return;
            }
            case 10: {
                this.targetAnnotUndo(undo);
                return;
            }
            case 11: {
                this.sourceNameUndo(undo);
                return;
            }
            case 12: {
                this.expControlUndo(undo);
                return;
            }
            case 13: {
                this.investUndo(undo);
                return;
            }
            case 14: {
                this.dataPointAnnotSetUndo(undo);
                return;
            }
            case 15: {
                this.sourceDefSetUndo(undo);
                return;
            }
            case 16: {
                this.measurePropUndo(undo);
                return;
            }
            case 17: {
                this.expCondUndo(undo);
                return;
            }
            case 18: {
                this.measureScaleUndo(undo);
                return;
            }
            case 19: {
                this.targetNameUndo(undo);
                return;
            }
            case 20: {
                this.annotationUndo(undo);
                return;
            }
            case 21: {
                this.pertPropUndo(undo);
                return;
            }
            case 22: {
                this.targetAnnotSetUndo(undo);
                return;
            }
            case 23: {
                this.annotModuleUndo(undo);
                return;
            }
            case 24: {
                if (undo.nameMapperMode.equals("targets")) {
                    this.entryMap_.changeUndo(undo);
                } else if (undo.nameMapperMode.equals("sources")) {
                    this.sourceMap_.changeUndo(undo);
                } else {
                    throw new IllegalArgumentException();
                }
                return;
            }
            case 25: {
                this.measurePropSetUndo(undo);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void changeRedo(PertDataChange redo) {
        switch (redo.mode) {
            case 1: {
                this.dataPointRedo(redo);
                return;
            }
            case 2: {
                this.experimentRedo(redo);
                return;
            }
            case 3: {
                this.dataPointSetRedo(redo);
                return;
            }
            case 4: {
                this.experimentSetRedo(redo);
                return;
            }
            case 5: {
                this.sourceDefRedo(redo);
                return;
            }
            case 6: {
                this.userFieldValsRedo(redo);
                return;
            }
            case 7: {
                this.userFieldNameRedo(redo);
                return;
            }
            case 8: {
                this.regRestrictRedo(redo);
                return;
            }
            case 9: {
                this.dataAnnotRedo(redo);
                return;
            }
            case 10: {
                this.targetAnnotRedo(redo);
                return;
            }
            case 11: {
                this.sourceNameRedo(redo);
                return;
            }
            case 12: {
                this.expControlRedo(redo);
                return;
            }
            case 13: {
                this.investRedo(redo);
                return;
            }
            case 14: {
                this.dataPointAnnotSetRedo(redo);
                return;
            }
            case 15: {
                this.sourceDefSetRedo(redo);
                return;
            }
            case 16: {
                this.measurePropRedo(redo);
                return;
            }
            case 17: {
                this.expCondRedo(redo);
                return;
            }
            case 18: {
                this.measureScaleRedo(redo);
                return;
            }
            case 19: {
                this.targetNameRedo(redo);
                return;
            }
            case 20: {
                this.annotationRedo(redo);
                return;
            }
            case 21: {
                this.pertPropRedo(redo);
                return;
            }
            case 22: {
                this.targetAnnotSetRedo(redo);
                return;
            }
            case 23: {
                this.annotModuleRedo(redo);
                return;
            }
            case 24: {
                if (redo.nameMapperMode.equals("targets")) {
                    this.entryMap_.changeRedo(redo);
                } else if (redo.nameMapperMode.equals("sources")) {
                    this.sourceMap_.changeRedo(redo);
                } else {
                    throw new IllegalArgumentException();
                }
                return;
            }
            case 25: {
                this.measurePropSetRedo(redo);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean havePertSources() {
        return !this.sourceDefs_.isEmpty();
    }

    public boolean haveData() {
        if (this.dataPoints_.size() > 0) {
            return true;
        }
        if (!this.experiments_.isEmpty()) {
            return true;
        }
        if (this.pertDict_.getKeys().hasNext()) {
            return true;
        }
        if (this.measureDict_.haveData()) {
            return true;
        }
        if (this.condDict_.haveData()) {
            return true;
        }
        if (this.pertAnnot_.haveMessages()) {
            return true;
        }
        if (!this.targets_.isEmpty()) {
            return true;
        }
        if (!this.sourceNames_.isEmpty()) {
            return true;
        }
        if (!this.investigators_.isEmpty()) {
            return true;
        }
        if (!this.sourceDefs_.isEmpty()) {
            return true;
        }
        if (!this.regionRestrictions_.isEmpty()) {
            return true;
        }
        if (this.entryMap_.haveData()) {
            return true;
        }
        return this.sourceMap_.haveData();
    }

    public MinMax getDataRange() {
        int numSrc = this.experiments_.size();
        if (numSrc == 0) {
            return null;
        }
        MinMax retval = new MinMax().init();
        Iterator psit = this.experiments_.values().iterator();
        while (psit.hasNext()) {
            Experiment prs = (Experiment)psit.next();
            int time = prs.getTime();
            int legMax = prs.getLegacyMaxTime();
            if (time != -1) {
                retval.update(time);
            }
            if (legMax == -1) continue;
            retval.update(legMax);
        }
        boolean haveVals = retval.min != Integer.MAX_VALUE && retval.max != Integer.MIN_VALUE;
        return haveVals ? retval : null;
    }

    public boolean haveCustomEntryMapForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        return this.entryMap_.haveCustomMapForNode(nodeID);
    }

    public boolean haveCustomSourceMapForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        return this.sourceMap_.haveCustomMapForNode(nodeID);
    }

    public boolean haveCustomMapForNode(String nodeID) {
        return this.haveCustomSourceMapForNode(nodeID) || this.haveCustomEntryMapForNode(nodeID);
    }

    public boolean haveDataForNode(String nodeID, String sourceID) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = this.getDataEntryKeysWithDefault(nodeID);
        if (mapped == null || mapped.isEmpty()) {
            return false;
        }
        List smapped = null;
        if (sourceID != null && ((smapped = this.getDataSourceKeysWithDefault(sourceID)) == null || smapped.isEmpty())) {
            return false;
        }
        Iterator mit = mapped.iterator();
        while (mit.hasNext()) {
            String key = (String)mit.next();
            if (smapped == null) {
                PertFilterExpression pfe = new PertFilterExpression(new PertFilter(5, 0, key));
                List pertsWithTarg = this.getPerturbations(pfe);
                if (pertsWithTarg.isEmpty()) continue;
                return true;
            }
            PertFilter tfilt = new PertFilter(5, 0, key);
            Iterator smit = smapped.iterator();
            while (smit.hasNext()) {
                String skey = (String)smit.next();
                PertFilter sfilt = new PertFilter(2, 0, skey);
                PertFilterExpression pfe = new PertFilterExpression(3, tfilt, sfilt);
                List pertsWithSrcAndTarg = this.getPerturbations(pfe);
                if (pertsWithSrcAndTarg.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public PertDataChange[] changeName(String oldName, String newName) {
        String foundSrc;
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        String foundTarg = this.getTargKeyFromName(oldName);
        if (foundTarg != null) {
            retlist.addAll(Arrays.asList(this.changeTargetNameManageIdents(foundTarg, newName)));
        }
        if ((foundSrc = this.getSourceKeyFromName(oldName)) != null) {
            retlist.addAll(Arrays.asList(this.setSourceName(foundSrc, newName)));
        }
        PertDataChange[] changes = retlist.toArray(new PertDataChange[retlist.size()]);
        return changes;
    }

    public PertDataChange setExperiment(Experiment exp) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 2);
        Experiment currExp = (Experiment)this.experiments_.get(exp.getID());
        retval.expOrig = currExp == null ? null : (Experiment)currExp.clone();
        this.experiments_.put(exp.getID(), exp);
        retval.expNew = (Experiment)exp.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public Map getBatchKeysForExperiment(String expKey) {
        HashMap<String, HashSet<String>> retval = new HashMap<String, HashSet<String>>();
        Iterator dpit = this.dataPoints_.keySet().iterator();
        while (dpit.hasNext()) {
            String dpKey = (String)dpit.next();
            PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(dpKey);
            if (!expKey.equals(pdp.getExperimentKey())) continue;
            String batchID = pdp.getBatchKey();
            String targetID = pdp.getTargetKey();
            HashSet<String> forTarg = (HashSet<String>)retval.get(targetID);
            if (forTarg == null) {
                forTarg = new HashSet<String>();
                retval.put(targetID, forTarg);
            }
            forTarg.add(batchID);
        }
        return retval;
    }

    public Map mergeExperimentBatchCollisions(Set keyIDs) {
        HashMap seenKeys = new HashMap();
        Iterator dpit = this.dataPoints_.keySet().iterator();
        while (dpit.hasNext()) {
            ArrayList<String> vals;
            String dpKey = (String)dpit.next();
            PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(dpKey);
            String expKey = pdp.getExperimentKey();
            if (!keyIDs.contains(expKey)) continue;
            String batchID = pdp.getBatchKey();
            String targetID = pdp.getTargetKey();
            HashMap<String, ArrayList<String>> forTarg = (HashMap<String, ArrayList<String>>)seenKeys.get(targetID);
            if (forTarg == null) {
                forTarg = new HashMap<String, ArrayList<String>>();
                seenKeys.put(targetID, forTarg);
            }
            if ((vals = (ArrayList<String>)forTarg.get(batchID)) == null) {
                vals = new ArrayList<String>();
                forTarg.put(batchID, vals);
            }
            vals.add(pdp.getDisplayValue());
        }
        return seenKeys;
    }

    public Map prepBatchCollisions(Map collisions, String expString) {
        boolean haveOne = false;
        TreeMap retval = new TreeMap();
        TreeMap perExp = new TreeMap();
        retval.put(expString, perExp);
        Iterator cit = collisions.keySet().iterator();
        while (cit.hasNext()) {
            String targetID = (String)cit.next();
            Map forTarg = (Map)collisions.get(targetID);
            TreeMap<String, BatchCollision> perTarg = new TreeMap<String, BatchCollision>();
            String targName = this.getTarget(targetID);
            perExp.put(targName, perTarg);
            Iterator ftit = forTarg.keySet().iterator();
            while (ftit.hasNext()) {
                String batchID = (String)ftit.next();
                ArrayList vals = (ArrayList)forTarg.get(batchID);
                int numVal = vals.size();
                if (numVal <= 1) continue;
                BatchCollision bc = new BatchCollision(expString, targName, batchID);
                perTarg.put(batchID, bc);
                bc.vals.addAll(vals);
                haveOne = true;
            }
        }
        return haveOne ? retval : null;
    }

    public PertDataChange[] mergeExperiments(List keyIDs, String useKey, Experiment revisedExp) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                retlist.add(this.setExperiment(revisedExp));
                continue;
            }
            retlist.add(this.deleteExperiment(keyID));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    public PertDataChange mergeExperimentRefs(Set pointsToMerge, String expKey, Set abandonKeys) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 3);
        retval.dataPtsSubsetOrig = new HashMap();
        retval.dataPtsSubsetNew = new HashMap();
        Iterator k2dit = pointsToMerge.iterator();
        while (k2dit.hasNext()) {
            String key = (String)k2dit.next();
            PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(key);
            if (pdp.getExperimentKey().equals(expKey)) continue;
            retval.dataPtsSubsetOrig.put(key, pdp.clone());
            pdp.setExperimentKey(expKey);
            retval.dataPtsSubsetNew.put(key, pdp.clone());
        }
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deleteExperiment(String psiID) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 2);
        retval.expOrig = (Experiment)((Experiment)this.experiments_.get(psiID)).clone();
        this.experiments_.remove(psiID);
        this.labels_.removeLabel(psiID);
        retval.expNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void experimentUndo(PertDataChange undo) {
        if (undo.expOrig == null) {
            String repairID = undo.expNew.getID();
            this.experiments_.remove(repairID);
            this.labels_.removeLabel(repairID);
        } else if (undo.expNew == null) {
            Experiment expu = (Experiment)undo.expOrig.clone();
            String repairID = expu.getID();
            this.experiments_.put(repairID, expu);
            this.labels_.addExistingLabel(repairID);
        } else {
            Experiment expu = (Experiment)undo.expOrig.clone();
            String repairID = expu.getID();
            this.experiments_.put(repairID, expu);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void experimentRedo(PertDataChange redo) {
        if (redo.expOrig == null) {
            Experiment expn = (Experiment)redo.expNew.clone();
            String repairID = expn.getID();
            this.experiments_.put(repairID, expn);
            this.labels_.addExistingLabel(repairID);
        } else if (redo.expNew == null) {
            String repairID = redo.expOrig.getID();
            this.experiments_.remove(repairID);
            this.labels_.removeLabel(repairID);
        } else {
            Experiment expn = (Experiment)redo.expNew.clone();
            String repairID = expn.getID();
            this.experiments_.put(repairID, expn);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    private void experimentSetUndo(PertDataChange undo) {
        if (undo.expSubsetOrig == null) {
            throw new IllegalStateException();
        }
        if (undo.expSubsetNew == null) {
            Iterator kit = undo.expSubsetOrig.keySet().iterator();
            while (kit.hasNext()) {
                String key = (String)kit.next();
                Experiment exp = (Experiment)undo.expSubsetOrig.get(key);
                Experiment expc = (Experiment)exp.clone();
                this.experiments_.put(key, expc);
                this.labels_.addExistingLabel(key);
            }
        } else {
            Iterator kit = undo.expSubsetOrig.keySet().iterator();
            while (kit.hasNext()) {
                String key = (String)kit.next();
                Experiment exp = (Experiment)undo.expSubsetOrig.get(key);
                Experiment expc = (Experiment)exp.clone();
                this.experiments_.put(key, expc);
            }
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void experimentSetRedo(PertDataChange redo) {
        if (redo.expSubsetOrig == null) {
            throw new IllegalStateException();
        }
        if (redo.expSubsetNew == null) {
            Iterator kit = redo.expSubsetOrig.keySet().iterator();
            while (kit.hasNext()) {
                String key = (String)kit.next();
                this.experiments_.remove(key);
                this.labels_.removeLabel(key);
            }
        } else {
            Iterator kit = redo.expSubsetNew.keySet().iterator();
            while (kit.hasNext()) {
                String key = (String)kit.next();
                Experiment exp = (Experiment)redo.expSubsetNew.get(key);
                Experiment expc = (Experiment)exp.clone();
                this.experiments_.put(key, expc);
            }
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public Experiment getExperiment(String key) {
        return (Experiment)this.experiments_.get(key);
    }

    public Iterator getExperimentKeys() {
        return new TreeSet(this.experiments_.keySet()).iterator();
    }

    public PertDataChange setSourceDef(PertSource ps) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 5);
        PertSource currPs = (PertSource)this.sourceDefs_.get(ps.getID());
        retval.srcDefOrig = currPs == null ? null : (PertSource)currPs.clone();
        this.sourceDefs_.put(ps.getID(), ps);
        retval.srcDefNew = (PertSource)ps.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange deleteSourceDef(String psID) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 5);
        retval.srcDefOrig = (PertSource)((PertSource)this.sourceDefs_.get(psID)).clone();
        this.sourceDefs_.remove(psID);
        retval.srcDefNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange[] mergePertSourceDefs(List keyIDs, String useKey, PertSource revisedPsrc) {
        ArrayList<PertDataChange> retlist = new ArrayList<PertDataChange>();
        int numIDs = keyIDs.size();
        for (int i = 0; i < numIDs; ++i) {
            String keyID = (String)keyIDs.get(i);
            if (keyID.equals(useKey)) {
                retlist.add(this.setSourceDef(revisedPsrc));
                continue;
            }
            retlist.add(this.deleteSourceDef(keyID));
        }
        return retlist.toArray(new PertDataChange[retlist.size()]);
    }

    private void sourceDefUndo(PertDataChange undo) {
        if (undo.srcDefOrig == null) {
            String repairID = undo.srcDefNew.getID();
            this.sourceDefs_.remove(repairID);
            this.labels_.removeLabel(repairID);
        } else if (undo.srcDefNew == null) {
            String repairID = undo.srcDefOrig.getID();
            PertSource psc = (PertSource)undo.srcDefOrig.clone();
            this.sourceDefs_.put(repairID, psc);
            this.labels_.addExistingLabel(repairID);
        } else {
            String repairID = undo.srcDefOrig.getID();
            PertSource psc = (PertSource)undo.srcDefOrig.clone();
            this.sourceDefs_.put(repairID, psc);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void sourceDefRedo(PertDataChange redo) {
        if (redo.srcDefOrig == null) {
            String repairID = redo.srcDefNew.getID();
            PertSource psc = (PertSource)redo.srcDefNew.clone();
            this.sourceDefs_.put(repairID, psc);
            this.labels_.addExistingLabel(repairID);
        } else if (redo.srcDefNew == null) {
            String repairID = redo.srcDefOrig.getID();
            this.sourceDefs_.remove(repairID);
            this.labels_.removeLabel(repairID);
        } else {
            String repairID = redo.srcDefNew.getID();
            PertSource psc = (PertSource)redo.srcDefNew.clone();
            this.sourceDefs_.put(repairID, psc);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange setDataPoint(PertDataPoint pdp) {
        PertDataChange retval = new PertDataChange(this.serialNumber_, 1);
        PertDataPoint currPdp = (PertDataPoint)this.dataPoints_.get(pdp.getID());
        retval.pdpOrig = currPdp == null ? null : (PertDataPoint)currPdp.clone();
        this.dataPoints_.put(pdp.getID(), pdp);
        retval.pdpNew = (PertDataPoint)pdp.clone();
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private void dataPointUndo(PertDataChange undo) {
        if (undo.pdpOrig == null) {
            String repairID = undo.pdpNew.getID();
            this.dataPoints_.remove(repairID);
            this.labels_.removeLabel(repairID);
        } else if (undo.pdpNew == null) {
            PertDataPoint pdpu = (PertDataPoint)undo.pdpOrig.clone();
            String repairID = pdpu.getID();
            this.dataPoints_.put(repairID, pdpu);
            this.labels_.addExistingLabel(repairID);
            if (undo.dataAnnotsOrig != null) {
                ArrayList notes = (ArrayList)undo.dataAnnotsOrig.clone();
                this.dataPointNotes_.put(repairID, notes);
            }
            if (undo.dataRegResOrig != null) {
                RegionRestrict regReg = (RegionRestrict)undo.dataRegResOrig.clone();
                this.regionRestrictions_.put(repairID, regReg);
            }
            if (undo.userDataOrig != null) {
                ArrayList values = (ArrayList)undo.userDataOrig.clone();
                this.userData_.put(repairID, values);
            }
        } else {
            PertDataPoint pdpu = (PertDataPoint)undo.pdpOrig.clone();
            String repairID = pdpu.getID();
            this.dataPoints_.put(repairID, pdpu);
        }
        this.serialNumber_ = undo.serialNumberOrig;
    }

    private void dataPointRedo(PertDataChange redo) {
        if (redo.pdpOrig == null) {
            PertDataPoint pdpn = (PertDataPoint)redo.pdpNew.clone();
            String repairID = pdpn.getID();
            this.dataPoints_.put(repairID, pdpn);
            this.labels_.addExistingLabel(repairID);
        } else if (redo.pdpNew == null) {
            String repairID = redo.pdpOrig.getID();
            this.dataPoints_.remove(repairID);
            this.labels_.removeLabel(repairID);
            if (redo.dataAnnotsOrig != null) {
                this.dataPointNotes_.remove(repairID);
            }
            if (redo.dataRegResOrig != null) {
                this.regionRestrictions_.remove(repairID);
            }
            if (redo.userDataOrig != null) {
                this.userData_.remove(repairID);
            }
        } else {
            PertDataPoint pdpn = (PertDataPoint)redo.pdpNew.clone();
            String repairID = pdpn.getID();
            this.dataPoints_.put(repairID, pdpn);
        }
        this.serialNumber_ = redo.serialNumberNew;
    }

    public PertDataChange deleteDataPoint(String pdpID) {
        ArrayList values;
        RegionRestrict regReg;
        PertDataChange retval = new PertDataChange(this.serialNumber_, 1);
        retval.pdpOrig = (PertDataPoint)((PertDataPoint)this.dataPoints_.get(pdpID)).clone();
        this.dataPoints_.remove(pdpID);
        this.labels_.removeLabel(pdpID);
        ArrayList notes = (ArrayList)this.dataPointNotes_.get(pdpID);
        if (notes != null) {
            retval.dataAnnotsOrig = (ArrayList)notes.clone();
            this.dataPointNotes_.remove(pdpID);
        }
        if ((regReg = (RegionRestrict)this.regionRestrictions_.get(pdpID)) != null) {
            retval.dataRegResOrig = (RegionRestrict)regReg.clone();
            this.regionRestrictions_.remove(pdpID);
        }
        if ((values = (ArrayList)this.userData_.get(pdpID)) != null) {
            retval.userDataOrig = (ArrayList)values.clone();
            this.userData_.remove(pdpID);
        }
        retval.pdpNew = null;
        retval.serialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public PertDataChange[] dropDanglingMapsForEntry(String entryID) {
        return this.entryMap_.dropDanglingMapsFor(entryID);
    }

    public PertDataChange dropPertDataForFilter(PertFilterExpression pfe) {
        List dropPoints = this.getPerturbations(pfe);
        HashSet<String> keysToDrop = new HashSet<String>();
        int numNew = dropPoints.size();
        for (int i = 0; i < numNew; ++i) {
            PertDataPoint pdp = (PertDataPoint)dropPoints.get(i);
            keysToDrop.add(pdp.getID());
        }
        return this.deleteDataPoints(keysToDrop);
    }

    public Set getNetworkElements() {
        HashSet<QpcrSourceSet> retval = new HashSet<QpcrSourceSet>();
        List sigPerts = this.getSignificantPerturbations();
        int numSig = sigPerts.size();
        for (int i = 0; i < numSig; ++i) {
            PertDataPoint pdp = (PertDataPoint)sigPerts.get(i);
            String tname = pdp.getTargetName(this);
            retval.add(new QpcrSourceSet(tname, 0));
            Experiment psi = pdp.getExperiment(this);
            if (psi.isSinglePerturbation()) {
                PertSource ps = psi.getSources().getSinglePert(this);
                retval.add(new QpcrSourceSet(ps.getSourceName(this), 0));
                continue;
            }
            retval.add(new QpcrSourceSet(psi.getPertDisplayString(this, 0), psi.getSources().getNumSources()));
        }
        return retval;
    }

    public void installNameMap(NameMapper nMap) {
        String usage = nMap.getUsage();
        if (usage.equals("targets")) {
            this.entryMap_ = nMap;
        } else if (usage.equals("sources")) {
            this.sourceMap_ = nMap;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public PertDataChange setEntryMap(String key, List entries) {
        return this.entryMap_.setDataMap(key, entries);
    }

    public void importLegacyEntryMapEntry(String key, List entries) {
        this.buildInvertTrgNameCache();
        this.entryMap_.importLegacyMapEntry(key, entries, this.invertTargNameCache_);
    }

    public void importLegacySourceMapEntry(String key, List entries) {
        this.buildInvertSrcNameCache();
        this.sourceMap_.importLegacyMapEntry(key, entries, this.invertSrcNameCache_);
    }

    public PertDataChange setSourceMap(String key, List entries) {
        return this.sourceMap_.setDataMap(key, entries);
    }

    public PertDataChange[] addDataMaps(String key, List entries, List sources) {
        PertDataChange retval;
        ArrayList<PertDataChange> retvalList = new ArrayList<PertDataChange>();
        if (entries != null && entries.size() > 0) {
            retval = this.setEntryMap(key, entries);
            retvalList.add(retval);
        }
        if (sources != null && sources.size() > 0) {
            retval = this.setSourceMap(key, sources);
            retvalList.add(retval);
        }
        return retvalList.toArray(new PertDataChange[retvalList.size()]);
    }

    public List getDataEntryKeysWithDefault(String nodeId) {
        String name = ((DBGenome)Database.getDB().getGenome()).getNode(nodeId).getName();
        return this.entryMap_.getDataKeysWithDefault(nodeId, this.getTargKeyFromName(name));
    }

    public List getDataSourceKeysWithDefault(String nodeId) {
        String name = ((DBGenome)Database.getDB().getGenome()).getNode(nodeId).getName();
        return this.sourceMap_.getDataKeysWithDefault(nodeId, this.getSourceKeyFromName(name));
    }

    public List getDataEntryKeysWithDefaultGivenName(String nodeId, String nodeName) {
        return this.entryMap_.getDataKeysWithDefault(nodeId, this.getTargKeyFromName(nodeName));
    }

    public List getCustomDataEntryKeys(String geneId) {
        return this.entryMap_.getCustomDataKeys(geneId);
    }

    public List getCustomDataSourceKeys(String geneId) {
        return this.sourceMap_.getCustomDataKeys(geneId);
    }

    public Set getDataEntryKeyInverse(String key) {
        return this.entryMap_.getDataKeyInverse(key, this.targets_);
    }

    public Set getDataSourceKeyInverse(String key) {
        return this.sourceMap_.getDataKeyInverse(key, this.sourceNames_);
    }

    public boolean dataEntryOnlyInverseIsDefault(String key) {
        return this.entryMap_.onlyInverseIsDefault(key, this.targets_);
    }

    public boolean dataSourceOnlyInverseIsDefault(String key) {
        return this.sourceMap_.onlyInverseIsDefault(key, this.sourceNames_);
    }

    public Set getDataEntryKeySet() {
        return this.entryMap_.getDataKeySet();
    }

    public Set getDataSourceKeySet() {
        return this.sourceMap_.getDataKeySet();
    }

    public PertDataChange dropDataEntryKeys(String geneId) {
        if (!this.entryMap_.haveCustomMapForNode(geneId) && !this.entryMap_.haveEmptyMapForNode(geneId)) {
            return null;
        }
        return this.entryMap_.dropDataKeys(geneId);
    }

    public PertDataChange dropDataSourceKeys(String geneId) {
        if (!this.sourceMap_.haveCustomMapForNode(geneId) && !this.sourceMap_.haveEmptyMapForNode(geneId)) {
            return null;
        }
        return this.sourceMap_.dropDataKeys(geneId);
    }

    public PertDataChange[] dropAllDataEntryKeys() {
        ArrayList<PertDataChange> retval = new ArrayList<PertDataChange>();
        Iterator ksit = new HashSet(this.getDataEntryKeySet()).iterator();
        while (ksit.hasNext()) {
            String id = (String)ksit.next();
            PertDataChange pdc = this.dropDataEntryKeys(id);
            retval.add(pdc);
        }
        return retval.toArray(new PertDataChange[retval.size()]);
    }

    public PertDataChange[] dropAllDataSourceKeys() {
        ArrayList<PertDataChange> retval = new ArrayList<PertDataChange>();
        Iterator ksit = new HashSet(this.getDataSourceKeySet()).iterator();
        while (ksit.hasNext()) {
            String id = (String)ksit.next();
            PertDataChange pdc = this.dropDataSourceKeys(id);
            retval.add(pdc);
        }
        return retval.toArray(new PertDataChange[retval.size()]);
    }

    public Set getPerturbationSources(String targetID) {
        HashSet retval = new HashSet();
        List stPerts = this.getSrcTargPerts(null, targetID);
        int numSt = stPerts.size();
        if (numSt == 0) {
            return retval;
        }
        for (int i = 0; i < numSt; ++i) {
            PertDataPoint pdp = (PertDataPoint)stPerts.get(i);
            String sskey = pdp.getSingleSourceKey(this);
            if (sskey == null) continue;
            retval.addAll(this.getDataSourceKeyInverse(sskey));
        }
        return retval;
    }

    public Set getProxiedSources() {
        HashSet<String> retval = new HashSet<String>();
        Iterator sdit = this.sourceDefs_.values().iterator();
        while (sdit.hasNext()) {
            PertSource chk = (PertSource)sdit.next();
            if (!chk.isAProxy()) continue;
            retval.add(chk.getSourceNameKey());
        }
        return retval;
    }

    public Map getMappedProxiedSources() {
        HashMap<String, HashSet<String>> retval = new HashMap<String, HashSet<String>>();
        Iterator sdit = this.sourceDefs_.values().iterator();
        while (sdit.hasNext()) {
            PertSource chk = (PertSource)sdit.next();
            if (!chk.isAProxy()) continue;
            String srcKey = chk.getSourceNameKey();
            HashSet<String> allProx = (HashSet<String>)retval.get(srcKey);
            if (allProx == null) {
                allProx = new HashSet<String>();
                retval.put(srcKey, allProx);
            }
            allProx.add(chk.getProxiedSpeciesKey());
        }
        return retval;
    }

    public Set getPertSourceKeysForProxies() {
        HashSet<String> retval = new HashSet<String>();
        Iterator sdit = this.sourceDefs_.keySet().iterator();
        while (sdit.hasNext()) {
            String chkID = (String)sdit.next();
            PertSource chk = (PertSource)this.sourceDefs_.get(chkID);
            if (!chk.isAProxy()) continue;
            retval.add(chkID);
        }
        return retval;
    }

    public List getSignificantPerturbations() {
        if (this.sigPertCache_ == null || this.sigPertCacheVersionSN_ != this.serialNumber_) {
            PertFilter pertFilter = new PertFilter(7, 9, null);
            PertFilterExpression pfe = new PertFilterExpression(pertFilter);
            this.sigPertCache_ = this.getPerturbations(pfe);
            this.sigPertCacheVersionSN_ = this.serialNumber_;
        }
        return this.sigPertCache_;
    }

    public PertFilterExpression getFilterExpression(String sourceID, String targetID, boolean allowProxy) {
        List skeys = sourceID == null ? null : this.getDataSourceKeysWithDefault(sourceID);
        List tkeys = this.getDataEntryKeysWithDefault(targetID);
        return this.getFilterExpression(sourceID == null, skeys, tkeys, allowProxy);
    }

    public PertFilterExpression getFilterExpression(boolean skipSource, List skeys, List tkeys, boolean allowProxy) {
        int srcFilterCat = allowProxy ? 3 : 2;
        PertFilterExpression srcExp = null;
        if (skeys == null || skeys.isEmpty()) {
            int useOp = skipSource ? 1 : 0;
            srcExp = new PertFilterExpression(useOp);
            if (useOp == 0) {
                return srcExp;
            }
        } else {
            int numS = skeys.size();
            for (int i = 0; i < numS; ++i) {
                String sKey = (String)skeys.get(i);
                PertFilter srcFilter = new PertFilter(srcFilterCat, 0, sKey);
                srcExp = srcExp == null ? new PertFilterExpression(srcFilter) : new PertFilterExpression(4, srcExp, srcFilter);
            }
        }
        PertFilterExpression trgExp = null;
        if (tkeys == null || tkeys.isEmpty()) {
            trgExp = new PertFilterExpression(0);
            return trgExp;
        }
        int numT = tkeys.size();
        for (int i = 0; i < numT; ++i) {
            String tKey = (String)tkeys.get(i);
            PertFilter trgFilter = new PertFilter(5, 0, tKey);
            trgExp = trgExp == null ? new PertFilterExpression(trgFilter) : new PertFilterExpression(4, trgExp, trgFilter);
        }
        PertFilterExpression exp = srcExp == null ? trgExp : new PertFilterExpression(3, trgExp, srcExp);
        return exp;
    }

    public List getSrcTargPerts(String sourceID, String targetID) {
        PertFilterExpression fex = this.getFilterExpression(sourceID, targetID, false);
        return this.getPerturbations(fex);
    }

    public boolean haveDataRelaxedMatch(String targetName) {
        List sigPerts = this.getSignificantPerturbations();
        int numSig = sigPerts.size();
        for (int i = 0; i < numSig; ++i) {
            PertDataPoint pdp = (PertDataPoint)sigPerts.get(i);
            String tname = pdp.getTargetName(this);
            if (!DataUtil.keysEqual(tname, targetName)) continue;
            return true;
        }
        return false;
    }

    public double getPertAverageValue(String sourceID, String targetID, boolean avgSigOnly) {
        List stPerts = this.getSrcTargPerts(sourceID, targetID);
        int numSt = stPerts.size();
        if (numSt == 0) {
            return 0.0;
        }
        ArrayList<Double> doubleVals = new ArrayList<Double>();
        for (int i = 0; i < numSt; ++i) {
            PertDataPoint pdp = (PertDataPoint)stPerts.get(i);
            Double dValObj = pdp.getPerturbValue(this);
            if (dValObj == null || avgSigOnly && !pdp.isSignificant(this)) continue;
            doubleVals.add(dValObj);
        }
        return DataUtil.avgVal(doubleVals);
    }

    public String getToolTip(String sourceID, String targetID, String scaleKey) {
        MinMax time;
        List stPerts = this.getSrcTargPerts(sourceID, targetID);
        int numstp = stPerts.size();
        if (numstp == 0) {
            return "";
        }
        HashMap tipData = new HashMap();
        for (int i = 0; i < numstp; ++i) {
            ArrayList<String> dataForBatch;
            HashMap<String, ArrayList<String>> batchesForTime;
            PertDataPoint pdp = (PertDataPoint)stPerts.get(i);
            String display = pdp.getScaledDisplayValueOldStyle(scaleKey, this, false);
            String batchKey = pdp.getDecoratedBatchKey(this, false);
            MinMax time2 = pdp.getTimeRange(this);
            SrcTarg stKey = new SrcTarg(pdp.getPertDisplayString(this, 0), pdp.getTargetKey());
            TreeMap dataForST = (TreeMap)tipData.get(stKey);
            if (dataForST == null) {
                dataForST = new TreeMap();
                tipData.put(stKey, dataForST);
            }
            if ((batchesForTime = (HashMap<String, ArrayList<String>>)dataForST.get(time2)) == null) {
                batchesForTime = new HashMap<String, ArrayList<String>>();
                dataForST.put(time2, batchesForTime);
            }
            if ((dataForBatch = (ArrayList<String>)batchesForTime.get(batchKey)) == null) {
                dataForBatch = new ArrayList<String>();
                batchesForTime.put(batchKey, dataForBatch);
            }
            dataForBatch.add(display);
        }
        Iterator tdit = tipData.keySet().iterator();
        while (tdit.hasNext()) {
            SrcTarg stKey = (SrcTarg)tdit.next();
            TreeMap dataForST = (TreeMap)tipData.get(stKey);
            Iterator dfstit = dataForST.keySet().iterator();
            TreeMap reducedForST = new TreeMap();
            while (dfstit.hasNext()) {
                time = (MinMax)dfstit.next();
                if (time.min == time.max) continue;
                reducedForST.put(time, dataForST.get(time));
            }
            dfstit = dataForST.keySet().iterator();
            while (dfstit.hasNext()) {
                time = (MinMax)dfstit.next();
                HashMap batchesForTimeSrc = (HashMap)dataForST.get(time);
                if (time.min != time.max) continue;
                boolean transferred = false;
                Iterator redit = reducedForST.keySet().iterator();
                while (redit.hasNext()) {
                    MinMax candidate = (MinMax)redit.next();
                    if (candidate.min == candidate.max || !candidate.contained(time.min)) continue;
                    HashMap batchesForTimeTarg = (HashMap)reducedForST.get(candidate);
                    batchesForTimeTarg.putAll(batchesForTimeSrc);
                    transferred = true;
                    break;
                }
                if (transferred) continue;
                reducedForST.put(time, batchesForTimeSrc);
            }
            tipData.put(stKey, reducedForST);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        tdit = tipData.keySet().iterator();
        while (tdit.hasNext()) {
            SrcTarg stKey = (SrcTarg)tdit.next();
            buf.append(stKey.srcID);
            buf.append(": ");
            buf.append(this.getTarget(stKey.targID));
            buf.append("<br>");
            TreeMap dataForST = (TreeMap)tipData.get(stKey);
            Iterator dfstit = dataForST.keySet().iterator();
            while (dfstit.hasNext()) {
                time = (MinMax)dfstit.next();
                buf.append("&nbsp;&nbsp;");
                buf.append(Experiment.getTimeDisplayString(time, true, true));
                buf.append(": ");
                HashMap batchesForTime = (HashMap)dataForST.get(time);
                Iterator bftit = batchesForTime.keySet().iterator();
                while (bftit.hasNext()) {
                    String batchKey = (String)bftit.next();
                    ArrayList dataForBatch = (ArrayList)batchesForTime.get(batchKey);
                    Iterator dfbit = dataForBatch.iterator();
                    while (dfbit.hasNext()) {
                        String dataStr = (String)dfbit.next();
                        buf.append(dataStr);
                        if (!dfbit.hasNext()) continue;
                        buf.append(",");
                    }
                    if (!bftit.hasNext()) continue;
                    buf.append("/");
                }
                buf.append("<br>");
            }
        }
        buf.append("</html>");
        return buf.toString();
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        TreeSet dpKeys;
        TreeSet rrKeys;
        TreeSet psKeys;
        TreeSet sdKeys;
        TreeSet iKeys;
        TreeSet snKeys;
        TreeSet tKeys;
        ind.indent();
        out.print("<perturbationData");
        if (this.serialNumber_ != 0L) {
            out.print(" serialNum=\"");
            out.print(this.serialNumber_);
            out.print("\"");
        }
        out.println(">");
        ind.up();
        this.pertDict_.writeXML(out, ind);
        this.measureDict_.writeXML(out, ind);
        this.condDict_.writeXML(out, ind);
        if (this.pertAnnot_.haveMessages()) {
            this.pertAnnot_.writeXML(out, ind);
        }
        if (!(tKeys = new TreeSet(this.targets_.keySet())).isEmpty()) {
            ind.indent();
            out.println("<pertTargs>");
            ind.up();
            Iterator tkit = tKeys.iterator();
            while (tkit.hasNext()) {
                String tkey = (String)tkit.next();
                String targ = (String)this.targets_.get(tkey);
                ind.indent();
                out.print("<pertTarg id=\"");
                out.print(tkey);
                out.print("\" name=\"");
                out.print(CharacterEntityMapper.mapEntities(targ, false));
                List notes = this.getFootnotesForTarget(tkey);
                if (notes != null && !notes.isEmpty()) {
                    out.print("\" notes=\"");
                    out.print(Splitter.tokenJoin(notes, ","));
                }
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</pertTargs>");
        }
        if (!(snKeys = new TreeSet(this.sourceNames_.keySet())).isEmpty()) {
            ind.indent();
            out.println("<pertSrcNames>");
            ind.up();
            Iterator tkit = snKeys.iterator();
            while (tkit.hasNext()) {
                String snkey = (String)tkit.next();
                String srcName = (String)this.sourceNames_.get(snkey);
                ind.indent();
                out.print("<pertSrcName id=\"");
                out.print(snkey);
                out.print("\" name=\"");
                out.print(CharacterEntityMapper.mapEntities(srcName, false));
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</pertSrcNames>");
        }
        if (!(iKeys = new TreeSet(this.investigators_.keySet())).isEmpty()) {
            ind.indent();
            out.println("<pertInvests>");
            ind.up();
            Iterator ikit = iKeys.iterator();
            while (ikit.hasNext()) {
                String ikey = (String)ikit.next();
                String invest = (String)this.investigators_.get(ikey);
                ind.indent();
                out.print("<pertInvest id=\"");
                out.print(ikey);
                out.print("\" name=\"");
                out.print(CharacterEntityMapper.mapEntities(invest, false));
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</pertInvests>");
        }
        if (!(sdKeys = new TreeSet(this.sourceDefs_.keySet())).isEmpty()) {
            ind.indent();
            out.println("<pertSourceDefs>");
            ind.up();
            Iterator sdkit = sdKeys.iterator();
            while (sdkit.hasNext()) {
                String sdkey = (String)sdkit.next();
                PertSource psd = (PertSource)this.sourceDefs_.get(sdkey);
                psd.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</pertSourceDefs>");
        }
        if (!(psKeys = new TreeSet(this.experiments_.keySet())).isEmpty()) {
            ind.indent();
            out.println("<experiments>");
            ind.up();
            Iterator pskit = psKeys.iterator();
            while (pskit.hasNext()) {
                String pskey = (String)pskit.next();
                Experiment psi = (Experiment)this.experiments_.get(pskey);
                psi.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</experiments>");
        }
        if (!(rrKeys = new TreeSet(this.regionRestrictions_.keySet())).isEmpty()) {
            ind.indent();
            out.println("<regRestricts>");
            ind.up();
            Iterator rrkit = rrKeys.iterator();
            while (rrkit.hasNext()) {
                String rrkey = (String)rrkit.next();
                RegionRestrict rr = (RegionRestrict)this.regionRestrictions_.get(rrkey);
                rr.writeXML(out, ind, rrkey);
            }
            ind.down().indent();
            out.println("</regRestricts>");
        }
        if (!this.userFields_.isEmpty()) {
            ind.indent();
            out.println("<userFields>");
            ind.up();
            Iterator ufit = this.userFields_.iterator();
            while (ufit.hasNext()) {
                String fieldName = (String)ufit.next();
                ind.indent();
                out.print("<userField name=\"");
                out.print(CharacterEntityMapper.mapEntities(fieldName, false));
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</userFields>");
            TreeSet edKeys = new TreeSet(this.userData_.keySet());
            if (!edKeys.isEmpty()) {
                ind.indent();
                out.println("<userDataVals>");
                ind.up();
                Iterator edkit = edKeys.iterator();
                while (edkit.hasNext()) {
                    String udfkey = (String)edkit.next();
                    ArrayList udf = (ArrayList)this.userData_.get(udfkey);
                    this.writeXMLForUserData(out, ind, udf, udfkey);
                }
                ind.down().indent();
                out.println("</userDataVals>");
            }
        }
        if (!(dpKeys = new TreeSet(this.dataPoints_.keySet())).isEmpty()) {
            ind.indent();
            out.println("<dataPoints>");
            ind.up();
            Iterator dpkit = dpKeys.iterator();
            while (dpkit.hasNext()) {
                String dpkey = (String)dpkit.next();
                PertDataPoint pdp = (PertDataPoint)this.dataPoints_.get(dpkey);
                pdp.writeXML(out, ind, this);
            }
            ind.down().indent();
            out.println("</dataPoints>");
        }
        boolean doEntry = this.entryMap_.haveData();
        boolean doSrc = this.sourceMap_.haveData();
        if (doEntry || doSrc) {
            ind.indent();
            out.println("<pertDataMaps>");
            ind.up();
            if (doEntry) {
                this.entryMap_.writeXML(out, ind);
            }
            if (doSrc) {
                this.sourceMap_.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</pertDataMaps>");
        }
        ind.down().indent();
        out.println("</perturbationData>");
    }

    public void writeXMLForUserData(PrintWriter out, Indenter ind, List udf, String udfkey) {
        ind.indent();
        out.print("<userData key=\"");
        out.print(udfkey);
        out.print("\"");
        int numUDF = udf.size();
        for (int i = 0; i < numUDF; ++i) {
            String datVal = (String)udf.get(i);
            if (datVal.trim().equals("")) continue;
            out.print(" f");
            out.print(i);
            out.print("=\"");
            out.print(CharacterEntityMapper.mapEntities(datVal, false));
            out.print("\"");
        }
        out.println("/>");
    }

    public static String getTimeDisplay(Integer timeObj, boolean showUnits, boolean abbreviate) {
        String timeStr;
        if (timeObj == null) {
            return null;
        }
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        if (tad.haveNamedStages()) {
            int timeNum = timeObj;
            TimeAxisDefinition.NamedStage stage = tad.getNamedStageForIndex(timeNum);
            timeStr = abbreviate ? stage.abbrev : stage.name;
        } else {
            timeStr = timeObj.toString();
        }
        if (!showUnits) {
            return timeStr;
        }
        String displayUnitAbbrev = tad.unitDisplayAbbrev();
        StringBuffer buf = new StringBuffer();
        if (tad.unitsAreASuffix()) {
            buf.append(timeStr);
            buf.append(" ");
            buf.append(displayUnitAbbrev);
        } else {
            buf.append(displayUnitAbbrev);
            buf.append(" ");
            buf.append(timeStr);
        }
        return buf.toString();
    }

    private Set buildFullInteractionNetwork(int collapseMode) {
        HashMap<SrcTarg, Integer> resultMap = new HashMap<SrcTarg, Integer>();
        Map[] collapseMaps = this.buildCollapseMaps();
        List sigPerts = this.getSignificantPerturbations();
        int numSig = sigPerts.size();
        for (int i = 0; i < numSig; ++i) {
            PertDataPoint pdp = (PertDataPoint)sigPerts.get(i);
            int linkSign = pdp.getLink(this);
            if (linkSign == 3) continue;
            int stSign = this.mapDataSignToSignTag(linkSign);
            Experiment psi = pdp.getExperiment(this);
            Iterator sit = psi.getSources().getSources();
            while (sit.hasNext()) {
                String srcID = (String)sit.next();
                PertSource src = this.getSourceDef(srcID);
                SrcTarg stk = new SrcTarg(src.getSourceNameKey(), pdp.getTargetKey());
                Integer vals = (Integer)resultMap.get(stk);
                vals = vals == null ? new Integer(stSign) : new Integer(vals | stSign);
                resultMap.put(stk, vals);
            }
        }
        HashSet retval = new HashSet();
        Iterator rmit = resultMap.keySet().iterator();
        while (rmit.hasNext()) {
            SrcTarg stk = (SrcTarg)rmit.next();
            Integer vals = (Integer)resultMap.get(stk);
            this.collapseToCandidates(collapseMode, collapseMaps, stk, vals, retval);
        }
        return retval;
    }

    private int mapDataSignToSignTag(int sign) {
        switch (sign) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 4;
            }
        }
        throw new IllegalStateException();
    }

    private void collapseToCandidates(int collapseMode, Map[] maps, SrcTarg stk, Integer vals, Set retval) {
        Map collapse = maps[collapseMode];
        int result = (Integer)collapse.get(vals);
        if ((result & 1) != 0) {
            retval.add(new LinkCandidate(stk.srcID, stk.targID, 1));
        }
        if ((result & 2) != 0) {
            retval.add(new LinkCandidate(stk.srcID, stk.targID, -1));
        }
        if ((result & 4) != 0) {
            retval.add(new LinkCandidate(stk.srcID, stk.targID, 0));
        }
    }

    private Map[] buildCollapseMaps() {
        HashMap<Integer, Integer> noCollapse = new HashMap<Integer, Integer>();
        noCollapse.put(new Integer(0), new Integer(0));
        noCollapse.put(new Integer(1), new Integer(1));
        noCollapse.put(new Integer(2), new Integer(2));
        noCollapse.put(new Integer(4), new Integer(4));
        noCollapse.put(new Integer(3), new Integer(3));
        noCollapse.put(new Integer(5), new Integer(5));
        noCollapse.put(new Integer(6), new Integer(6));
        noCollapse.put(new Integer(7), new Integer(7));
        HashMap<Integer, Integer> distinctPM = new HashMap<Integer, Integer>();
        distinctPM.put(new Integer(0), new Integer(0));
        distinctPM.put(new Integer(1), new Integer(1));
        distinctPM.put(new Integer(2), new Integer(2));
        distinctPM.put(new Integer(4), new Integer(4));
        distinctPM.put(new Integer(3), new Integer(3));
        distinctPM.put(new Integer(5), new Integer(1));
        distinctPM.put(new Integer(6), new Integer(2));
        distinctPM.put(new Integer(7), new Integer(3));
        HashMap<Integer, Integer> dropSign = new HashMap<Integer, Integer>();
        dropSign.put(new Integer(0), new Integer(0));
        dropSign.put(new Integer(1), new Integer(1));
        dropSign.put(new Integer(2), new Integer(2));
        dropSign.put(new Integer(4), new Integer(4));
        dropSign.put(new Integer(3), new Integer(4));
        dropSign.put(new Integer(5), new Integer(4));
        dropSign.put(new Integer(6), new Integer(4));
        dropSign.put(new Integer(7), new Integer(4));
        HashMap<Integer, Integer> keepSign = new HashMap<Integer, Integer>();
        keepSign.put(new Integer(0), new Integer(0));
        keepSign.put(new Integer(1), new Integer(1));
        keepSign.put(new Integer(2), new Integer(2));
        keepSign.put(new Integer(4), new Integer(4));
        keepSign.put(new Integer(3), new Integer(4));
        keepSign.put(new Integer(5), new Integer(1));
        keepSign.put(new Integer(6), new Integer(2));
        keepSign.put(new Integer(7), new Integer(4));
        Map[] retval = new HashMap[]{noCollapse, distinctPM, dropSign, keepSign};
        return retval;
    }

    public static class SourceInfo
    implements Comparable {
        public String source;
        public int sign;

        public SourceInfo(String source, int sign) {
            this.source = source;
            this.sign = sign;
        }

        public int compareTo(Object o) {
            SourceInfo other = (SourceInfo)o;
            int srcCompare = this.source.compareTo(other.source);
            if (srcCompare != 0) {
                return srcCompare;
            }
            return this.sign - other.sign;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceInfo)) {
                return false;
            }
            SourceInfo other = (SourceInfo)o;
            if (this.sign != other.sign) {
                return false;
            }
            if (this.source == null) {
                return other.source == null;
            }
            return this.source.equals(other.source);
        }

        public int hashCode() {
            return this.source == null ? 0 : this.source.hashCode();
        }
    }

    public static class SNSWorker
    extends AbstractFactoryClient {
        public SNSWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add(PerturbationData.SN_SET_XML_TAG_);
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            if (elemName.equals(PerturbationData.SN_SET_XML_TAG_)) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                String dNum = AttributeExtractor.extractAttribute(elemName, attrs, PerturbationData.SN_SET_XML_TAG_, "dataNum", true);
                String tNum = AttributeExtractor.extractAttribute(elemName, attrs, PerturbationData.SN_SET_XML_TAG_, "targNum", true);
                String sNum = AttributeExtractor.extractAttribute(elemName, attrs, PerturbationData.SN_SET_XML_TAG_, "srcNum", true);
                try {
                    SerialNumberSet sns;
                    long pDataSN = Long.parseLong(dNum);
                    long targMapSN = Long.parseLong(tNum);
                    long srcMapSN = Long.parseLong(sNum);
                    board.sns = sns = new SerialNumberSet(pDataSN, targMapSN, srcMapSN);
                    return sns;
                }
                catch (NumberFormatException nfex) {
                    throw new IOException();
                }
            }
            return null;
        }
    }

    public static class SerialNumberSet
    implements Cloneable {
        public long pDataSN;
        public long targMapSN;
        public long srcMapSN;

        public SerialNumberSet(long pDataSN, long targMapSN, long srcMapSN) {
            this.pDataSN = pDataSN;
            this.targMapSN = targMapSN;
            this.srcMapSN = srcMapSN;
        }

        public Object clone() {
            try {
                return (SerialNumberSet)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SerialNumberSet)) {
                return false;
            }
            SerialNumberSet other = (SerialNumberSet)o;
            if (this.pDataSN != other.pDataSN) {
                return false;
            }
            if (this.targMapSN != other.targMapSN) {
                return false;
            }
            return this.srcMapSN == other.srcMapSN;
        }

        public int hashCode() {
            return (int)(this.pDataSN + this.targMapSN + this.srcMapSN);
        }

        public String getDisplayList() {
            ArrayList<String> currNums = new ArrayList<String>();
            currNums.add(Long.toString(this.pDataSN));
            currNums.add(Long.toString(this.targMapSN));
            currNums.add(Long.toString(this.srcMapSN));
            return UiUtil.getListDisplay(currNums);
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            ind.indent();
            UiUtil.xmlOpen(PerturbationData.SN_SET_XML_TAG_, out, false);
            out.print("dataNum=\"");
            out.print(this.pDataSN);
            out.print("\" targNum=\"");
            out.print(this.targMapSN);
            out.print("\" srcNum=\"");
            out.print(this.srcMapSN);
            out.println("\" />");
        }
    }

    public static class SourceNameWorker
    extends AbstractFactoryClient {
        public SourceNameWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pertSrcName");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            SourceName retval = null;
            if (elemName.equals("pertSrcName")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.srcName = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private SourceName buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "pertSrcName", "id", true);
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "pertSrcName", "name", true);
            name = CharacterEntityMapper.unmapEntities(name, false);
            return new SourceName(id, name);
        }
    }

    public static class SourceName {
        public String id;
        public String name;

        public SourceName(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class InvestWorker
    extends AbstractFactoryClient {
        public InvestWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pertInvest");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Invest retval = null;
            if (elemName.equals("pertInvest")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.invest = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private Invest buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "pertInvest", "id", true);
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "pertInvest", "name", true);
            name = CharacterEntityMapper.unmapEntities(name, false);
            return new Invest(id, name);
        }
    }

    public static class Invest {
        public String id;
        public String name;

        public Invest(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class UserFieldWorker
    extends AbstractFactoryClient {
        public UserFieldWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("userField");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            String retval = null;
            if (elemName.equals("userField")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.userFieldName = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private String buildFromXML(String elemName, Attributes attrs) throws IOException {
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "userField", "name", true);
            name = CharacterEntityMapper.unmapEntities(name, false);
            return name;
        }
    }

    public static class UserDataWorker
    extends AbstractFactoryClient {
        public UserDataWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("userData");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            AugUserData retval = null;
            if (elemName.equals("userData")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.augUserData = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private AugUserData buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "userData", "key", true);
            HashMap<String, String> indexToVal = new HashMap<String, String>();
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null || key.equals("key") || key.indexOf("f") != 0) continue;
                String val = attrs.getValue(i);
                val = CharacterEntityMapper.unmapEntities(val, false);
                String indexStr = key.substring(1);
                indexToVal.put(indexStr, val);
            }
            return new AugUserData(id, indexToVal);
        }
    }

    public static class AugUserData {
        public String key;
        public Map indexToVal;

        public AugUserData(String key, Map indexToVal) {
            this.key = key;
            this.indexToVal = indexToVal;
        }
    }

    public static class TargetWorker
    extends AbstractFactoryClient {
        public TargetWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pertTarg");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            AugTarget retval = null;
            if (elemName.equals("pertTarg")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.augTarg = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private AugTarget buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "pertTarg", "id", true);
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "pertTarg", "name", true);
            name = CharacterEntityMapper.unmapEntities(name, false);
            String notes = AttributeExtractor.extractAttribute(elemName, attrs, "pertTarg", "notes", false);
            ArrayList noteList = null;
            if (notes != null) {
                noteList = Splitter.stringBreak(notes, ",", 0, false);
            }
            return new AugTarget(id, name, noteList);
        }
    }

    public static class AugTarget {
        public String id;
        public String name;
        public List notes;

        public AugTarget(String id, String name, List notes) {
            this.id = id;
            this.name = name;
            this.notes = notes;
        }
    }

    public static class MyRegGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            RegionRestrict rr = board.augRegRes.rr;
            String reg = board.reg;
            try {
                rr.addRegion(reg);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
            return null;
        }
    }

    public static class RegWorker
    extends AbstractFactoryClient {
        public RegWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("reg");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            String retval = null;
            if (elemName.equals("reg")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.reg = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private String buildFromXML(String elemName, Attributes attrs) throws IOException {
            String regName = AttributeExtractor.extractAttribute(elemName, attrs, "reg", "name", true);
            regName = CharacterEntityMapper.unmapEntities(regName, false);
            return regName;
        }
    }

    public static class RegRestrictWorker
    extends AbstractFactoryClient {
        public RegRestrictWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("regRestrict");
            this.installWorker(new RegWorker(whiteboard), new MyRegGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            AugRegRestrict retval = null;
            if (elemName.equals("regRestrict")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.augRegRes = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private AugRegRestrict buildFromXML(String elemName, Attributes attrs) throws IOException {
            RegionRestrict retval;
            String key = AttributeExtractor.extractAttribute(elemName, attrs, "regRestrict", "dpKey", true);
            String val = AttributeExtractor.extractAttribute(elemName, attrs, "regRestrict", "descript", false);
            if (val != null) {
                val = CharacterEntityMapper.unmapEntities(val, false);
                retval = new RegionRestrict(val);
            } else {
                retval = new RegionRestrict(new ArrayList());
            }
            return new AugRegRestrict(key, retval);
        }
    }

    public static class AugRegRestrict {
        public String key;
        public RegionRestrict rr;

        public AugRegRestrict(String key, RegionRestrict rr) {
            this.key = key;
            this.rr = rr;
        }
    }

    public static class MyUserFieldGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            String fieldName = board.userFieldName;
            board.pertData.addUserFieldNameForIO(fieldName);
            return null;
        }
    }

    public static class MyUserDataGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            AugUserData aug = board.augUserData;
            board.pertData.setUserDataForIO(aug.key, aug.indexToVal);
            return null;
        }
    }

    public static class MyRegResGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            AugRegRestrict at = board.augRegRes;
            board.pertData.setRegionRestrictionForDataPointForIO(at.key, at.rr);
            return null;
        }
    }

    public static class MyMeasureDictionaryGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.measureDict_ = board.mDict;
            return null;
        }
    }

    public static class MyCondDictionaryGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.condDict_ = board.cDict;
            return null;
        }
    }

    public static class MyPertDictionaryGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.pertDict_ = board.pDict;
            return null;
        }
    }

    public static class MyNameMapperGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.installNameMap(board.currPertDataMap);
            return null;
        }
    }

    public static class MyDataGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            PerturbationData pData = board.pertData;
            PertDataPoint.AugPertDataPoint apdp = board.augPertDataPt;
            pData.addDataPointForIO(apdp.pdp);
            if (apdp.notes != null && !apdp.notes.isEmpty()) {
                pData.setFootnotesForDataPointForIO(apdp.pdp.getID(), apdp.notes);
            }
            return null;
        }
    }

    public static class MySourceGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.addPertSrcInfoForIO(board.pertSrcInfo);
            return null;
        }
    }

    public static class MySourceDefGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.addPertSrcDefForIO(board.pertSrc);
            return null;
        }
    }

    public static class MyPertAnnotGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.pertAnnot_ = board.pa;
            return null;
        }
    }

    public static class MyAugTargGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.addTargetForIO(board.augTarg);
            return null;
        }
    }

    public static class MySrcNameGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.addSourceNameForIO(board.srcName);
            return null;
        }
    }

    public static class MyInvestGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.pertData.addInvestForIO(board.invest);
            return null;
        }
    }

    public static class PertDataWorker
    extends AbstractFactoryClient {
        boolean mapsAreIllegal_;
        boolean serialNumberIsIllegal_;

        public PertDataWorker(boolean mapsAreIllegal, boolean serialNumberIsIllegal) {
            super(new FactoryWhiteboard());
            FactoryWhiteboard whiteboard = (FactoryWhiteboard)this.sharedWhiteboard_;
            this.myKeys_.add("perturbationData");
            this.mapsAreIllegal_ = mapsAreIllegal;
            this.serialNumberIsIllegal_ = serialNumberIsIllegal;
            this.installWorker(new PertDictionary.PertDictionaryWorker(whiteboard), new MyPertDictionaryGlue());
            this.installWorker(new MeasureDictionary.MeasureDictionaryWorker(whiteboard), new MyMeasureDictionaryGlue());
            this.installWorker(new ConditionDictionary.ConditionDictionaryWorker(whiteboard), new MyCondDictionaryGlue());
            this.installWorker(new PertAnnotations.PertAnnotationsWorker(whiteboard), new MyPertAnnotGlue());
            this.installWorker(new InvestWorker(whiteboard), new MyInvestGlue());
            this.installWorker(new TargetWorker(whiteboard), new MyAugTargGlue());
            this.installWorker(new SourceNameWorker(whiteboard), new MySrcNameGlue());
            this.installWorker(new PertSource.PertSourceWorker(whiteboard), new MySourceDefGlue());
            this.installWorker(new Experiment.PertSourcesInfoWorker(whiteboard), new MySourceGlue());
            this.installWorker(new PertDataPoint.PertDataPointWorker(whiteboard), new MyDataGlue());
            this.installWorker(new NameMapper.NameMapperWorker(whiteboard), new MyNameMapperGlue());
            this.installWorker(new RegRestrictWorker(whiteboard), new MyRegResGlue());
            this.installWorker(new UserDataWorker(whiteboard), new MyUserDataGlue());
            this.installWorker(new UserFieldWorker(whiteboard), new MyUserFieldGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            PerturbationData retval = null;
            if (elemName.equals("perturbationData")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.pertData = this.buildFromXML(elemName, attrs);
                if (board.pertData != null) {
                    Database db = Database.getDB();
                    db.setPertData(board.pertData);
                }
            }
            return retval;
        }

        private PerturbationData buildFromXML(String elemName, Attributes attrs) throws IOException {
            String serNum = AttributeExtractor.extractAttribute(elemName, attrs, "perturbationData", "serialNum", false);
            if (serNum != null) {
                if (this.serialNumberIsIllegal_) {
                    throw new IOException();
                }
                try {
                    long sNum = Long.parseLong(serNum);
                    return new PerturbationData(sNum);
                }
                catch (NumberFormatException nfex) {
                    throw new IOException();
                }
            }
            return new PerturbationData();
        }
    }

    public static class RegionRestrict
    implements Cloneable {
        private boolean isNullTargetStyle_;
        private String valForNull_;
        private ArrayList valsForRegular_;

        public RegionRestrict(String valForNull) {
            this.isNullTargetStyle_ = true;
            this.valForNull_ = valForNull;
        }

        public RegionRestrict(List valsForRegular) {
            this.isNullTargetStyle_ = false;
            this.valsForRegular_ = new ArrayList(valsForRegular);
        }

        public boolean isLegacyNullStyle() {
            return this.isNullTargetStyle_;
        }

        public String getLegacyValue() {
            if (!this.isNullTargetStyle_) {
                throw new IllegalStateException();
            }
            return this.valForNull_;
        }

        public boolean containsRegionName(Set dropNames) {
            if (this.isNullTargetStyle_) {
                return false;
            }
            int vfrn = this.valsForRegular_.size();
            for (int i = 0; i < vfrn; ++i) {
                String vfr = (String)this.valsForRegular_.get(i);
                if (!DataUtil.containsKey(dropNames, vfr)) continue;
                return true;
            }
            return false;
        }

        public RegionRestrict dropRegionName(String dropName) {
            if (this.isNullTargetStyle_) {
                throw new IllegalStateException();
            }
            ArrayList<String> newVals = new ArrayList<String>();
            boolean dropped = false;
            int vfrn = this.valsForRegular_.size();
            for (int i = 0; i < vfrn; ++i) {
                String vfr = (String)this.valsForRegular_.get(i);
                if (!DataUtil.keysEqual(dropName, vfr)) {
                    newVals.add(vfr);
                    continue;
                }
                dropped = true;
            }
            if (!dropped) {
                throw new IllegalStateException();
            }
            return newVals.isEmpty() ? null : new RegionRestrict(newVals);
        }

        public RegionRestrict changeRegionName(String oldName, String newName) {
            if (this.isNullTargetStyle_) {
                return null;
            }
            ArrayList<String> newVals = new ArrayList<String>();
            boolean changed = false;
            int vfrn = this.valsForRegular_.size();
            for (int i = 0; i < vfrn; ++i) {
                String vfr = (String)this.valsForRegular_.get(i);
                if (DataUtil.keysEqual(oldName, vfr)) {
                    newVals.add(newName);
                    changed = true;
                    continue;
                }
                newVals.add(vfr);
            }
            return changed ? new RegionRestrict(newVals) : null;
        }

        public void addRegion(String reg) {
            if (this.isNullTargetStyle_) {
                throw new IllegalStateException();
            }
            this.valsForRegular_.add(reg);
        }

        public Iterator getRegions() {
            if (this.isNullTargetStyle_) {
                throw new IllegalStateException();
            }
            return this.valsForRegular_.iterator();
        }

        public int numRegions() {
            if (this.isNullTargetStyle_) {
                throw new IllegalStateException();
            }
            return this.valsForRegular_.size();
        }

        public String getDisplayValue() {
            String retval = "";
            if (this.isLegacyNullStyle()) {
                retval = this.getLegacyValue();
            } else {
                StringBuffer buf = new StringBuffer();
                Iterator rrit = this.getRegions();
                while (rrit.hasNext()) {
                    String reg = (String)rrit.next();
                    buf.append(reg);
                    if (!rrit.hasNext()) continue;
                    buf.append(", ");
                }
                retval = buf.toString();
            }
            return retval;
        }

        public Object clone() {
            try {
                RegionRestrict newVal = (RegionRestrict)super.clone();
                if (this.valsForRegular_ != null) {
                    newVal.valsForRegular_ = (ArrayList)this.valsForRegular_.clone();
                }
                return newVal;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public void writeXML(PrintWriter out, Indenter ind, String key) {
            ind.indent();
            out.print("<regRestrict dpKey=\"");
            out.print(key);
            if (this.isNullTargetStyle_) {
                out.print("\" descript=\"");
                out.print(CharacterEntityMapper.mapEntities(this.valForNull_, false));
                out.println("\"/>");
            } else {
                out.println("\">");
                ind.up();
                int numV = this.valsForRegular_.size();
                for (int i = 0; i < numV; ++i) {
                    String val = (String)this.valsForRegular_.get(i);
                    ind.indent();
                    out.print("<reg name=\"");
                    out.print(CharacterEntityMapper.mapEntities(val, false));
                    out.println("\"/>");
                }
                ind.down().indent();
                out.println("</regRestrict>");
            }
        }
    }

    public static class KeyAndDataChange {
        public String key;
        public PertDataChange undoInfo;

        KeyAndDataChange(String key, PertDataChange undoInfo) {
            this.key = key;
            this.undoInfo = undoInfo;
        }
    }

    public static class QpcrSourceSet {
        public String name;
        public int sourceCount;

        public QpcrSourceSet(String name, int sourceCount) {
            this.name = name;
            this.sourceCount = sourceCount;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return DataUtil.normKey(this.name).hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QpcrSourceSet)) {
                return false;
            }
            QpcrSourceSet other = (QpcrSourceSet)o;
            if (this.sourceCount != other.sourceCount) {
                return false;
            }
            if (this.name == null || other.name == null) {
                return this.name == null && other.name == null;
            }
            return DataUtil.normKey(this.name).equals(DataUtil.normKey(other.name));
        }
    }

    private class SrcTarg {
        String srcID;
        String targID;

        SrcTarg(String srcID, String targID) {
            this.srcID = srcID;
            this.targID = targID;
        }

        public String toString() {
            return PerturbationData.this.getSourceName(this.srcID) + " " + PerturbationData.this.getTarget(this.targID);
        }

        public int hashCode() {
            return this.srcID.hashCode() + this.targID.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof SrcTarg)) {
                return false;
            }
            SrcTarg otherST = (SrcTarg)other;
            if (!this.srcID.equals(otherST.srcID)) {
                return false;
            }
            return this.targID.equals(otherST.targID);
        }
    }

    public static class AugmentedQpcrChange {
        public Object other;
        public PertDataChange[] changes;

        public AugmentedQpcrChange(Object other, PertDataChange[] changes) {
            this.other = other;
            this.changes = changes;
        }
    }

    public static class QpcrMapResult {
        public String name;
        public int type;
        public static final int ENTRY_MAP = 0;
        public static final int SOURCE_MAP = 1;

        public QpcrMapResult(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

