/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.systemsbiology.biotapestry.plugin.DataDisplayPlugIn;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.xml.sax.Attributes;

public abstract class AbstractPlugInDirective
implements Comparable {
    public static final int INTERNAL_DATA_DISPLAY = 0;
    public static final int EXTERNAL_DATA_DISPLAY = 1;
    protected int type_;
    protected String className_;
    protected int order_;
    protected File jar_;

    public AbstractPlugInDirective(String type, String className, String order, File jarFile) {
        this.stockCore(type, className, order);
        this.jar_ = jarFile;
    }

    protected AbstractPlugInDirective() {
        this.jar_ = null;
    }

    public int getType() {
        return this.type_;
    }

    public int getOrder() {
        return this.order_;
    }

    public String getClassName() {
        return this.className_;
    }

    public File getJar() {
        return this.jar_;
    }

    public DataDisplayPlugIn buildPlugIn() {
        if (this.jar_ == null) {
            return this.manufacture();
        }
        return this.load();
    }

    public int compareTo(Object o) {
        AbstractPlugInDirective other = (AbstractPlugInDirective)o;
        if (this.order_ != other.order_) {
            return this.order_ > other.order_ ? 1 : -1;
        }
        return this.className_.compareTo(other.className_);
    }

    public abstract String mapToTypeTag(int var1);

    public abstract int mapFromTypeTag(String var1);

    protected void stockCoreFromXML(String elemName, Attributes attrs) throws IOException {
        String typeStr = AttributeExtractor.extractAttribute(elemName, attrs, elemName, "type", true);
        String className = AttributeExtractor.extractAttribute(elemName, attrs, elemName, "class", true);
        String orderStr = AttributeExtractor.extractAttribute(elemName, attrs, elemName, "order", true);
        try {
            this.stockCore(typeStr, className, orderStr);
        }
        catch (IllegalArgumentException iex) {
            throw new IOException();
        }
    }

    private void stockCore(String type, String className, String order) throws IllegalArgumentException {
        this.className_ = className;
        if (type == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.type_ = this.mapFromTypeTag(type);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException();
        }
        try {
            this.order_ = Integer.parseInt(order);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException();
        }
    }

    private DataDisplayPlugIn load() {
        try {
            URL purl = this.jar_.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{purl});
            Class<?> pluggedIn = Class.forName(this.className_, true, loader);
            DataDisplayPlugIn instance = (DataDisplayPlugIn)pluggedIn.newInstance();
            return instance;
        }
        catch (MalformedURLException muex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + muex);
        }
        catch (ClassNotFoundException cnfex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + cnfex);
        }
        catch (InstantiationException iex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + iex);
        }
        catch (IllegalAccessException iex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + iex);
        }
        return null;
    }

    private DataDisplayPlugIn manufacture() {
        try {
            Class<?> plugClass = Class.forName(this.className_);
            DataDisplayPlugIn instance = (DataDisplayPlugIn)plugClass.newInstance();
            return instance;
        }
        catch (ClassNotFoundException cnfex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + cnfex);
        }
        catch (InstantiationException iex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + iex);
        }
        catch (IllegalAccessException iex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + iex);
        }
        return null;
    }
}

