/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.plugin;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.systemsbiology.biotapestry.plugin.LinkPlugInDirective;
import org.systemsbiology.biotapestry.plugin.NodePlugInDirective;
import org.systemsbiology.biotapestry.plugin.PlugInDirective;
import org.systemsbiology.biotapestry.plugin.PlugInManager;
import org.xml.sax.Attributes;

public class PlugInDirectiveFactory
implements ParserClient {
    private Set legacyKeys_ = PlugInDirective.keywordsOfInterest();
    private Set instKeys_ = NodePlugInDirective.keywordsOfInterest();
    private Set linkInstKeys_ = LinkPlugInDirective.keywordsOfInterest();
    private HashSet allKeys_ = new HashSet(this.instKeys_);
    private PlugInManager mgr_;

    public PlugInDirectiveFactory(PlugInManager mgr) {
        this.allKeys_.addAll(this.linkInstKeys_);
        this.allKeys_.addAll(this.legacyKeys_);
        this.mgr_ = mgr;
    }

    public void setContainer(Object container) {
    }

    public boolean finishElement(String elemName) {
        return this.allKeys_.contains(elemName);
    }

    public void processCharacters(char[] chars, int start, int length) {
    }

    public Set keywordsOfInterest() {
        return this.allKeys_;
    }

    public Object processElement(String elemName, Attributes attrs) throws IOException {
        LinkPlugInDirective pid;
        if (this.legacyKeys_.contains(elemName)) {
            PlugInDirective pid2 = PlugInDirective.buildFromXML(elemName, attrs);
            if (pid2 != null) {
                this.mgr_.addDirective(pid2);
                return pid2;
            }
        } else if (this.instKeys_.contains(elemName)) {
            NodePlugInDirective pid3 = NodePlugInDirective.buildFromXML(elemName, attrs);
            if (pid3 != null) {
                this.mgr_.addDirective(pid3);
                return pid3;
            }
        } else if (this.linkInstKeys_.contains(elemName) && (pid = LinkPlugInDirective.buildFromXML(elemName, attrs)) != null) {
            this.mgr_.addLinkDirective(pid);
            return pid;
        }
        return null;
    }
}

