/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.systemsbiology.biotapestry.parser.SUParser;
import org.systemsbiology.biotapestry.plugin.AbstractPlugInDirective;
import org.systemsbiology.biotapestry.plugin.DataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.LinkPlugInDirective;
import org.systemsbiology.biotapestry.plugin.NodePlugInDirective;
import org.systemsbiology.biotapestry.plugin.PlugInDirective;
import org.systemsbiology.biotapestry.plugin.PlugInDirectiveFactory;

public class PlugInManager {
    private static PlugInManager singleton_;
    private ArrayList dataDisplay_ = new ArrayList();
    private ArrayList linkDataDisplay_ = new ArrayList();
    private int maxCount_;
    private int maxLinkCount_;
    private TreeSet directives_;
    private TreeSet linkDirectives_ = new TreeSet();

    public void addDirective(AbstractPlugInDirective dir) {
        this.directives_.add(dir);
        int order = dir.getOrder();
        if (this.maxCount_ < order) {
            this.maxCount_ = order;
        }
    }

    public void addLinkDirective(LinkPlugInDirective dir) {
        this.linkDirectives_.add(dir);
        int order = dir.getOrder();
        if (this.maxLinkCount_ < order) {
            this.maxLinkCount_ = order;
        }
    }

    public Iterator getDataDisplayPlugIns() {
        return this.dataDisplay_.iterator();
    }

    public Iterator getLinkDataDisplayPlugIns() {
        return this.linkDataDisplay_.iterator();
    }

    public boolean loadDataDisplayPlugIns(Map args) {
        if (!this.readPlugInListing()) {
            return false;
        }
        String plugDirStr = (String)args.get("plugInDir");
        if (plugDirStr != null) {
            File plugDirectory = new File(plugDirStr);
            if (!(plugDirectory.exists() && plugDirectory.isDirectory() && plugDirectory.canRead())) {
                return false;
            }
            if (!this.readJarFiles(plugDirectory, this.maxCount_ + 1, this.maxLinkCount_ + 1)) {
                return false;
            }
        }
        Iterator drit = this.directives_.iterator();
        while (drit.hasNext()) {
            AbstractPlugInDirective pid = (AbstractPlugInDirective)drit.next();
            DataDisplayPlugIn pi = pid.buildPlugIn();
            if (pi == null) continue;
            this.dataDisplay_.add(pi);
        }
        Iterator ldrit = this.linkDirectives_.iterator();
        while (ldrit.hasNext()) {
            LinkPlugInDirective pid = (LinkPlugInDirective)ldrit.next();
            DataDisplayPlugIn pi = pid.buildPlugIn();
            if (pi == null) continue;
            this.linkDataDisplay_.add(pi);
        }
        return true;
    }

    public static synchronized PlugInManager getMgr() {
        if (singleton_ == null) {
            singleton_ = new PlugInManager();
        }
        return singleton_;
    }

    private PlugInManager() {
        this.directives_ = new TreeSet();
        this.maxCount_ = Integer.MIN_VALUE;
        this.maxLinkCount_ = Integer.MIN_VALUE;
    }

    private boolean readJarFiles(File plugInDir, int currMax, int currLinkMax) {
        try {
            ExtensionFilter filter = new ExtensionFilter(".jar");
            if (plugInDir.isDirectory()) {
                File[] files = plugInDir.listFiles(filter);
                for (int i = 0; i < files.length; ++i) {
                    AbstractPlugInDirective pid;
                    String plugin;
                    int j;
                    JarFile jar = new JarFile(files[i]);
                    List sl = this.getServiceList(jar, "org.systemsbiology.biotapestry.plugin.ExternalDataDisplayPlugIn");
                    int numSvc = sl.size();
                    for (j = 0; j < numSvc; ++j) {
                        plugin = (String)sl.get(j);
                        pid = new PlugInDirective("ExternalDataDisplay", plugin, Integer.toString(currMax++), files[i]);
                        this.addDirective(pid);
                    }
                    sl = this.getServiceList(jar, "org.systemsbiology.biotapestry.plugin.InternalDataDisplayPlugIn");
                    numSvc = sl.size();
                    for (j = 0; j < numSvc; ++j) {
                        plugin = (String)sl.get(j);
                        pid = new PlugInDirective("InternalDataDisplay", plugin, Integer.toString(currMax++), files[i]);
                        this.addDirective(pid);
                    }
                    sl = this.getServiceList(jar, "org.systemsbiology.biotapestry.plugin.ExternalNodeDataDisplayPlugIn");
                    numSvc = sl.size();
                    for (j = 0; j < numSvc; ++j) {
                        plugin = (String)sl.get(j);
                        pid = new NodePlugInDirective("ExternalNodeDataDisplay", plugin, Integer.toString(currMax++), files[i]);
                        this.addDirective(pid);
                    }
                    sl = this.getServiceList(jar, "org.systemsbiology.biotapestry.plugin.InternalNodeDataDisplayPlugIn");
                    numSvc = sl.size();
                    for (j = 0; j < numSvc; ++j) {
                        plugin = (String)sl.get(j);
                        pid = new NodePlugInDirective("InternalNodeDataDisplay", plugin, Integer.toString(currMax++), files[i]);
                        this.addDirective(pid);
                    }
                    sl = this.getServiceList(jar, "org.systemsbiology.biotapestry.plugin.ExternalLinkDataDisplayPlugIn");
                    numSvc = sl.size();
                    for (j = 0; j < numSvc; ++j) {
                        plugin = (String)sl.get(j);
                        pid = new LinkPlugInDirective("ExternalLinkDataDisplay", plugin, Integer.toString(currLinkMax++), files[i]);
                        this.addLinkDirective((LinkPlugInDirective)pid);
                    }
                    sl = this.getServiceList(jar, "org.systemsbiology.biotapestry.plugin.InternalLinkDataDisplayPlugIn");
                    numSvc = sl.size();
                    for (j = 0; j < numSvc; ++j) {
                        plugin = (String)sl.get(j);
                        pid = new LinkPlugInDirective("InternalLinkDataDisplay", plugin, Integer.toString(currLinkMax++), files[i]);
                        this.addLinkDirective((LinkPlugInDirective)pid);
                    }
                }
            }
        }
        catch (IOException ioex) {
            return false;
        }
        return true;
    }

    private List getServiceList(JarFile jar, String svcInterface) throws IOException {
        svcInterface = "META-INF/services/" + svcInterface;
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.equals(svcInterface)) continue;
            return this.readClassList(jar, entry);
        }
        return new ArrayList();
    }

    private List readClassList(JarFile jar, JarEntry entry) throws IOException {
        String newLine;
        ArrayList<String> retval = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(jar.getInputStream(entry)));
        while ((newLine = in.readLine()) != null) {
            if ((newLine = newLine.trim()).equals("") || newLine.startsWith("#")) continue;
            retval.add(newLine);
        }
        in.close();
        return retval;
    }

    private boolean readPlugInListing() {
        URL url = this.getClass().getResource("/org/systemsbiology/biotapestry/plugin/plugInListing.xml");
        if (url == null) {
            System.err.println("No plugIn directives file found");
            return false;
        }
        ArrayList<PlugInDirectiveFactory> alist = new ArrayList<PlugInDirectiveFactory>();
        alist.add(new PlugInDirectiveFactory(this));
        SUParser sup = new SUParser(alist);
        try {
            sup.parse(url);
        }
        catch (IOException ioe) {
            System.err.println("Could not read plugIn directives file");
            return false;
        }
        return true;
    }

    class ExtensionFilter
    implements FileFilter {
        private String suffix_;

        ExtensionFilter(String suffix) {
            this.suffix_ = suffix;
        }

        private boolean hasSuffix(String fileName, String suffix) {
            int sufl;
            int fnl = fileName.length();
            return fnl > (sufl = suffix.length()) && fileName.toLowerCase().lastIndexOf(suffix.toLowerCase()) == fnl - sufl;
        }

        public boolean accept(File f) {
            String fileName = f.getName();
            return this.hasSuffix(fileName, this.suffix_);
        }
    }
}

