/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.qpcr.Measurement;
import org.systemsbiology.biotapestry.qpcr.QpcrTablePublisher;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

class Batch
implements Cloneable {
    static final int NO_TIME = -1;
    private ArrayList measurements_;
    private int time_;
    private String date_;
    private String invest_;
    private String batchKey_;

    Batch() {
        this.measurements_ = new ArrayList();
        this.time_ = -1;
        this.date_ = null;
        this.invest_ = null;
        this.batchKey_ = null;
    }

    Batch(int time, String date, String invest) {
        this.measurements_ = new ArrayList();
        this.time_ = time;
        this.date_ = date;
        this.invest_ = invest;
        this.batchKey_ = null;
    }

    Batch(int time, String date, String invest, String batchKey) {
        this.measurements_ = new ArrayList();
        this.time_ = time;
        this.date_ = date;
        this.invest_ = invest;
        this.batchKey_ = batchKey;
    }

    Batch(Batch other) {
        this.restore(other);
    }

    public Object clone() {
        try {
            Batch newVal = (Batch)super.clone();
            newVal.measurements_ = new ArrayList();
            Iterator omit = this.measurements_.iterator();
            while (omit.hasNext()) {
                newVal.measurements_.add(((Measurement)omit.next()).clone());
            }
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    void restore(Batch other) {
        this.measurements_ = new ArrayList();
        this.time_ = other.time_;
        this.date_ = other.date_;
        this.invest_ = other.invest_;
        this.batchKey_ = other.batchKey_;
        Iterator omit = other.measurements_.iterator();
        while (omit.hasNext()) {
            this.measurements_.add(new Measurement((Measurement)omit.next()));
        }
    }

    void addMeasurement(Measurement meas) {
        this.measurements_.add(meas);
    }

    Iterator getMeasurements() {
        return this.measurements_.iterator();
    }

    int getMeasurementCount() {
        return this.measurements_.size();
    }

    void dropMeasurements() {
        this.measurements_.clear();
    }

    void setDate(String date) {
        this.date_ = date;
    }

    void setTime(int time) {
        this.time_ = time;
    }

    void setInvestigators(String invest) {
        this.invest_ = invest;
    }

    String getDate() {
        return this.date_;
    }

    int getTimeNumber() {
        return this.time_;
    }

    String getTimeString() {
        if (this.time_ == -1) {
            return null;
        }
        return TimeAxisDefinition.getTimeDisplay(new Integer(this.time_), false, false);
    }

    String getBatchKey() {
        return this.batchKey_;
    }

    void setBatchKey(String key) {
        this.batchKey_ = key;
    }

    String getInvestigators() {
        return this.invest_;
    }

    Set getFootnoteNumbers() {
        HashSet retval = new HashSet();
        Iterator ms = this.getMeasurements();
        while (ms.hasNext()) {
            Measurement m = (Measurement)ms.next();
            List mNotes = m.getFootnoteNumbers();
            retval.addAll(mNotes);
        }
        return retval;
    }

    void writeHTML(PrintWriter out, Indenter ind, QpcrTablePublisher qtp, Integer batchTime) {
        Iterator mit = this.getMeasurements();
        while (mit.hasNext()) {
            Measurement m = (Measurement)mit.next();
            m.writeHTML(out, ind, qtp, batchTime);
            if (!mit.hasNext()) continue;
            out.print(",");
            qtp.breakSpace();
        }
    }

    void getNonStandardTimes(Set nonStd, int stdMin, int stdMax) {
        Iterator ms = this.getMeasurements();
        while (ms.hasNext()) {
            Measurement m = (Measurement)ms.next();
            if (!m.isNonStandardTime(stdMin, stdMax)) continue;
            nonStd.add(m.getTime());
        }
    }

    boolean hasStandardTime(int stdMin, int stdMax) {
        Iterator ms = this.getMeasurements();
        while (ms.hasNext()) {
            Measurement m = (Measurement)ms.next();
            if (m.isNonStandardTime(stdMin, stdMax)) continue;
            return true;
        }
        return false;
    }

    static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("batch");
        retval.add("nullBatch");
        return retval;
    }

    public String toString() {
        return "Batch: measurements = " + this.measurements_;
    }

    static boolean isForNull(String elemName) {
        return elemName.equals("nullBatch");
    }

    static Batch buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("batch") && !elemName.equals("nullBatch")) {
            return null;
        }
        String time = null;
        String date = null;
        String invest = null;
        String batchKey = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("time")) {
                    time = val;
                    continue;
                }
                if (key.equals("date")) {
                    date = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("invest")) {
                    invest = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (!key.equals("key")) continue;
                batchKey = CharacterEntityMapper.unmapEntities(val, false);
            }
        }
        int timeVal = -1;
        if (time != null) {
            try {
                timeVal = Integer.parseInt(time);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        if (timeVal != -1 || date != null || invest != null || batchKey != null) {
            return new Batch(timeVal, date, invest, batchKey);
        }
        return new Batch();
    }
}

