/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.biotapestry.qpcr.QpcrTablePublisher;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.Splitter;
import org.xml.sax.Attributes;

class Footnote {
    private String number_;
    private String body_;

    Footnote(String number) {
        this.number_ = number;
    }

    Footnote(Footnote other) {
        this.number_ = other.number_;
        this.body_ = other.body_;
    }

    String getNumber() {
        return this.number_;
    }

    String getNote() {
        return this.body_;
    }

    void setNote(String note) {
        this.body_ = note;
    }

    void writeHTML(PrintWriter out, Indenter ind, QpcrTablePublisher qtp) {
        ind.indent();
        qtp.paragraph(false);
        out.print("<sup>");
        out.print(this.number_);
        out.print("</sup>");
        out.print(this.body_);
        out.println("</p>");
    }

    static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("footnote");
        return retval;
    }

    public String toString() {
        return "Footnote: number = " + this.number_ + " note = " + this.body_;
    }

    static Footnote buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("footnote")) {
            return null;
        }
        String number = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (!key.equals("number")) continue;
                number = val;
            }
        }
        if (number == null) {
            throw new IOException();
        }
        return new Footnote(number);
    }

    static boolean isValidList(String list) {
        Pattern plus = Pattern.compile("([ ]*[\\w\\*]+[ ]*,)*[ ]*[\\w\\*]+");
        Matcher m = plus.matcher(list);
        return m.matches();
    }

    static boolean isValidID(String id) {
        Pattern plus = Pattern.compile("[\\w\\*]+");
        Matcher m = plus.matcher(id.trim());
        return m.matches();
    }

    static List extractNotes(String list) {
        if (!Footnote.isValidList(list)) {
            throw new IllegalArgumentException();
        }
        return Splitter.stringBreak(list, ",", 0, true);
    }
}

