/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.qpcr.QpcrTablePublisher;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.Splitter;
import org.xml.sax.Attributes;

class Measurement
implements Cloneable {
    static final int ZERO = 0;
    static final int PLUS = 1;
    static final int MINUS = 2;
    static final int UNKNOWN = 3;
    static final int UNSIGNED_LINK = 0;
    static final int REPRESS_LINK = 1;
    static final int PROMOTE_LINK = 2;
    static final int NO_LINK = 3;
    private String value_;
    private Integer time_;
    private Integer nonStdMaxTime_;
    private String notes_;
    private String control_;
    private Boolean isSignificant_;
    private String comments_;
    private String colorDisplay_;

    Measurement(String value, String time, String notes, String control, Boolean isSig, String comments) {
        this.value_ = value == null ? null : value.trim().toUpperCase();
        this.time_ = Measurement.timeConversion(time);
        this.nonStdMaxTime_ = null;
        this.notes_ = notes;
        this.control_ = control;
        this.isSignificant_ = isSig;
        this.comments_ = comments;
    }

    Measurement(Measurement other) {
        this.value_ = other.value_;
        this.time_ = other.time_;
        this.nonStdMaxTime_ = other.nonStdMaxTime_;
        this.notes_ = other.notes_;
        this.control_ = other.control_;
        this.isSignificant_ = other.isSignificant_;
        this.comments_ = other.comments_;
    }

    void setNonStdMaxTime(String nonStdMax) {
        this.nonStdMaxTime_ = Measurement.timeConversion(nonStdMax);
    }

    void setColorDisplay(String colorTag) {
        this.colorDisplay_ = colorTag;
    }

    public Object clone() {
        try {
            Measurement newVal = (Measurement)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    boolean isNonStandardTime(int stdMin, int stdMax) {
        if (this.time_ == null) {
            return false;
        }
        int hrVal = this.time_;
        if (this.nonStdMaxTime_ == null) {
            return hrVal < stdMin || hrVal > stdMax;
        }
        int maxTimeVal = this.nonStdMaxTime_;
        return hrVal != stdMin && maxTimeVal != stdMax;
    }

    String getValue() {
        return this.value_;
    }

    Boolean getIsSignificant() {
        return this.isSignificant_;
    }

    String getControl() {
        return this.control_;
    }

    String getComment() {
        return this.comments_;
    }

    Integer getTime() {
        return this.time_;
    }

    String getNotes() {
        return this.notes_;
    }

    List getFootnoteNumbers() {
        if (this.notes_ != null) {
            return Splitter.stringBreak(this.notes_, ",", 0, true);
        }
        return new ArrayList();
    }

    void writeHTML(PrintWriter out, Indenter ind, QpcrTablePublisher qtp, Integer batchTime) {
        boolean closeColor = false;
        if (this.colorDisplay_ != null && !this.colorDisplay_.equalsIgnoreCase("black")) {
            qtp.openColor(this.colorDisplay_);
            closeColor = true;
        }
        qtp.valueSignPrefix(this.value_);
        out.print(this.value_);
        if (closeColor) {
            qtp.closeColor();
        }
        if (this.notes_ != null) {
            out.print("<sup>");
            out.print(this.notes_);
            out.print("</sup>");
        }
        if (!(this.time_ == null || batchTime != null && batchTime.equals(this.time_))) {
            out.print(" (");
            out.print(this.getTimeDisplay(true, true));
            out.print(")");
        }
    }

    String getTimeDisplay(boolean showUnits, boolean abbreviate) {
        if (this.time_ == null) {
            return null;
        }
        String minDisp = TimeAxisDefinition.getTimeDisplay(this.time_, showUnits, abbreviate);
        if (this.nonStdMaxTime_ == null) {
            return minDisp;
        }
        String maxDisp = TimeAxisDefinition.getTimeDisplay(this.nonStdMaxTime_, showUnits, abbreviate);
        return minDisp + "-" + maxDisp;
    }

    public String toString() {
        return "Measurement: value = " + this.value_ + " time = " + this.time_ + " notes = " + this.notes_;
    }

    static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("measurement");
        retval.add("nullMeasurement");
        return retval;
    }

    static Measurement buildFromXML(String elemName, Attributes attrs, double legacyThresh) throws IOException {
        if (!elemName.equals("measurement") && !elemName.equals("nullMeasurement")) {
            return null;
        }
        String value = null;
        String time = null;
        String notes = null;
        String control = null;
        String isSigString = null;
        String comments = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("value")) {
                    value = val;
                    continue;
                }
                if (key.equals("time")) {
                    time = val;
                    continue;
                }
                if (key.equals("notes")) {
                    notes = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("control")) {
                    control = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("isSig")) {
                    isSigString = val;
                    continue;
                }
                if (!key.equals("comment")) continue;
                comments = CharacterEntityMapper.unmapEntities(val, false);
            }
        }
        if (value == null) {
            throw new IOException();
        }
        if (!Measurement.isValidMeasurement(value)) {
            throw new IOException();
        }
        if (!Measurement.isValidTime(time)) {
            throw new IOException();
        }
        legacyThresh = Math.abs(legacyThresh);
        Boolean isSig = isSigString != null ? Boolean.valueOf(isSigString) : new Boolean(!Measurement.isBelowThreshold(value, null, -legacyThresh, legacyThresh));
        return new Measurement(value, time, notes, control, isSig, comments);
    }

    static boolean isValidMeasurement(String input) {
        if (input == null) {
            return false;
        }
        if ((input = input.trim()).equals("")) {
            return false;
        }
        if (input.toUpperCase().equals("NS")) {
            return true;
        }
        if (Measurement.isValidForMissingData(input)) {
            return true;
        }
        try {
            Double.parseDouble(input);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    static boolean isValidTime(String input) {
        if (input == null) {
            return true;
        }
        if ((input = input.trim()).equals("")) {
            return true;
        }
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        if (tad.haveNamedStages()) {
            int stageNum = tad.getIndexForNamedStage(input);
            return stageNum != -1;
        }
        try {
            Integer.parseInt(input);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    static Integer timeConversion(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).equals("")) {
            return null;
        }
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        if (tad.haveNamedStages()) {
            int stageNum = tad.getIndexForNamedStage(input);
            if (stageNum == -1) {
                throw new IllegalArgumentException();
            }
            return new Integer(stageNum);
        }
        try {
            return Integer.decode(input);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    static boolean isValidForMissingData(String val) {
        if (val == null) {
            return false;
        }
        val = val.trim();
        int len = val.length();
        for (int i = 0; i < len; ++i) {
            if (val.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    static boolean isBelowThreshold(String val, Boolean sigTag, double negThresh, double posThresh) {
        if (val == null) {
            return false;
        }
        String trim = val.trim();
        if (trim.equalsIgnoreCase("NS")) {
            return true;
        }
        if (Measurement.isValidForMissingData(trim)) {
            return false;
        }
        if (sigTag != null) {
            return sigTag == false;
        }
        double doubVal = 0.0;
        try {
            doubVal = Double.parseDouble(trim);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException();
        }
        if (doubVal < 0.0) {
            return doubVal > negThresh;
        }
        return doubVal < posThresh;
    }

    static Boolean convertSigInput(String isValid) {
        if (isValid != null) {
            if ((isValid = isValid.trim()).equalsIgnoreCase("YES") || isValid.equalsIgnoreCase("Y")) {
                return new Boolean(true);
            }
            if (!isValid.equals("")) {
                return new Boolean(false);
            }
            return null;
        }
        return null;
    }

    static boolean sigCSVInputOK(String isValid) {
        String string = isValid = isValid == null ? "" : isValid.trim();
        return isValid.equals("") || isValid.equalsIgnoreCase("YES") || isValid.equalsIgnoreCase("Y") || isValid.equalsIgnoreCase("NO") || isValid.equalsIgnoreCase("N") || isValid.equalsIgnoreCase("NS");
    }
}

