/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.qpcr.NullTarget;
import org.systemsbiology.biotapestry.qpcr.NullTimeSpan;
import org.systemsbiology.biotapestry.qpcr.QPCRData;
import org.systemsbiology.biotapestry.qpcr.QpcrTablePublisher;
import org.systemsbiology.biotapestry.qpcr.Source;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

class NullPerturb
implements Cloneable {
    private ArrayList sources_;
    private ArrayList targets_;
    private TreeSet investigators_;

    NullPerturb() {
        this.sources_ = new ArrayList();
        this.targets_ = new ArrayList();
        this.investigators_ = new TreeSet();
    }

    NullPerturb(List sources) {
        this.sources_ = new ArrayList();
        int num = sources.size();
        for (int i = 0; i < num; ++i) {
            this.sources_.add(((Source)sources.get(i)).clone());
        }
        this.targets_ = new ArrayList();
        this.investigators_ = new TreeSet();
    }

    NullPerturb(NullPerturb other) {
        this.mergeInNewValues(other);
    }

    boolean sourcesContainOneOrMore(List otherSources) {
        if (otherSources != null) {
            Iterator srcIt = this.sources_.iterator();
            while (srcIt.hasNext()) {
                Source src = (Source)srcIt.next();
                if (!DataUtil.containsKey(otherSources, src.getBaseType())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    boolean sourcesMatch(List otherSources) {
        if (otherSources.size() != this.sources_.size()) {
            return false;
        }
        QPCRData.SourceComparator srcCmp = new QPCRData.SourceComparator();
        TreeSet mySorted = new TreeSet(srcCmp);
        mySorted.addAll(this.sources_);
        TreeSet otherSorted = new TreeSet(srcCmp);
        otherSorted.addAll(otherSources);
        Iterator msit = mySorted.iterator();
        Iterator osit = otherSorted.iterator();
        while (msit.hasNext()) {
            Source os;
            Source ms = (Source)msit.next();
            if (srcCmp.compare(ms, os = (Source)osit.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            NullPerturb newVal = (NullPerturb)super.clone();
            newVal.sources_ = new ArrayList();
            Iterator osit = this.sources_.iterator();
            while (osit.hasNext()) {
                newVal.sources_.add(((Source)osit.next()).clone());
            }
            newVal.targets_ = new ArrayList();
            Iterator otit = this.targets_.iterator();
            while (otit.hasNext()) {
                newVal.targets_.add(((NullTarget)otit.next()).clone());
            }
            newVal.investigators_ = new TreeSet(this.investigators_);
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    void updateDataRange(NullTimeSpan defaultSpan, int[] range) {
        int size = this.targets_.size();
        for (int i = 0; i < size; ++i) {
            NullTarget targ = (NullTarget)this.targets_.get(i);
            targ.updateDataRange(defaultSpan, range);
        }
    }

    void mergeInNewValues(NullPerturb other) {
        this.sources_ = new ArrayList();
        Iterator osit = other.sources_.iterator();
        while (osit.hasNext()) {
            this.sources_.add(((Source)osit.next()).clone());
        }
        this.targets_ = new ArrayList();
        Iterator otit = other.targets_.iterator();
        while (otit.hasNext()) {
            this.targets_.add(((NullTarget)otit.next()).clone());
        }
        this.investigators_ = new TreeSet(other.investigators_);
    }

    Iterator getSources() {
        return this.sources_.iterator();
    }

    Iterator getTargets() {
        return this.targets_.iterator();
    }

    void addSource(Source source) {
        this.sources_.add(source);
    }

    void deleteSource(int index) {
        this.sources_.remove(index);
    }

    Source getSource(int index) {
        return (Source)this.sources_.get(index);
    }

    int getSourceCount() {
        return this.sources_.size();
    }

    void replaceSource(int index, Source source) {
        this.sources_.set(index, source);
    }

    void addTarget(NullTarget target) {
        this.targets_.add(target);
    }

    void deleteTarget(int index) {
        this.targets_.remove(index);
    }

    NullTarget getTarget(int index) {
        return (NullTarget)this.targets_.get(index);
    }

    Set getFootnoteNumbers() {
        HashSet retval = new HashSet();
        Iterator pers = this.getSources();
        while (pers.hasNext()) {
            Source src = (Source)pers.next();
            List notes = src.getFootnoteNumbers();
            retval.addAll(notes);
        }
        Iterator pert = this.getTargets();
        while (pert.hasNext()) {
            NullTarget nt = (NullTarget)pert.next();
            List notes = nt.getFootnoteNumbers();
            retval.addAll(notes);
        }
        return retval;
    }

    void setNote(String note, QPCRData qpcr) throws IOException {
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        if (tad.getUnits() != 2) {
            throw new IOException();
        }
        this.convertNoteToTargets(note, this.targets_, qpcr.getLegacyNullPerturbationsDefaultTimeSpan());
    }

    boolean appliesToTargets(List targetGeneNames) {
        return this.appliesToTargetsGetTarget(targetGeneNames) != null;
    }

    NullTarget appliesToTargetsGetTarget(List targetGeneNames) {
        Iterator tgit = targetGeneNames.iterator();
        while (tgit.hasNext()) {
            String targetName = (String)tgit.next();
            Iterator trgit = this.getTargets();
            while (trgit.hasNext()) {
                NullTarget nt = (NullTarget)trgit.next();
                String nextTarg = nt.getTarget();
                if (!DataUtil.keysEqual(targetName, nextTarg)) continue;
                return nt;
            }
        }
        return null;
    }

    List appliesToTargetGetTargetIndices(String targetName) {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        int numTarg = this.targets_.size();
        for (int i = 0; i < numTarg; ++i) {
            NullTarget nt = this.getTarget(i);
            String nextTarg = nt.getTarget();
            if (!DataUtil.keysEqual(targetName, nextTarg)) continue;
            retval.add(new Integer(i));
        }
        return retval;
    }

    int getTargetCount() {
        return this.targets_.size();
    }

    void deleteTargetIndices(List indices) {
        ArrayList newTargs = new ArrayList();
        int numTarg = this.targets_.size();
        for (int i = 0; i < numTarg; ++i) {
            if (indices.contains(new Integer(i))) continue;
            newTargs.add(this.targets_.get(i));
        }
        this.targets_ = newTargs;
    }

    String buildTargetDisplayString(NullTimeSpan defaultSpan) {
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        String units = tad.unitDisplayAbbrev();
        boolean isSuffix = tad.unitsAreASuffix();
        Map spanLists = this.groupInSpanSets(defaultSpan);
        HashSet<NullTimeSpan> defaultSet = new HashSet<NullTimeSpan>();
        defaultSet.add(defaultSpan);
        HashMap<Set, SortedMap> multiTargs = new HashMap<Set, SortedMap>();
        TreeMap defAndSingles = new TreeMap();
        Iterator slit = spanLists.keySet().iterator();
        while (slit.hasNext()) {
            Set spanSet = (Set)slit.next();
            SortedMap targMap = (SortedMap)spanLists.get(spanSet);
            if (((Object)spanSet).equals(defaultSet) || targMap.size() == 1) {
                this.mergeMaps(defAndSingles, targMap);
                continue;
            }
            multiTargs.put(spanSet, targMap);
        }
        StringBuffer buf = new StringBuffer();
        boolean isFirst = true;
        Iterator dsit = defAndSingles.keySet().iterator();
        while (dsit.hasNext()) {
            String dKey = (String)dsit.next();
            List targForTString = (List)defAndSingles.get(dKey);
            Iterator tftit = targForTString.iterator();
            while (tftit.hasNext()) {
                NullTarget nt = (NullTarget)tftit.next();
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                Set spanSet = nt.getSpansInSet();
                if (spanSet.isEmpty()) {
                    spanSet.add(new NullTimeSpan(defaultSpan));
                }
                boolean showSpans = !((Object)spanSet).equals(defaultSet);
                buf.append(nt.displayString(showSpans, units, isSuffix));
            }
        }
        Iterator mtit = multiTargs.keySet().iterator();
        while (mtit.hasNext()) {
            Set spanSet = (Set)mtit.next();
            SortedMap targMap = (SortedMap)spanLists.get(spanSet);
            Iterator tmit = targMap.keySet().iterator();
            boolean isFirstForBracket = true;
            while (tmit.hasNext()) {
                String dKey = (String)tmit.next();
                List targForTString = (List)targMap.get(dKey);
                Iterator tftit = targForTString.iterator();
                while (tftit.hasNext()) {
                    NullTarget nt = (NullTarget)tftit.next();
                    if (isFirstForBracket) {
                        isFirstForBracket = false;
                        if (isFirst) {
                            isFirst = false;
                            buf.append("[");
                        } else {
                            buf.append(", [");
                        }
                    } else if (isFirst) {
                        isFirst = false;
                    } else {
                        buf.append(", ");
                    }
                    boolean showSpans = !tmit.hasNext() && !tftit.hasNext();
                    buf.append(nt.displayString(showSpans, units, isSuffix));
                    if (!showSpans) continue;
                    buf.append("]");
                }
            }
        }
        return buf.toString();
    }

    void addInvestigators(Set invest) {
        this.investigators_.addAll(invest);
    }

    String buildInvestDisplayString() {
        String only;
        ResourceManager rMan = ResourceManager.getManager();
        String etAl = rMan.getString("qpcrData.andOthers");
        int numInv = this.investigators_.size();
        if (numInv == 1 && (only = (String)this.investigators_.iterator().next()).equals(etAl)) {
            return null;
        }
        int count = 0;
        boolean etAlPending = this.investigators_.contains(etAl);
        StringBuffer buf = new StringBuffer();
        Iterator iit = this.investigators_.iterator();
        while (iit.hasNext()) {
            String inv = (String)iit.next();
            if (inv.equals(etAl)) continue;
            buf.append(inv);
            if (count < numInv - 2) {
                buf.append(", ");
            } else if (count < numInv - 1) {
                if (etAlPending) {
                    buf.append(", ");
                } else {
                    buf.append(" &amp ");
                }
            }
            ++count;
        }
        if (etAlPending) {
            buf.append(etAl);
        }
        return buf.toString();
    }

    private void mergeMaps(SortedMap destMap, SortedMap srcMap) {
        Iterator smit = srcMap.keySet().iterator();
        while (smit.hasNext()) {
            String smkey = (String)smit.next();
            List smList = (List)srcMap.get(smkey);
            List dstList = (List)destMap.get(smkey);
            if (dstList == null) {
                destMap.put(smkey, new ArrayList(smList));
                continue;
            }
            dstList.addAll(smList);
        }
    }

    private Map groupInSpanSets(NullTimeSpan defaultSpan) {
        Iterator trgs = this.getTargets();
        HashMap spanMaps = new HashMap();
        while (trgs.hasNext()) {
            ArrayList<NullTarget> targsForTarg;
            TreeMap<String, ArrayList<NullTarget>> currMap;
            NullTarget trg = (NullTarget)trgs.next();
            Set spanSet = trg.getSpansInSet();
            if (spanSet.isEmpty()) {
                spanSet.add(new NullTimeSpan(defaultSpan));
            }
            if ((currMap = (TreeMap<String, ArrayList<NullTarget>>)spanMaps.get(spanSet)) == null) {
                currMap = new TreeMap<String, ArrayList<NullTarget>>();
                spanMaps.put(spanSet, currMap);
                targsForTarg = new ArrayList();
                currMap.put(trg.getTarget(), targsForTarg);
            } else {
                targsForTarg = (ArrayList<NullTarget>)currMap.get(trg.getTarget());
                if (targsForTarg == null) {
                    targsForTarg = new ArrayList<NullTarget>();
                    currMap.put(trg.getTarget(), targsForTarg);
                }
            }
            targsForTarg.add(trg);
        }
        return spanMaps;
    }

    String getSourceDisplayString(boolean footnotes) {
        StringBuffer buf = new StringBuffer();
        Iterator sit = this.getSources();
        while (sit.hasNext()) {
            String notes;
            Source src = (Source)sit.next();
            buf.append(src.getDisplayValue());
            if (footnotes && (notes = src.getNotes()) != null) {
                buf.append(" [");
                buf.append(notes);
                buf.append("]");
            }
            if (!sit.hasNext()) continue;
            buf.append(" + ");
        }
        return buf.toString();
    }

    void writeHTML(PrintWriter out, Indenter ind, QpcrTablePublisher qtp, NullTimeSpan defaultSpan) {
        ind.indent();
        out.println("<tr valign=\"top\" >");
        ind.up().indent();
        out.println("<td>");
        ind.up().indent();
        Iterator srcs = this.getSources();
        while (srcs.hasNext()) {
            Source src = (Source)srcs.next();
            src.writeHTML(out, ind, srcs.hasNext(), qtp, true);
        }
        ind.down().indent();
        out.println("</td>");
        ind.indent();
        out.println("<td>");
        ind.up().indent();
        qtp.paragraph(false);
        out.print("<i>");
        out.print(this.buildTargetDisplayString(defaultSpan));
        out.println("</i>");
        String inv = this.buildInvestDisplayString();
        if (inv != null) {
            ResourceManager rMan = ResourceManager.getManager();
            out.print(" (");
            out.print(rMan.getString("qpcrData.dataOf"));
            out.print(" ");
            out.print(inv);
            out.print(")");
        }
        out.println("</p>");
        ind.down().indent();
        out.println("</td>");
        ind.down().indent();
        out.println("</tr>");
    }

    static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("nullPerturbation");
        return retval;
    }

    public String toString() {
        return "NullPerturb: sources = " + this.sources_ + " targets = " + this.targets_;
    }

    static NullPerturb buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("nullPerturbation")) {
            return null;
        }
        String p = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (!key.equals("perturbation")) continue;
                p = CharacterEntityMapper.unmapEntities(val, false);
            }
        }
        NullPerturb retval = new NullPerturb();
        if (p != null) {
            retval.convertLegacySource(p);
        }
        return retval;
    }

    private void convertNoteToTargets(String note, List targets, NullTimeSpan defaultNull) {
        ArrayList tokens = new ArrayList();
        Pattern plus = Pattern.compile(",");
        Pattern spanStart = Pattern.compile(".*\\([0-9]+$");
        Pattern spanEnd = Pattern.compile(".*[0-9]+ *h\\)]?$");
        Matcher m = plus.matcher(note);
        int pstart = 0;
        ArrayList currGlue = new ArrayList();
        while (m.find()) {
            String next = note.substring(pstart, m.start());
            this.addOrGlue(next, spanStart, spanEnd, currGlue, tokens);
            pstart = m.end();
        }
        String last = note.substring(pstart, note.length());
        this.addOrGlue(last, spanStart, spanEnd, currGlue, tokens);
        String def = this.extractDefault(tokens);
        int minTime = defaultNull.getMin();
        TimeTaggedList defaultToks = new TimeTaggedList();
        if (def == null) {
            defaultToks.isDefault = true;
        } else {
            defaultToks.taggedToken = def;
        }
        ArrayList bracketedToks = new ArrayList();
        this.groupByTimeTags(defaultToks, bracketedToks, tokens);
        targets.addAll(this.convertTimeTaggedList(defaultToks, minTime));
        int brakNum = bracketedToks.size();
        for (int i = 0; i < brakNum; ++i) {
            TimeTaggedList bt = (TimeTaggedList)bracketedToks.get(i);
            targets.addAll(this.convertTimeTaggedList(bt, minTime));
        }
    }

    private List convertTimeTaggedList(TimeTaggedList ttl, int minTime) {
        ArrayList<NullTarget> retval = new ArrayList<NullTarget>();
        List spans = this.parseTimeTag(ttl.isDefault, ttl.taggedToken, minTime);
        int size = ttl.tokens.size();
        for (int i = 0; i < size; ++i) {
            NullTarget newNull;
            String token = (String)ttl.tokens.get(i);
            String[] chopped = this.chopOutTimeSpan(token);
            List useSpans = chopped.length == 2 ? this.parseTimeTag(false, chopped[1], minTime) : spans;
            String[] choppedToo = this.chopOutRegion(chopped[0].trim());
            NullTarget nullTarget = newNull = choppedToo.length == 2 ? new NullTarget(choppedToo[0].trim(), choppedToo[1].trim()) : new NullTarget(choppedToo[0].trim());
            if (useSpans != null) {
                int spSize = useSpans.size();
                for (int j = 0; j < spSize; ++j) {
                    NullTimeSpan span = (NullTimeSpan)useSpans.get(j);
                    newNull.addTimeSpan(span);
                }
            }
            retval.add(newNull);
        }
        return retval;
    }

    private void addOrGlue(String next, Pattern spanStart, Pattern spanEnd, List glued, List tokens) {
        Matcher mSS = spanStart.matcher(next = next.trim());
        if (mSS.matches()) {
            glued.add(next);
        } else if (!glued.isEmpty()) {
            Matcher mSE = spanEnd.matcher(next);
            glued.add(next);
            if (mSE.matches()) {
                tokens.add(this.flushGlueToString(glued));
                glued.clear();
            }
        } else {
            tokens.add(next);
        }
    }

    private String flushGlueToString(List glued) {
        StringBuffer buf = new StringBuffer();
        int size = glued.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append((String)glued.get(i));
        }
        return buf.toString();
    }

    private void groupByTimeTags(TimeTaggedList defaultToks, List specialToks, List tokens) {
        Pattern brackStart = Pattern.compile("^\\[.*");
        Pattern brackEnd = Pattern.compile(".*]$");
        int tokNum = tokens.size();
        TimeTaggedList tokTarg = defaultToks;
        for (int i = 0; i < tokNum; ++i) {
            Matcher mBE;
            String tok = (String)tokens.get(i);
            Matcher mBS = brackStart.matcher(tok);
            if (mBS.matches()) {
                tok = tok.replaceFirst("\\[", "");
                tokTarg = new TimeTaggedList();
            }
            if ((mBE = brackEnd.matcher(tok)).matches()) {
                tok = tok.substring(0, tok.length() - 1);
                String[] chopped = this.chopOutTimeSpan(tok);
                tokTarg.tokens.add(chopped[0]);
                if (chopped.length == 2) {
                    tokTarg.taggedToken = chopped[1];
                    specialToks.add(tokTarg);
                } else {
                    defaultToks.tokens.addAll(tokTarg.tokens);
                }
                tokTarg = defaultToks;
                continue;
            }
            tokTarg.tokens.add(tok);
        }
    }

    private String extractDefault(List tokens) {
        if (tokens.size() == 0) {
            return null;
        }
        String tok = (String)tokens.get(0);
        Pattern defSpan = Pattern.compile("^(\\([0-9, -&]+h *\\):)");
        Matcher dSM = defSpan.matcher(tok);
        if (dSM.find()) {
            String grp = dSM.group(1);
            dSM.reset();
            tok = dSM.replaceFirst("");
            tokens.set(0, tok.trim());
            return grp;
        }
        return null;
    }

    private List parseTimeTag(boolean isDefault, String tag, int minTime) {
        if (isDefault) {
            return null;
        }
        boolean isList = tag.indexOf(",") != -1;
        boolean isRange = tag.indexOf("-") != -1;
        boolean isPair = tag.indexOf("&") != -1;
        boolean toUpper = tag.indexOf("(to") != -1;
        boolean isSingle = !isList && !isRange && !isPair && !toUpper;
        ArrayList<NullTimeSpan> retval = new ArrayList<NullTimeSpan>();
        Pattern number = Pattern.compile("([0-9]+)");
        Matcher m = number.matcher(tag);
        int pstart = 0;
        int first = Integer.MIN_VALUE;
        while (m.find()) {
            int val;
            String next = m.group(1);
            try {
                val = Integer.parseInt(next);
            }
            catch (NumberFormatException nfex) {
                System.err.println("Could not parse " + next);
                throw new IllegalStateException();
            }
            if (isList || isSingle) {
                retval.add(new NullTimeSpan(val));
            } else if (toUpper) {
                retval.add(new NullTimeSpan(minTime, val));
            } else if (isPair) {
                retval.add(new NullTimeSpan(val));
            } else if (first != Integer.MIN_VALUE) {
                retval.add(new NullTimeSpan(first, val));
                first = Integer.MIN_VALUE;
            } else {
                first = val;
            }
            pstart = m.end();
        }
        return retval;
    }

    private String[] chopOutTimeSpan(String token) {
        String[] retval;
        Pattern parenSpan = Pattern.compile("(\\(.*[0-9] *h *\\))$");
        Matcher cP = parenSpan.matcher(token);
        if (cP.find()) {
            String grp = cP.group(1);
            cP.reset();
            token = cP.replaceFirst("");
            retval = new String[]{token.trim(), grp};
        } else {
            retval = new String[]{token};
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] chopOutRegion(String token) {
        String[] retval;
        Pattern parenSpan = Pattern.compile("(\\(in *[0-9a-zA-Z']+ *\\))$");
        Matcher cP = parenSpan.matcher(token);
        if (cP.find()) {
            String grp = cP.group(1);
            cP.reset();
            token = cP.replaceFirst("");
            retval = new String[2];
            retval[0] = token.trim();
            Pattern regionPart = Pattern.compile("\\(in *([0-9a-zA-Z']+) *\\)");
            Matcher rP = regionPart.matcher(grp);
            if (!rP.find()) throw new IllegalStateException();
            retval[1] = rP.group(1);
            return retval;
        } else {
            retval = new String[]{token};
        }
        return retval;
    }

    private void convertLegacySource(String legacy) throws IOException {
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        if (tad.getUnits() != 2) {
            throw new IOException();
        }
        Source src = new Source();
        src.setDisplayValue(legacy);
        this.addSource(src);
    }

    private class TimeTaggedList {
        boolean isDefault = false;
        String taggedToken;
        ArrayList tokens = new ArrayList();

        TimeTaggedList() {
        }

        public String toString() {
            return (this.isDefault ? "Default: " : this.taggedToken + " : ") + this.tokens;
        }
    }
}

