/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.qpcr.Batch;
import org.systemsbiology.biotapestry.qpcr.NullTimeSpan;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Splitter;
import org.xml.sax.Attributes;

class NullTarget
implements Cloneable {
    private String target_;
    private String region_;
    private ArrayList spans_;
    private ArrayList supportBatches_;
    private String footsForHTML_;

    NullTarget() {
        this.spans_ = new ArrayList();
        this.supportBatches_ = new ArrayList();
    }

    NullTarget(String target) {
        this.target_ = target;
        this.spans_ = new ArrayList();
        this.supportBatches_ = new ArrayList();
    }

    NullTarget(String target, String region) {
        this.target_ = target;
        this.region_ = region;
        this.spans_ = new ArrayList();
        this.supportBatches_ = new ArrayList();
    }

    NullTarget(NullTarget other) {
        this.mergeInNewValues(other);
    }

    public Object clone() {
        try {
            NullTarget newVal = (NullTarget)super.clone();
            newVal.spans_ = new ArrayList();
            Iterator osit = this.spans_.iterator();
            while (osit.hasNext()) {
                newVal.spans_.add(((NullTimeSpan)osit.next()).clone());
            }
            newVal.supportBatches_ = new ArrayList();
            Iterator sbit = this.supportBatches_.iterator();
            while (sbit.hasNext()) {
                newVal.supportBatches_.add(((Batch)sbit.next()).clone());
            }
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    void mergeInNewValues(NullTarget other) {
        this.target_ = other.target_;
        this.region_ = other.region_;
        this.spans_ = new ArrayList();
        Iterator osit = other.spans_.iterator();
        while (osit.hasNext()) {
            this.spans_.add(((NullTimeSpan)osit.next()).clone());
        }
        this.supportBatches_ = new ArrayList();
        Iterator sbit = other.supportBatches_.iterator();
        while (sbit.hasNext()) {
            this.supportBatches_.add(((Batch)sbit.next()).clone());
        }
        this.footsForHTML_ = other.footsForHTML_;
    }

    void updateDataRange(NullTimeSpan defaultSpan, int[] range) {
        int myMin = Integer.MAX_VALUE;
        int myMax = Integer.MIN_VALUE;
        if (this.spans_.isEmpty()) {
            myMin = defaultSpan.getMin();
            myMax = defaultSpan.isASpan() ? defaultSpan.getMax() : myMin;
        } else {
            int numSpan = this.spans_.size();
            for (int i = 0; i < numSpan; ++i) {
                int ntsMax;
                NullTimeSpan nts = (NullTimeSpan)this.spans_.get(i);
                int ntsMin = nts.getMin();
                int n = ntsMax = nts.isASpan() ? nts.getMax() : ntsMin;
                if (ntsMin < myMin) {
                    myMin = ntsMin;
                }
                if (ntsMax <= myMax) continue;
                myMax = ntsMax;
            }
        }
        if (myMin < range[0]) {
            range[0] = myMin;
        }
        if (myMax > range[1]) {
            range[1] = myMax;
        }
    }

    String getTarget() {
        return this.target_;
    }

    String getRegionRestriction() {
        return this.region_;
    }

    void setTarget(String target) {
        this.target_ = target;
    }

    void setRegionRestriction(String region) {
        this.region_ = region;
    }

    void setFootsForHTML(String foots) {
        this.footsForHTML_ = foots;
    }

    List getFootnoteNumbers() {
        if (this.footsForHTML_ != null) {
            return Splitter.stringBreak(this.footsForHTML_, ",", 0, true);
        }
        return new ArrayList();
    }

    void addTimeSpan(NullTimeSpan span) {
        this.spans_.add(span);
    }

    Iterator getTimes() {
        return this.spans_.iterator();
    }

    Set getSpansInSet() {
        return new HashSet(this.spans_);
    }

    int getTimesCount() {
        return this.spans_.size();
    }

    void deleteTimeSpan(int index) {
        this.spans_.remove(index);
    }

    void dropTimeSpans() {
        this.spans_.clear();
    }

    NullTimeSpan getTimeSpan(int index) {
        return (NullTimeSpan)this.spans_.get(index);
    }

    void replaceTimeSpan(int index, NullTimeSpan span) {
        this.spans_.set(index, span);
    }

    public void addBatch(Batch batch) {
        this.supportBatches_.add(batch);
    }

    void deleteBatch(int index) {
        this.supportBatches_.remove(index);
    }

    Batch getBatch(int index) {
        return (Batch)this.supportBatches_.get(index);
    }

    int getBatchCount() {
        return this.supportBatches_.size();
    }

    Iterator getSupportData() {
        return this.supportBatches_.iterator();
    }

    String displayString(boolean fullyQualified, String units, boolean isSuffix) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.target_);
        if (this.footsForHTML_ != null) {
            buf.append("<sup>");
            buf.append(this.footsForHTML_);
            buf.append("</sup>");
        }
        if (!fullyQualified) {
            return buf.toString();
        }
        buf.append(" (");
        buf.append(this.displayTimeSpansString(units, isSuffix));
        buf.append(")");
        return buf.toString();
    }

    String displayTimeSpansString(String units, boolean isSuffix) {
        StringBuffer buf = new StringBuffer();
        boolean isFirst = true;
        if (!isSuffix) {
            buf.append(units);
            buf.append(" ");
        }
        ArrayList sorted = new ArrayList(this.spans_);
        Collections.sort(sorted);
        Iterator tsit = sorted.iterator();
        while (tsit.hasNext()) {
            NullTimeSpan nts = (NullTimeSpan)tsit.next();
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(nts.displayString());
        }
        if (isSuffix) {
            buf.append(" ");
            buf.append(units);
        }
        return buf.toString();
    }

    static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("nullTarget");
        return retval;
    }

    public String toString() {
        return "NullTarget: target = " + this.target_ + " region = " + this.region_ + "spans = " + this.spans_;
    }

    static NullTarget buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("nullTarget")) {
            return null;
        }
        String target = null;
        String region = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("target")) {
                    target = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (!key.equals("region")) continue;
                region = CharacterEntityMapper.unmapEntities(val, false);
            }
        }
        if (target == null) {
            throw new IOException();
        }
        return new NullTarget(target, region);
    }
}

