/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.util.MinMax;
import org.xml.sax.Attributes;

class NullTimeSpan
implements Cloneable,
Comparable {
    private int minTime_;
    private int maxTime_;
    private boolean isSpan_;

    NullTimeSpan(int min) {
        this.minTime_ = min;
        this.isSpan_ = false;
        this.maxTime_ = -1;
    }

    NullTimeSpan(int min, int max) {
        this.minTime_ = min;
        this.isSpan_ = true;
        this.maxTime_ = max;
    }

    NullTimeSpan(MinMax mm) {
        this.minTime_ = mm.min;
        this.isSpan_ = mm.min < mm.max;
        this.maxTime_ = this.isSpan_ ? mm.max : -1;
    }

    NullTimeSpan(NullTimeSpan other) {
        this.mergeInNewValues(other);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    void mergeInNewValues(NullTimeSpan other) {
        this.minTime_ = other.minTime_;
        this.isSpan_ = other.isSpan_;
        this.maxTime_ = other.maxTime_;
    }

    boolean isASpan() {
        return this.isSpan_;
    }

    int getMin() {
        return this.minTime_;
    }

    int getTime() {
        if (this.isSpan_) {
            throw new IllegalStateException();
        }
        return this.minTime_;
    }

    int getMax() {
        if (!this.isSpan_) {
            throw new IllegalStateException();
        }
        return this.maxTime_;
    }

    String displayString() {
        StringBuffer buf = new StringBuffer();
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        boolean namedStages = tad.haveNamedStages();
        String minTime = namedStages ? tad.getNamedStageForIndex((int)this.minTime_).name : Integer.toString(this.minTime_);
        buf.append(minTime);
        if (this.isASpan()) {
            buf.append("-");
            String maxTime = namedStages ? tad.getNamedStageForIndex((int)this.maxTime_).name : Integer.toString(this.maxTime_);
            buf.append(maxTime);
        }
        return buf.toString();
    }

    static Set keywordsOfInterest(boolean forDefault) {
        HashSet<String> retval = new HashSet<String>();
        retval.add(forDefault ? "defaultNullTimes" : "nullTimes");
        return retval;
    }

    public String toString() {
        return "NullTimeSpan: isSpan = " + this.isSpan_ + " min = " + this.minTime_ + " max = " + this.maxTime_;
    }

    public int hashCode() {
        return this.minTime_ + (this.isSpan_ ? this.maxTime_ : 0);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof NullTimeSpan)) {
            return false;
        }
        NullTimeSpan otherNTS = (NullTimeSpan)other;
        if (this.minTime_ != otherNTS.minTime_) {
            return false;
        }
        if (this.isSpan_ != otherNTS.isSpan_) {
            return false;
        }
        if (!this.isSpan_) {
            return true;
        }
        return this.maxTime_ == otherNTS.maxTime_;
    }

    public int compareTo(Object o) {
        NullTimeSpan other = (NullTimeSpan)o;
        if (this.minTime_ > other.minTime_) {
            return 1;
        }
        if (this.minTime_ < other.minTime_) {
            return -1;
        }
        if (!this.isSpan_ && !other.isSpan_) {
            return 0;
        }
        if (!this.isSpan_ && other.isSpan_) {
            return -1;
        }
        if (this.isSpan_ && !other.isSpan_) {
            return 1;
        }
        if (this.maxTime_ < other.maxTime_) {
            return -1;
        }
        if (this.maxTime_ > other.maxTime_) {
            return 1;
        }
        return 0;
    }

    static NullTimeSpan buildFromXML(String elemName, Attributes attrs) throws IOException {
        int minTime;
        if (!elemName.equals("defaultNullTimes") && !elemName.equals("nullTimes")) {
            return null;
        }
        String minStr = null;
        String maxStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("min")) {
                    minStr = val;
                    continue;
                }
                if (!key.equals("max")) continue;
                maxStr = val;
            }
        }
        if (minStr == null) {
            throw new IOException();
        }
        int maxTime = -1;
        boolean isSpan = false;
        try {
            minTime = Integer.parseInt(minStr);
            if (maxStr != null) {
                maxTime = Integer.parseInt(maxStr);
                isSpan = true;
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
        Database db = Database.getDB();
        TimeAxisDefinition tad = db.getTimeAxisDefinition();
        if (!tad.spanIsOk(minTime, isSpan ? maxTime : minTime)) {
            throw new IOException();
        }
        return isSpan ? new NullTimeSpan(minTime, maxTime) : new NullTimeSpan(minTime);
    }
}

